/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogLoader;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FileJournalManager;
import org.apache.hadoop.hdfs.server.namenode.JournalManager;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.TestEditLog;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestFileJournalManager {
    @Test
    public void testNormalOperation() throws IOException {
        File f1 = new File(TestEditLog.TEST_DIR + "/normtest0");
        File f2 = new File(TestEditLog.TEST_DIR + "/normtest1");
        File f3 = new File(TestEditLog.TEST_DIR + "/normtest2");
        ImmutableList editUris = ImmutableList.of((Object)f1.toURI(), (Object)f2.toURI(), (Object)f3.toURI());
        NNStorage storage = TestEditLog.setupEdits((List<URI>)editUris, 5, new TestEditLog.AbortSpec[0]);
        long numJournals = 0L;
        for (Storage.StorageDirectory sd : storage.dirIterable((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS)) {
            FileJournalManager jm = new FileJournalManager(sd);
            Assert.assertEquals((long)60L, (long)jm.getNumberOfTransactions(1L, true));
            ++numJournals;
        }
        Assert.assertEquals((long)3L, (long)numJournals);
    }

    @Test
    public void testInprogressRecovery() throws IOException {
        File f = new File(TestEditLog.TEST_DIR + "/filejournaltest0");
        NNStorage storage = TestEditLog.setupEdits(Collections.singletonList(f.toURI()), 5, new TestEditLog.AbortSpec(5, 0));
        Storage.StorageDirectory sd = (Storage.StorageDirectory)storage.dirIterator((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS).next();
        FileJournalManager jm = new FileJournalManager(sd);
        Assert.assertEquals((long)52L, (long)jm.getNumberOfTransactions(1L, true));
    }

    @Test
    public void testInprogressRecoveryMixed() throws IOException {
        File f1 = new File(TestEditLog.TEST_DIR + "/mixtest0");
        File f2 = new File(TestEditLog.TEST_DIR + "/mixtest1");
        File f3 = new File(TestEditLog.TEST_DIR + "/mixtest2");
        ImmutableList editUris = ImmutableList.of((Object)f1.toURI(), (Object)f2.toURI(), (Object)f3.toURI());
        NNStorage storage = TestEditLog.setupEdits((List<URI>)editUris, 5, new TestEditLog.AbortSpec(5, 1));
        Iterator dirs = storage.dirIterator((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS);
        Storage.StorageDirectory sd = (Storage.StorageDirectory)dirs.next();
        FileJournalManager jm = new FileJournalManager(sd);
        Assert.assertEquals((long)60L, (long)jm.getNumberOfTransactions(1L, true));
        sd = (Storage.StorageDirectory)dirs.next();
        jm = new FileJournalManager(sd);
        Assert.assertEquals((long)52L, (long)jm.getNumberOfTransactions(1L, true));
        sd = (Storage.StorageDirectory)dirs.next();
        jm = new FileJournalManager(sd);
        Assert.assertEquals((long)60L, (long)jm.getNumberOfTransactions(1L, true));
    }

    @Test
    public void testInprogressRecoveryAll() throws IOException {
        File f1 = new File(TestEditLog.TEST_DIR + "/failalltest0");
        File f2 = new File(TestEditLog.TEST_DIR + "/failalltest1");
        File f3 = new File(TestEditLog.TEST_DIR + "/failalltest2");
        ImmutableList editUris = ImmutableList.of((Object)f1.toURI(), (Object)f2.toURI(), (Object)f3.toURI());
        NNStorage storage = TestEditLog.setupEdits((List<URI>)editUris, 5, new TestEditLog.AbortSpec(5, 0), new TestEditLog.AbortSpec(5, 1), new TestEditLog.AbortSpec(5, 2));
        Iterator dirs = storage.dirIterator((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS);
        Storage.StorageDirectory sd = (Storage.StorageDirectory)dirs.next();
        FileJournalManager jm = new FileJournalManager(sd);
        Assert.assertEquals((long)52L, (long)jm.getNumberOfTransactions(1L, true));
        sd = (Storage.StorageDirectory)dirs.next();
        jm = new FileJournalManager(sd);
        Assert.assertEquals((long)52L, (long)jm.getNumberOfTransactions(1L, true));
        sd = (Storage.StorageDirectory)dirs.next();
        jm = new FileJournalManager(sd);
        Assert.assertEquals((long)52L, (long)jm.getNumberOfTransactions(1L, true));
    }

    private void corruptAfterStartSegment(File f) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(f, "rw");
        raf.seek(22L);
        for (int i = 0; i < 1000; ++i) {
            raf.writeInt(-559038737);
        }
        raf.close();
    }

    @Test
    public void testReadFromStream() throws IOException {
        long numLoaded;
        long count;
        File f = new File(TestEditLog.TEST_DIR + "/filejournaltest1");
        NNStorage storage = TestEditLog.setupEdits(Collections.singletonList(f.toURI()), 10, new TestEditLog.AbortSpec(10, 0));
        Storage.StorageDirectory sd = (Storage.StorageDirectory)storage.dirIterator((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS).next();
        FileJournalManager jm = new FileJournalManager(sd);
        long expectedTotalTxnCount = 102L;
        Assert.assertEquals((long)expectedTotalTxnCount, (long)jm.getNumberOfTransactions(1L, true));
        long skippedTxns = 30L;
        long startingTxId = skippedTxns + 1L;
        long numTransactionsToLoad = jm.getNumberOfTransactions(startingTxId, true);
        for (numLoaded = 0L; numLoaded < numTransactionsToLoad; numLoaded += count) {
            EditLogInputStream editIn = jm.getInputStream(startingTxId, true);
            FSEditLogLoader.EditLogValidation val = FSEditLogLoader.validateEditLog((EditLogInputStream)editIn);
            count = val.getNumTransactions();
            editIn.close();
            startingTxId += count;
        }
        Assert.assertEquals((long)(expectedTotalTxnCount - skippedTxns), (long)numLoaded);
    }

    @Test
    public void testAskForTransactionsMidfile() throws IOException {
        File f = new File(TestEditLog.TEST_DIR + "/filejournaltest2");
        NNStorage storage = TestEditLog.setupEdits(Collections.singletonList(f.toURI()), 10, new TestEditLog.AbortSpec[0]);
        Storage.StorageDirectory sd = (Storage.StorageDirectory)storage.dirIterator((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS).next();
        FileJournalManager jm = new FileJournalManager(sd);
        int TOTAL_TXIDS = 110;
        for (int txid = 1; txid <= 110; ++txid) {
            Assert.assertEquals((long)(110 - txid + 1), (long)jm.getNumberOfTransactions((long)txid, true));
        }
    }

    @Test
    public void testManyLogsWithGaps() throws IOException {
        File f = new File(TestEditLog.TEST_DIR + "/filejournaltest3");
        NNStorage storage = TestEditLog.setupEdits(Collections.singletonList(f.toURI()), 10, new TestEditLog.AbortSpec[0]);
        Storage.StorageDirectory sd = (Storage.StorageDirectory)storage.dirIterator((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS).next();
        long startGapTxId = 31L;
        long endGapTxId = 40L;
        File[] files = new File(f, "current").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(NNStorage.getFinalizedEditsFileName((long)31L, (long)40L));
            }
        });
        Assert.assertEquals((long)1L, (long)files.length);
        Assert.assertTrue((boolean)files[0].delete());
        FileJournalManager jm = new FileJournalManager(sd);
        Assert.assertEquals((long)30L, (long)jm.getNumberOfTransactions(1L, true));
        try {
            jm.getNumberOfTransactions(31L, true);
            Assert.fail((String)"Should have thrown an exception by now");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains("Gap in transactions, max txnid is 110, 0 txns from 31", ioe);
        }
        Assert.assertEquals((long)70L, (long)jm.getNumberOfTransactions(41L, true));
    }

    @Test
    public void testManyLogsWithCorruptInprogress() throws IOException {
        File f = new File(TestEditLog.TEST_DIR + "/filejournaltest5");
        NNStorage storage = TestEditLog.setupEdits(Collections.singletonList(f.toURI()), 10, new TestEditLog.AbortSpec(10, 0));
        Storage.StorageDirectory sd = (Storage.StorageDirectory)storage.dirIterator((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS).next();
        File[] files = new File(f, "current").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("edits_inprogress");
            }
        });
        Assert.assertEquals((long)files.length, (long)1L);
        this.corruptAfterStartSegment(files[0]);
        FileJournalManager jm = new FileJournalManager(sd);
        Assert.assertEquals((long)101L, (long)jm.getNumberOfTransactions(1L, true));
    }

    @Test
    public void testGetRemoteEditLog() throws IOException {
        Storage.StorageDirectory sd = FSImageTestUtil.mockStorageDirectory((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS, false, NNStorage.getFinalizedEditsFileName((long)1L, (long)100L), NNStorage.getFinalizedEditsFileName((long)101L, (long)200L), NNStorage.getInProgressEditsFileName((long)201L), NNStorage.getFinalizedEditsFileName((long)1001L, (long)1100L));
        FileJournalManager fjm = new FileJournalManager(sd);
        Assert.assertEquals((Object)"[1,100],[101,200],[1001,1100]", (Object)TestFileJournalManager.getLogsAsString(fjm, 1L));
        Assert.assertEquals((Object)"[101,200],[1001,1100]", (Object)TestFileJournalManager.getLogsAsString(fjm, 101L));
        Assert.assertEquals((Object)"[1001,1100]", (Object)TestFileJournalManager.getLogsAsString(fjm, 201L));
        try {
            Assert.assertEquals((Object)"[]", (Object)TestFileJournalManager.getLogsAsString(fjm, 150L));
            Assert.fail((String)"Did not throw when asking for a txn in the middle of a log");
        }
        catch (IllegalStateException ioe) {
            GenericTestUtils.assertExceptionContains("150 which is in the middle", ioe);
        }
        Assert.assertEquals((String)"Asking for a newer log than exists should return empty list", (Object)"", (Object)TestFileJournalManager.getLogsAsString(fjm, 9999L));
    }

    @Test
    public void testReadFromMiddleOfEditLog() throws JournalManager.CorruptionException, IOException {
        File f = new File(TestEditLog.TEST_DIR + "/filejournaltest2");
        NNStorage storage = TestEditLog.setupEdits(Collections.singletonList(f.toURI()), 10, new TestEditLog.AbortSpec[0]);
        Storage.StorageDirectory sd = (Storage.StorageDirectory)storage.dirIterator((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS).next();
        FileJournalManager jm = new FileJournalManager(sd);
        EditLogInputStream elis = jm.getInputStream(5L, true);
        FSEditLogOp op = elis.readOp();
        Assert.assertEquals((String)"read unexpected op", (long)op.getTransactionId(), (long)5L);
    }

    @Test
    public void testExcludeInProgressStreams() throws JournalManager.CorruptionException, IOException {
        File f = new File(TestEditLog.TEST_DIR + "/filejournaltest2");
        NNStorage storage = TestEditLog.setupEdits(Collections.singletonList(f.toURI()), 10, false, new TestEditLog.AbortSpec[0]);
        Storage.StorageDirectory sd = (Storage.StorageDirectory)storage.dirIterator((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS).next();
        FileJournalManager jm = new FileJournalManager(sd);
        Assert.assertEquals((long)100L, (long)jm.getNumberOfTransactions(1L, false));
        EditLogInputStream elis = jm.getInputStream(90L, false);
        FSEditLogOp lastReadOp = null;
        while ((lastReadOp = elis.readOp()) != null) {
            Assert.assertTrue((lastReadOp.getTransactionId() <= 100L ? 1 : 0) != 0);
        }
    }

    private static String getLogsAsString(FileJournalManager fjm, long firstTxId) throws IOException {
        return Joiner.on((String)",").join((Iterable)fjm.getRemoteEditLogs(firstTxId));
    }
}

