/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogLoader;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.io.IOUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;

public class TestFSEditLogLoader {
    private static final File TEST_DIR;
    private static final int NUM_DATA_NODES = 0;

    @Test
    public void testDisplayRecentEditLogOpCodes() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        FileSystem fileSys = null;
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
        cluster.waitActive();
        fileSys = cluster.getFileSystem();
        FSNamesystem namesystem = cluster.getNamesystem();
        FSImage fsimage = namesystem.getFSImage();
        for (int i = 0; i < 20; ++i) {
            fileSys.mkdirs(new Path("/tmp/tmp" + i));
        }
        Storage.StorageDirectory sd = (Storage.StorageDirectory)fsimage.getStorage().dirIterator((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS).next();
        cluster.shutdown();
        File editFile = FSImageTestUtil.findLatestEditsLog(sd).getFile();
        Assert.assertTrue((String)("Should exist: " + editFile), (boolean)editFile.exists());
        long fileLen = editFile.length();
        RandomAccessFile rwf = new RandomAccessFile(editFile, "rw");
        rwf.seek(fileLen - 40L);
        for (int i = 0; i < 20; ++i) {
            rwf.write(FSEditLogOpCodes.OP_DELETE.getOpCode());
        }
        rwf.close();
        String expectedErrorMessage = "^Error replaying edit log at offset \\d+\n";
        expectedErrorMessage = expectedErrorMessage + "Recent opcode offsets: (\\d+\\s*){4}$";
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(false).build();
            Assert.fail((String)"should not be able to start");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"error message contains opcodes message", (boolean)e.getMessage().matches(expectedErrorMessage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplicationAdjusted() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.replication.interval", 1);
        conf.setInt("dfs.heartbeat.interval", 1);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
            cluster.waitActive();
            FileSystem fs = cluster.getFileSystem();
            Path p = new Path("/testfile");
            DFSTestUtil.createFile(fs, p, 10L, (short)1, 1L);
            DFSTestUtil.waitReplication(fs, p, (short)1);
            cluster.shutdown();
            cluster = null;
            conf.setInt("dfs.namenode.replication.min", 2);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).format(false).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSTestUtil.waitReplication(fs, p, (short)2);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountValidTransactions() throws IOException {
        File testDir = new File(TEST_DIR, "testCountValidTransactions");
        File logFile = new File(testDir, NNStorage.getInProgressEditsFileName((long)1L));
        FSEditLog fsel = null;
        int NUM_TXNS = 30;
        TreeMap offsetToTxId = Maps.newTreeMap();
        try {
            fsel = FSImageTestUtil.createStandaloneEditLog(testDir);
            fsel.openForWrite();
            Assert.assertTrue((String)("should exist: " + logFile), (boolean)logFile.exists());
            for (int i = 0; i < 30; ++i) {
                long trueOffset = TestFSEditLogLoader.getNonTrailerLength(logFile);
                long thisTxId = fsel.getLastWrittenTxId() + 1L;
                offsetToTxId.put(trueOffset, thisTxId);
                System.err.println("txid " + thisTxId + " at offset " + trueOffset);
                fsel.logDelete("path" + i, (long)i);
                fsel.logSync();
            }
        }
        finally {
            if (fsel != null) {
                fsel.close();
            }
        }
        logFile = testDir.listFiles()[0];
        long validLength = TestFSEditLogLoader.getNonTrailerLength(logFile);
        FSEditLogLoader.EditLogValidation validation = EditLogFileInputStream.validateEditLog((File)logFile);
        Assert.assertEquals((long)32L, (long)validation.getNumTransactions());
        Assert.assertEquals((long)validLength, (long)validation.getValidLength());
        File logFileBak = new File(testDir, logFile.getName() + ".bak");
        Files.copy((File)logFile, (File)logFileBak);
        for (Map.Entry entry : offsetToTxId.entrySet()) {
            long txOffset = (Long)entry.getKey();
            long txid = (Long)entry.getValue();
            Files.copy((File)logFileBak, (File)logFile);
            this.truncateFile(logFile, txOffset);
            validation = EditLogFileInputStream.validateEditLog((File)logFile);
            Assert.assertEquals((String)("Failed when truncating to length " + txOffset), (long)(txid - 1L), (long)validation.getNumTransactions());
            Assert.assertEquals((long)txOffset, (long)validation.getValidLength());
            Files.copy((File)logFileBak, (File)logFile);
            this.truncateFile(logFile, txOffset + 1L);
            validation = EditLogFileInputStream.validateEditLog((File)logFile);
            Assert.assertEquals((String)("Failed when truncating to length " + (txOffset + 1L)), (long)(txid - 1L), (long)validation.getNumTransactions());
            Assert.assertEquals((long)txOffset, (long)validation.getValidLength());
            Files.copy((File)logFileBak, (File)logFile);
            this.corruptByteInFile(logFile, txOffset);
            validation = EditLogFileInputStream.validateEditLog((File)logFile);
            Assert.assertEquals((String)("Failed when corrupting txn opcode at " + txOffset), (long)(txid - 1L), (long)validation.getNumTransactions());
            Assert.assertEquals((long)txOffset, (long)validation.getValidLength());
            Files.copy((File)logFileBak, (File)logFile);
            this.corruptByteInFile(logFile, txOffset + 5L);
            validation = EditLogFileInputStream.validateEditLog((File)logFile);
            Assert.assertEquals((String)("Failed when corrupting txn data at " + (txOffset + 5L)), (long)(txid - 1L), (long)validation.getNumTransactions());
            Assert.assertEquals((long)txOffset, (long)validation.getValidLength());
        }
        long prevNumValid = 0L;
        for (long offset = 0L; offset < validLength; ++offset) {
            Files.copy((File)logFileBak, (File)logFile);
            this.corruptByteInFile(logFile, offset);
            FSEditLogLoader.EditLogValidation val = EditLogFileInputStream.validateEditLog((File)logFile);
            Assert.assertTrue((String)String.format("%d should have been >= %d", val.getNumTransactions(), prevNumValid), (val.getNumTransactions() >= prevNumValid ? 1 : 0) != 0);
            prevNumValid = val.getNumTransactions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void corruptByteInFile(File file, long offset) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        try {
            raf.seek(offset);
            int origByte = raf.read();
            raf.seek(offset);
            raf.writeByte(origByte - 1);
        }
        finally {
            IOUtils.closeStream((Closeable)raf);
        }
    }

    private void truncateFile(File logFile, long newLength) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(logFile, "rw");
        raf.setLength(newLength);
        raf.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNonTrailerLength(File f) throws IOException {
        int chunkSizeToRead = 262144;
        FileInputStream fis = new FileInputStream(f);
        try {
            byte[] buf = new byte[262144];
            FileChannel fc = fis.getChannel();
            long size = fc.size();
            for (long pos = size - size % 262144L; pos >= 0L; pos -= 262144L) {
                fc.position(pos);
                int readLen = (int)Math.min(size - pos, 262144L);
                IOUtils.readFully((InputStream)fis, (byte[])buf, (int)0, (int)readLen);
                for (int i = readLen - 1; i >= 0; --i) {
                    if (buf[i] == FSEditLogOpCodes.OP_INVALID.getOpCode()) continue;
                    long l = pos + (long)i + 1L;
                    return l;
                }
            }
            long l = 0L;
            return l;
        }
        finally {
            fis.close();
        }
    }

    static {
        ((Log4JLogger)FSImage.LOG).getLogger().setLevel(Level.ALL);
        TEST_DIR = new File(System.getProperty("test.build.data", "build/test/data"));
    }
}

