/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.JournalSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestEditLogJournalFailures {
    private int editsPerformed = 0;
    private MiniDFSCluster cluster;
    private FileSystem fs;
    private Runtime runtime;

    @Before
    public void setUpMiniCluster() throws IOException {
        this.setUpMiniCluster((Configuration)new HdfsConfiguration(), true);
    }

    public void setUpMiniCluster(Configuration conf, boolean manageNameDfsDirs) throws IOException {
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).manageNameDfsDirs(manageNameDfsDirs).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.runtime = Runtime.getRuntime();
        this.runtime = (Runtime)Mockito.spy((Object)this.runtime);
        ((Runtime)Mockito.doNothing().when((Object)this.runtime)).exit(Matchers.anyInt());
        this.cluster.getNameNode().getFSImage().getEditLog().setRuntimeForTesting(this.runtime);
    }

    @After
    public void shutDownMiniCluster() throws IOException {
        if (this.fs != null) {
            this.fs.close();
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testSingleFailedEditsDirOnFlush() throws IOException {
        Assert.assertTrue((boolean)this.doAnEdit());
        this.invalidateEditsDirAtIndex(0, true, false);
        this.assertExitInvocations(0);
        Assert.assertTrue((boolean)this.doAnEdit());
        this.assertExitInvocations(0);
        Assert.assertFalse((boolean)this.cluster.getNameNode().isInSafeMode());
    }

    @Test
    public void testAllEditsDirsFailOnFlush() throws IOException {
        Assert.assertTrue((boolean)this.doAnEdit());
        this.invalidateEditsDirAtIndex(0, true, false);
        this.invalidateEditsDirAtIndex(1, true, false);
        this.assertExitInvocations(0);
        Assert.assertTrue((boolean)this.doAnEdit());
        this.assertExitInvocations(1);
    }

    @Test
    public void testAllEditsDirFailOnWrite() throws IOException {
        Assert.assertTrue((boolean)this.doAnEdit());
        this.invalidateEditsDirAtIndex(0, true, true);
        this.invalidateEditsDirAtIndex(1, true, true);
        this.assertExitInvocations(0);
        Assert.assertTrue((boolean)this.doAnEdit());
        this.assertExitInvocations(Mockito.atLeast((int)1));
    }

    @Test
    public void testSingleFailedEditsDirOnSetReadyToFlush() throws IOException {
        Assert.assertTrue((boolean)this.doAnEdit());
        this.invalidateEditsDirAtIndex(0, false, false);
        this.assertExitInvocations(0);
        Assert.assertTrue((boolean)this.doAnEdit());
        this.assertExitInvocations(0);
        Assert.assertFalse((boolean)this.cluster.getNameNode().isInSafeMode());
    }

    @Test
    public void testSingleRequiredFailedEditsDirOnSetReadyToFlush() throws IOException {
        String[] editsDirs = this.cluster.getConfiguration(0).getTrimmedStrings("dfs.namenode.name.dir");
        this.shutDownMiniCluster();
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.edits.dir.required", editsDirs[0]);
        conf.setInt("dfs.namenode.edits.dir.minimum", 0);
        conf.setInt("dfs.namenode.resource.checked.volumes.minimum", 0);
        this.setUpMiniCluster((Configuration)conf, true);
        Assert.assertTrue((boolean)this.doAnEdit());
        this.invalidateEditsDirAtIndex(0, false, false);
        JournalSet.JournalAndStream nonRequiredJas = this.getJournalAndStream(1);
        EditLogFileOutputStream nonRequiredSpy = this.spyOnStream(nonRequiredJas);
        this.assertExitInvocations(0);
        Assert.assertTrue((boolean)nonRequiredJas.isActive());
        this.doAnEdit();
        ((EditLogFileOutputStream)Mockito.verify((Object)nonRequiredSpy, (VerificationMode)Mockito.never())).setReadyToFlush();
        Assert.assertFalse((boolean)nonRequiredJas.isActive());
        this.assertExitInvocations(Mockito.atLeast((int)1));
    }

    @Test
    public void testMultipleRedundantFailedEditsDirOnSetReadyToFlush() throws IOException {
        this.shutDownMiniCluster();
        HdfsConfiguration conf = new HdfsConfiguration();
        Object[] nameDirs = new String[4];
        for (int i = 0; i < nameDirs.length; ++i) {
            File nameDir = new File(System.getProperty("test.build.data"), "name-dir" + i);
            nameDir.mkdirs();
            nameDirs[i] = nameDir.getAbsolutePath();
        }
        conf.set("dfs.namenode.name.dir", StringUtils.join((Object[])nameDirs, (String)","));
        conf.setInt("dfs.namenode.edits.dir.minimum", 2);
        this.setUpMiniCluster((Configuration)conf, false);
        Assert.assertTrue((boolean)this.doAnEdit());
        this.assertExitInvocations(0);
        this.invalidateEditsDirAtIndex(0, false, false);
        Assert.assertTrue((boolean)this.doAnEdit());
        this.assertExitInvocations(0);
        this.invalidateEditsDirAtIndex(1, false, false);
        Assert.assertTrue((boolean)this.doAnEdit());
        this.assertExitInvocations(0);
        this.invalidateEditsDirAtIndex(2, false, false);
        this.doAnEdit();
        this.assertExitInvocations(Mockito.atLeast((int)1));
    }

    private void invalidateEditsDirAtIndex(int index, boolean failOnFlush, boolean failOnWrite) throws IOException {
        JournalSet.JournalAndStream jas = this.getJournalAndStream(index);
        EditLogFileOutputStream spyElos = this.spyOnStream(jas);
        if (failOnWrite) {
            ((EditLogFileOutputStream)Mockito.doThrow((Throwable)new IOException("fail on write()")).when((Object)spyElos)).write((FSEditLogOp)Matchers.any());
        }
        if (failOnFlush) {
            ((EditLogFileOutputStream)Mockito.doThrow((Throwable)new IOException("fail on flush()")).when((Object)spyElos)).flush();
        } else {
            ((EditLogFileOutputStream)Mockito.doThrow((Throwable)new IOException("fail on setReadyToFlush()")).when((Object)spyElos)).setReadyToFlush();
        }
        ((EditLogFileOutputStream)Mockito.doNothing().when((Object)spyElos)).abort();
    }

    private EditLogFileOutputStream spyOnStream(JournalSet.JournalAndStream jas) {
        EditLogFileOutputStream elos = (EditLogFileOutputStream)jas.getCurrentStream();
        EditLogFileOutputStream spyElos = (EditLogFileOutputStream)Mockito.spy((Object)elos);
        jas.setCurrentStreamForTests((EditLogOutputStream)spyElos);
        return spyElos;
    }

    private JournalSet.JournalAndStream getJournalAndStream(int index) {
        FSImage fsimage = this.cluster.getNamesystem().getFSImage();
        FSEditLog editLog = fsimage.getEditLog();
        return (JournalSet.JournalAndStream)editLog.getJournals().get(index);
    }

    private boolean doAnEdit() throws IOException {
        return this.fs.mkdirs(new Path("/tmp", Integer.toString(this.editsPerformed++)));
    }

    private void assertExitInvocations(int expectedExits) {
        this.assertExitInvocations(Mockito.times((int)expectedExits));
    }

    private void assertExitInvocations(VerificationMode expectedExits) {
        ((Runtime)Mockito.verify((Object)this.runtime, (VerificationMode)expectedExits)).exit(Matchers.anyInt());
    }
}

