/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogLoader;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.JournalSet;
import org.apache.hadoop.hdfs.server.namenode.JournalStream;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Level;
import org.aspectj.util.FileUtil;
import org.junit.Test;
import org.mockito.Mockito;

public class TestEditLog
extends TestCase {
    static final Log LOG;
    static final int NUM_DATA_NODES = 0;
    static final int NUM_TRANSACTIONS = 100;
    static final int NUM_THREADS = 100;
    static final File TEST_DIR;
    static final byte[] HADOOP20_SOME_EDITS;
    static final byte TRAILER_BYTE;
    private static final int CHECKPOINT_ON_STARTUP_MIN_TXNS = 100;
    static final int TXNS_PER_ROLL = 10;
    static final int TXNS_PER_FAIL = 2;

    public void testPreTxIdEditLogNoEdits() throws Exception {
        FSNamesystem namesys = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        namesys.dir = (FSDirectory)Mockito.mock(FSDirectory.class);
        long numEdits = this.testLoad(StringUtils.hexStringToByte((String)"ffffffed"), namesys);
        TestEditLog.assertEquals((long)0L, (long)numEdits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPreTxidEditLogWithEdits() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            FSNamesystem namesystem = cluster.getNamesystem();
            long numEdits = this.testLoad(HADOOP20_SOME_EDITS, namesystem);
            TestEditLog.assertEquals((long)3L, (long)numEdits);
            HdfsFileStatus fileInfo = namesystem.getFileInfo("/myfile", false);
            TestEditLog.assertEquals((String)"supergroup", (String)fileInfo.getGroup());
            TestEditLog.assertEquals((int)3, (int)fileInfo.getReplication());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private long testLoad(byte[] data, FSNamesystem namesys) throws IOException {
        FSEditLogLoader loader = new FSEditLogLoader(namesys);
        return loader.loadFSEdits((EditLogInputStream)new EditLogByteInputStream(data), 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleEditLog() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        FileSystem fileSys = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            FSNamesystem namesystem = cluster.getNamesystem();
            FSImage fsimage = namesystem.getFSImage();
            FSEditLog editLog = fsimage.getEditLog();
            this.assertExistsInStorageDirs(cluster, NNStorage.NameNodeDirType.EDITS, NNStorage.getInProgressEditsFileName((long)1L));
            editLog.logSetReplication("fakefile", (short)1);
            editLog.logSync();
            editLog.rollEditLog();
            this.assertExistsInStorageDirs(cluster, NNStorage.NameNodeDirType.EDITS, NNStorage.getFinalizedEditsFileName((long)1L, (long)3L));
            this.assertExistsInStorageDirs(cluster, NNStorage.NameNodeDirType.EDITS, NNStorage.getInProgressEditsFileName((long)4L));
            editLog.logSetReplication("fakefile", (short)2);
            editLog.logSync();
            editLog.close();
        }
        finally {
            if (fileSys != null) {
                fileSys.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public void testMultiThreadedEditLog() throws IOException {
        this.testEditLog(2048);
        this.testEditLog(1);
    }

    private void assertExistsInStorageDirs(MiniDFSCluster cluster, NNStorage.NameNodeDirType dirType, String filename) {
        NNStorage storage = cluster.getNamesystem().getFSImage().getStorage();
        for (Storage.StorageDirectory sd : storage.dirIterable((Storage.StorageDirType)dirType)) {
            File f = new File(sd.getCurrentDir(), filename);
            TestEditLog.assertTrue((String)("Expect that " + f + " exists"), (boolean)f.exists());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testEditLog(int initialSize) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        FileSystem fileSys = null;
        try {
            int i;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            FSNamesystem namesystem = cluster.getNamesystem();
            Iterator<URI> it = cluster.getNameDirs(0).iterator();
            while (it.hasNext()) {
                File dir = new File(it.next().getPath());
                System.out.println(dir);
            }
            FSImage fsimage = namesystem.getFSImage();
            FSEditLog editLog = fsimage.getEditLog();
            editLog.setOutputBufferCapacity(initialSize);
            fsimage.rollEditLog();
            Thread[] threadId = new Thread[100];
            for (i = 0; i < 100; ++i) {
                Transactions trans = new Transactions(namesystem, 100, i);
                threadId[i] = new Thread((Runnable)trans, "TransactionThread-" + i);
                threadId[i].start();
            }
            for (i = 0; i < 100; ++i) {
                try {
                    threadId[i].join();
                    continue;
                }
                catch (InterruptedException e) {
                    --i;
                }
            }
            fsimage.rollEditLog();
            long expectedTxns = 20002L;
            Iterator it2 = fsimage.getStorage().dirIterator((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS);
            while (it2.hasNext()) {
                FSEditLogLoader loader = new FSEditLogLoader(namesystem);
                File editFile = NNStorage.getFinalizedEditsFile((Storage.StorageDirectory)((Storage.StorageDirectory)it2.next()), (long)3L, (long)(3L + expectedTxns - 1L));
                TestEditLog.assertTrue((String)("Expect " + editFile + " exists"), (boolean)editFile.exists());
                System.out.println("Verifying file: " + editFile);
                long numEdits = loader.loadFSEdits((EditLogInputStream)new EditLogFileInputStream(editFile), 3L);
                int numLeases = namesystem.leaseManager.countLease();
                System.out.println("Number of outstanding leases " + numLeases);
                TestEditLog.assertEquals((int)0, (int)numLeases);
                TestEditLog.assertTrue((String)("Verification for " + editFile + " failed. " + "Expected " + expectedTxns + " transactions. " + "Found " + numEdits + " transactions."), (numEdits == expectedTxns ? 1 : 0) != 0);
            }
        }
        finally {
            try {
                if (fileSys != null) {
                    fileSys.close();
                }
                if (cluster != null) {
                    cluster.shutdown();
                }
            }
            catch (Throwable t) {
                LOG.error((Object)"Couldn't shut down cleanly", t);
            }
        }
    }

    private void doLogEdit(ExecutorService exec, final FSEditLog log, final String filename) throws Exception {
        exec.submit(new Callable<Void>(){

            @Override
            public Void call() {
                log.logSetReplication(filename, (short)1);
                return null;
            }
        }).get();
    }

    private void doCallLogSync(ExecutorService exec, final FSEditLog log) throws Exception {
        exec.submit(new Callable<Void>(){

            @Override
            public Void call() {
                log.logSync();
                return null;
            }
        }).get();
    }

    private void doCallLogSyncAll(ExecutorService exec, final FSEditLog log) throws Exception {
        exec.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                log.logSyncAll();
                return null;
            }
        }).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSyncBatching() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        FileSystem fileSys = null;
        ExecutorService threadA = Executors.newSingleThreadExecutor();
        ExecutorService threadB = Executors.newSingleThreadExecutor();
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            FSNamesystem namesystem = cluster.getNamesystem();
            FSImage fsimage = namesystem.getFSImage();
            FSEditLog editLog = fsimage.getEditLog();
            TestEditLog.assertEquals((String)"should start with only the BEGIN_LOG_SEGMENT txn synced", (long)1L, (long)editLog.getSyncTxId());
            this.doLogEdit(threadA, editLog, "thread-a 1");
            TestEditLog.assertEquals((String)"logging edit without syncing should do not affect txid", (long)1L, (long)editLog.getSyncTxId());
            this.doLogEdit(threadB, editLog, "thread-b 1");
            TestEditLog.assertEquals((String)"logging edit without syncing should do not affect txid", (long)1L, (long)editLog.getSyncTxId());
            this.doCallLogSync(threadB, editLog);
            TestEditLog.assertEquals((String)"logSync from second thread should bump txid up to 2", (long)3L, (long)editLog.getSyncTxId());
            this.doCallLogSync(threadA, editLog);
            TestEditLog.assertEquals((String)"logSync from first thread shouldn't change txid", (long)3L, (long)editLog.getSyncTxId());
            MetricsAsserts.assertCounter((String)"TransactionsBatchedInSync", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)"NameNodeActivity"));
        }
        finally {
            threadA.shutdown();
            threadB.shutdown();
            if (fileSys != null) {
                fileSys.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBatchedSyncWithClosedLogs() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        FileSystem fileSys = null;
        ExecutorService threadA = Executors.newSingleThreadExecutor();
        ExecutorService threadB = Executors.newSingleThreadExecutor();
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            FSNamesystem namesystem = cluster.getNamesystem();
            FSImage fsimage = namesystem.getFSImage();
            FSEditLog editLog = fsimage.getEditLog();
            this.doLogEdit(threadA, editLog, "thread-a 1");
            TestEditLog.assertEquals((String)"logging edit without syncing should do not affect txid", (long)1L, (long)editLog.getSyncTxId());
            this.doCallLogSyncAll(threadB, editLog);
            TestEditLog.assertEquals((String)"logSyncAll should sync thread A's transaction", (long)2L, (long)editLog.getSyncTxId());
            editLog.close();
            this.doCallLogSync(threadA, editLog);
        }
        finally {
            threadA.shutdown();
            threadB.shutdown();
            if (fileSys != null) {
                fileSys.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public void testEditChecksum() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        FileSystem fileSys = null;
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
        cluster.waitActive();
        fileSys = cluster.getFileSystem();
        FSNamesystem namesystem = cluster.getNamesystem();
        FSImage fsimage = namesystem.getFSImage();
        FSEditLog editLog = fsimage.getEditLog();
        fileSys.mkdirs(new Path("/tmp"));
        Storage.StorageDirectory sd = (Storage.StorageDirectory)fsimage.getStorage().dirIterator((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS).next();
        editLog.close();
        cluster.shutdown();
        File editFile = NNStorage.getFinalizedEditsFile((Storage.StorageDirectory)sd, (long)1L, (long)3L);
        TestEditLog.assertTrue((boolean)editFile.exists());
        long fileLen = editFile.length();
        System.out.println("File name: " + editFile + " len: " + fileLen);
        RandomAccessFile rwf = new RandomAccessFile(editFile, "rw");
        rwf.seek(fileLen - 4L);
        int b = rwf.readInt();
        rwf.seek(fileLen - 4L);
        rwf.writeInt(b + 1);
        rwf.close();
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(false).build();
            TestEditLog.fail((String)"should not be able to start");
        }
        catch (IOException e) {
            TestEditLog.assertEquals((String)"Cause of exception should be ChecksumException", e.getCause().getClass(), ChecksumException.class);
        }
    }

    public void testCrashRecoveryNoTransactions() throws Exception {
        this.testCrashRecovery(0);
    }

    public void testCrashRecoveryWithTransactions() throws Exception {
        this.testCrashRecovery(150);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCrashRecovery(int numTransactions) throws Exception {
        MiniDFSCluster cluster = null;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.checkpoint.txns", 100);
        try {
            LOG.info((Object)"\n===========================================\nStarting empty cluster");
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(true).build();
            cluster.waitActive();
            FileSystem fs = cluster.getFileSystem();
            for (int i = 0; i < numTransactions; ++i) {
                fs.mkdirs(new Path("/test" + i));
            }
            File nameDir = new File(cluster.getNameDirs(0).iterator().next().getPath());
            File dfsDir = nameDir.getParentFile();
            TestEditLog.assertEquals((String)dfsDir.getName(), (String)"dfs");
            LOG.info((Object)"Copying data directory aside to a hot backup");
            File backupDir = new File(dfsDir.getParentFile(), "dfs.backup-while-running");
            FileUtil.copyDir((File)dfsDir, (File)backupDir);
            LOG.info((Object)"Shutting down cluster #1");
            cluster.shutdown();
            cluster = null;
            FileUtil.deleteContents((File)dfsDir);
            backupDir.renameTo(dfsDir);
            File currentDir = new File(nameDir, "current");
            File editsFile = new File(currentDir, NNStorage.getInProgressEditsFileName((long)1L));
            TestEditLog.assertTrue((String)("Edits file " + editsFile + " should exist"), (boolean)editsFile.exists());
            File imageFile = FSImageTestUtil.findNewestImageFile(currentDir.getAbsolutePath());
            TestEditLog.assertNotNull((String)("No image found in " + nameDir), (Object)imageFile);
            TestEditLog.assertEquals((String)NNStorage.getImageFileName((long)0L), (String)imageFile.getName());
            LOG.info((Object)"\n===========================================\nStarting same cluster after simulated crash");
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(false).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            for (int i = 0; i < numTransactions; ++i) {
                TestEditLog.assertTrue((boolean)fs.exists(new Path("/test" + i)));
            }
            long expectedTxId = numTransactions > 100 ? (long)(numTransactions + 1) : 0L;
            imageFile = FSImageTestUtil.findNewestImageFile(currentDir.getAbsolutePath());
            TestEditLog.assertNotNull((String)("No image found in " + nameDir), (Object)imageFile);
            TestEditLog.assertEquals((String)NNStorage.getImageFileName((long)expectedTxId), (String)imageFile.getName());
            cluster.shutdown();
            cluster = null;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(false).build();
            cluster.waitActive();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public void testCrashRecoveryEmptyLogOneDir() throws Exception {
        this.doTestCrashRecoveryEmptyLog(false, true, true);
    }

    public void testCrashRecoveryEmptyLogBothDirs() throws Exception {
        this.doTestCrashRecoveryEmptyLog(true, true, false);
    }

    public void testCrashRecoveryEmptyLogOneDirNoUpdateSeenTxId() throws Exception {
        this.doTestCrashRecoveryEmptyLog(false, false, true);
    }

    public void testCrashRecoveryEmptyLogBothDirsNoUpdateSeenTxId() throws Exception {
        this.doTestCrashRecoveryEmptyLog(true, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestCrashRecoveryEmptyLog(boolean inBothDirs, boolean updateTransactionIdFile, boolean shouldSucceed) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
        cluster.shutdown();
        Collection<URI> editsDirs = cluster.getNameEditsDirs(0);
        for (URI uri : editsDirs) {
            File dir = new File(uri.getPath());
            File currentDir = new File(dir, "current");
            GenericTestUtils.assertGlobEquals(currentDir, "edits_.*", NNStorage.getFinalizedEditsFileName((long)1L, (long)2L));
            File log = new File(currentDir, NNStorage.getInProgressEditsFileName((long)3L));
            new EditLogFileOutputStream(log, 1024).create();
            if (!inBothDirs) break;
            NNStorage storage = new NNStorage((Configuration)conf, Collections.emptyList(), (Collection)Lists.newArrayList((Object[])new URI[]{uri}));
            if (updateTransactionIdFile) {
                storage.writeTransactionIdFileToStorage(3L);
            }
            storage.close();
        }
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(false).build();
            if (!shouldSucceed) {
                TestEditLog.fail((String)"Should not have succeeded in startin cluster");
            }
        }
        catch (IOException ioe) {
            if (shouldSucceed) {
                LOG.info((Object)"Should have succeeded in starting cluster, but failed", (Throwable)ioe);
                throw ioe;
            }
            GenericTestUtils.assertExceptionContains("No non-corrupt logs for txid 3", ioe);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailedOpen() throws Exception {
        File logDir = new File(TEST_DIR, "testFailedOpen");
        logDir.mkdirs();
        FSEditLog log = FSImageTestUtil.createStandaloneEditLog(logDir);
        try {
            logDir.setWritable(false);
            log.openForWrite();
            TestEditLog.fail((String)"Did no throw exception on only having a bad dir");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains("too few journals successfully started", ioe);
        }
        finally {
            logDir.setWritable(true);
            log.close();
        }
    }

    @Test
    public void testEditLogManifestMocks() throws IOException {
        NNStorage storage = this.mockStorageWithEdits("[1,100]|[101,200]|[201,]", "[1,100]|[101,200]|[201,]");
        FSEditLog log = new FSEditLog(storage);
        log.initJournalsForWrite();
        TestEditLog.assertEquals((String)"[[1,100], [101,200]]", (String)log.getEditLogManifest(1L).toString());
        TestEditLog.assertEquals((String)"[[101,200]]", (String)log.getEditLogManifest(101L).toString());
        storage = this.mockStorageWithEdits("[1,100]|[101,200]", "[1,100]|[201,300]|[301,400]");
        log = new FSEditLog(storage);
        log.initJournalsForWrite();
        TestEditLog.assertEquals((String)"[[1,100], [101,200], [201,300], [301,400]]", (String)log.getEditLogManifest(1L).toString());
        storage = this.mockStorageWithEdits("[1,100]|[301,400]", "[301,400]|[401,500]");
        log = new FSEditLog(storage);
        log.initJournalsForWrite();
        TestEditLog.assertEquals((String)"[[301,400], [401,500]]", (String)log.getEditLogManifest(1L).toString());
        storage = this.mockStorageWithEdits("[1,100]|[101,150]", "[1,50]|[101,200]");
        log = new FSEditLog(storage);
        log.initJournalsForWrite();
        TestEditLog.assertEquals((String)"[[1,100], [101,200]]", (String)log.getEditLogManifest(1L).toString());
        TestEditLog.assertEquals((String)"[[101,200]]", (String)log.getEditLogManifest(101L).toString());
        storage = this.mockStorageWithEdits("[1,100]|[101,]", "[1,100]|[101,200]");
        log = new FSEditLog(storage);
        log.initJournalsForWrite();
        TestEditLog.assertEquals((String)"[[1,100], [101,200]]", (String)log.getEditLogManifest(1L).toString());
        TestEditLog.assertEquals((String)"[[101,200]]", (String)log.getEditLogManifest(101L).toString());
    }

    private NNStorage mockStorageWithEdits(String ... editsDirSpecs) throws IOException {
        ArrayList sds = Lists.newArrayList();
        ArrayList uris = Lists.newArrayList();
        NNStorage storage = (NNStorage)Mockito.mock(NNStorage.class);
        for (String dirSpec : editsDirSpecs) {
            String[] logSpecs;
            ArrayList files = Lists.newArrayList();
            for (String logSpec : logSpecs = dirSpec.split("\\|")) {
                Matcher m = Pattern.compile("\\[(\\d+),(\\d+)?\\]").matcher(logSpec);
                TestEditLog.assertTrue((String)("bad spec: " + logSpec), (boolean)m.matches());
                if (m.group(2) == null) {
                    files.add(NNStorage.getInProgressEditsFileName((long)Long.valueOf(m.group(1))));
                    continue;
                }
                files.add(NNStorage.getFinalizedEditsFileName((long)Long.valueOf(m.group(1)), (long)Long.valueOf(m.group(2))));
            }
            Storage.StorageDirectory sd = FSImageTestUtil.mockStorageDirectory((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS, false, files.toArray(new String[0]));
            sds.add(sd);
            URI u = URI.create("file:///storage" + Math.random());
            ((NNStorage)Mockito.doReturn((Object)sd).when((Object)storage)).getStorageDirectory(u);
            uris.add(u);
        }
        ((NNStorage)Mockito.doReturn((Object)sds).when((Object)storage)).dirIterable((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS);
        ((NNStorage)Mockito.doReturn((Object)uris).when((Object)storage)).getEditsDirectories();
        return storage;
    }

    public static NNStorage setupEdits(List<URI> editUris, int numrolls, boolean closeOnFinish, AbortSpec ... abortAtRolls) throws IOException {
        int i;
        ArrayList<AbortSpec> aborts = new ArrayList<AbortSpec>(Arrays.asList(abortAtRolls));
        NNStorage storage = new NNStorage(new Configuration(), Collections.emptyList(), editUris);
        storage.format("test-cluster-id");
        FSEditLog editlog = new FSEditLog(storage);
        editlog.initJournalsForWrite();
        editlog.openForWrite();
        for (i = 2; i < 10; ++i) {
            editlog.logGenerationStamp(0L);
        }
        editlog.logSync();
        for (i = 0; i < numrolls; ++i) {
            editlog.rollEditLog();
            editlog.logGenerationStamp((long)i);
            editlog.logSync();
            while (aborts.size() > 0 && ((AbortSpec)aborts.get((int)0)).roll == i + 1) {
                AbortSpec spec = (AbortSpec)aborts.remove(0);
                ((JournalSet.JournalAndStream)editlog.getJournals().get(spec.logindex)).abort();
            }
            for (int j = 3; j < 10; ++j) {
                editlog.logGenerationStamp((long)i);
            }
            editlog.logSync();
        }
        if (closeOnFinish) {
            editlog.close();
        }
        FSImageTestUtil.logStorageContents(LOG, storage);
        return storage;
    }

    public static NNStorage setupEdits(List<URI> editUris, int numrolls, AbortSpec ... abortAtRolls) throws IOException {
        return TestEditLog.setupEdits(editUris, numrolls, true, abortAtRolls);
    }

    @Test
    public void testAlternatingJournalFailure() throws IOException {
        File f1 = new File(TEST_DIR + "/alternatingjournaltest0");
        File f2 = new File(TEST_DIR + "/alternatingjournaltest1");
        ImmutableList editUris = ImmutableList.of((Object)f1.toURI(), (Object)f2.toURI());
        NNStorage storage = TestEditLog.setupEdits((List<URI>)editUris, 10, new AbortSpec(1, 0), new AbortSpec(2, 1), new AbortSpec(3, 0), new AbortSpec(4, 1), new AbortSpec(5, 0), new AbortSpec(6, 1), new AbortSpec(7, 0), new AbortSpec(8, 1), new AbortSpec(9, 0), new AbortSpec(10, 1));
        long totaltxnread = 0L;
        FSEditLog editlog = new FSEditLog(storage);
        editlog.initJournalsForWrite();
        long startTxId = 1L;
        Collection editStreams = editlog.selectInputStreams(startTxId, 110L);
        for (EditLogInputStream edits : editStreams) {
            FSEditLogLoader.EditLogValidation val = FSEditLogLoader.validateEditLog((EditLogInputStream)edits);
            long read = val.getNumTransactions();
            LOG.info((Object)("Loading edits " + edits + " read " + read));
            TestEditLog.assertEquals((long)startTxId, (long)val.getStartTxId());
            startTxId += read;
            totaltxnread += read;
        }
        editlog.close();
        storage.close();
        TestEditLog.assertEquals((long)110L, (long)totaltxnread);
    }

    @Test
    public void testLoadingWithGaps() throws IOException {
        File f1 = new File(TEST_DIR + "/gaptest0");
        ImmutableList editUris = ImmutableList.of((Object)f1.toURI());
        NNStorage storage = TestEditLog.setupEdits((List<URI>)editUris, 3, new AbortSpec[0]);
        long startGapTxId = 11L;
        long endGapTxId = 20L;
        File[] files = new File(f1, "current").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(NNStorage.getFinalizedEditsFileName((long)11L, (long)20L));
            }
        });
        TestEditLog.assertEquals((int)1, (int)files.length);
        TestEditLog.assertTrue((boolean)files[0].delete());
        FSEditLog editlog = new FSEditLog(storage);
        editlog.initJournalsForWrite();
        long startTxId = 1L;
        try {
            editlog.selectInputStreams(startTxId, 40L);
            TestEditLog.fail((String)"Should have thrown exception");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains("No non-corrupt logs for txid 11", ioe);
        }
    }

    static {
        ((Log4JLogger)FSEditLog.LOG).getLogger().setLevel(Level.ALL);
        LOG = LogFactory.getLog(TestEditLog.class);
        TEST_DIR = new File(System.getProperty("test.build.data", "build/test/data"));
        HADOOP20_SOME_EDITS = StringUtils.hexStringToByte((String)"ffff ffed 0a00 0000 0000 03fa e100 00000005 0007 2f6d 7966 696c 6500 0133 000d3132 3932 3331 3634 3034 3138 3400 0d313239 3233 3136 3430 3431 3834 0009 31333432 3137 3732 3800 0000 0004 746f 64640a73 7570 6572 6772 6f75 7001 a400 15444653 436c 6965 6e74 5f2d 3136 3136 35353738 3931 000b 3137 322e 3239 2e35 2e333209 0000 0005 0007 2f6d 7966 696c 65000133 000d 3132 3932 3331 3634 3034 31383400 0d31 3239 3233 3136 3430 3431 38340009 3133 3432 3137 3732 3800 0000 0004746f 6464 0a73 7570 6572 6772 6f75 7001a4ff 0000 0000 0000 0000 0000 0000 0000".replace(" ", ""));
        TRAILER_BYTE = FSEditLogOpCodes.OP_INVALID.getOpCode();
    }

    static class AbortSpec {
        final int roll;
        final int logindex;

        AbortSpec(int roll, int logindex) {
            this.roll = roll;
            this.logindex = logindex;
        }
    }

    private static class EditLogByteInputStream
    extends EditLogInputStream {
        private InputStream input;
        private long len;
        private int version;
        private FSEditLogOp.Reader reader = null;
        private FSEditLogLoader.PositionTrackingInputStream tracker = null;

        public EditLogByteInputStream(byte[] data) throws IOException {
            this.len = data.length;
            this.input = new ByteArrayInputStream(data);
            BufferedInputStream bin = new BufferedInputStream(this.input);
            DataInputStream in = new DataInputStream(bin);
            this.version = EditLogFileInputStream.readLogVersion((DataInputStream)in);
            this.tracker = new FSEditLogLoader.PositionTrackingInputStream((InputStream)in);
            in = new DataInputStream((InputStream)this.tracker);
            this.reader = new FSEditLogOp.Reader(in, this.version);
        }

        public long getFirstTxId() throws IOException {
            return -12345L;
        }

        public long getLastTxId() throws IOException {
            return -12345L;
        }

        public long length() throws IOException {
            return this.len;
        }

        public long getPosition() {
            return this.tracker.getPos();
        }

        public FSEditLogOp readOp() throws IOException {
            return this.reader.readOp();
        }

        public int getVersion() throws IOException {
            return this.version;
        }

        public void close() throws IOException {
            this.input.close();
        }

        public String getName() {
            return "AnonEditLogByteInputStream";
        }

        public JournalStream.JournalType getType() {
            return JournalStream.JournalType.FILE;
        }

        public boolean isInProgress() {
            return true;
        }
    }

    static class Transactions
    implements Runnable {
        FSNamesystem namesystem;
        int numTransactions;
        short replication = (short)3;
        long blockSize = 64L;
        final int id;

        Transactions(FSNamesystem ns, int num, int id) {
            this.namesystem = ns;
            this.numTransactions = num;
            this.id = id;
        }

        @Override
        public void run() {
            PermissionStatus p = this.namesystem.createFsOwnerPermissions(new FsPermission(511));
            FSEditLog editLog = this.namesystem.getEditLog();
            for (int i = 0; i < this.numTransactions; ++i) {
                INodeFileUnderConstruction inode = new INodeFileUnderConstruction(p, this.replication, this.blockSize, 0L, "", "", null);
                String fileName = "/filename-" + this.id + "-" + i;
                editLog.logOpenFile(fileName, inode);
                editLog.logCloseFile(fileName, (INodeFile)inode);
                editLog.logSync();
            }
        }
    }
}

