/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.RegisterCommand;
import org.junit.After;
import org.junit.Test;

public class TestDeadDatanode {
    private static final Log LOG = LogFactory.getLog(TestDeadDatanode.class);
    private MiniDFSCluster cluster;

    @After
    public void cleanup() {
        this.cluster.shutdown();
    }

    private void waitForDatanodeState(String nodeID, boolean alive, int waitTime) throws TimeoutException, InterruptedException {
        String state;
        long stopTime = System.currentTimeMillis() + (long)waitTime;
        FSNamesystem namesystem = this.cluster.getNamesystem();
        String string = state = alive ? "alive" : "dead";
        while (System.currentTimeMillis() < stopTime) {
            DatanodeDescriptor dd = BlockManagerTestUtil.getDatanode(namesystem, nodeID);
            if (dd.isAlive == alive) {
                LOG.info((Object)("datanode " + nodeID + " is " + state));
                return;
            }
            LOG.info((Object)("Waiting for datanode " + nodeID + " to become " + state));
            Thread.sleep(1000L);
        }
        throw new TimeoutException("Timedout waiting for datanode reach state " + state);
    }

    @Test
    public void testDeadDatanode() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 500);
        conf.setLong("dfs.heartbeat.interval", 1L);
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        this.cluster.waitActive();
        String poolId = this.cluster.getNamesystem().getBlockPoolId();
        DataNode dn = this.cluster.getDataNodes().get(0);
        DatanodeRegistration reg = DataNodeTestUtils.getDNRegistrationForBP(this.cluster.getDataNodes().get(0), poolId);
        this.waitForDatanodeState(reg.getStorageID(), true, 20000);
        dn.shutdown();
        this.waitForDatanodeState(reg.getStorageID(), false, 20000);
        NamenodeProtocols dnp = this.cluster.getNameNodeRpc();
        ReceivedDeletedBlockInfo[] blocks = new ReceivedDeletedBlockInfo[]{new ReceivedDeletedBlockInfo(new Block(0L), ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, null)};
        try {
            dnp.blockReceivedAndDeleted(reg, poolId, blocks);
            Assert.fail((String)"Expected IOException is not thrown");
        }
        catch (IOException ex) {
            // empty catch block
        }
        long[] blockReport = new long[]{0L, 0L, 0L};
        try {
            dnp.blockReport(reg, poolId, blockReport);
            Assert.fail((String)"Expected IOException is not thrown");
        }
        catch (IOException ex) {
            // empty catch block
        }
        DatanodeCommand[] cmd = dnp.sendHeartbeat(reg, 0L, 0L, 0L, 0L, 0, 0, 0).getCommands();
        Assert.assertEquals((int)1, (int)cmd.length);
        Assert.assertEquals((int)cmd[0].getAction(), (int)RegisterCommand.REGISTER.getAction());
    }
}

