/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestClusterId {
    private static final Log LOG = LogFactory.getLog(TestClusterId.class);
    File hdfsDir;

    private String getClusterId(Configuration config) throws IOException {
        Collection dirsToFormat = FSNamesystem.getNamespaceDirs((Configuration)config);
        List editsToFormat = FSNamesystem.getNamespaceEditsDirs((Configuration)config);
        FSImage fsImage = new FSImage(config, dirsToFormat, editsToFormat);
        Iterator sdit = fsImage.getStorage().dirIterator((Storage.StorageDirType)NNStorage.NameNodeDirType.IMAGE);
        Storage.StorageDirectory sd = (Storage.StorageDirectory)sdit.next();
        Properties props = Storage.readPropertiesFile((File)sd.getVersionFile());
        String cid = props.getProperty("clusterID");
        LOG.info((Object)("successfully formated : sd=" + sd.getCurrentDir() + ";cid=" + cid));
        return cid;
    }

    @Before
    public void setUp() throws IOException {
        String baseDir = System.getProperty("test.build.data", "build/test/data");
        this.hdfsDir = new File(baseDir, "dfs");
        if (this.hdfsDir.exists() && !FileUtil.fullyDelete((File)this.hdfsDir)) {
            throw new IOException("Could not delete test directory '" + this.hdfsDir + "'");
        }
        LOG.info((Object)("hdfsdir is " + this.hdfsDir.getAbsolutePath()));
    }

    @After
    public void tearDown() throws IOException {
        if (this.hdfsDir.exists() && !FileUtil.fullyDelete((File)this.hdfsDir)) {
            throw new IOException("Could not tearDown test directory '" + this.hdfsDir + "'");
        }
    }

    @Test
    public void testFormatClusterIdOption() throws IOException {
        Configuration config = new Configuration();
        config.set("dfs.namenode.name.dir", new File(this.hdfsDir, "name").getPath());
        NameNode.format((Configuration)config);
        String cid = this.getClusterId(config);
        Assert.assertTrue((String)"Didn't get new ClusterId", (cid != null && !cid.equals("") ? 1 : 0) != 0);
        HdfsServerConstants.StartupOption.FORMAT.setClusterId("mycluster");
        NameNode.format((Configuration)config);
        cid = this.getClusterId(config);
        Assert.assertTrue((String)"ClusterId didn't match", (boolean)cid.equals("mycluster"));
        HdfsServerConstants.StartupOption.FORMAT.setClusterId("");
        NameNode.format((Configuration)config);
        String newCid = this.getClusterId(config);
        Assert.assertFalse((String)"ClusterId should not be the same", (boolean)newCid.equals(cid));
    }
}

