/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.BackupImage;
import org.apache.hadoop.hdfs.server.namenode.BackupNode;
import org.apache.hadoop.hdfs.server.namenode.Checkpointer;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FileJournalManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.TestCheckpoint;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;

public class TestBackupNode
extends TestCase {
    public static final Log LOG = LogFactory.getLog(TestBackupNode.class);
    static final String BASE_DIR;

    protected void setUp() throws Exception {
        super.setUp();
        File baseDir = new File(BASE_DIR);
        if (baseDir.exists() && !FileUtil.fullyDelete((File)baseDir)) {
            throw new IOException("Cannot remove directory: " + baseDir);
        }
        File dirC = new File(TestBackupNode.getBackupNodeDir(HdfsServerConstants.StartupOption.CHECKPOINT, 1));
        dirC.mkdirs();
        File dirB = new File(TestBackupNode.getBackupNodeDir(HdfsServerConstants.StartupOption.BACKUP, 1));
        dirB.mkdirs();
        dirB = new File(TestBackupNode.getBackupNodeDir(HdfsServerConstants.StartupOption.BACKUP, 2));
        dirB.mkdirs();
    }

    static String getBackupNodeDir(HdfsServerConstants.StartupOption t, int idx) {
        return BASE_DIR + "name" + t.getName() + idx + "/";
    }

    BackupNode startBackupNode(Configuration conf, HdfsServerConstants.StartupOption startupOpt, int idx) throws IOException {
        HdfsConfiguration c = new HdfsConfiguration(conf);
        String dirs = TestBackupNode.getBackupNodeDir(startupOpt, idx);
        c.set("dfs.namenode.name.dir", dirs);
        c.set("dfs.namenode.edits.dir", "${dfs.namenode.name.dir}");
        c.set("dfs.namenode.backup.address", "127.0.0.1:0");
        return (BackupNode)NameNode.createNameNode((String[])new String[]{startupOpt.getName()}, (Configuration)c);
    }

    void waitCheckpointDone(MiniDFSCluster cluster, BackupNode backup, long txid) {
        long thisCheckpointTxId;
        do {
            try {
                LOG.info((Object)("Waiting checkpoint to complete... checkpoint txid should increase above " + txid));
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
        } while ((thisCheckpointTxId = backup.getFSImage().getStorage().getMostRecentCheckpointTxId()) < txid);
        FSImageTestUtil.assertNNHasCheckpoints(cluster, Collections.singletonList((int)thisCheckpointTxId));
    }

    public void testCheckpointNode() throws Exception {
        this.testCheckpoint(HdfsServerConstants.StartupOption.CHECKPOINT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBackupNodeTailsEdits() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        HAUtil.setAllowStandbyReads((Configuration)conf, (boolean)true);
        MiniDFSCluster cluster = null;
        FileSystem fileSys = null;
        BackupNode backup = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            fileSys = cluster.getFileSystem();
            backup = this.startBackupNode((Configuration)conf, HdfsServerConstants.StartupOption.BACKUP, 1);
            BackupImage bnImage = (BackupImage)backup.getFSImage();
            this.testBNInSync(cluster, backup, 1);
            NameNode nn = cluster.getNameNode();
            NamenodeProtocols nnRpc = nn.getRpcServer();
            nnRpc.rollEditLog();
            TestBackupNode.assertEquals((long)bnImage.getEditLog().getCurSegmentTxId(), (long)nn.getFSImage().getEditLog().getCurSegmentTxId());
            this.testBNInSync(cluster, backup, 2);
            long nnImageBefore = nn.getFSImage().getStorage().getMostRecentCheckpointTxId();
            backup.doCheckpoint();
            long nnImageAfter = nn.getFSImage().getStorage().getMostRecentCheckpointTxId();
            TestBackupNode.assertTrue((String)("nn should have received new checkpoint. before: " + nnImageBefore + " after: " + nnImageAfter), (nnImageAfter > nnImageBefore ? 1 : 0) != 0);
            this.testBNInSync(cluster, backup, 3);
            Storage.StorageDirectory sd = bnImage.getStorage().getStorageDir(0);
            backup.stop();
            backup = null;
            FileJournalManager.EditLogFile editsLog = FSImageTestUtil.findLatestEditsLog(sd);
            TestBackupNode.assertEquals((long)editsLog.getFirstTxId(), (long)nn.getFSImage().getEditLog().getCurSegmentTxId());
            TestBackupNode.assertTrue((String)("Should not have finalized " + editsLog), (boolean)editsLog.isInProgress());
            TestBackupNode.assertTrue((boolean)fileSys.mkdirs(new Path("/edit-while-bn-down")));
            backup = this.startBackupNode((Configuration)conf, HdfsServerConstants.StartupOption.BACKUP, 1);
            this.testBNInSync(cluster, backup, 4);
            TestBackupNode.assertNotNull((Object)backup.getNamesystem().getFileInfo("/edit-while-bn-down", false));
        }
        finally {
            LOG.info((Object)"Shutting down...");
            if (backup != null) {
                backup.stop();
            }
            if (fileSys != null) {
                fileSys.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        this.assertStorageDirsMatch(cluster.getNameNode(), backup);
    }

    private void testBNInSync(MiniDFSCluster cluster, final BackupNode backup, int testIdx) throws Exception {
        final NameNode nn = cluster.getNameNode();
        FileSystem fs = cluster.getFileSystem();
        for (int i = 0; i < 10; ++i) {
            final String src = "/test_" + testIdx + "_" + i;
            LOG.info((Object)("Creating " + src + " on NN"));
            Path p = new Path(src);
            TestBackupNode.assertTrue((boolean)fs.mkdirs(p));
            GenericTestUtils.waitFor(new Supplier<Boolean>(){

                public Boolean get() {
                    LOG.info((Object)("Checking for " + src + " on BN"));
                    try {
                        boolean hasFile = backup.getNamesystem().getFileInfo(src, false) != null;
                        boolean txnIdMatch = backup.getRpcServer().getTransactionID() == nn.getRpcServer().getTransactionID();
                        return hasFile && txnIdMatch;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, 30, 10000);
        }
        this.assertStorageDirsMatch(nn, backup);
    }

    private void assertStorageDirsMatch(NameNode nn, BackupNode backup) throws Exception {
        ArrayList dirs = Lists.newArrayList(FSImageTestUtil.getCurrentDirs(nn.getFSImage().getStorage(), null));
        dirs.addAll(FSImageTestUtil.getCurrentDirs(backup.getFSImage().getStorage(), null));
        FSImageTestUtil.assertParallelFilesAreIdentical(dirs, (Set<String>)ImmutableSet.of((Object)"VERSION"));
    }

    public void testBackupNode() throws Exception {
        this.testCheckpoint(HdfsServerConstants.StartupOption.BACKUP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testCheckpoint(HdfsServerConstants.StartupOption op) throws Exception {
        Path file1 = new Path("/checkpoint.dat");
        Path file2 = new Path("/checkpoint2.dat");
        Path file3 = new Path("/backup.dat");
        HdfsConfiguration conf = new HdfsConfiguration();
        HAUtil.setAllowStandbyReads((Configuration)conf, (boolean)true);
        short replication = (short)conf.getInt("dfs.replication", 3);
        int numDatanodes = Math.max(3, replication);
        conf.set("dfs.blockreport.initialDelay", "0");
        conf.setInt("dfs.datanode.scan.period.hours", -1);
        conf.setInt("dfs.namenode.checkpoint.txns", 1);
        MiniDFSCluster cluster = null;
        FileSystem fileSys = null;
        BackupNode backup = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            fileSys = cluster.getFileSystem();
            TestBackupNode.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
            TestBackupNode.assertTrue((!fileSys.exists(file2) ? 1 : 0) != 0);
            TestBackupNode.assertTrue((boolean)fileSys.mkdirs(file1));
            long txid = cluster.getNameNodeRpc().getTransactionID();
            backup = this.startBackupNode((Configuration)conf, op, 1);
            this.waitCheckpointDone(cluster, backup, txid);
        }
        catch (IOException e) {
            LOG.error((Object)"Error in TestBackupNode:", (Throwable)e);
            TestBackupNode.assertTrue((String)e.getLocalizedMessage(), (boolean)false);
        }
        finally {
            if (backup != null) {
                backup.stop();
            }
            if (fileSys != null) {
                fileSys.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        File nnCurDir = new File(BASE_DIR, "name1/current/");
        File bnCurDir = new File(TestBackupNode.getBackupNodeDir(op, 1), "/current/");
        FSImageTestUtil.assertParallelFilesAreIdentical((List<File>)ImmutableList.of((Object)bnCurDir, (Object)nnCurDir), (Set<String>)ImmutableSet.of((Object)"VERSION"));
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(numDatanodes).format(false).build();
            fileSys = cluster.getFileSystem();
            TestBackupNode.assertTrue((boolean)fileSys.exists(file1));
            fileSys.delete(file1, true);
            fileSys.mkdirs(file2);
            backup = this.startBackupNode((Configuration)conf, op, 1);
            long txid = cluster.getNameNodeRpc().getTransactionID();
            this.waitCheckpointDone(cluster, backup, txid);
            for (int i = 0; i < 10; ++i) {
                fileSys.mkdirs(new Path("file_" + i));
            }
            txid = cluster.getNameNodeRpc().getTransactionID();
            backup.doCheckpoint();
            this.waitCheckpointDone(cluster, backup, txid);
            txid = cluster.getNameNodeRpc().getTransactionID();
            backup.doCheckpoint();
            this.waitCheckpointDone(cluster, backup, txid);
            InetSocketAddress add = backup.getNameNodeAddress();
            FileSystem bnFS = FileSystem.get((URI)new Path("hdfs://" + NameNode.getHostPortString((InetSocketAddress)add)).toUri(), (Configuration)conf);
            boolean canWrite = true;
            try {
                TestCheckpoint.writeFile(bnFS, file3, replication);
            }
            catch (IOException eio) {
                LOG.info((Object)"Write to BN failed as expected: ", (Throwable)eio);
                canWrite = false;
            }
            TestBackupNode.assertFalse((String)"Write to BackupNode must be prohibited.", (boolean)canWrite);
            TestCheckpoint.writeFile(fileSys, file3, replication);
            TestCheckpoint.checkFile(fileSys, file3, replication);
            TestBackupNode.assertTrue((String)"file3 does not exist on BackupNode", (op != HdfsServerConstants.StartupOption.BACKUP || backup.getNamesystem().getFileInfo(file3.toUri().getPath(), false) != null ? 1 : 0) != 0);
        }
        catch (IOException e) {
            LOG.error((Object)"Error in TestBackupNode:", (Throwable)e);
            throw new AssertionError((Object)e);
        }
        finally {
            if (backup != null) {
                backup.stop();
            }
            if (fileSys != null) {
                fileSys.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        FSImageTestUtil.assertParallelFilesAreIdentical((List<File>)ImmutableList.of((Object)bnCurDir, (Object)nnCurDir), (Set<String>)ImmutableSet.of((Object)"VERSION"));
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(false).build();
            fileSys = cluster.getFileSystem();
            TestBackupNode.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
            TestBackupNode.assertTrue((boolean)fileSys.exists(file2));
        }
        catch (IOException e) {
            LOG.error((Object)"Error in TestBackupNode:", (Throwable)e);
            TestBackupNode.assertTrue((String)e.getLocalizedMessage(), (boolean)false);
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
    }

    static {
        ((Log4JLogger)Checkpointer.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)BackupImage.LOG).getLogger().setLevel(Level.ALL);
        BASE_DIR = MiniDFSCluster.getBaseDirectory();
    }
}

