/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeRpcServer;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.AccessControlException;
import org.mockito.Mockito;

public class NameNodeAdapter {
    public static FSNamesystem getNamesystem(NameNode namenode) {
        return namenode.getNamesystem();
    }

    public static LocatedBlocks getBlockLocations(NameNode namenode, String src, long offset, long length) throws IOException {
        return namenode.getNamesystem().getBlockLocations(src, offset, length, false, true);
    }

    public static HdfsFileStatus getFileInfo(NameNode namenode, String src, boolean resolveLink) throws AccessControlException, UnresolvedLinkException, StandbyException {
        return namenode.getNamesystem().getFileInfo(src, resolveLink);
    }

    public static boolean mkdirs(NameNode namenode, String src, PermissionStatus permissions, boolean createParent) throws UnresolvedLinkException, IOException {
        return namenode.getNamesystem().mkdirs(src, permissions, createParent);
    }

    public static void saveNamespace(NameNode namenode) throws AccessControlException, IOException {
        namenode.getNamesystem().saveNamespace();
    }

    public static void enterSafeMode(NameNode namenode, boolean resourcesLow) throws IOException {
        namenode.getNamesystem().enterSafeMode(resourcesLow);
    }

    public static void leaveSafeMode(NameNode namenode, boolean checkForUpgrades) throws SafeModeException {
        namenode.getNamesystem().leaveSafeMode(checkForUpgrades);
    }

    public static void abortEditLogs(NameNode nn) {
        FSEditLog el = nn.getFSImage().getEditLog();
        el.abortCurrentLogSegment();
    }

    public static Server getRpcServer(NameNode namenode) {
        return ((NameNodeRpcServer)namenode.getRpcServer()).clientRpcServer;
    }

    public static DelegationTokenSecretManager getDtSecretManager(FSNamesystem ns) {
        return ns.getDelegationTokenSecretManager();
    }

    public static HeartbeatResponse sendHeartBeat(DatanodeRegistration nodeReg, DatanodeDescriptor dd, FSNamesystem namesystem) throws IOException {
        return namesystem.handleHeartbeat(nodeReg, dd.getCapacity(), dd.getDfsUsed(), dd.getRemaining(), dd.getBlockPoolUsed(), 0, 0, 0);
    }

    public static boolean setReplication(FSNamesystem ns, String src, short replication) throws IOException {
        return ns.setReplication(src, replication);
    }

    public static LeaseManager getLeaseManager(FSNamesystem ns) {
        return ns.leaseManager;
    }

    public static void setLeasePeriod(FSNamesystem namesystem, long soft, long hard) {
        NameNodeAdapter.getLeaseManager(namesystem).setLeasePeriod(soft, hard);
        namesystem.leaseManager.triggerMonitorCheckNow();
    }

    public static String getLeaseHolderForPath(NameNode namenode, String path) {
        return namenode.getNamesystem().leaseManager.getLeaseByPath(path).getHolder();
    }

    public static long getLeaseRenewalTime(NameNode nn, String path) {
        LeaseManager lm = nn.getNamesystem().leaseManager;
        LeaseManager.Lease l = lm.getLeaseByPath(path);
        if (l == null) {
            return -1L;
        }
        return l.getLastUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatanodeDescriptor getDatanode(FSNamesystem ns, DatanodeID id) throws IOException {
        ns.readLock();
        try {
            DatanodeDescriptor datanodeDescriptor = ns.getBlockManager().getDatanodeManager().getDatanode(id);
            return datanodeDescriptor;
        }
        finally {
            ns.readUnlock();
        }
    }

    public static long[] getStats(FSNamesystem fsn) {
        return fsn.getStats();
    }

    public static ReentrantReadWriteLock spyOnFsLock(FSNamesystem fsn) {
        ReentrantReadWriteLock spy = (ReentrantReadWriteLock)Mockito.spy((Object)fsn.getFsLockForTests());
        fsn.setFsLockForTests(spy);
        return spy;
    }

    public static FSImage spyOnFsImage(NameNode nn1) {
        FSImage spy;
        nn1.getNamesystem().dir.fsImage = spy = (FSImage)Mockito.spy((Object)nn1.getNamesystem().dir.fsImage);
        return spy;
    }

    public static String getMkdirOpPath(FSEditLogOp op) {
        if (op.opCode == FSEditLogOpCodes.OP_MKDIR) {
            return ((FSEditLogOp.MkdirOp)op).path;
        }
        return null;
    }

    public static int getSafeModeSafeBlocks(NameNode nn) {
        FSNamesystem.SafeModeInfo smi = nn.getNamesystem().getSafeModeInfoForTests();
        if (smi == null) {
            return -1;
        }
        return smi.blockSafe;
    }

    public static boolean safeModeInitializedReplQueues(NameNode nn) {
        FSNamesystem.SafeModeInfo smi = nn.getNamesystem().getSafeModeInfoForTests();
        if (smi == null) {
            return true;
        }
        return smi.initializedReplQueues;
    }

    public static File getInProgressEditsFile(Storage.StorageDirectory sd, long startTxId) {
        return NNStorage.getInProgressEditsFile((Storage.StorageDirectory)sd, (long)startTxId);
    }
}

