/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.FSDatasetInterface;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipelineInterface;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.util.DataChecksum;

public class TestSimulatedFSDataset
extends TestCase {
    Configuration conf = null;
    static final String bpid = "BP-TEST";
    static final int NUMBLOCKS = 20;
    static final int BLOCK_LENGTH_MULTIPLIER = 79;

    protected void setUp() throws Exception {
        super.setUp();
        this.conf = new HdfsConfiguration();
        this.conf.setBoolean("dfs.datanode.simulateddatastorage", true);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    long blockIdToLen(long blkid) {
        return blkid * 79L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int addSomeBlocks(FSDatasetInterface fsdataset, int startingBlockId) throws IOException {
        int bytesAdded = 0;
        for (int i = startingBlockId; i < startingBlockId + 20; ++i) {
            ExtendedBlock b = new ExtendedBlock(bpid, (long)i, 0L, 0L);
            ReplicaInPipelineInterface bInfo = fsdataset.createRbw(b);
            FSDatasetInterface.BlockWriteStreams out = bInfo.createStreams(true, DataChecksum.newDataChecksum((int)1, (int)512));
            try {
                OutputStream dataOut = out.dataOut;
                TestSimulatedFSDataset.assertEquals((long)0L, (long)fsdataset.getLength(b));
                int j = 1;
                while ((long)j <= this.blockIdToLen(i)) {
                    dataOut.write(j);
                    TestSimulatedFSDataset.assertEquals((long)j, (long)bInfo.getBytesOnDisk());
                    ++bytesAdded;
                    ++j;
                }
            }
            finally {
                out.close();
            }
            b.setNumBytes(this.blockIdToLen(i));
            fsdataset.finalizeBlock(b);
            TestSimulatedFSDataset.assertEquals((long)this.blockIdToLen(i), (long)fsdataset.getLength(b));
        }
        return bytesAdded;
    }

    int addSomeBlocks(FSDatasetInterface fsdataset) throws IOException {
        return this.addSomeBlocks(fsdataset, 1);
    }

    public void testGetMetaData() throws IOException {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        ExtendedBlock b = new ExtendedBlock(bpid, 1L, 5L, 0L);
        try {
            TestSimulatedFSDataset.assertFalse((boolean)fsdataset.metaFileExists(b));
            TestSimulatedFSDataset.assertTrue((String)"Expected an IO exception", (boolean)false);
        }
        catch (IOException e) {
            // empty catch block
        }
        this.addSomeBlocks(fsdataset);
        b = new ExtendedBlock(bpid, 1L, 0L, 0L);
        FSDatasetInterface.MetaDataInputStream metaInput = fsdataset.getMetaDataInputStream(b);
        DataInputStream metaDataInput = new DataInputStream((InputStream)metaInput);
        short version = metaDataInput.readShort();
        TestSimulatedFSDataset.assertEquals((short)1, (short)version);
        DataChecksum checksum = DataChecksum.newDataChecksum((DataInputStream)metaDataInput);
        TestSimulatedFSDataset.assertEquals((int)0, (int)checksum.getChecksumType());
        TestSimulatedFSDataset.assertEquals((int)0, (int)checksum.getChecksumSize());
    }

    public void testStorageUsage() throws IOException {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        TestSimulatedFSDataset.assertEquals((long)fsdataset.getDfsUsed(), (long)0L);
        TestSimulatedFSDataset.assertEquals((long)fsdataset.getRemaining(), (long)fsdataset.getCapacity());
        int bytesAdded = this.addSomeBlocks(fsdataset);
        TestSimulatedFSDataset.assertEquals((long)bytesAdded, (long)fsdataset.getDfsUsed());
        TestSimulatedFSDataset.assertEquals((long)(fsdataset.getCapacity() - (long)bytesAdded), (long)fsdataset.getRemaining());
    }

    void checkBlockDataAndSize(FSDatasetInterface fsdataset, ExtendedBlock b, long expectedLen) throws IOException {
        int data;
        InputStream input = fsdataset.getBlockInputStream(b);
        long lengthRead = 0L;
        while ((data = input.read()) != -1) {
            TestSimulatedFSDataset.assertEquals((int)9, (int)data);
            ++lengthRead;
        }
        TestSimulatedFSDataset.assertEquals((long)expectedLen, (long)lengthRead);
    }

    public void testWriteRead() throws IOException {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        this.addSomeBlocks(fsdataset);
        for (int i = 1; i <= 20; ++i) {
            ExtendedBlock b = new ExtendedBlock(bpid, (long)i, 0L, 0L);
            TestSimulatedFSDataset.assertTrue((boolean)fsdataset.isValidBlock(b));
            TestSimulatedFSDataset.assertEquals((long)this.blockIdToLen(i), (long)fsdataset.getLength(b));
            this.checkBlockDataAndSize(fsdataset, b, this.blockIdToLen(i));
        }
    }

    public void testGetBlockReport() throws IOException {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        BlockListAsLongs blockReport = fsdataset.getBlockReport(bpid);
        TestSimulatedFSDataset.assertEquals((int)0, (int)blockReport.getNumberOfBlocks());
        this.addSomeBlocks(fsdataset);
        blockReport = fsdataset.getBlockReport(bpid);
        TestSimulatedFSDataset.assertEquals((int)20, (int)blockReport.getNumberOfBlocks());
        for (Block b : blockReport) {
            TestSimulatedFSDataset.assertNotNull((Object)b);
            TestSimulatedFSDataset.assertEquals((long)this.blockIdToLen(b.getBlockId()), (long)b.getNumBytes());
        }
    }

    public void testInjectionEmpty() throws IOException {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        BlockListAsLongs blockReport = fsdataset.getBlockReport(bpid);
        TestSimulatedFSDataset.assertEquals((int)0, (int)blockReport.getNumberOfBlocks());
        int bytesAdded = this.addSomeBlocks(fsdataset);
        blockReport = fsdataset.getBlockReport(bpid);
        TestSimulatedFSDataset.assertEquals((int)20, (int)blockReport.getNumberOfBlocks());
        for (Block b : blockReport) {
            TestSimulatedFSDataset.assertNotNull((Object)b);
            TestSimulatedFSDataset.assertEquals((long)this.blockIdToLen(b.getBlockId()), (long)b.getNumBytes());
        }
        SimulatedFSDataset sfsdataset = this.getSimulatedFSDataset();
        sfsdataset.injectBlocks(bpid, (Iterable<Block>)blockReport);
        blockReport = sfsdataset.getBlockReport(bpid);
        TestSimulatedFSDataset.assertEquals((int)20, (int)blockReport.getNumberOfBlocks());
        for (Block b : blockReport) {
            TestSimulatedFSDataset.assertNotNull((Object)b);
            TestSimulatedFSDataset.assertEquals((long)this.blockIdToLen(b.getBlockId()), (long)b.getNumBytes());
            TestSimulatedFSDataset.assertEquals((long)this.blockIdToLen(b.getBlockId()), (long)sfsdataset.getLength(new ExtendedBlock(bpid, b)));
        }
        TestSimulatedFSDataset.assertEquals((long)bytesAdded, (long)sfsdataset.getDfsUsed());
        TestSimulatedFSDataset.assertEquals((long)(sfsdataset.getCapacity() - (long)bytesAdded), (long)sfsdataset.getRemaining());
    }

    public void testInjectionNonEmpty() throws IOException {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        BlockListAsLongs blockReport = fsdataset.getBlockReport(bpid);
        TestSimulatedFSDataset.assertEquals((int)0, (int)blockReport.getNumberOfBlocks());
        int bytesAdded = this.addSomeBlocks(fsdataset);
        blockReport = fsdataset.getBlockReport(bpid);
        TestSimulatedFSDataset.assertEquals((int)20, (int)blockReport.getNumberOfBlocks());
        for (Block b : blockReport) {
            TestSimulatedFSDataset.assertNotNull((Object)b);
            TestSimulatedFSDataset.assertEquals((long)this.blockIdToLen(b.getBlockId()), (long)b.getNumBytes());
        }
        fsdataset = null;
        SimulatedFSDataset sfsdataset = this.getSimulatedFSDataset();
        bytesAdded += this.addSomeBlocks(sfsdataset, 21);
        sfsdataset.getBlockReport(bpid);
        TestSimulatedFSDataset.assertEquals((int)20, (int)blockReport.getNumberOfBlocks());
        sfsdataset.getBlockReport(bpid);
        TestSimulatedFSDataset.assertEquals((int)20, (int)blockReport.getNumberOfBlocks());
        sfsdataset.injectBlocks(bpid, (Iterable<Block>)blockReport);
        blockReport = sfsdataset.getBlockReport(bpid);
        TestSimulatedFSDataset.assertEquals((int)40, (int)blockReport.getNumberOfBlocks());
        for (Block b : blockReport) {
            TestSimulatedFSDataset.assertNotNull((Object)b);
            TestSimulatedFSDataset.assertEquals((long)this.blockIdToLen(b.getBlockId()), (long)b.getNumBytes());
            TestSimulatedFSDataset.assertEquals((long)this.blockIdToLen(b.getBlockId()), (long)sfsdataset.getLength(new ExtendedBlock(bpid, b)));
        }
        TestSimulatedFSDataset.assertEquals((long)bytesAdded, (long)sfsdataset.getDfsUsed());
        TestSimulatedFSDataset.assertEquals((long)(sfsdataset.getCapacity() - (long)bytesAdded), (long)sfsdataset.getRemaining());
        this.conf.setLong("dfs.datanode.simulateddatastorage.capacity", 10L);
        try {
            sfsdataset = this.getSimulatedFSDataset();
            sfsdataset.addBlockPool(bpid, this.conf);
            sfsdataset.injectBlocks(bpid, (Iterable<Block>)blockReport);
            TestSimulatedFSDataset.assertTrue((String)"Expected an IO exception", (boolean)false);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void checkInvalidBlock(ExtendedBlock b) throws IOException {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        TestSimulatedFSDataset.assertFalse((boolean)fsdataset.isValidBlock(b));
        try {
            fsdataset.getLength(b);
            TestSimulatedFSDataset.assertTrue((String)"Expected an IO exception", (boolean)false);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            fsdataset.getBlockInputStream(b);
            TestSimulatedFSDataset.assertTrue((String)"Expected an IO exception", (boolean)false);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            fsdataset.finalizeBlock(b);
            TestSimulatedFSDataset.assertTrue((String)"Expected an IO exception", (boolean)false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testInValidBlocks() throws IOException {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        ExtendedBlock b = new ExtendedBlock(bpid, 1L, 5L, 0L);
        this.checkInvalidBlock(b);
        this.addSomeBlocks(fsdataset);
        b = new ExtendedBlock(bpid, 119L, 5L, 0L);
        this.checkInvalidBlock(b);
    }

    public void testInvalidate() throws IOException {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        int bytesAdded = this.addSomeBlocks(fsdataset);
        Block[] deleteBlocks = new Block[]{new Block(1L, 0L, 0L), new Block(2L, 0L, 0L)};
        fsdataset.invalidate(bpid, deleteBlocks);
        this.checkInvalidBlock(new ExtendedBlock(bpid, deleteBlocks[0]));
        this.checkInvalidBlock(new ExtendedBlock(bpid, deleteBlocks[1]));
        long sizeDeleted = this.blockIdToLen(1L) + this.blockIdToLen(2L);
        TestSimulatedFSDataset.assertEquals((long)((long)bytesAdded - sizeDeleted), (long)fsdataset.getDfsUsed());
        TestSimulatedFSDataset.assertEquals((long)(fsdataset.getCapacity() - (long)bytesAdded + sizeDeleted), (long)fsdataset.getRemaining());
        for (int i = 3; i <= 20; ++i) {
            Block b = new Block((long)i, 0L, 0L);
            TestSimulatedFSDataset.assertTrue((boolean)fsdataset.isValidBlock(new ExtendedBlock(bpid, b)));
        }
    }

    private SimulatedFSDataset getSimulatedFSDataset() throws IOException {
        SimulatedFSDataset fsdataset = new SimulatedFSDataset(this.conf);
        fsdataset.addBlockPool(bpid, this.conf);
        return fsdataset;
    }
}

