/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.ReplicasMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestReplicasMap {
    private final ReplicasMap map = new ReplicasMap(TestReplicasMap.class);
    private final String bpid = "BP-TEST";
    private final Block block = new Block(1234L, 1234L, 1234L);

    @Before
    public void setup() {
        this.map.add("BP-TEST", (ReplicaInfo)new FinalizedReplica(this.block, null, null));
    }

    @Test
    public void testGet() {
        try {
            this.map.get("BP-TEST", null);
            Assert.fail((String)"Expected exception not thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        Assert.assertNotNull((Object)this.map.get("BP-TEST", this.block));
        Block b = new Block(this.block);
        b.setGenerationStamp(0L);
        Assert.assertNull((Object)this.map.get("BP-TEST", b));
        b.setGenerationStamp(this.block.getGenerationStamp());
        b.setBlockId(0L);
        Assert.assertNull((Object)this.map.get("BP-TEST", b));
        Assert.assertNotNull((Object)this.map.get("BP-TEST", this.block.getBlockId()));
        Assert.assertNull((Object)this.map.get("BP-TEST", 0L));
    }

    @Test
    public void testAdd() {
        try {
            this.map.add("BP-TEST", null);
            Assert.fail((String)"Expected exception not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRemove() {
        try {
            this.map.remove("BP-TEST", null);
            Assert.fail((String)"Expected exception not thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        Block b = new Block(this.block);
        b.setGenerationStamp(0L);
        Assert.assertNull((Object)this.map.remove("BP-TEST", b));
        b.setGenerationStamp(this.block.getGenerationStamp());
        b.setBlockId(0L);
        Assert.assertNull((Object)this.map.remove("BP-TEST", b));
        Assert.assertNotNull((Object)this.map.remove("BP-TEST", this.block));
        Assert.assertNull((Object)this.map.remove("BP-TEST", 0L));
        this.map.add("BP-TEST", (ReplicaInfo)new FinalizedReplica(this.block, null, null));
        Assert.assertNotNull((Object)this.map.remove("BP-TEST", this.block.getBlockId()));
    }
}

