/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.junit.Test;

public class TestMulitipleNNDataBlockScanner {
    private static final Log LOG = LogFactory.getLog(TestMulitipleNNDataBlockScanner.class);
    Configuration conf;
    MiniDFSCluster cluster = null;
    String[] bpids = new String[3];
    FileSystem[] fs = new FileSystem[3];

    public void setUp() throws IOException {
        int i;
        this.conf = new HdfsConfiguration();
        this.conf.setInt("dfs.blocksize", 100);
        this.conf.setInt("dfs.bytes-per-checksum", 100);
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(3)).build();
        for (i = 0; i < 3; ++i) {
            this.cluster.waitActive(i);
        }
        for (i = 0; i < 3; ++i) {
            this.bpids[i] = this.cluster.getNamesystem(i).getBlockPoolId();
        }
        for (i = 0; i < 3; ++i) {
            this.fs[i] = this.cluster.getFileSystem(i);
        }
        for (i = 0; i < 3; ++i) {
            DFSTestUtil.createFile(this.fs[i], new Path("file1"), 1000L, (short)1, 0L);
            DFSTestUtil.createFile(this.fs[i], new Path("file2"), 1000L, (short)1, 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataBlockScanner() throws IOException, InterruptedException {
        this.setUp();
        try {
            DataNode dn = this.cluster.getDataNodes().get(0);
            for (int i = 0; i < 3; ++i) {
                long blocksScanned = 0L;
                while (blocksScanned != 20L) {
                    blocksScanned = dn.blockScanner.getBlocksScannedInLastRun(this.bpids[i]);
                    LOG.info((Object)("Waiting for all blocks to be scanned for bpid=" + this.bpids[i] + "; Scanned so far=" + blocksScanned));
                    Thread.sleep(5000L);
                }
            }
            StringBuilder buffer = new StringBuilder();
            dn.blockScanner.printBlockReport(buffer, false);
            LOG.info((Object)("Block Report\n" + buffer.toString()));
        }
        finally {
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockScannerAfterRefresh() throws IOException, InterruptedException {
        this.setUp();
        try {
            Configuration dnConf = this.cluster.getDataNodes().get(0).getConf();
            HdfsConfiguration conf = new HdfsConfiguration(dnConf);
            StringBuilder namenodesBuilder = new StringBuilder();
            String bpidToShutdown = this.cluster.getNamesystem(2).getBlockPoolId();
            for (int i = 0; i < 2; ++i) {
                String nsId = DFSUtil.getNamenodeNameServiceId((Configuration)this.cluster.getConfiguration(i));
                namenodesBuilder.append(nsId);
                namenodesBuilder.append(",");
            }
            conf.set("dfs.federation.nameservices", namenodesBuilder.toString());
            DataNode dn = this.cluster.getDataNodes().get(0);
            dn.refreshNamenodes((Configuration)conf);
            try {
                while (true) {
                    dn.blockScanner.getBlocksScannedInLastRun(bpidToShutdown);
                    Thread.sleep(1000L);
                }
            }
            catch (IOException ex) {
                LOG.info((Object)ex.getMessage());
                namenodesBuilder.append(DFSUtil.getNamenodeNameServiceId((Configuration)this.cluster.getConfiguration(2)));
                conf.set("dfs.federation.nameservices", namenodesBuilder.toString());
                dn.refreshNamenodes((Configuration)conf);
                for (int i = 0; i < 3; ++i) {
                    long blocksScanned = 0L;
                    while (blocksScanned != 20L) {
                        blocksScanned = dn.blockScanner.getBlocksScannedInLastRun(this.bpids[i]);
                        LOG.info((Object)("Waiting for all blocks to be scanned for bpid=" + this.bpids[i] + "; Scanned so far=" + blocksScanned));
                        Thread.sleep(5000L);
                    }
                }
                this.cluster.shutdown();
            }
        }
        catch (Throwable throwable) {
            this.cluster.shutdown();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockScannerAfterRestart() throws IOException, InterruptedException {
        this.setUp();
        try {
            this.cluster.restartDataNode(0);
            this.cluster.waitActive();
            DataNode dn = this.cluster.getDataNodes().get(0);
            for (int i = 0; i < 3; ++i) {
                long blocksScanned = 0L;
                while (blocksScanned != 20L) {
                    if (dn.blockScanner != null) {
                        blocksScanned = dn.blockScanner.getBlocksScannedInLastRun(this.bpids[i]);
                        LOG.info((Object)("Waiting for all blocks to be scanned for bpid=" + this.bpids[i] + "; Scanned so far=" + blocksScanned));
                    }
                    Thread.sleep(5000L);
                }
            }
        }
        finally {
            this.cluster.shutdown();
        }
    }
}

