/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.FSDataset;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.ReplicasMap;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestDatanodeRestart {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFinalizedReplicas() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 1024L);
        conf.setInt("dfs.client-write-packet-size", 512);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        cluster.waitActive();
        FileSystem fs = cluster.getFileSystem();
        try {
            String TopDir = "/test";
            DFSTestUtil util = new DFSTestUtil("TestCrcCorruption", 2, 3, 8192);
            util.createFiles(fs, "/test", (short)3);
            util.waitReplication(fs, "/test", (short)3);
            util.checkFiles(fs, "/test");
            cluster.restartDataNodes();
            cluster.waitActive();
            util.checkFiles(fs, "/test");
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRbwReplicas() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 1024L);
        conf.setInt("dfs.client-write-packet-size", 512);
        conf.setBoolean("dfs.support.append", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        cluster.waitActive();
        try {
            this.testRbwReplicas(cluster, false);
            this.testRbwReplicas(cluster, true);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRbwReplicas(MiniDFSCluster cluster, boolean isCorrupt) throws IOException {
        FSDataOutputStream out = null;
        FileSystem fs = cluster.getFileSystem();
        Path src = new Path("/test.txt");
        try {
            int fileLen = 515;
            byte[] writeBuf = new byte[515];
            new Random().nextBytes(writeBuf);
            out = fs.create(src);
            out.write(writeBuf);
            out.hflush();
            DataNode dn = cluster.getDataNodes().get(0);
            for (FSDataset.FSVolume volume : ((FSDataset)dn.data).volumes.getVolumes()) {
                File currentDir = volume.getDir().getParentFile();
                File rbwDir = new File(currentDir, "rbw");
                for (File file : rbwDir.listFiles()) {
                    if (!isCorrupt || !Block.isBlockFilename((File)file)) continue;
                    new RandomAccessFile(file, "rw").setLength(514L);
                }
            }
            cluster.restartDataNodes();
            cluster.waitActive();
            dn = cluster.getDataNodes().get(0);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            ReplicasMap replicas = ((FSDataset)dn.data).volumeMap;
            Assert.assertEquals((long)1L, (long)replicas.size(bpid));
            ReplicaInfo replica = (ReplicaInfo)replicas.replicas(bpid).iterator().next();
            Assert.assertEquals((Object)HdfsServerConstants.ReplicaState.RWR, (Object)replica.getState());
            if (isCorrupt) {
                Assert.assertEquals((long)512L, (long)replica.getNumBytes());
            } else {
                Assert.assertEquals((long)515L, (long)replica.getNumBytes());
            }
            dn.data.invalidate(bpid, new Block[]{replica});
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(out);
            if (fs.exists(src)) {
                fs.delete(src, false);
            }
            fs.close();
            throw throwable;
        }
        IOUtils.closeStream((Closeable)out);
        if (fs.exists(src)) {
            fs.delete(src, false);
        }
        fs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecoverReplicas() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 1024L);
        conf.setInt("dfs.client-write-packet-size", 512);
        conf.setBoolean("dfs.support.append", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        cluster.waitActive();
        try {
            FileSystem fs = cluster.getFileSystem();
            for (int i = 0; i < 4; ++i) {
                Path fileName = new Path("/test" + i);
                DFSTestUtil.createFile(fs, fileName, 1L, (short)1, 0L);
                DFSTestUtil.waitReplication(fs, fileName, (short)1);
            }
            String bpid = cluster.getNamesystem().getBlockPoolId();
            DataNode dn = cluster.getDataNodes().get(0);
            Iterator replicasItor = ((FSDataset)dn.data).volumeMap.replicas(bpid).iterator();
            ReplicaInfo replica = (ReplicaInfo)replicasItor.next();
            TestDatanodeRestart.createUnlinkTmpFile(replica, true, true);
            TestDatanodeRestart.createUnlinkTmpFile(replica, false, true);
            replica = (ReplicaInfo)replicasItor.next();
            TestDatanodeRestart.createUnlinkTmpFile(replica, true, false);
            TestDatanodeRestart.createUnlinkTmpFile(replica, false, false);
            replica = (ReplicaInfo)replicasItor.next();
            TestDatanodeRestart.createUnlinkTmpFile(replica, true, true);
            TestDatanodeRestart.createUnlinkTmpFile(replica, false, false);
            cluster.restartDataNodes();
            cluster.waitActive();
            dn = cluster.getDataNodes().get(0);
            Collection replicas = ((FSDataset)dn.data).volumeMap.replicas(bpid);
            Assert.assertEquals((long)4L, (long)replicas.size());
            replicasItor = replicas.iterator();
            while (replicasItor.hasNext()) {
                Assert.assertEquals((Object)HdfsServerConstants.ReplicaState.FINALIZED, (Object)((ReplicaInfo)replicasItor.next()).getState());
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createUnlinkTmpFile(ReplicaInfo replicaInfo, boolean changeBlockFile, boolean isRename) throws IOException {
        File src = changeBlockFile ? replicaInfo.getBlockFile() : replicaInfo.getMetaFile();
        File dst = FSDataset.getUnlinkTmpFile((File)src);
        if (isRename) {
            src.renameTo(dst);
        } else {
            FileInputStream in = new FileInputStream(src);
            try {
                FileOutputStream out = new FileOutputStream(dst);
                try {
                    IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)1);
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }
    }
}

