/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDatanodeRegister {
    public static final Log LOG = LogFactory.getLog(TestDatanodeRegister.class);
    static final InetSocketAddress INVALID_ADDR = new InetSocketAddress("127.0.0.1", 1);

    @Test
    public void testDataNodeRegister() throws Exception {
        DataNode mockDN = (DataNode)Mockito.mock(DataNode.class);
        ((DataNode)Mockito.doReturn((Object)true).when((Object)mockDN)).shouldRun();
        BPOfferService mockBPOS = (BPOfferService)Mockito.mock(BPOfferService.class);
        ((BPOfferService)Mockito.doReturn((Object)mockDN).when((Object)mockBPOS)).getDataNode();
        BPServiceActor actor = new BPServiceActor(INVALID_ADDR, mockBPOS);
        NamespaceInfo fakeNSInfo = (NamespaceInfo)Mockito.mock(NamespaceInfo.class);
        Mockito.when((Object)fakeNSInfo.getBuildVersion()).thenReturn((Object)"NSBuildVersion");
        DatanodeProtocolClientSideTranslatorPB fakeDNProt = (DatanodeProtocolClientSideTranslatorPB)Mockito.mock(DatanodeProtocolClientSideTranslatorPB.class);
        Mockito.when((Object)fakeDNProt.versionRequest()).thenReturn((Object)fakeNSInfo);
        actor.setNameNode(fakeDNProt);
        try {
            actor.retrieveNamespaceInfo();
            Assert.fail((String)"register() did not throw exception! Expected: IncorrectVersionException");
        }
        catch (IncorrectVersionException ie) {
            LOG.info((Object)"register() returned correct Exception: IncorrectVersionException");
        }
    }
}

