/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestDataNodeVolumeFailureToleration {
    private static final Log LOG = LogFactory.getLog(TestDataNodeVolumeFailureToleration.class);
    private FileSystem fs;
    private MiniDFSCluster cluster;
    private Configuration conf;
    private String dataDir;
    final int WAIT_FOR_HEARTBEATS = 3000;
    final int WAIT_FOR_DEATH = 15000;

    public TestDataNodeVolumeFailureToleration() {
        ((Log4JLogger)LOG).getLogger().setLevel(Level.ALL);
        this.WAIT_FOR_HEARTBEATS = 3000;
        this.WAIT_FOR_DEATH = 15000;
    }

    @Before
    public void setUp() throws Exception {
        this.conf = new HdfsConfiguration();
        this.conf.setLong("dfs.blocksize", 512L);
        this.conf.setInt("dfs.heartbeat.interval", 1);
        this.conf.setInt("dfs.df.interval", 1000);
        this.conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        this.conf.setInt("dfs.datanode.failed.volumes.tolerated", 1);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.dataDir = this.cluster.getDataDirectory();
    }

    @After
    public void tearDown() throws Exception {
        for (int i = 0; i < 3; ++i) {
            new File(this.dataDir, "data" + (2 * i + 1)).setExecutable(true);
            new File(this.dataDir, "data" + (2 * i + 2)).setExecutable(true);
        }
        this.cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidVolumesAtStartup() throws Exception {
        Assume.assumeTrue((!System.getProperty("os.name").startsWith("Windows") ? 1 : 0) != 0);
        this.cluster.shutdownDataNodes();
        this.conf.setInt("dfs.datanode.failed.volumes.tolerated", 1);
        File tld = new File(MiniDFSCluster.getBaseDirectory(), "badData");
        File dataDir1 = new File(tld, "data1");
        File dataDir1Actual = new File(dataDir1, "1");
        dataDir1Actual.mkdirs();
        File dataDir2 = new File(tld, "data2");
        this.prepareDirToFail(dataDir2);
        File dataDir2Actual = new File(dataDir2, "2");
        this.conf.set("dfs.datanode.data.dir", dataDir1Actual.getPath() + "," + dataDir2Actual.getPath());
        this.cluster.startDataNodes(this.conf, 1, false, null, null);
        this.cluster.waitActive();
        try {
            Assert.assertTrue((String)"The DN should have started up fine.", (boolean)this.cluster.isDataNodeUp());
            DataNode dn = this.cluster.getDataNodes().get(0);
            String si = dn.getFSDataset().getStorageInfo();
            Assert.assertTrue((String)"The DN should have started with this directory", (boolean)si.contains(dataDir1Actual.getPath()));
            Assert.assertFalse((String)"The DN shouldn't have a bad directory.", (boolean)si.contains(dataDir2Actual.getPath()));
        }
        finally {
            this.cluster.shutdownDataNodes();
            FileUtil.chmod((String)dataDir2.toString(), (String)"755");
        }
    }

    @Test
    public void testConfigureMinValidVolumes() throws Exception {
        Assume.assumeTrue((!System.getProperty("os.name").startsWith("Windows") ? 1 : 0) != 0);
        this.conf.setInt("dfs.datanode.failed.volumes.tolerated", 0);
        this.cluster.startDataNodes(this.conf, 2, true, null, null);
        this.cluster.waitActive();
        DatanodeManager dm = this.cluster.getNamesystem().getBlockManager().getDatanodeManager();
        long origCapacity = DFSTestUtil.getLiveDatanodeCapacity(dm);
        long dnCapacity = DFSTestUtil.getDatanodeCapacity(dm, 0);
        File dn2Vol1 = new File(this.dataDir, "data3");
        Assert.assertTrue((String)"Couldn't chmod local vol", (boolean)dn2Vol1.setExecutable(false));
        Path file1 = new Path("/test1");
        DFSTestUtil.createFile(this.fs, file1, 1024L, (short)3, 1L);
        DFSTestUtil.waitReplication(this.fs, file1, (short)2);
        DFSTestUtil.waitForDatanodeStatus(dm, 2, 1, 0L, origCapacity - 1L * dnCapacity, 3000L);
        Assert.assertTrue((String)"Couldn't chmod local vol", (boolean)dn2Vol1.setExecutable(true));
        Path file2 = new Path("/test2");
        DFSTestUtil.createFile(this.fs, file2, 1024L, (short)3, 1L);
        DFSTestUtil.waitReplication(this.fs, file2, (short)2);
    }

    private void restartDatanodes(int volTolerated, boolean manageDfsDirs) throws IOException {
        this.cluster.shutdownDataNodes();
        this.conf.setInt("dfs.datanode.failed.volumes.tolerated", volTolerated);
        this.cluster.startDataNodes(this.conf, 1, manageDfsDirs, null, null);
        this.cluster.waitActive();
    }

    @Test
    public void testVolumeAndTolerableConfiguration() throws Exception {
        this.testVolumeConfig(-1, 0, false, true);
        this.testVolumeConfig(100, 0, false, true);
        this.testVolumeConfig(0, 1, false, false);
        this.testVolumeConfig(1, 1, true, false);
        this.testVolumeConfig(0, 0, true, false);
        this.testVolumeConfig(0, 2, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testVolumeConfig(int volumesTolerated, int volumesFailed, boolean expectedBPServiceState, boolean manageDfsDirs) throws IOException, InterruptedException, TimeoutException {
        Assume.assumeTrue((!System.getProperty("os.name").startsWith("Windows") ? 1 : 0) != 0);
        boolean dnIndex = false;
        File[] dirs = new File[]{new File(this.cluster.getInstanceStorageDir(0, 0), "current"), new File(this.cluster.getInstanceStorageDir(0, 1), "current")};
        try {
            for (int i = 0; i < volumesFailed; ++i) {
                this.prepareDirToFail(dirs[i]);
            }
            this.restartDatanodes(volumesTolerated, manageDfsDirs);
            Assert.assertEquals((Object)expectedBPServiceState, (Object)this.cluster.getDataNodes().get(0).isBPServiceAlive(this.cluster.getNamesystem().getBlockPoolId()));
        }
        finally {
            for (File dir : dirs) {
                FileUtil.chmod((String)dir.toString(), (String)"755");
            }
        }
    }

    private void prepareDirToFail(File dir) throws IOException, InterruptedException {
        dir.mkdirs();
        Assert.assertEquals((String)"Couldn't chmod local vol", (long)0L, (long)FileUtil.chmod((String)dir.toString(), (String)"000"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailedVolumeOnStartupIsCounted() throws Exception {
        Assume.assumeTrue((!System.getProperty("os.name").startsWith("Windows") ? 1 : 0) != 0);
        DatanodeManager dm = this.cluster.getNamesystem().getBlockManager().getDatanodeManager();
        long origCapacity = DFSTestUtil.getLiveDatanodeCapacity(dm);
        File dir = new File(this.cluster.getInstanceStorageDir(0, 0), "current");
        try {
            this.prepareDirToFail(dir);
            this.restartDatanodes(1, false);
            Assert.assertEquals((Object)true, (Object)this.cluster.getDataNodes().get(0).isBPServiceAlive(this.cluster.getNamesystem().getBlockPoolId()));
            DFSTestUtil.waitForDatanodeStatus(dm, 1, 0, 1L, origCapacity / 2L, 3000L);
        }
        finally {
            FileUtil.chmod((String)dir.toString(), (String)"755");
        }
    }
}

