/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.MetricsAsserts;

public class TestDataNodeMetrics
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDataNodeMetrics() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.datanode.simulateddatastorage", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            FileSystem fs = cluster.getFileSystem();
            long LONG_FILE_LEN = 0x80000000L;
            DFSTestUtil.createFile(fs, new Path("/tmp.txt"), 0x80000000L, (short)1, 1L);
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            TestDataNodeMetrics.assertEquals((int)datanodes.size(), (int)1);
            DataNode datanode = (DataNode)datanodes.get(0);
            MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)datanode.getMetrics().name());
            MetricsAsserts.assertCounter((String)"BytesWritten", (long)0x80000000L, (MetricsRecordBuilder)rb);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

