/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.junit.Assert;
import org.junit.Test;

public class TestDataNodeMXBean {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataNodeMXBean() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        try {
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((long)datanodes.size(), (long)1L);
            DataNode datanode = (DataNode)datanodes.get(0);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=DataNode,name=DataNodeInfo");
            String clusterId = (String)mbs.getAttribute(mxbeanName, "ClusterId");
            Assert.assertEquals((Object)datanode.getClusterId(), (Object)clusterId);
            String version = (String)mbs.getAttribute(mxbeanName, "Version");
            Assert.assertEquals((Object)datanode.getVersion(), (Object)version);
            String rpcPort = (String)mbs.getAttribute(mxbeanName, "RpcPort");
            Assert.assertEquals((Object)datanode.getRpcPort(), (Object)rpcPort);
            String httpPort = (String)mbs.getAttribute(mxbeanName, "HttpPort");
            Assert.assertEquals((Object)datanode.getHttpPort(), (Object)httpPort);
            String namenodeAddresses = (String)mbs.getAttribute(mxbeanName, "NamenodeAddresses");
            Assert.assertEquals((Object)datanode.getNamenodeAddresses(), (Object)namenodeAddresses);
            String volumeInfo = (String)mbs.getAttribute(mxbeanName, "VolumeInfo");
            Assert.assertEquals((Object)TestDataNodeMXBean.replaceDigits(datanode.getVolumeInfo()), (Object)TestDataNodeMXBean.replaceDigits(volumeInfo));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private static String replaceDigits(String s) {
        return s.replaceAll("[0-9]+", "_DIGITS_");
    }
}

