/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.FSDataset;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.mockito.Mockito;

public class DataNodeAdapter {
    public static ReplicaInfo fetchReplicaInfo(DataNode dn, String bpid, long blkId) {
        return ((FSDataset)dn.data).fetchReplicaInfo(bpid, blkId);
    }

    public static void setHeartbeatsDisabledForTests(DataNode dn, boolean heartbeatsDisabledForTests) {
        dn.setHeartbeatsDisabledForTests(heartbeatsDisabledForTests);
    }

    public static void triggerDeletionReport(DataNode dn) throws IOException {
        for (BPOfferService bpos : dn.getAllBpOs()) {
            bpos.triggerDeletionReportForTests();
        }
    }

    public static void triggerHeartbeat(DataNode dn) throws IOException {
        for (BPOfferService bpos : dn.getAllBpOs()) {
            bpos.triggerHeartbeatForTests();
        }
    }

    public static void triggerBlockReport(DataNode dn) throws IOException {
        for (BPOfferService bpos : dn.getAllBpOs()) {
            bpos.triggerBlockReportForTests();
        }
    }

    public static long getPendingAsyncDeletions(DataNode dn) {
        FSDataset fsd = (FSDataset)dn.getFSDataset();
        return fsd.asyncDiskService.countPendingDeletions();
    }

    public static DatanodeProtocolClientSideTranslatorPB spyOnBposToNN(DataNode dn, NameNode nn) {
        String bpid = nn.getNamesystem().getBlockPoolId();
        BPOfferService bpos = null;
        for (BPOfferService thisBpos : dn.getAllBpOs()) {
            if (!thisBpos.getBlockPoolId().equals(bpid)) continue;
            bpos = thisBpos;
            break;
        }
        Preconditions.checkArgument((bpos != null ? 1 : 0) != 0, (String)"No such bpid: %s", (Object[])new Object[]{bpid});
        BPServiceActor bpsa = null;
        for (BPServiceActor thisBpsa : bpos.getBPServiceActors()) {
            if (!thisBpsa.getNNSocketAddress().equals(nn.getServiceRpcAddress())) continue;
            bpsa = thisBpsa;
            break;
        }
        Preconditions.checkArgument((bpsa != null ? 1 : 0) != 0, (String)"No service actor to NN at %s", (Object[])new Object[]{nn.getServiceRpcAddress()});
        DatanodeProtocolClientSideTranslatorPB origNN = bpsa.getNameNodeProxy();
        DatanodeProtocolClientSideTranslatorPB spy = (DatanodeProtocolClientSideTranslatorPB)Mockito.spy((Object)origNN);
        bpsa.setNameNode(spy);
        return spy;
    }
}

