/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import java.io.IOException;
import java.net.InetSocketAddress;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.JspHelper;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestJspHelper {
    private Configuration conf = new HdfsConfiguration();

    @Test
    public void testGetUgi() throws IOException {
        this.conf.set("fs.defaultFS", "hdfs://localhost:4321/");
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        String user = "TheDoctor";
        Text userText = new Text(user);
        DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(userText, userText, null);
        Token token = new Token((TokenIdentifier)dtId, (SecretManager)new DummySecretManager(0L, 0L, 0L, 0L));
        String tokenString = token.encodeToUrlString();
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)user);
        Mockito.when((Object)request.getParameter("nnaddr")).thenReturn((Object)"1.1.1.1:1111");
        this.conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        this.verifyServiceInToken(context, request, "1.1.1.1:1111");
        Mockito.when((Object)request.getParameter("nnaddr")).thenReturn(null);
        InetSocketAddress addr = new InetSocketAddress("localhost", 2222);
        Mockito.when((Object)context.getAttribute("name.node.address")).thenReturn((Object)addr);
        this.verifyServiceInToken(context, request, addr.getAddress().getHostAddress() + ":2222");
        token.setService(new Text("3.3.3.3:3333"));
        tokenString = token.encodeToUrlString();
        Mockito.when((Object)context.getAttribute("name.node.address")).thenReturn(null);
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        this.verifyServiceInToken(context, request, "3.3.3.3:3333");
    }

    private void verifyServiceInToken(ServletContext context, HttpServletRequest request, String expected) throws IOException {
        UserGroupInformation ugi = JspHelper.getUGI((ServletContext)context, (HttpServletRequest)request, (Configuration)this.conf);
        Token tokenInUgi = (Token)ugi.getTokens().iterator().next();
        Assert.assertEquals((Object)tokenInUgi.getService().toString(), (Object)expected);
    }

    @Test
    public void testDelegationTokenUrlParam() {
        this.conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        String tokenString = "xyzabc";
        String delegationTokenParam = JspHelper.getDelegationTokenUrlParam((String)tokenString);
        Assert.assertEquals((Object)"&delegation=xyzabc", (Object)delegationTokenParam);
        this.conf.set("hadoop.security.authentication", "simple");
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        delegationTokenParam = JspHelper.getDelegationTokenUrlParam((String)tokenString);
        Assert.assertEquals((Object)"", (Object)delegationTokenParam);
    }

    public static class DummySecretManager
    extends AbstractDelegationTokenSecretManager<DelegationTokenIdentifier> {
        public DummySecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval) {
            super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval);
        }

        public DelegationTokenIdentifier createIdentifier() {
            return null;
        }

        public byte[] createPassword(DelegationTokenIdentifier dtId) {
            return new byte[1];
        }
    }
}

