/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.UnderReplicatedBlocks;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.junit.Assert;
import org.junit.Test;

public class TestReplicationPolicy {
    private Random random = DFSUtil.getRandom();
    private static final int BLOCK_SIZE = 1024;
    private static final int NUM_OF_DATANODES = 6;
    private static final Configuration CONF;
    private static final NetworkTopology cluster;
    private static final NameNode namenode;
    private static final BlockPlacementPolicy replicator;
    private static final String filename = "/dummyfile.txt";
    private static final DatanodeDescriptor[] dataNodes;
    private static final DatanodeDescriptor NODE;

    @Test
    public void testChooseTarget1() throws Exception {
        dataNodes[0].updateHeartbeat((long)(2 * HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, (long)(HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, 4, 0);
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodes[0], 1024L);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(filename, 3, dataNodes[0], 1024L);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[2]));
        targets = replicator.chooseTarget(filename, 4, dataNodes[0], 1024L);
        Assert.assertEquals((long)targets.length, (long)4L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        Assert.assertTrue((cluster.isOnSameRack((Node)targets[1], (Node)targets[2]) || cluster.isOnSameRack((Node)targets[2], (Node)targets[3]) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[2]));
        dataNodes[0].updateHeartbeat((long)(2 * HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, (long)(HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, 0, 0);
    }

    private static DatanodeDescriptor[] chooseTarget(BlockPlacementPolicyDefault policy, int numOfReplicas, DatanodeDescriptor writer, List<DatanodeDescriptor> chosenNodes, HashMap<Node, Node> excludedNodes, long blocksize) {
        return policy.chooseTarget(numOfReplicas, writer, chosenNodes, false, excludedNodes, blocksize);
    }

    @Test
    public void testChooseTarget2() throws Exception {
        int i;
        BlockPlacementPolicyDefault repl = (BlockPlacementPolicyDefault)replicator;
        ArrayList<DatanodeDescriptor> chosenNodes = new ArrayList<DatanodeDescriptor>();
        HashMap<Node, Node> excludedNodes = new HashMap<Node, Node>();
        excludedNodes.put((Node)dataNodes[1], (Node)dataNodes[1]);
        DatanodeDescriptor[] targets = TestReplicationPolicy.chooseTarget(repl, 0, dataNodes[0], chosenNodes, excludedNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)0L);
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.put((Node)dataNodes[1], (Node)dataNodes[1]);
        targets = TestReplicationPolicy.chooseTarget(repl, 1, dataNodes[0], chosenNodes, excludedNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.put((Node)dataNodes[1], (Node)dataNodes[1]);
        targets = TestReplicationPolicy.chooseTarget(repl, 2, dataNodes[0], chosenNodes, excludedNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.put((Node)dataNodes[1], (Node)dataNodes[1]);
        targets = TestReplicationPolicy.chooseTarget(repl, 3, dataNodes[0], chosenNodes, excludedNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[2]));
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.put((Node)dataNodes[1], (Node)dataNodes[1]);
        targets = TestReplicationPolicy.chooseTarget(repl, 4, dataNodes[0], chosenNodes, excludedNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)4L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[0]);
        for (i = 1; i < 4; ++i) {
            Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[i]));
        }
        Assert.assertTrue((cluster.isOnSameRack((Node)targets[1], (Node)targets[2]) || cluster.isOnSameRack((Node)targets[2], (Node)targets[3]) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[3]));
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.put((Node)dataNodes[1], (Node)dataNodes[1]);
        chosenNodes.add(dataNodes[2]);
        targets = repl.chooseTarget(1, dataNodes[0], chosenNodes, true, excludedNodes, 1024L);
        System.out.println("targets=" + Arrays.asList(targets));
        Assert.assertEquals((long)2L, (long)targets.length);
        for (i = 0; i < targets.length && !dataNodes[2].equals((Object)targets[i]); ++i) {
        }
        Assert.assertTrue((i < targets.length ? 1 : 0) != 0);
    }

    @Test
    public void testChooseTarget3() throws Exception {
        dataNodes[0].updateHeartbeat((long)(2 * HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, (long)((HdfsConstants.MIN_BLOCKS_FOR_WRITE - 1) * 1024), 0L, 0, 0);
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodes[0], 1024L);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[1]);
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[1]);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(filename, 3, dataNodes[0], 1024L);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[1]);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[2]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(filename, 4, dataNodes[0], 1024L);
        Assert.assertEquals((long)targets.length, (long)4L);
        Assert.assertEquals((Object)targets[0], (Object)dataNodes[1]);
        for (int i = 1; i < 4; ++i) {
            Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[i]));
        }
        Assert.assertTrue((cluster.isOnSameRack((Node)targets[1], (Node)targets[2]) || cluster.isOnSameRack((Node)targets[2], (Node)targets[3]) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[3]));
        dataNodes[0].updateHeartbeat((long)(2 * HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, (long)(HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, 0, 0);
    }

    @Test
    public void testChoooseTarget4() throws Exception {
        int i;
        for (int i2 = 0; i2 < 2; ++i2) {
            dataNodes[i2].updateHeartbeat((long)(2 * HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, (long)((HdfsConstants.MIN_BLOCKS_FOR_WRITE - 1) * 1024), 0L, 0, 0);
        }
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodes[0], 1024L);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)dataNodes[0]));
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)dataNodes[0]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(filename, 3, dataNodes[0], 1024L);
        Assert.assertEquals((long)targets.length, (long)3L);
        for (i = 0; i < 3; ++i) {
            Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[i], (Node)dataNodes[0]));
        }
        Assert.assertTrue((cluster.isOnSameRack((Node)targets[0], (Node)targets[1]) || cluster.isOnSameRack((Node)targets[1], (Node)targets[2]) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[2]));
        for (i = 0; i < 2; ++i) {
            dataNodes[i].updateHeartbeat((long)(2 * HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, (long)(HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, 0, 0);
        }
    }

    @Test
    public void testChooseTarget5() throws Exception {
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, NODE, 1024L);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = replicator.chooseTarget(filename, 1, NODE, 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        targets = replicator.chooseTarget(filename, 2, NODE, 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(filename, 3, NODE, 1024L);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)targets[1], (Node)targets[2]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
    }

    @Test
    public void testRereplicate1() throws Exception {
        ArrayList<DatanodeDescriptor> chosenNodes = new ArrayList<DatanodeDescriptor>();
        chosenNodes.add(dataNodes[0]);
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[1]));
        targets = replicator.chooseTarget(filename, 3, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)targets[0], (Node)targets[2]));
    }

    @Test
    public void testRereplicate2() throws Exception {
        ArrayList<DatanodeDescriptor> chosenNodes = new ArrayList<DatanodeDescriptor>();
        chosenNodes.add(dataNodes[0]);
        chosenNodes.add(dataNodes[1]);
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[1]));
    }

    @Test
    public void testRereplicate3() throws Exception {
        ArrayList<DatanodeDescriptor> chosenNodes = new ArrayList<DatanodeDescriptor>();
        chosenNodes.add(dataNodes[0]);
        chosenNodes.add(dataNodes[2]);
        DatanodeDescriptor[] targets = replicator.chooseTarget(filename, 0, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[2], (Node)targets[0]));
        targets = replicator.chooseTarget(filename, 1, dataNodes[2], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[2], (Node)targets[0]));
        Assert.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        targets = replicator.chooseTarget(filename, 2, dataNodes[0], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)targets[0]));
        targets = replicator.chooseTarget(filename, 2, dataNodes[2], chosenNodes, 1024L);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[2], (Node)targets[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testReplicationWithPriority() throws Exception {
        int DFS_NAMENODE_REPLICATION_INTERVAL = 1000;
        int HIGH_PRIORITY = 0;
        Configuration conf = new Configuration();
        conf.setInt("dfs.namenode.replication.interval", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).format(true).build();
        try {
            cluster.waitActive();
            UnderReplicatedBlocks neededReplications = cluster.getNameNode().getNamesystem().getBlockManager().neededReplications;
            for (int i = 0; i < 100; ++i) {
                neededReplications.add(new Block(this.random.nextLong()), 2, 0, 3);
            }
            Thread.sleep(DFS_NAMENODE_REPLICATION_INTERVAL);
            neededReplications.add(new Block(this.random.nextLong()), 1, 0, 3);
            Thread.sleep(DFS_NAMENODE_REPLICATION_INTERVAL);
            Assert.assertFalse((String)"Not able to clear the element from high priority list", (boolean)neededReplications.iterator(HIGH_PRIORITY).hasNext());
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testChooseUnderReplicatedBlocks() throws Exception {
        UnderReplicatedBlocks underReplicatedBlocks = new UnderReplicatedBlocks();
        for (int i = 0; i < 5; ++i) {
            underReplicatedBlocks.add(new Block(this.random.nextLong()), 1, 0, 3);
            underReplicatedBlocks.add(new Block(this.random.nextLong()), 2, 0, 7);
            underReplicatedBlocks.add(new Block(this.random.nextLong()), 6, 0, 6);
            underReplicatedBlocks.add(new Block(this.random.nextLong()), 5, 0, 6);
            underReplicatedBlocks.add(new Block(this.random.nextLong()), 0, 0, 3);
        }
        List chosenBlocks = underReplicatedBlocks.chooseUnderReplicatedBlocks(6);
        this.assertTheChosenBlocks(chosenBlocks, 5, 1, 0, 0, 0);
        chosenBlocks = underReplicatedBlocks.chooseUnderReplicatedBlocks(10);
        this.assertTheChosenBlocks(chosenBlocks, 0, 4, 5, 1, 0);
        underReplicatedBlocks.add(new Block(this.random.nextLong()), 1, 0, 3);
        chosenBlocks = underReplicatedBlocks.chooseUnderReplicatedBlocks(10);
        this.assertTheChosenBlocks(chosenBlocks, 1, 0, 0, 4, 5);
        chosenBlocks = underReplicatedBlocks.chooseUnderReplicatedBlocks(7);
        this.assertTheChosenBlocks(chosenBlocks, 6, 1, 0, 0, 0);
    }

    private void assertTheChosenBlocks(List<List<Block>> chosenBlocks, int firstPrioritySize, int secondPrioritySize, int thirdPrioritySize, int fourthPrioritySize, int fifthPrioritySize) {
        Assert.assertEquals((String)"Not returned the expected number of QUEUE_HIGHEST_PRIORITY blocks", (long)firstPrioritySize, (long)chosenBlocks.get(0).size());
        Assert.assertEquals((String)"Not returned the expected number of QUEUE_VERY_UNDER_REPLICATED blocks", (long)secondPrioritySize, (long)chosenBlocks.get(1).size());
        Assert.assertEquals((String)"Not returned the expected number of QUEUE_UNDER_REPLICATED blocks", (long)thirdPrioritySize, (long)chosenBlocks.get(2).size());
        Assert.assertEquals((String)"Not returned the expected number of QUEUE_REPLICAS_BADLY_DISTRIBUTED blocks", (long)fourthPrioritySize, (long)chosenBlocks.get(3).size());
        Assert.assertEquals((String)"Not returned the expected number of QUEUE_WITH_CORRUPT_BLOCKS blocks", (long)fifthPrioritySize, (long)chosenBlocks.get(4).size());
    }

    static {
        int i;
        CONF = new HdfsConfiguration();
        dataNodes = new DatanodeDescriptor[]{new DatanodeDescriptor(new DatanodeID("h1:5020"), "/d1/r1"), new DatanodeDescriptor(new DatanodeID("h2:5020"), "/d1/r1"), new DatanodeDescriptor(new DatanodeID("h3:5020"), "/d1/r2"), new DatanodeDescriptor(new DatanodeID("h4:5020"), "/d1/r2"), new DatanodeDescriptor(new DatanodeID("h5:5020"), "/d2/r3"), new DatanodeDescriptor(new DatanodeID("h6:5020"), "/d2/r3")};
        NODE = new DatanodeDescriptor(new DatanodeID("h7:5020"), "/d2/r4");
        try {
            FileSystem.setDefaultUri((Configuration)CONF, (String)"hdfs://localhost:0");
            CONF.set("dfs.namenode.http-address", "0.0.0.0:0");
            DFSTestUtil.formatNameNode(CONF);
            namenode = new NameNode(CONF);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        BlockManager bm = namenode.getNamesystem().getBlockManager();
        replicator = bm.getBlockPlacementPolicy();
        cluster = bm.getDatanodeManager().getNetworkTopology();
        for (i = 0; i < 6; ++i) {
            cluster.add((Node)dataNodes[i]);
        }
        for (i = 0; i < 6; ++i) {
            dataNodes[i].updateHeartbeat((long)(2 * HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, (long)(2 * HdfsConstants.MIN_BLOCKS_FOR_WRITE * 1024), 0L, 0, 0);
        }
    }
}

