/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.CorruptReplicasMap;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;

public class TestCorruptReplicaInfo
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestCorruptReplicaInfo.class);
    private Map<Long, Block> block_map = new HashMap<Long, Block>();

    private Block getBlock(Long block_id) {
        if (!this.block_map.containsKey(block_id)) {
            this.block_map.put(block_id, new Block(block_id.longValue(), 0L, 0L));
        }
        return this.block_map.get(block_id);
    }

    private Block getBlock(int block_id) {
        return this.getBlock(Long.valueOf(block_id));
    }

    public void testCorruptReplicaInfo() throws IOException, InterruptedException {
        CorruptReplicasMap crm = new CorruptReplicasMap();
        TestCorruptReplicaInfo.assertEquals((String)"Number of corrupt blocks must initially be 0", (int)0, (int)crm.size());
        TestCorruptReplicaInfo.assertNull((String)"Param n cannot be less than 0", (Object)crm.getCorruptReplicaBlockIds(-1, null));
        TestCorruptReplicaInfo.assertNull((String)"Param n cannot be greater than 100", (Object)crm.getCorruptReplicaBlockIds(101, null));
        long[] l = crm.getCorruptReplicaBlockIds(0, null);
        TestCorruptReplicaInfo.assertNotNull((String)"n = 0 must return non-null", (Object)l);
        TestCorruptReplicaInfo.assertEquals((String)"n = 0 must return an empty list", (int)0, (int)l.length);
        int NUM_BLOCK_IDS = 140;
        LinkedList<Long> block_ids = new LinkedList<Long>();
        for (int i = 0; i < NUM_BLOCK_IDS; ++i) {
            block_ids.add(Long.valueOf(i));
        }
        DatanodeDescriptor dn1 = new DatanodeDescriptor();
        DatanodeDescriptor dn2 = new DatanodeDescriptor();
        crm.addToCorruptReplicasMap(this.getBlock(0), dn1);
        TestCorruptReplicaInfo.assertEquals((String)"Number of corrupt blocks not returning correctly", (int)1, (int)crm.size());
        crm.addToCorruptReplicasMap(this.getBlock(1), dn1);
        TestCorruptReplicaInfo.assertEquals((String)"Number of corrupt blocks not returning correctly", (int)2, (int)crm.size());
        crm.addToCorruptReplicasMap(this.getBlock(1), dn2);
        TestCorruptReplicaInfo.assertEquals((String)"Number of corrupt blocks not returning correctly", (int)2, (int)crm.size());
        crm.removeFromCorruptReplicasMap(this.getBlock(1));
        TestCorruptReplicaInfo.assertEquals((String)"Number of corrupt blocks not returning correctly", (int)1, (int)crm.size());
        crm.removeFromCorruptReplicasMap(this.getBlock(0));
        TestCorruptReplicaInfo.assertEquals((String)"Number of corrupt blocks not returning correctly", (int)0, (int)crm.size());
        for (Long block_id : block_ids) {
            crm.addToCorruptReplicasMap(this.getBlock(block_id), dn1);
        }
        TestCorruptReplicaInfo.assertEquals((String)"Number of corrupt blocks not returning correctly", (int)NUM_BLOCK_IDS, (int)crm.size());
        TestCorruptReplicaInfo.assertTrue((String)"First five block ids not returned correctly ", (boolean)Arrays.equals(new long[]{0L, 1L, 2L, 3L, 4L}, crm.getCorruptReplicaBlockIds(5, null)));
        LOG.info((Object)crm.getCorruptReplicaBlockIds(10, Long.valueOf(7L)));
        LOG.info(block_ids.subList(7, 18));
        TestCorruptReplicaInfo.assertTrue((String)"10 blocks after 7 not returned correctly ", (boolean)Arrays.equals(new long[]{8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L}, crm.getCorruptReplicaBlockIds(10, Long.valueOf(7L))));
    }
}

