/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class TestBlockInfo {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hdfs.TestBlockInfo");

    @Test
    public void testBlockListMoveToHead() throws Exception {
        int curIndex;
        LOG.info((Object)"BlockInfo moveToHead tests...");
        int MAX_BLOCKS = 10;
        DatanodeDescriptor dd = new DatanodeDescriptor();
        ArrayList<Block> blockList = new ArrayList<Block>(10);
        ArrayList<BlockInfo> blockInfoList = new ArrayList<BlockInfo>();
        LOG.info((Object)"Building block list...");
        for (int i = 0; i < 10; ++i) {
            blockList.add(new Block((long)i, 0L, 1000L));
            blockInfoList.add(new BlockInfo((Block)blockList.get(i), 3));
            dd.addBlock((BlockInfo)blockInfoList.get(i));
            Assert.assertEquals((String)"Find datanode should be 0", (long)0L, (long)((BlockInfo)blockInfoList.get(i)).findDatanode(dd));
        }
        LOG.info((Object)"Checking list length...");
        Assert.assertEquals((String)"Length should be MAX_BLOCK", (long)10L, (long)dd.numBlocks());
        Iterator it = dd.getBlockIterator();
        int len = 0;
        while (it.hasNext()) {
            it.next();
            ++len;
        }
        Assert.assertEquals((String)"There should be MAX_BLOCK blockInfo's", (long)10L, (long)len);
        int headIndex = dd.getHead().findDatanode(dd);
        LOG.info((Object)"Moving each block to the head of the list...");
        for (int i = 0; i < 10; ++i) {
            curIndex = ((BlockInfo)blockInfoList.get(i)).findDatanode(dd);
            headIndex = dd.moveBlockToHead((BlockInfo)blockInfoList.get(i), curIndex, headIndex);
            Assert.assertEquals((String)"Block should be at the head of the list now.", blockInfoList.get(i), (Object)dd.getHead());
        }
        LOG.info((Object)"Moving head to the head...");
        BlockInfo temp = dd.getHead();
        curIndex = 0;
        headIndex = 0;
        dd.moveBlockToHead(temp, curIndex, headIndex);
        Assert.assertEquals((String)"Moving head to the head of the list shopuld not change the list", (Object)temp, (Object)dd.getHead());
        LOG.info((Object)"Checking elements of the list...");
        Assert.assertNotNull((String)"Head should not be null", (Object)temp);
        int c = 9;
        for (temp = dd.getHead(); temp != null; temp = temp.getNext(0)) {
            Assert.assertEquals((String)"Expected element is not on the list", blockInfoList.get(c--), (Object)temp);
        }
        LOG.info((Object)"Moving random blocks to the head of the list...");
        headIndex = dd.getHead().findDatanode(dd);
        Random rand = new Random();
        for (int i = 0; i < 10; ++i) {
            int j = rand.nextInt(10);
            curIndex = ((BlockInfo)blockInfoList.get(j)).findDatanode(dd);
            headIndex = dd.moveBlockToHead((BlockInfo)blockInfoList.get(j), curIndex, headIndex);
            Assert.assertEquals((String)"Block should be at the head of the list now.", blockInfoList.get(j), (Object)dd.getHead());
        }
    }
}

