/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.balancer;

import java.net.InetSocketAddress;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.balancer.Balancer;
import org.apache.hadoop.hdfs.server.balancer.TestBalancer;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestBalancerWithHANameNodes {
    private MiniDFSCluster cluster;
    ClientProtocol client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testBalancerWithHANameNodes() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        long newNodeCapacity = 500L;
        String newNodeRack = "/rack2";
        String[] racks = new String[]{"/rack0", "/rack1"};
        long[] capacities = new long[]{500L, 500L};
        Assert.assertEquals((long)capacities.length, (long)racks.length);
        int numOfDatanodes = capacities.length;
        MiniDFSNNTopology.NNConf nn1Conf = new MiniDFSNNTopology.NNConf("nn1");
        nn1Conf.setIpcPort(8020);
        MiniDFSNNTopology simpleHATopology = new MiniDFSNNTopology().addNameservice(new MiniDFSNNTopology.NSConf(null).addNN(nn1Conf).addNN(new MiniDFSNNTopology.NNConf("nn2")));
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(simpleHATopology).numDataNodes(capacities.length).racks(racks).simulatedCapacities(capacities).build();
        try {
            this.cluster.waitActive();
            this.cluster.transitionToActive(1);
            Thread.sleep(500L);
            this.client = DFSUtil.createNamenode((InetSocketAddress)this.cluster.getNameNode(1).getNameNodeAddress(), (Configuration)conf);
            long totalCapacity = TestBalancer.sum(capacities);
            long totalUsedSpace = totalCapacity * 3L / 10L;
            TestBalancer.createFile(this.cluster, TestBalancer.filePath, totalUsedSpace / (long)numOfDatanodes, (short)numOfDatanodes, 1);
            this.cluster.startDataNodes((Configuration)conf, 1, true, null, new String[]{newNodeRack}, new long[]{newNodeCapacity});
            HATestUtil.setFailoverConfigurations(this.cluster, (Configuration)conf, NameNode.getUri((InetSocketAddress)this.cluster.getNameNode(0).getNameNodeAddress()).getHost());
            TestBalancer.waitForHeartBeat(totalUsedSpace, totalCapacity += newNodeCapacity, this.client, this.cluster);
            Map namenodes = DFSUtil.getNNServiceRpcAddresses((Configuration)conf);
            int r = Balancer.run((Map)namenodes, (Balancer.Parameters)Balancer.Parameters.DEFALUT, (Configuration)conf);
            Assert.assertEquals((long)Balancer.ReturnStatus.SUCCESS.code, (long)r);
            TestBalancer.waitForBalancer(totalUsedSpace, totalCapacity, this.client, this.cluster);
        }
        finally {
            this.cluster.shutdown();
        }
    }

    static {
        Balancer.setBlockMoveWaitTime((long)1000L);
    }
}

