/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security;

import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SaslInputStream;
import org.apache.hadoop.security.SaslRpcClient;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.log4j.Level;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestClientProtocolWithDelegationToken {
    private static final String ADDRESS = "0.0.0.0";
    public static final Log LOG = LogFactory.getLog(TestClientProtocolWithDelegationToken.class);
    private static Configuration conf = new Configuration();

    @Test
    public void testDelegationTokenRpc() throws Exception {
        ClientProtocol mockNN = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        FSNamesystem mockNameSys = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Mockito.when((Object)mockNN.getProtocolVersion(Matchers.anyString(), Matchers.anyLong())).thenReturn((Object)69L);
        ((ClientProtocol)Mockito.doReturn((Object)ProtocolSignature.getProtocolSignature((VersionedProtocol)mockNN, (String)ClientProtocol.class.getName(), (long)69L, (int)0)).when((Object)mockNN)).getProtocolSignature(Matchers.anyString(), Matchers.anyLong(), Matchers.anyInt());
        DelegationTokenSecretManager sm = new DelegationTokenSecretManager(86400000L, 86400000L, 604800000L, 3600000L, mockNameSys);
        sm.startThreads();
        RPC.Server server = RPC.getServer(ClientProtocol.class, (Object)mockNN, (String)ADDRESS, (int)0, (int)5, (boolean)true, (Configuration)conf, (SecretManager)sm);
        server.start();
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        final InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        String user = current.getUserName();
        Text owner = new Text(user);
        DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(owner, owner, null);
        Token token = new Token((TokenIdentifier)dtId, (SecretManager)sm);
        Text host = new Text(addr.getAddress().getHostAddress() + ":" + addr.getPort());
        token.setService(host);
        LOG.info((Object)("Service IP address for token is " + host));
        current.addToken(token);
        current.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>((Server)server){
            final /* synthetic */ Server val$server;
            {
                this.val$server = server;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                ClientProtocol proxy = null;
                try {
                    proxy = (ClientProtocol)RPC.getProxy(ClientProtocol.class, (long)69L, (InetSocketAddress)addr, (Configuration)conf);
                    proxy.getServerDefaults();
                }
                finally {
                    this.val$server.stop();
                    if (proxy != null) {
                        RPC.stopProxy((Object)proxy);
                    }
                }
                return null;
            }
        });
    }

    static {
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        ((Log4JLogger)Client.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)Server.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslRpcClient.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslRpcServer.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslInputStream.LOG).getLogger().setLevel(Level.ALL);
    }
}

