/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.security.token.block.BlockKey;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLog;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLogManifest;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.junit.Test;

public class TestPBHelper {
    @Test
    public void testConvertNamenodeRole() {
        Assert.assertEquals((Object)HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto.BACKUP, (Object)PBHelper.convert((HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.BACKUP));
        Assert.assertEquals((Object)HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto.CHECKPOINT, (Object)PBHelper.convert((HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.CHECKPOINT));
        Assert.assertEquals((Object)HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto.NAMENODE, (Object)PBHelper.convert((HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE));
        Assert.assertEquals((Object)HdfsServerConstants.NamenodeRole.BACKUP, (Object)PBHelper.convert((HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto)HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto.BACKUP));
        Assert.assertEquals((Object)HdfsServerConstants.NamenodeRole.CHECKPOINT, (Object)PBHelper.convert((HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto)HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto.CHECKPOINT));
        Assert.assertEquals((Object)HdfsServerConstants.NamenodeRole.NAMENODE, (Object)PBHelper.convert((HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto)HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto.NAMENODE));
    }

    private static StorageInfo getStorageInfo() {
        return new StorageInfo(1, 2, "cid", 3L);
    }

    @Test
    public void testConvertStoragInfo() {
        StorageInfo info = TestPBHelper.getStorageInfo();
        HdfsProtos.StorageInfoProto infoProto = PBHelper.convert((StorageInfo)info);
        StorageInfo info2 = PBHelper.convert((HdfsProtos.StorageInfoProto)infoProto);
        Assert.assertEquals((String)info.getClusterID(), (String)info2.getClusterID());
        Assert.assertEquals((long)info.getCTime(), (long)info2.getCTime());
        Assert.assertEquals((int)info.getLayoutVersion(), (int)info2.getLayoutVersion());
        Assert.assertEquals((int)info.getNamespaceID(), (int)info2.getNamespaceID());
    }

    @Test
    public void testConvertNamenodeRegistration() {
        StorageInfo info = TestPBHelper.getStorageInfo();
        NamenodeRegistration reg = new NamenodeRegistration("address:999", "http:1000", info, HdfsServerConstants.NamenodeRole.NAMENODE);
        HdfsProtos.NamenodeRegistrationProto regProto = PBHelper.convert((NamenodeRegistration)reg);
        NamenodeRegistration reg2 = PBHelper.convert((HdfsProtos.NamenodeRegistrationProto)regProto);
        Assert.assertEquals((String)reg.getAddress(), (String)reg2.getAddress());
        Assert.assertEquals((String)reg.getClusterID(), (String)reg2.getClusterID());
        Assert.assertEquals((long)reg.getCTime(), (long)reg2.getCTime());
        Assert.assertEquals((String)reg.getHttpAddress(), (String)reg2.getHttpAddress());
        Assert.assertEquals((int)reg.getLayoutVersion(), (int)reg2.getLayoutVersion());
        Assert.assertEquals((int)reg.getNamespaceID(), (int)reg2.getNamespaceID());
        Assert.assertEquals((String)reg.getRegistrationID(), (String)reg2.getRegistrationID());
        Assert.assertEquals((Object)reg.getRole(), (Object)reg2.getRole());
        Assert.assertEquals((int)reg.getVersion(), (int)reg2.getVersion());
    }

    @Test
    public void testConvertDatanodeID() {
        DatanodeID dn = new DatanodeID("node", "sid", 1, 2);
        HdfsProtos.DatanodeIDProto dnProto = PBHelper.convert((DatanodeID)dn);
        DatanodeID dn2 = PBHelper.convert((HdfsProtos.DatanodeIDProto)dnProto);
        this.compare(dn, dn2);
    }

    void compare(DatanodeID dn, DatanodeID dn2) {
        Assert.assertEquals((String)dn.getHost(), (String)dn2.getHost());
        Assert.assertEquals((int)dn.getInfoPort(), (int)dn2.getInfoPort());
        Assert.assertEquals((int)dn.getIpcPort(), (int)dn2.getIpcPort());
        Assert.assertEquals((String)dn.getName(), (String)dn2.getName());
        Assert.assertEquals((int)dn.getPort(), (int)dn2.getPort());
        Assert.assertEquals((String)dn.getStorageID(), (String)dn2.getStorageID());
    }

    @Test
    public void testConvertBlock() {
        Block b = new Block(1L, 100L, 3L);
        HdfsProtos.BlockProto bProto = PBHelper.convert((Block)b);
        Block b2 = PBHelper.convert((HdfsProtos.BlockProto)bProto);
        Assert.assertEquals((Object)b, (Object)b2);
    }

    private static BlocksWithLocations.BlockWithLocations getBlockWithLocations(int bid) {
        return new BlocksWithLocations.BlockWithLocations(new Block((long)bid, 0L, 1L), new String[]{"dn1", "dn2", "dn3"});
    }

    private void compare(BlocksWithLocations.BlockWithLocations locs1, BlocksWithLocations.BlockWithLocations locs2) {
        Assert.assertEquals((Object)locs1.getBlock(), (Object)locs2.getBlock());
        Assert.assertTrue((boolean)Arrays.equals(locs1.getDatanodes(), locs2.getDatanodes()));
    }

    @Test
    public void testConvertBlockWithLocations() {
        BlocksWithLocations.BlockWithLocations locs = TestPBHelper.getBlockWithLocations(1);
        HdfsProtos.BlockWithLocationsProto locsProto = PBHelper.convert((BlocksWithLocations.BlockWithLocations)locs);
        BlocksWithLocations.BlockWithLocations locs2 = PBHelper.convert((HdfsProtos.BlockWithLocationsProto)locsProto);
        this.compare(locs, locs2);
    }

    @Test
    public void testConvertBlocksWithLocations() {
        BlocksWithLocations.BlockWithLocations[] list = new BlocksWithLocations.BlockWithLocations[]{TestPBHelper.getBlockWithLocations(1), TestPBHelper.getBlockWithLocations(2)};
        BlocksWithLocations locs = new BlocksWithLocations(list);
        HdfsProtos.BlocksWithLocationsProto locsProto = PBHelper.convert((BlocksWithLocations)locs);
        BlocksWithLocations locs2 = PBHelper.convert((HdfsProtos.BlocksWithLocationsProto)locsProto);
        BlocksWithLocations.BlockWithLocations[] blocks = locs.getBlocks();
        BlocksWithLocations.BlockWithLocations[] blocks2 = locs2.getBlocks();
        Assert.assertEquals((int)blocks.length, (int)blocks2.length);
        for (int i = 0; i < blocks.length; ++i) {
            this.compare(blocks[i], blocks2[i]);
        }
    }

    private static BlockKey getBlockKey(int keyId) {
        return new BlockKey(keyId, 10L, "encodedKey".getBytes());
    }

    private void compare(BlockKey k1, BlockKey k2) {
        Assert.assertEquals((long)k1.getExpiryDate(), (long)k2.getExpiryDate());
        Assert.assertEquals((int)k1.getKeyId(), (int)k2.getKeyId());
        Assert.assertTrue((boolean)Arrays.equals(k1.getEncodedKey(), k2.getEncodedKey()));
    }

    @Test
    public void testConvertBlockKey() {
        BlockKey key = TestPBHelper.getBlockKey(1);
        HdfsProtos.BlockKeyProto keyProto = PBHelper.convert((BlockKey)key);
        BlockKey key1 = PBHelper.convert((HdfsProtos.BlockKeyProto)keyProto);
        this.compare(key, key1);
    }

    @Test
    public void testConvertExportedBlockKeys() {
        BlockKey[] keys = new BlockKey[]{TestPBHelper.getBlockKey(2), TestPBHelper.getBlockKey(3)};
        ExportedBlockKeys expKeys = new ExportedBlockKeys(true, 9L, 10L, TestPBHelper.getBlockKey(1), keys);
        HdfsProtos.ExportedBlockKeysProto expKeysProto = PBHelper.convert((ExportedBlockKeys)expKeys);
        ExportedBlockKeys expKeys1 = PBHelper.convert((HdfsProtos.ExportedBlockKeysProto)expKeysProto);
        this.compare(expKeys, expKeys1);
    }

    void compare(ExportedBlockKeys expKeys, ExportedBlockKeys expKeys1) {
        BlockKey[] allKeys = expKeys.getAllKeys();
        BlockKey[] allKeys1 = expKeys1.getAllKeys();
        Assert.assertEquals((int)allKeys.length, (int)allKeys1.length);
        for (int i = 0; i < allKeys.length; ++i) {
            this.compare(allKeys[i], allKeys1[i]);
        }
        this.compare(expKeys.getCurrentKey(), expKeys1.getCurrentKey());
        Assert.assertEquals((long)expKeys.getKeyUpdateInterval(), (long)expKeys1.getKeyUpdateInterval());
        Assert.assertEquals((long)expKeys.getTokenLifetime(), (long)expKeys1.getTokenLifetime());
    }

    @Test
    public void testConvertCheckpointSignature() {
        CheckpointSignature s = new CheckpointSignature(TestPBHelper.getStorageInfo(), "bpid", 100L, 1L);
        HdfsProtos.CheckpointSignatureProto sProto = PBHelper.convert((CheckpointSignature)s);
        CheckpointSignature s1 = PBHelper.convert((HdfsProtos.CheckpointSignatureProto)sProto);
        Assert.assertEquals((String)s.getBlockpoolID(), (String)s1.getBlockpoolID());
        Assert.assertEquals((String)s.getClusterID(), (String)s1.getClusterID());
        Assert.assertEquals((long)s.getCTime(), (long)s1.getCTime());
        Assert.assertEquals((long)s.getCurSegmentTxId(), (long)s1.getCurSegmentTxId());
        Assert.assertEquals((int)s.getLayoutVersion(), (int)s1.getLayoutVersion());
        Assert.assertEquals((long)s.getMostRecentCheckpointTxId(), (long)s1.getMostRecentCheckpointTxId());
        Assert.assertEquals((int)s.getNamespaceID(), (int)s1.getNamespaceID());
    }

    private static void compare(RemoteEditLog l1, RemoteEditLog l2) {
        Assert.assertEquals((long)l1.getEndTxId(), (long)l2.getEndTxId());
        Assert.assertEquals((long)l1.getStartTxId(), (long)l2.getStartTxId());
    }

    @Test
    public void testConvertRemoteEditLog() {
        RemoteEditLog l = new RemoteEditLog(1L, 100L);
        HdfsProtos.RemoteEditLogProto lProto = PBHelper.convert((RemoteEditLog)l);
        RemoteEditLog l1 = PBHelper.convert((HdfsProtos.RemoteEditLogProto)lProto);
        TestPBHelper.compare(l, l1);
    }

    @Test
    public void testConvertRemoteEditLogManifest() {
        ArrayList<RemoteEditLog> logs = new ArrayList<RemoteEditLog>();
        logs.add(new RemoteEditLog(1L, 10L));
        logs.add(new RemoteEditLog(11L, 20L));
        RemoteEditLogManifest m = new RemoteEditLogManifest(logs);
        HdfsProtos.RemoteEditLogManifestProto mProto = PBHelper.convert((RemoteEditLogManifest)m);
        RemoteEditLogManifest m1 = PBHelper.convert((HdfsProtos.RemoteEditLogManifestProto)mProto);
        List logs1 = m1.getLogs();
        Assert.assertEquals((int)logs.size(), (int)logs1.size());
        for (int i = 0; i < logs.size(); ++i) {
            TestPBHelper.compare((RemoteEditLog)logs.get(i), (RemoteEditLog)logs1.get(i));
        }
    }

    public ExtendedBlock getExtendedBlock() {
        return new ExtendedBlock("bpid", 1L, 100L, 2L);
    }

    public DatanodeInfo getDNInfo() {
        return new DatanodeInfo(new DatanodeID("node", "sid", 1, 2));
    }

    private void compare(DatanodeInfo dn1, DatanodeInfo dn2) {
        Assert.assertEquals((Object)dn1.getAdminState(), (Object)dn2.getAdminState());
        Assert.assertEquals((long)dn1.getBlockPoolUsed(), (long)dn2.getBlockPoolUsed());
        Assert.assertEquals((Object)Float.valueOf(dn1.getBlockPoolUsedPercent()), (Object)Float.valueOf(dn2.getBlockPoolUsedPercent()));
        Assert.assertEquals((long)dn1.getCapacity(), (long)dn2.getCapacity());
        Assert.assertEquals((String)dn1.getDatanodeReport(), (String)dn2.getDatanodeReport());
        Assert.assertEquals((long)dn1.getDfsUsed(), (long)dn1.getDfsUsed());
        Assert.assertEquals((Object)Float.valueOf(dn1.getDfsUsedPercent()), (Object)Float.valueOf(dn1.getDfsUsedPercent()));
        Assert.assertEquals((String)dn1.getHost(), (String)dn2.getHost());
        Assert.assertEquals((String)dn1.getHostName(), (String)dn2.getHostName());
        Assert.assertEquals((int)dn1.getInfoPort(), (int)dn2.getInfoPort());
        Assert.assertEquals((int)dn1.getIpcPort(), (int)dn2.getIpcPort());
        Assert.assertEquals((long)dn1.getLastUpdate(), (long)dn2.getLastUpdate());
        Assert.assertEquals((int)dn1.getLevel(), (int)dn2.getLevel());
        Assert.assertEquals((String)dn1.getNetworkLocation(), (String)dn2.getNetworkLocation());
    }

    @Test
    public void testConvertExtendedBlock() {
        ExtendedBlock b = this.getExtendedBlock();
        HdfsProtos.ExtendedBlockProto bProto = PBHelper.convert((ExtendedBlock)b);
        ExtendedBlock b1 = PBHelper.convert((HdfsProtos.ExtendedBlockProto)bProto);
        Assert.assertEquals((Object)b, (Object)b1);
        b.setBlockId(-1L);
        bProto = PBHelper.convert((ExtendedBlock)b);
        b1 = PBHelper.convert((HdfsProtos.ExtendedBlockProto)bProto);
        Assert.assertEquals((Object)b, (Object)b1);
    }

    @Test
    public void testConvertRecoveringBlock() {
        DatanodeInfo[] dnInfo = new DatanodeInfo[]{this.getDNInfo(), this.getDNInfo()};
        BlockRecoveryCommand.RecoveringBlock b = new BlockRecoveryCommand.RecoveringBlock(this.getExtendedBlock(), dnInfo, 3L);
        HdfsProtos.RecoveringBlockProto bProto = PBHelper.convert((BlockRecoveryCommand.RecoveringBlock)b);
        BlockRecoveryCommand.RecoveringBlock b1 = PBHelper.convert((HdfsProtos.RecoveringBlockProto)bProto);
        Assert.assertEquals((Object)b.getBlock(), (Object)b1.getBlock());
        DatanodeInfo[] dnInfo1 = b1.getLocations();
        Assert.assertEquals((int)dnInfo.length, (int)dnInfo1.length);
        for (int i = 0; i < dnInfo.length; ++i) {
            this.compare(dnInfo[0], dnInfo1[0]);
        }
    }

    @Test
    public void testConvertText() {
        Text t = new Text("abc".getBytes());
        String s = t.toString();
        Text t1 = new Text(s);
        Assert.assertEquals((Object)t, (Object)t1);
    }

    @Test
    public void testConvertBlockToken() {
        Token token = new Token("identifier".getBytes(), "password".getBytes(), new Text("kind"), new Text("service"));
        HdfsProtos.BlockTokenIdentifierProto tokenProto = PBHelper.convert((Token)token);
        Token token2 = PBHelper.convert((HdfsProtos.BlockTokenIdentifierProto)tokenProto);
        this.compare((Token<BlockTokenIdentifier>)token, (Token<BlockTokenIdentifier>)token2);
    }

    @Test
    public void testConvertNamespaceInfo() {
        NamespaceInfo info = new NamespaceInfo(37, "clusterID", "bpID", 2300L, 53);
        HdfsProtos.NamespaceInfoProto proto = PBHelper.convert((NamespaceInfo)info);
        NamespaceInfo info2 = PBHelper.convert((HdfsProtos.NamespaceInfoProto)proto);
        this.compare((StorageInfo)info, (StorageInfo)info2);
        Assert.assertEquals((String)info.getBlockPoolID(), (String)info2.getBlockPoolID());
        Assert.assertEquals((String)info.getBuildVersion(), (String)info2.getBuildVersion());
        Assert.assertEquals((int)info.getDistributedUpgradeVersion(), (int)info2.getDistributedUpgradeVersion());
    }

    private void compare(StorageInfo expected, StorageInfo actual) {
        Assert.assertEquals((String)expected.clusterID, (String)actual.clusterID);
        Assert.assertEquals((int)expected.namespaceID, (int)actual.namespaceID);
        Assert.assertEquals((long)expected.cTime, (long)actual.cTime);
        Assert.assertEquals((int)expected.layoutVersion, (int)actual.layoutVersion);
    }

    private void compare(Token<BlockTokenIdentifier> expected, Token<BlockTokenIdentifier> actual) {
        Assert.assertTrue((boolean)Arrays.equals(expected.getIdentifier(), actual.getIdentifier()));
        Assert.assertTrue((boolean)Arrays.equals(expected.getPassword(), actual.getPassword()));
        Assert.assertEquals((Object)expected.getKind(), (Object)actual.getKind());
        Assert.assertEquals((Object)expected.getService(), (Object)actual.getService());
    }

    @Test
    public void testConvertLocatedBlock() {
        DatanodeInfo[] dnInfos = new DatanodeInfo[]{new DatanodeInfo("host0", "0", 5000, 5001, 20000L, 10001L, 9999L, 59L, 69L, 32, "local", "host0", DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS), new DatanodeInfo("host1", "1", 5000, 5001, 20000L, 10001L, 9999L, 59L, 69L, 32, "local", "host1", DatanodeInfo.AdminStates.DECOMMISSIONED), new DatanodeInfo("host2", "2", 5000, 5001, 20000L, 10001L, 9999L, 59L, 69L, 32, "local", "host1", DatanodeInfo.AdminStates.NORMAL)};
        LocatedBlock lb = new LocatedBlock(new ExtendedBlock("bp12", 12345L, 10L, 53L), dnInfos, 5L, false);
        HdfsProtos.LocatedBlockProto lbProto = PBHelper.convert((LocatedBlock)lb);
        LocatedBlock lb2 = PBHelper.convert((HdfsProtos.LocatedBlockProto)lbProto);
        Assert.assertEquals((Object)lb.getBlock(), (Object)lb2.getBlock());
        this.compare((Token<BlockTokenIdentifier>)lb.getBlockToken(), (Token<BlockTokenIdentifier>)lb2.getBlockToken());
        Assert.assertEquals((long)lb.getStartOffset(), (long)lb2.getStartOffset());
        Assert.assertEquals((boolean)lb.isCorrupt(), (boolean)lb2.isCorrupt());
        DatanodeInfo[] dnInfos2 = lb2.getLocations();
        Assert.assertEquals((int)dnInfos.length, (int)dnInfos2.length);
        for (int i = 0; i < dnInfos.length; ++i) {
            this.compare(dnInfos[i], dnInfos2[i]);
        }
    }

    @Test
    public void testConvertDatanodeRegistration() {
        DatanodeID dnId = new DatanodeID("host", "xyz", 1, 0);
        BlockKey[] keys = new BlockKey[]{TestPBHelper.getBlockKey(2), TestPBHelper.getBlockKey(3)};
        ExportedBlockKeys expKeys = new ExportedBlockKeys(true, 9L, 10L, TestPBHelper.getBlockKey(1), keys);
        DatanodeRegistration reg = new DatanodeRegistration(dnId, new StorageInfo(), expKeys);
        DatanodeProtocolProtos.DatanodeRegistrationProto proto = PBHelper.convert((DatanodeRegistration)reg);
        DatanodeRegistration reg2 = PBHelper.convert((DatanodeProtocolProtos.DatanodeRegistrationProto)proto);
        this.compare(reg.storageInfo, reg2.storageInfo);
        this.compare(reg.exportedKeys, reg2.exportedKeys);
        this.compare((DatanodeID)reg, (DatanodeID)reg2);
    }

    @Test
    public void testConvertBlockCommand() {
        Block[] blocks = new Block[]{new Block(21L), new Block(22L)};
        DatanodeInfo[][] dnInfos = new DatanodeInfo[][]{new DatanodeInfo[1], new DatanodeInfo[2]};
        dnInfos[0][0] = new DatanodeInfo();
        dnInfos[1][0] = new DatanodeInfo();
        dnInfos[1][1] = new DatanodeInfo();
        BlockCommand bc = new BlockCommand(1, "bp1", blocks, (DatanodeInfo[][])dnInfos);
        DatanodeProtocolProtos.BlockCommandProto bcProto = PBHelper.convert((BlockCommand)bc);
        BlockCommand bc2 = PBHelper.convert((DatanodeProtocolProtos.BlockCommandProto)bcProto);
        Assert.assertEquals((int)bc.getAction(), (int)bc2.getAction());
        Assert.assertEquals((int)bc.getBlocks().length, (int)bc2.getBlocks().length);
        Block[] blocks2 = bc2.getBlocks();
        for (int i = 0; i < blocks.length; ++i) {
            Assert.assertEquals((Object)blocks[i], (Object)blocks2[i]);
        }
        DatanodeInfo[][] dnInfos2 = bc2.getTargets();
        Assert.assertEquals((int)dnInfos.length, (int)dnInfos2.length);
        for (int i = 0; i < dnInfos.length; ++i) {
            DatanodeInfo[] d1 = dnInfos[i];
            DatanodeInfo[] d2 = dnInfos2[i];
            Assert.assertEquals((int)d1.length, (int)d2.length);
            for (int j = 0; j < d1.length; ++j) {
                this.compare(d1[j], d2[j]);
            }
        }
    }
}

