/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.io.DataOutputBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestCorruptFileBlocks {
    static CorruptFileBlocks serializeAndDeserialize(CorruptFileBlocks cfb) throws IOException {
        DataOutputBuffer buf = new DataOutputBuffer();
        cfb.write((DataOutput)buf);
        byte[] data = buf.getData();
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(data));
        CorruptFileBlocks result = new CorruptFileBlocks();
        result.readFields((DataInput)input);
        return result;
    }

    static boolean checkSerialize(CorruptFileBlocks cfb) throws IOException {
        return cfb.equals((Object)TestCorruptFileBlocks.serializeAndDeserialize(cfb));
    }

    @Test
    public void testSerialization() throws IOException {
        CorruptFileBlocks cfb = new CorruptFileBlocks();
        Assert.assertTrue((String)"cannot serialize empty CFB", (boolean)TestCorruptFileBlocks.checkSerialize(cfb));
        String[] files = new String[]{};
        CorruptFileBlocks cfb2 = new CorruptFileBlocks(files, "");
        Assert.assertTrue((String)"cannot serialize CFB with empty cookie", (boolean)TestCorruptFileBlocks.checkSerialize(cfb2));
        files = new String[]{"a", "bb", "ccc"};
        cfb2 = new CorruptFileBlocks(files, "test");
        Assert.assertTrue((String)"cannot serialize CFB", (boolean)TestCorruptFileBlocks.checkSerialize(cfb2));
    }
}

