/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.EOFException;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.Test;

public class TestShortCircuitLocalRead {
    static final String DIR = "/" + TestShortCircuitLocalRead.class.getSimpleName() + "/";
    static final long seed = 3735928559L;
    static final int blockSize = 5120;
    boolean simulatedStorage = false;

    static FSDataOutputStream createFile(FileSystem fileSys, Path name, int repl) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, 5120L);
        return stm;
    }

    private static void checkData(byte[] actual, int from, byte[] expected, String message) {
        TestShortCircuitLocalRead.checkData(actual, from, expected, actual.length, message);
    }

    private static void checkData(byte[] actual, int from, byte[] expected, int len, String message) {
        for (int idx = 0; idx < len; ++idx) {
            if (expected[from + idx] == actual[idx]) continue;
            Assert.fail((String)(message + " byte " + (from + idx) + " differs. expected " + expected[from + idx] + " actual " + actual[idx]));
        }
    }

    static void checkFileContent(FileSystem fs, Path name, byte[] expected, int readOffset) throws IOException {
        FSDataInputStream stm = fs.open(name);
        byte[] actual = new byte[expected.length - readOffset];
        stm.readFully((long)readOffset, actual);
        TestShortCircuitLocalRead.checkData(actual, readOffset, expected, "Read 2");
        stm.close();
        actual = new byte[expected.length - readOffset];
        stm = fs.open(name);
        long skipped = stm.skip((long)readOffset);
        Assert.assertEquals((long)skipped, (long)readOffset);
        int nread = stm.read(actual, 0, 3);
        nread += stm.read(actual, nread, 2);
        nread += stm.read(actual, nread, 517);
        TestShortCircuitLocalRead.checkData(actual, readOffset, expected, nread, "A few bytes");
        while (nread < actual.length) {
            int nbytes = stm.read(actual, nread, actual.length - nread);
            if (nbytes < 0) {
                throw new EOFException("End of file reached before reading fully.");
            }
            nread += nbytes;
        }
        TestShortCircuitLocalRead.checkData(actual, readOffset, expected, "Read 3");
        stm.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestShortCircuitRead(boolean ignoreChecksum, int size, int readOffset) throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.client.read.shortcircuit", true);
        conf.setBoolean("dfs.client.read.shortcircuit.skip.checksum", ignoreChecksum);
        conf.set("dfs.block.local-path-access.user", UserGroupInformation.getCurrentUser().getShortUserName());
        if (this.simulatedStorage) {
            conf.setBoolean("dfs.datanode.simulateddatastorage", true);
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
        FileSystem fs = cluster.getFileSystem();
        try {
            Path path = new Path("/");
            Assert.assertTrue((String)"/ should be a directory", (fs.getFileStatus(path).isDirectory() ? 1 : 0) != 0);
            byte[] fileData = AppendTestUtil.randomBytes(3735928559L, size);
            Path file1 = new Path("filelocal.dat");
            FSDataOutputStream stm = TestShortCircuitLocalRead.createFile(fs, file1, 1);
            stm.write(fileData);
            stm.close();
            TestShortCircuitLocalRead.checkFileContent(fs, file1, fileData, readOffset);
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    @Test
    public void testFileLocalReadNoChecksum() throws IOException {
        this.doTestShortCircuitRead(true, 15460, 0);
    }

    @Test
    public void testFileLocalReadChecksum() throws IOException {
        this.doTestShortCircuitRead(false, 15460, 0);
    }

    @Test
    public void testSmallFileLocalRead() throws IOException {
        this.doTestShortCircuitRead(false, 13, 0);
        this.doTestShortCircuitRead(false, 13, 5);
        this.doTestShortCircuitRead(true, 13, 0);
        this.doTestShortCircuitRead(true, 13, 5);
    }

    @Test
    public void testReadFromAnOffset() throws IOException {
        this.doTestShortCircuitRead(false, 15460, 777);
        this.doTestShortCircuitRead(true, 15460, 777);
    }

    @Test
    public void testLongFile() throws IOException {
        this.doTestShortCircuitRead(false, 51300, 777);
        this.doTestShortCircuitRead(true, 51300, 777);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetBlockLocalPathInfo() throws IOException, InterruptedException {
        final Configuration conf = new Configuration();
        conf.set("dfs.block.local-path-access.user", "alloweduser");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
        cluster.waitActive();
        DataNode dn = cluster.getDataNodes().get(0);
        FileSystem fs = cluster.getFileSystem();
        try {
            DFSTestUtil.createFile(fs, new Path("/tmp/x"), 16L, (short)1, 23L);
            UserGroupInformation aUgi = UserGroupInformation.createRemoteUser((String)"alloweduser");
            LocatedBlocks lb = cluster.getNameNode().getRpcServer().getBlockLocations("/tmp/x", 0L, 16L);
            ExtendedBlock blk = new ExtendedBlock(lb.get(0).getBlock());
            Token token = lb.get(0).getBlockToken();
            final DatanodeInfo dnInfo = lb.get(0).getLocations()[0];
            ClientDatanodeProtocol proxy = (ClientDatanodeProtocol)aUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ClientDatanodeProtocol>(){

                @Override
                public ClientDatanodeProtocol run() throws Exception {
                    return DFSUtil.createClientDatanodeProtocolProxy((DatanodeID)dnInfo, (Configuration)conf, (int)60000);
                }
            });
            BlockLocalPathInfo blpi = proxy.getBlockLocalPathInfo(blk, token);
            Assert.assertEquals((Object)dn.data.getBlockLocalPathInfo(blk).getBlockPath(), (Object)blpi.getBlockPath());
            UserGroupInformation bUgi = UserGroupInformation.createRemoteUser((String)"notalloweduser");
            proxy = (ClientDatanodeProtocol)bUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ClientDatanodeProtocol>(){

                @Override
                public ClientDatanodeProtocol run() throws Exception {
                    return DFSUtil.createClientDatanodeProtocolProxy((DatanodeID)dnInfo, (Configuration)conf, (int)60000);
                }
            });
            try {
                proxy.getBlockLocalPathInfo(blk, token);
                Assert.fail((String)("The call should have failed as " + bUgi.getShortUserName() + " is not allowed to call getBlockLocalPathInfo"));
            }
            catch (IOException ex) {
                Assert.assertTrue((boolean)ex.getMessage().contains("not allowed to call getBlockLocalPathInfo"));
            }
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        int i;
        if (args.length != 3) {
            System.out.println("Usage: test shortcircuit checksum threadCount");
            System.exit(1);
        }
        boolean shortcircuit = Boolean.valueOf(args[0]);
        boolean checksum = Boolean.valueOf(args[1]);
        int threadCount = Integer.valueOf(args[2]);
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.client.read.shortcircuit", shortcircuit);
        conf.setBoolean("dfs.client.read.shortcircuit.skip.checksum", checksum);
        int fileSize = 5120100;
        final byte[] dataToWrite = AppendTestUtil.randomBytes(3735928559L, fileSize);
        final Path file1 = new Path("filelocal.dat");
        final FileSystem fs = FileSystem.get((Configuration)conf);
        FSDataOutputStream stm = TestShortCircuitLocalRead.createFile(fs, file1, 1);
        stm.write(dataToWrite);
        stm.close();
        long start = System.currentTimeMillis();
        int iteration = 20;
        Thread[] threads = new Thread[threadCount];
        for (i = 0; i < threadCount; ++i) {
            threads[i] = new Thread(){

                @Override
                public void run() {
                    for (int i = 0; i < 20; ++i) {
                        try {
                            TestShortCircuitLocalRead.checkFileContent(fs, file1, dataToWrite, 0);
                            continue;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
        }
        for (i = 0; i < threadCount; ++i) {
            threads[i].start();
        }
        for (i = 0; i < threadCount; ++i) {
            threads[i].join();
        }
        long end = System.currentTimeMillis();
        System.out.println("Iteration 20 took " + (end - start));
        fs.delete(file1, false);
    }
}

