/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtocol;
import org.apache.hadoop.hdfs.protocol.datatransfer.ReplaceDatanodeOnFailure;
import org.apache.hadoop.io.IOUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;

public class TestReplaceDatanodeOnFailure {
    static final Log LOG = AppendTestUtil.LOG;
    static final String DIR = "/" + TestReplaceDatanodeOnFailure.class.getSimpleName() + "/";
    static final short REPLICATION = 3;
    private static final String RACK0 = "/rack0";
    private static final String RACK1 = "/rack1";

    public TestReplaceDatanodeOnFailure() {
        ((Log4JLogger)DataTransferProtocol.LOG).getLogger().setLevel(Level.ALL);
    }

    @Test
    public void testDefaultPolicy() throws Exception {
        ReplaceDatanodeOnFailure p = ReplaceDatanodeOnFailure.DEFAULT;
        DatanodeInfo[] infos = new DatanodeInfo[5];
        DatanodeInfo[][] datanodes = new DatanodeInfo[infos.length + 1][];
        datanodes[0] = new DatanodeInfo[0];
        int i = 0;
        while (i < infos.length) {
            infos[i] = new DatanodeInfo(new DatanodeID("dn" + i));
            datanodes[++i] = new DatanodeInfo[i];
            System.arraycopy(infos, 0, datanodes[i], 0, datanodes[i].length);
        }
        boolean[] isAppend = new boolean[]{true, true, false, false};
        boolean[] isHflushed = new boolean[]{true, false, true, false};
        for (short replication = 1; replication <= infos.length; replication = (short)((short)(replication + 1))) {
            for (int nExistings = 0; nExistings < datanodes.length; ++nExistings) {
                DatanodeInfo[] existings = datanodes[nExistings];
                Assert.assertEquals((long)nExistings, (long)existings.length);
                for (int i2 = 0; i2 < isAppend.length; ++i2) {
                    for (int j = 0; j < isHflushed.length; ++j) {
                        boolean isAH;
                        int half = replication / 2;
                        boolean enoughReplica = replication <= nExistings;
                        boolean noReplica = nExistings == 0;
                        boolean replicationL3 = replication < 3;
                        boolean existingsLEhalf = nExistings <= half;
                        boolean bl = isAH = isAppend[i2] || isHflushed[j];
                        boolean expected = enoughReplica || noReplica || replicationL3 ? false : isAH || existingsLEhalf;
                        boolean computed = p.satisfy(replication, existings, isAppend[i2], isHflushed[j]);
                        try {
                            Assert.assertEquals((Object)expected, (Object)computed);
                            continue;
                        }
                        catch (AssertionError e) {
                            String s = "replication=" + replication + "\nnExistings =" + nExistings + "\nisAppend   =" + isAppend[i2] + "\nisHflushed =" + isHflushed[j];
                            throw new RuntimeException(s, (Throwable)((Object)e));
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplaceDatanodeOnFailure() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        ReplaceDatanodeOnFailure.ALWAYS.write((Configuration)conf);
        Object[] racks = new String[3];
        Arrays.fill(racks, RACK0);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).racks((String[])racks).numDataNodes(3).build();
        try {
            DistributedFileSystem fs = (DistributedFileSystem)cluster.getFileSystem();
            Path dir = new Path(DIR);
            SlowWriter[] slowwriters = new SlowWriter[10];
            for (int i = 1; i <= slowwriters.length; ++i) {
                slowwriters[i - 1] = new SlowWriter(fs, new Path(dir, "file" + i), (long)i * 200L);
            }
            for (SlowWriter s : slowwriters) {
                s.start();
            }
            TestReplaceDatanodeOnFailure.sleepSeconds(1);
            cluster.startDataNodes((Configuration)conf, 2, true, null, new String[]{RACK1, RACK1});
            cluster.stopDataNode(AppendTestUtil.nextInt(3));
            TestReplaceDatanodeOnFailure.sleepSeconds(5);
            for (SlowWriter s : slowwriters) {
                s.checkReplication();
                s.interruptRunning();
            }
            for (SlowWriter s : slowwriters) {
                s.joinAndClose();
            }
            LOG.info((Object)"Verify the file");
            for (int i = 0; i < slowwriters.length; ++i) {
                LOG.info((Object)(slowwriters[i].filepath + ": length=" + fs.getFileStatus(slowwriters[i].filepath).getLen()));
                FSDataInputStream in = null;
                try {
                    int x;
                    in = fs.open(slowwriters[i].filepath);
                    int j = 0;
                    while ((x = in.read()) != -1) {
                        Assert.assertEquals((long)j, (long)x);
                        ++j;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeStream(in);
                    throw throwable;
                }
                IOUtils.closeStream((Closeable)in);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    static void sleepSeconds(int waittime) throws InterruptedException {
        LOG.info((Object)("Wait " + waittime + " seconds"));
        Thread.sleep((long)waittime * 1000L);
    }

    static class SlowWriter
    extends Thread {
        final Path filepath;
        private FSDataOutputStream out = null;
        final long sleepms;
        private volatile boolean running = true;

        SlowWriter(DistributedFileSystem fs, Path filepath, long sleepms) throws IOException {
            super(SlowWriter.class.getSimpleName() + ":" + filepath);
            this.filepath = filepath;
            this.out = fs.create(filepath, (short)3);
            this.sleepms = sleepms;
        }

        @Override
        public void run() {
            int i = 0;
            try {
                SlowWriter.sleep(this.sleepms);
                while (this.running) {
                    LOG.info((Object)(this.getName() + " writes " + i));
                    this.out.write(i);
                    this.out.hflush();
                    SlowWriter.sleep(this.sleepms);
                    ++i;
                }
            }
            catch (InterruptedException e) {
                LOG.info((Object)(this.getName() + " interrupted:" + e));
            }
            catch (IOException e) {
                throw new RuntimeException(this.getName(), e);
            }
            finally {
                LOG.info((Object)(this.getName() + " terminated: i=" + i));
            }
        }

        void interruptRunning() {
            this.running = false;
            this.interrupt();
        }

        void joinAndClose() throws InterruptedException {
            LOG.info((Object)(this.getName() + " join and close"));
            this.join();
            IOUtils.closeStream((Closeable)this.out);
        }

        void checkReplication() throws IOException {
            DFSOutputStream dfsout = (DFSOutputStream)this.out.getWrappedStream();
            Assert.assertEquals((long)3L, (long)dfsout.getNumCurrentReplicas());
        }
    }
}

