/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.lang.reflect.Field;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.HftpFileSystem;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.Test;

public class TestHftpDelegationToken {
    @Test
    public void testHdfsDelegationToken() throws Exception {
        final Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"oom", (String[])new String[]{"memory"});
        Token token = new Token(new byte[0], new byte[0], DelegationTokenIdentifier.HDFS_DELEGATION_KIND, new Text("127.0.0.1:8020"));
        user.addToken(token);
        Token token2 = new Token(null, null, new Text("other token"), new Text("127.0.0.1:8020"));
        user.addToken(token2);
        Assert.assertEquals((String)"wrong tokens in user", (long)2L, (long)user.getTokens().size());
        FileSystem fs = (FileSystem)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return FileSystem.get((URI)new URI("hftp://localhost:50470/"), (Configuration)conf);
            }
        });
        Assert.assertSame((String)"wrong kind of file system", HftpFileSystem.class, fs.getClass());
        Field renewToken = HftpFileSystem.class.getDeclaredField("renewToken");
        renewToken.setAccessible(true);
        Assert.assertSame((String)"wrong token", (Object)token, (Object)renewToken.get(fs));
    }
}

