/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TestTrash;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;

public class TestHDFSTrash
extends TestTrash {
    private static MiniDFSCluster cluster = null;

    public static Test suite() {
        TestSetup setup = new TestSetup((Test)new TestSuite(TestHDFSTrash.class)){

            protected void setUp() throws Exception {
                HdfsConfiguration conf = new HdfsConfiguration();
                cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
            }

            protected void tearDown() throws Exception {
                if (cluster != null) {
                    cluster.shutdown();
                }
            }
        };
        return setup;
    }

    public void testTrash() throws IOException {
        TestHDFSTrash.trashShell((FileSystem)cluster.getFileSystem(), (Path)new Path("/"));
    }

    public void testNonDefaultFS() throws IOException {
        FileSystem fs = cluster.getFileSystem();
        Configuration conf = fs.getConf();
        conf.set("fs.defaultFS", fs.getUri().toString());
        TestHDFSTrash.trashNonDefaultFS((Configuration)conf);
    }
}

