/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.net.InetSocketAddress;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;

public class TestDatanodeRegistration
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChangeIpcPort() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
            DFSClient client = new DFSClient(addr, (Configuration)conf);
            cluster.restartDataNodes();
            DatanodeInfo[] report = client.datanodeReport(HdfsConstants.DatanodeReportType.ALL);
            long firstUpdateAfterRestart = report[0].getLastUpdate();
            boolean gotHeartbeat = false;
            for (int i = 0; i < 10 && !gotHeartbeat; ++i) {
                try {
                    Thread.sleep(i * 1000);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                report = client.datanodeReport(HdfsConstants.DatanodeReportType.ALL);
                gotHeartbeat = report[0].getLastUpdate() > firstUpdateAfterRestart;
            }
            if (!gotHeartbeat) {
                TestDatanodeRegistration.fail((String)"Never got a heartbeat from restarted datanode.");
            }
            int realIpcPort = cluster.getDataNodes().get(0).getIpcPort();
            TestDatanodeRegistration.assertEquals((int)realIpcPort, (int)report[0].getIpcPort());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

