/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Random;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.io.IOUtils;

public class TestDatanodeBlockScanner
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestDatanodeBlockScanner.class);
    private static final long TIMEOUT = 20000L;
    private static Pattern pattern = Pattern.compile(".*?(blk_[-]*\\d+).*?scan time\\s*:\\s*(\\d+)");
    private static Pattern pattern_blockVerify = Pattern.compile(".*?(SCAN_PERIOD)\\s*:\\s*(\\d+.*?)");

    private static long waitForVerification(int infoPort, FileSystem fs, Path file, int blocksValidated, long newTime, long timeout) throws IOException, TimeoutException {
        long failtime;
        URL url = new URL("http://localhost:" + infoPort + "/blockScannerReport?listblocks");
        long lastWarnTime = System.currentTimeMillis();
        if (newTime <= 0L) {
            newTime = 1L;
        }
        long verificationTime = 0L;
        String block = DFSTestUtil.getFirstBlock(fs, file).getBlockName();
        long l = failtime = timeout <= 0L ? Long.MAX_VALUE : System.currentTimeMillis() + timeout;
        while (verificationTime < newTime) {
            Matcher matcher;
            if (failtime < System.currentTimeMillis()) {
                throw new TimeoutException("failed to achieve block verification after " + timeout + " msec.  Current verification timestamp = " + verificationTime + ", requested verification time > " + newTime);
            }
            String response = DFSTestUtil.urlGet(url);
            if (blocksValidated >= 0) {
                matcher = pattern_blockVerify.matcher(response);
                while (matcher.find()) {
                    if (!block.equals(matcher.group(1))) continue;
                    TestDatanodeBlockScanner.assertEquals((int)1, (int)blocksValidated);
                    break;
                }
            }
            matcher = pattern.matcher(response);
            while (matcher.find()) {
                if (!block.equals(matcher.group(1))) continue;
                verificationTime = Long.parseLong(matcher.group(2));
                break;
            }
            if (verificationTime >= newTime) continue;
            long now = System.currentTimeMillis();
            if (now - lastWarnTime >= 5000L) {
                LOG.info((Object)("Waiting for verification of " + block));
                lastWarnTime = now;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ignored) {}
        }
        return verificationTime;
    }

    public void testDatanodeBlockScanner() throws IOException, TimeoutException {
        long startTime = System.currentTimeMillis();
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        cluster.waitActive();
        FileSystem fs = cluster.getFileSystem();
        Path file1 = new Path("/tmp/testBlockVerification/file1");
        Path file2 = new Path("/tmp/testBlockVerification/file2");
        DFSTestUtil.createFile(fs, file1, 10L, (short)1, 0L);
        cluster.shutdown();
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(false).build();
        cluster.waitActive();
        DFSClient dfsClient = new DFSClient(new InetSocketAddress("localhost", cluster.getNameNodePort()), (Configuration)conf);
        fs = cluster.getFileSystem();
        DatanodeInfo dn = dfsClient.datanodeReport(HdfsConstants.DatanodeReportType.LIVE)[0];
        TestDatanodeBlockScanner.assertTrue((TestDatanodeBlockScanner.waitForVerification(dn.getInfoPort(), fs, file1, 1, startTime, 20000L) >= startTime ? 1 : 0) != 0);
        DFSTestUtil.createFile(fs, file2, 10L, (short)1, 0L);
        IOUtils.copyBytes((InputStream)fs.open(file2), (OutputStream)new IOUtils.NullOutputStream(), (Configuration)conf, (boolean)true);
        TestDatanodeBlockScanner.assertTrue((TestDatanodeBlockScanner.waitForVerification(dn.getInfoPort(), fs, file2, 2, startTime, 20000L) >= startTime ? 1 : 0) != 0);
        cluster.shutdown();
    }

    public static boolean corruptReplica(ExtendedBlock blk, int replica) throws IOException {
        return MiniDFSCluster.corruptReplica(replica, blk);
    }

    public void testBlockCorruptionPolicy() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        Random random = new Random();
        FileSystem fs = null;
        int rand = random.nextInt(3);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        cluster.waitActive();
        fs = cluster.getFileSystem();
        Path file1 = new Path("/tmp/testBlockVerification/file1");
        DFSTestUtil.createFile(fs, file1, 1024L, (short)3, 0L);
        ExtendedBlock block = DFSTestUtil.getFirstBlock(fs, file1);
        DFSTestUtil.waitReplication(fs, file1, (short)3);
        TestDatanodeBlockScanner.assertFalse((boolean)DFSTestUtil.allBlockReplicasCorrupt(cluster, file1, 0));
        TestDatanodeBlockScanner.assertTrue((boolean)MiniDFSCluster.corruptReplica(rand, block));
        cluster.restartDataNode(rand);
        DFSTestUtil.waitReplication(fs, file1, (short)2);
        TestDatanodeBlockScanner.assertFalse((boolean)DFSTestUtil.allBlockReplicasCorrupt(cluster, file1, 0));
        TestDatanodeBlockScanner.assertTrue((boolean)MiniDFSCluster.corruptReplica(0, block));
        TestDatanodeBlockScanner.assertTrue((boolean)MiniDFSCluster.corruptReplica(1, block));
        TestDatanodeBlockScanner.assertTrue((boolean)MiniDFSCluster.corruptReplica(2, block));
        try {
            IOUtils.copyBytes((InputStream)fs.open(file1), (OutputStream)new IOUtils.NullOutputStream(), (Configuration)conf, (boolean)true);
        }
        catch (IOException e) {
            // empty catch block
        }
        DFSTestUtil.waitReplication(fs, file1, (short)3);
        TestDatanodeBlockScanner.assertTrue((boolean)DFSTestUtil.allBlockReplicasCorrupt(cluster, file1, 0));
        cluster.shutdown();
    }

    public void testBlockCorruptionRecoveryPolicy1() throws Exception {
        LOG.info((Object)"Testing corrupt replica recovery for one corrupt replica");
        this.blockCorruptionRecoveryPolicy(4, (short)3, 1);
    }

    public void testBlockCorruptionRecoveryPolicy2() throws Exception {
        LOG.info((Object)"Testing corrupt replica recovery for two corrupt replicas");
        this.blockCorruptionRecoveryPolicy(5, (short)3, 2);
    }

    private void blockCorruptionRecoveryPolicy(int numDataNodes, short numReplicas, int numCorruptReplicas) throws Exception {
        int i;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blockreport.intervalMsec", 30L);
        conf.setLong("dfs.namenode.replication.interval", 3L);
        conf.setLong("dfs.heartbeat.interval", 3L);
        conf.setBoolean("dfs.namenode.replication.considerLoad", false);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(numDataNodes).build();
        cluster.waitActive();
        FileSystem fs = cluster.getFileSystem();
        Path file1 = new Path("/tmp/testBlockCorruptRecovery/file");
        DFSTestUtil.createFile(fs, file1, 1024L, numReplicas, 0L);
        ExtendedBlock block = DFSTestUtil.getFirstBlock(fs, file1);
        DFSTestUtil.waitReplication(fs, file1, numReplicas);
        int[] corruptReplicasDNIDs = new int[numCorruptReplicas];
        int j = 0;
        for (i = 0; j != numCorruptReplicas && i < numDataNodes; ++i) {
            if (!TestDatanodeBlockScanner.corruptReplica(block, i)) continue;
            corruptReplicasDNIDs[j++] = i;
            LOG.info((Object)("successfully corrupted block " + block + " on node " + i + " " + cluster.getDataNodes().get(i).getSelfAddr()));
        }
        for (i = numCorruptReplicas - 1; i >= 0; --i) {
            LOG.info((Object)("restarting node with corrupt replica: position " + i + " node " + corruptReplicasDNIDs[i] + " " + cluster.getDataNodes().get(corruptReplicasDNIDs[i]).getSelfAddr()));
            cluster.restartDataNode(corruptReplicasDNIDs[i]);
        }
        DFSTestUtil.waitCorruptReplicas(fs, cluster.getNamesystem(), file1, block, numCorruptReplicas);
        DFSTestUtil.waitReplication(fs, file1, numReplicas);
        TestDatanodeBlockScanner.assertFalse((boolean)DFSTestUtil.allBlockReplicasCorrupt(cluster, file1, 0));
        DFSTestUtil.waitCorruptReplicas(fs, cluster.getNamesystem(), file1, block, 0);
        cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTruncatedBlockReport() throws Exception {
        ExtendedBlock block;
        FileSystem fs;
        HdfsConfiguration conf = new HdfsConfiguration();
        int REPLICATION_FACTOR = 2;
        Path fileName = new Path("/file1");
        conf.setLong("dfs.blockreport.intervalMsec", 3L);
        conf.setLong("dfs.namenode.replication.interval", 3L);
        conf.setLong("dfs.heartbeat.interval", 3L);
        conf.setBoolean("dfs.namenode.replication.considerLoad", false);
        long startTime = System.currentTimeMillis();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        cluster.waitActive();
        try {
            fs = cluster.getFileSystem();
            DFSTestUtil.createFile(fs, fileName, 1L, (short)2, 0L);
            DFSTestUtil.waitReplication(fs, fileName, (short)2);
            block = DFSTestUtil.getFirstBlock(fs, fileName);
        }
        finally {
            cluster.shutdown();
        }
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).format(false).build();
        cluster.waitActive();
        try {
            fs = cluster.getFileSystem();
            int infoPort = cluster.getDataNodes().get(0).getInfoPort();
            TestDatanodeBlockScanner.assertTrue((TestDatanodeBlockScanner.waitForVerification(infoPort, fs, fileName, 1, startTime, 20000L) >= startTime ? 1 : 0) != 0);
            if (!TestDatanodeBlockScanner.changeReplicaLength(block, 0, -1)) {
                throw new IOException("failed to find or change length of replica on node 0 " + cluster.getDataNodes().get(0).getSelfAddr());
            }
        }
        finally {
            cluster.shutdown();
        }
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).format(false).build();
        cluster.startDataNodes((Configuration)conf, 1, true, null, null);
        cluster.waitActive();
        cluster.waitClusterUp();
        TestDatanodeBlockScanner.assertFalse((String)"failed to leave safe mode", (boolean)cluster.getNameNode().isInSafeMode());
        try {
            DFSTestUtil.waitReplication(cluster.getFileSystem(), fileName, (short)2);
            TestDatanodeBlockScanner.waitForBlockDeleted(block, 0, 20000L);
        }
        finally {
            cluster.shutdown();
        }
    }

    static boolean changeReplicaLength(ExtendedBlock blk, int dnIndex, int lenDelta) throws IOException {
        File blockFile = MiniDFSCluster.getBlockFile(dnIndex, blk);
        if (blockFile != null && blockFile.exists()) {
            RandomAccessFile raFile = new RandomAccessFile(blockFile, "rw");
            raFile.setLength(raFile.length() + (long)lenDelta);
            raFile.close();
            return true;
        }
        LOG.info((Object)("failed to change length of block " + blk));
        return false;
    }

    private static void waitForBlockDeleted(ExtendedBlock blk, int dnIndex, long timeout) throws IOException, TimeoutException, InterruptedException {
        File blockFile = MiniDFSCluster.getBlockFile(dnIndex, blk);
        long failtime = System.currentTimeMillis() + (timeout > 0L ? timeout : Long.MAX_VALUE);
        while (blockFile != null && blockFile.exists()) {
            if (failtime < System.currentTimeMillis()) {
                throw new TimeoutException("waited too long for blocks to be deleted: " + blockFile.getPath() + (blockFile.exists() ? " still exists; " : " is absent; "));
            }
            Thread.sleep(100L);
            blockFile = MiniDFSCluster.getBlockFile(dnIndex, blk);
        }
    }
}

