/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.Permission;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Scanner;
import java.util.zip.GZIPOutputStream;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputChecker;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.FSDataset;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TestDFSShell
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestDFSShell.class);
    static final String TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp")).toString().replace(' ', '+');

    static Path writeFile(FileSystem fs, Path f) throws IOException {
        FSDataOutputStream out = fs.create(f);
        out.writeBytes("dhruba: " + f);
        out.close();
        TestDFSShell.assertTrue((boolean)fs.exists(f));
        return f;
    }

    static Path mkdir(FileSystem fs, Path p) throws IOException {
        TestDFSShell.assertTrue((boolean)fs.mkdirs(p));
        TestDFSShell.assertTrue((boolean)fs.exists(p));
        TestDFSShell.assertTrue((boolean)fs.getFileStatus(p).isDirectory());
        return p;
    }

    static File createLocalFile(File f) throws IOException {
        TestDFSShell.assertTrue((!f.exists() ? 1 : 0) != 0);
        PrintWriter out = new PrintWriter(f);
        out.print("createLocalFile: " + f.getAbsolutePath());
        out.flush();
        out.close();
        TestDFSShell.assertTrue((boolean)f.exists());
        TestDFSShell.assertTrue((boolean)f.isFile());
        return f;
    }

    static void show(String s) {
        System.out.println(Thread.currentThread().getStackTrace()[2] + " " + s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testZeroSizeFile() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        FileSystem fs = cluster.getFileSystem();
        TestDFSShell.assertTrue((String)("Not a HDFS: " + fs.getUri()), (boolean)(fs instanceof DistributedFileSystem));
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        try {
            File f1 = new File(TEST_ROOT_DIR, "f1");
            TestDFSShell.assertTrue((!f1.exists() ? 1 : 0) != 0);
            TestDFSShell.assertTrue((boolean)f1.createNewFile());
            TestDFSShell.assertTrue((boolean)f1.exists());
            TestDFSShell.assertTrue((boolean)f1.isFile());
            TestDFSShell.assertEquals((long)0L, (long)f1.length());
            Path root = TestDFSShell.mkdir((FileSystem)dfs, new Path("/test/zeroSizeFile"));
            Path remotef = new Path(root, "dst");
            TestDFSShell.show("copy local " + f1 + " to remote " + remotef);
            dfs.copyFromLocalFile(false, false, new Path(f1.getPath()), remotef);
            TestDFSShell.show("Block size = " + dfs.getFileStatus(remotef).getBlockSize());
            File f2 = new File(TEST_ROOT_DIR, "f2");
            TestDFSShell.assertTrue((!f2.exists() ? 1 : 0) != 0);
            dfs.copyToLocalFile(remotef, new Path(f2.getPath()));
            TestDFSShell.assertTrue((boolean)f2.exists());
            TestDFSShell.assertTrue((boolean)f2.isFile());
            TestDFSShell.assertEquals((long)0L, (long)f2.length());
            f1.delete();
            f2.delete();
        }
        finally {
            try {
                dfs.close();
            }
            catch (Exception e) {}
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRecrusiveRm() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        FileSystem fs = cluster.getFileSystem();
        TestDFSShell.assertTrue((String)("Not a HDFS: " + fs.getUri()), (boolean)(fs instanceof DistributedFileSystem));
        try {
            fs.mkdirs(new Path(new Path("parent"), "child"));
            try {
                fs.delete(new Path("parent"), false);
                assert (false);
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                fs.delete(new Path("parent"), true);
            }
            catch (IOException e) {
                assert (false);
            }
        }
        finally {
            try {
                fs.close();
            }
            catch (IOException e) {}
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDu() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        FileSystem fs = cluster.getFileSystem();
        TestDFSShell.assertTrue((String)("Not a HDFS: " + fs.getUri()), (boolean)(fs instanceof DistributedFileSystem));
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        PrintStream psBackup = System.out;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream psOut = new PrintStream(out);
        System.setOut(psOut);
        FsShell shell = new FsShell();
        shell.setConf((Configuration)conf);
        try {
            Path myPath = new Path("/test/dir");
            TestDFSShell.assertTrue((boolean)fs.mkdirs(myPath));
            TestDFSShell.assertTrue((boolean)fs.exists(myPath));
            Path myFile = new Path("/test/dir/file");
            TestDFSShell.writeFile(fs, myFile);
            TestDFSShell.assertTrue((boolean)fs.exists(myFile));
            Path myFile2 = new Path("/test/dir/file2");
            TestDFSShell.writeFile(fs, myFile2);
            TestDFSShell.assertTrue((boolean)fs.exists(myFile2));
            String[] args = new String[]{"-du", "/test/dir"};
            int val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            TestDFSShell.assertTrue((val == 0 ? 1 : 0) != 0);
            String returnString = out.toString();
            out.reset();
            TestDFSShell.assertTrue((boolean)returnString.contains("22"));
            TestDFSShell.assertTrue((boolean)returnString.contains("23"));
        }
        finally {
            try {
                dfs.close();
            }
            catch (Exception e) {}
            System.setOut(psBackup);
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPut() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        FileSystem fs = cluster.getFileSystem();
        TestDFSShell.assertTrue((String)("Not a HDFS: " + fs.getUri()), (boolean)(fs instanceof DistributedFileSystem));
        final DistributedFileSystem dfs = (DistributedFileSystem)fs;
        try {
            new File(TEST_ROOT_DIR, ".f1.crc").delete();
            new File(TEST_ROOT_DIR, ".f2.crc").delete();
            File f1 = TestDFSShell.createLocalFile(new File(TEST_ROOT_DIR, "f1"));
            final File f2 = TestDFSShell.createLocalFile(new File(TEST_ROOT_DIR, "f2"));
            Path root = TestDFSShell.mkdir((FileSystem)dfs, new Path("/test/put"));
            final Path dst = new Path(root, "dst");
            TestDFSShell.show("begin");
            final Thread copy2ndFileThread = new Thread(){

                @Override
                public void run() {
                    try {
                        TestDFSShell.show("copy local " + f2 + " to remote " + dst);
                        dfs.copyFromLocalFile(false, false, new Path(f2.getPath()), dst);
                    }
                    catch (IOException ioe) {
                        TestDFSShell.show("good " + StringUtils.stringifyException((Throwable)ioe));
                        return;
                    }
                    Assert.assertTrue((boolean)false);
                }
            };
            SecurityManager sm = System.getSecurityManager();
            System.out.println("SecurityManager = " + sm);
            System.setSecurityManager(new SecurityManager(){
                private boolean firstTime = true;

                @Override
                public void checkPermission(Permission perm) {
                    String s;
                    Thread t;
                    if (this.firstTime && !(t = Thread.currentThread()).toString().contains("DataNode") && (s = "" + Arrays.asList(t.getStackTrace())).contains("FileUtil.copyContent")) {
                        this.firstTime = false;
                        copy2ndFileThread.start();
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
            });
            TestDFSShell.show("copy local " + f1 + " to remote " + dst);
            dfs.copyFromLocalFile(false, false, new Path(f1.getPath()), dst);
            TestDFSShell.show("done");
            try {
                copy2ndFileThread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            System.setSecurityManager(sm);
            Path destmultiple = TestDFSShell.mkdir((FileSystem)dfs, new Path("/test/putmultiple"));
            Path[] srcs = new Path[]{new Path(f1.getPath()), new Path(f2.getPath())};
            dfs.copyFromLocalFile(false, false, srcs, destmultiple);
            srcs[0] = new Path(destmultiple, "f1");
            srcs[1] = new Path(destmultiple, "f2");
            TestDFSShell.assertTrue((boolean)dfs.exists(srcs[0]));
            TestDFSShell.assertTrue((boolean)dfs.exists(srcs[1]));
            Path destmultiple2 = TestDFSShell.mkdir((FileSystem)dfs, new Path("/test/movemultiple"));
            srcs[0] = new Path(f1.getPath());
            srcs[1] = new Path(f2.getPath());
            dfs.moveFromLocalFile(srcs, destmultiple2);
            TestDFSShell.assertFalse((boolean)f1.exists());
            TestDFSShell.assertFalse((boolean)f2.exists());
            srcs[0] = new Path(destmultiple2, "f1");
            srcs[1] = new Path(destmultiple2, "f2");
            TestDFSShell.assertTrue((boolean)dfs.exists(srcs[0]));
            TestDFSShell.assertTrue((boolean)dfs.exists(srcs[1]));
            f1.delete();
            f2.delete();
        }
        finally {
            try {
                dfs.close();
            }
            catch (Exception e) {}
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testErrOutPut() throws Exception {
        MiniDFSCluster cluster;
        block5: {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = null;
            PrintStream bak = null;
            try {
                cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
                FileSystem srcFs = cluster.getFileSystem();
                Path root = new Path("/nonexistentfile");
                bak = System.err;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintStream tmp = new PrintStream(out);
                System.setErr(tmp);
                String[] argv = new String[]{"-cat", root.toUri().getPath()};
                int ret = ToolRunner.run((Tool)new FsShell(), (String[])argv);
                TestDFSShell.assertEquals((String)" -cat returned 1 ", (int)1, (int)ret);
                String returned = out.toString();
                TestDFSShell.assertTrue((String)"cat does not print exceptions ", (returned.lastIndexOf("Exception") == -1 ? 1 : 0) != 0);
                out.reset();
                argv[0] = "-rm";
                argv[1] = root.toString();
                FsShell shell = new FsShell();
                shell.setConf((Configuration)conf);
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                TestDFSShell.assertEquals((String)" -rm returned 1 ", (int)1, (int)ret);
                returned = out.toString();
                out.reset();
                TestDFSShell.assertTrue((String)"rm prints reasonable error ", (returned.lastIndexOf("No such file or directory") != -1 ? 1 : 0) != 0);
                argv[0] = "-rmr";
                argv[1] = root.toString();
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                TestDFSShell.assertEquals((String)" -rmr returned 1", (int)1, (int)ret);
                returned = out.toString();
                TestDFSShell.assertTrue((String)"rmr prints reasonable error ", (returned.lastIndexOf("No such file or directory") != -1 ? 1 : 0) != 0);
                out.reset();
                argv[0] = "-du";
                argv[1] = "/nonexistentfile";
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                returned = out.toString();
                TestDFSShell.assertTrue((String)" -du prints reasonable error ", (returned.lastIndexOf("No such file or directory") != -1 ? 1 : 0) != 0);
                out.reset();
                argv[0] = "-dus";
                argv[1] = "/nonexistentfile";
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                returned = out.toString();
                TestDFSShell.assertTrue((String)" -dus prints reasonable error", (returned.lastIndexOf("No such file or directory") != -1 ? 1 : 0) != 0);
                out.reset();
                argv[0] = "-ls";
                argv[1] = "/nonexistenfile";
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                returned = out.toString();
                TestDFSShell.assertTrue((String)" -ls does not return Found 0 items", (returned.lastIndexOf("Found 0") == -1 ? 1 : 0) != 0);
                out.reset();
                argv[0] = "-ls";
                argv[1] = "/nonexistentfile";
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                TestDFSShell.assertEquals((String)" -lsr should fail ", (int)1, (int)ret);
                out.reset();
                srcFs.mkdirs(new Path("/testdir"));
                argv[0] = "-ls";
                argv[1] = "/testdir";
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                returned = out.toString();
                TestDFSShell.assertTrue((String)" -ls does not print out anything ", (returned.lastIndexOf("Found 0") == -1 ? 1 : 0) != 0);
                out.reset();
                argv[0] = "-ls";
                argv[1] = "/user/nonxistant/*";
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                TestDFSShell.assertEquals((String)" -ls on nonexistent glob returns 1", (int)1, (int)ret);
                out.reset();
                argv[0] = "-mkdir";
                argv[1] = "/testdir";
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                returned = out.toString();
                TestDFSShell.assertEquals((String)" -mkdir returned 1 ", (int)1, (int)ret);
                TestDFSShell.assertTrue((String)" -mkdir returned File exists", (returned.lastIndexOf("File exists") != -1 ? 1 : 0) != 0);
                Path testFile = new Path("/testfile");
                FSDataOutputStream outtmp = srcFs.create(testFile);
                outtmp.write(testFile.toString().getBytes());
                outtmp.close();
                out.reset();
                argv[0] = "-mkdir";
                argv[1] = "/testfile";
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                returned = out.toString();
                TestDFSShell.assertEquals((String)" -mkdir returned 1", (int)1, (int)ret);
                TestDFSShell.assertTrue((String)" -mkdir returned this is a file ", (returned.lastIndexOf("not a directory") != -1 ? 1 : 0) != 0);
                out.reset();
                argv = new String[]{"-mv", "/testfile", "file"};
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                TestDFSShell.assertEquals((String)"mv failed to rename", (int)1, (int)ret);
                out.reset();
                argv = new String[]{"-mv", "/testfile", "/testfiletest"};
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                returned = out.toString();
                TestDFSShell.assertTrue((String)"no output from rename", (returned.lastIndexOf("Renamed") == -1 ? 1 : 0) != 0);
                out.reset();
                argv[0] = "-mv";
                argv[1] = "/testfile";
                argv[2] = "/testfiletmp";
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                returned = out.toString();
                TestDFSShell.assertTrue((String)" unix like output", (returned.lastIndexOf("No such file or") != -1 ? 1 : 0) != 0);
                out.reset();
                argv = new String[]{"-du"};
                srcFs.mkdirs(srcFs.getHomeDirectory());
                ret = ToolRunner.run((Tool)shell, (String[])argv);
                returned = out.toString();
                TestDFSShell.assertEquals((String)" no error ", (int)0, (int)ret);
                TestDFSShell.assertTrue((String)"empty path specified", (returned.lastIndexOf("empty string") == -1 ? 1 : 0) != 0);
                if (bak == null) break block5;
            }
            catch (Throwable throwable) {
                if (bak != null) {
                    System.setErr(bak);
                }
                if (cluster != null) {
                    cluster.shutdown();
                }
                throw throwable;
            }
            System.setErr(bak);
        }
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testURIPaths() throws Exception {
        HdfsConfiguration srcConf = new HdfsConfiguration();
        HdfsConfiguration dstConf = new HdfsConfiguration();
        MiniDFSCluster srcCluster = null;
        MiniDFSCluster dstCluster = null;
        String bak = System.getProperty("test.build.data");
        try {
            srcCluster = new MiniDFSCluster.Builder((Configuration)srcConf).numDataNodes(2).build();
            File nameDir = new File(new File(bak), "dfs_tmp_uri/");
            nameDir.mkdirs();
            System.setProperty("test.build.data", nameDir.toString());
            dstCluster = new MiniDFSCluster.Builder((Configuration)dstConf).numDataNodes(2).build();
            FileSystem srcFs = srcCluster.getFileSystem();
            FileSystem dstFs = dstCluster.getFileSystem();
            FsShell shell = new FsShell();
            shell.setConf((Configuration)srcConf);
            String[] argv = new String[]{"-ls", dstFs.getUri().toString() + "/"};
            int ret = ToolRunner.run((Tool)shell, (String[])argv);
            TestDFSShell.assertEquals((String)"ls works on remote uri ", (int)0, (int)ret);
            dstFs.mkdirs(new Path("/hadoopdir"));
            argv = new String[]{"-rmr", dstFs.getUri().toString() + "/hadoopdir"};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            TestDFSShell.assertEquals((String)("-rmr works on remote uri " + argv[1]), (int)0, (int)ret);
            argv[0] = "-du";
            argv[1] = dstFs.getUri().toString() + "/";
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            TestDFSShell.assertEquals((String)"du works on remote uri ", (int)0, (int)ret);
            File furi = new File(TEST_ROOT_DIR, "furi");
            TestDFSShell.createLocalFile(furi);
            argv = new String[]{"-put", furi.toString(), dstFs.getUri().toString() + "/furi"};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            TestDFSShell.assertEquals((String)" put is working ", (int)0, (int)ret);
            argv[0] = "-cp";
            argv[1] = dstFs.getUri().toString() + "/furi";
            argv[2] = srcFs.getUri().toString() + "/furi";
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            TestDFSShell.assertEquals((String)" cp is working ", (int)0, (int)ret);
            TestDFSShell.assertTrue((boolean)srcFs.exists(new Path("/furi")));
            argv = new String[]{"-cat", dstFs.getUri().toString() + "/furi"};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            TestDFSShell.assertEquals((String)" cat is working ", (int)0, (int)ret);
            dstFs.delete(new Path("/furi"), true);
            dstFs.delete(new Path("/hadoopdir"), true);
            String file = "/tmp/chownTest";
            Path path = new Path(file);
            Path parent = new Path("/tmp");
            Path root = new Path("/");
            TestDFSShell.writeFile(dstFs, path);
            TestDFSShell.runCmd(shell, "-chgrp", "-R", "herbivores", dstFs.getUri().toString() + "/*");
            this.confirmOwner(null, "herbivores", dstFs, parent, path);
            TestDFSShell.runCmd(shell, "-chown", "-R", ":reptiles", dstFs.getUri().toString() + "/");
            this.confirmOwner(null, "reptiles", dstFs, root, parent, path);
            argv[0] = "-cat";
            argv[1] = "hdfs:///furi";
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            TestDFSShell.assertEquals((String)" default works for cat", (int)0, (int)ret);
            argv[0] = "-ls";
            argv[1] = "hdfs:///";
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            TestDFSShell.assertEquals((String)"default works for ls ", (int)0, (int)ret);
            argv[0] = "-rmr";
            argv[1] = "hdfs:///furi";
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            TestDFSShell.assertEquals((String)"default works for rm/rmr", (int)0, (int)ret);
        }
        finally {
            System.setProperty("test.build.data", bak);
            if (null != srcCluster) {
                srcCluster.shutdown();
            }
            if (null != dstCluster) {
                dstCluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testText() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
            FileSystem dfs = cluster.getFileSystem();
            this.textTest(new Path("/texttest").makeQualified(dfs.getUri(), dfs.getWorkingDirectory()), (Configuration)conf);
            conf.set("fs.default.name", dfs.getUri().toString());
            LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
            this.textTest(new Path(TEST_ROOT_DIR, "texttest").makeQualified(lfs.getUri(), lfs.getWorkingDirectory()), (Configuration)conf);
        }
        finally {
            if (null != cluster) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void textTest(Path root, Configuration conf) throws Exception {
        PrintStream bak = null;
        try {
            FileSystem fs = root.getFileSystem(conf);
            fs.mkdirs(root);
            GZIPOutputStream zout = new GZIPOutputStream((OutputStream)fs.create(new Path(root, "file.gz")));
            Random r = new Random();
            ByteArrayOutputStream file = new ByteArrayOutputStream();
            for (int i = 0; i < 1024; ++i) {
                char c = Character.forDigit(r.nextInt(26) + 10, 36);
                file.write(c);
                ((OutputStream)zout).write(c);
            }
            ((OutputStream)zout).close();
            bak = System.out;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            System.setOut(new PrintStream(out));
            String[] argv = new String[]{"-text", new Path(root, "file.gz").toString()};
            int ret = ToolRunner.run((Tool)new FsShell(conf), (String[])argv);
            TestDFSShell.assertEquals((String)("'-text " + argv[1] + " returned " + ret), (int)0, (int)ret);
            file.reset();
            out.reset();
            TestDFSShell.assertTrue((String)"Output doesn't match input", (boolean)Arrays.equals(file.toByteArray(), out.toByteArray()));
            if (null == bak) return;
        }
        catch (Throwable throwable) {
            if (null == bak) throw throwable;
            System.setOut(bak);
            throw throwable;
        }
        System.setOut(bak);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyToLocal() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        FileSystem fs = cluster.getFileSystem();
        TestDFSShell.assertTrue((String)("Not a HDFS: " + fs.getUri()), (boolean)(fs instanceof DistributedFileSystem));
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        FsShell shell = new FsShell();
        shell.setConf((Configuration)conf);
        try {
            String root = TestDFSShell.createTree((FileSystem)dfs, "copyToLocal");
            try {
                TestDFSShell.assertEquals((int)0, (int)TestDFSShell.runCmd(shell, "-copyToLocal", root + "*", TEST_ROOT_DIR));
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            File localroot = new File(TEST_ROOT_DIR, "copyToLocal");
            File localroot2 = new File(TEST_ROOT_DIR, "copyToLocal2");
            File f1 = new File(localroot, "f1");
            TestDFSShell.assertTrue((String)"Copying failed.", (boolean)f1.isFile());
            File f2 = new File(localroot, "f2");
            TestDFSShell.assertTrue((String)"Copying failed.", (boolean)f2.isFile());
            File sub = new File(localroot, "sub");
            TestDFSShell.assertTrue((String)"Copying failed.", (boolean)sub.isDirectory());
            File f3 = new File(sub, "f3");
            TestDFSShell.assertTrue((String)"Copying failed.", (boolean)f3.isFile());
            File f4 = new File(sub, "f4");
            TestDFSShell.assertTrue((String)"Copying failed.", (boolean)f4.isFile());
            File f5 = new File(localroot2, "f1");
            TestDFSShell.assertTrue((String)"Copying failed.", (boolean)f5.isFile());
            f1.delete();
            f2.delete();
            f3.delete();
            f4.delete();
            f5.delete();
            sub.delete();
            String[] args = new String[]{"-copyToLocal", "nosuchfile", TEST_ROOT_DIR};
            try {
                TestDFSShell.assertEquals((int)1, (int)shell.run(args));
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            File f6 = new File(TEST_ROOT_DIR, "nosuchfile");
            TestDFSShell.assertTrue((!f6.exists() ? 1 : 0) != 0);
        }
        finally {
            try {
                dfs.close();
            }
            catch (Exception e) {}
            cluster.shutdown();
        }
    }

    static String createTree(FileSystem fs, String name) throws IOException {
        String path = "/test/" + name;
        Path root = TestDFSShell.mkdir(fs, new Path(path));
        Path sub = TestDFSShell.mkdir(fs, new Path(root, "sub"));
        Path root2 = TestDFSShell.mkdir(fs, new Path(path + "2"));
        TestDFSShell.writeFile(fs, new Path(root, "f1"));
        TestDFSShell.writeFile(fs, new Path(root, "f2"));
        TestDFSShell.writeFile(fs, new Path(sub, "f3"));
        TestDFSShell.writeFile(fs, new Path(sub, "f4"));
        TestDFSShell.writeFile(fs, new Path(root2, "f1"));
        TestDFSShell.mkdir(fs, new Path(root2, "sub"));
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCount() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        DistributedFileSystem dfs = (DistributedFileSystem)cluster.getFileSystem();
        FsShell shell = new FsShell();
        shell.setConf((Configuration)conf);
        try {
            String root = TestDFSShell.createTree((FileSystem)dfs, "count");
            TestDFSShell.runCount(root, 2L, 4L, shell);
            TestDFSShell.runCount(root + "2", 2L, 1L, shell);
            TestDFSShell.runCount(root + "2/f1", 0L, 1L, shell);
            TestDFSShell.runCount(root + "2/sub", 1L, 0L, shell);
            LocalFileSystem localfs = FileSystem.getLocal((Configuration)conf);
            Path localpath = new Path(TEST_ROOT_DIR, "testcount");
            localpath = localpath.makeQualified(localfs.getUri(), localfs.getWorkingDirectory());
            localfs.mkdirs(localpath);
            String localstr = localpath.toString();
            System.out.println("localstr=" + localstr);
            TestDFSShell.runCount(localstr, 1L, 0L, shell);
            TestDFSShell.assertEquals((int)0, (int)TestDFSShell.runCmd(shell, "-count", root, localstr));
        }
        finally {
            try {
                dfs.close();
            }
            catch (Exception e) {}
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runCount(String path, long dirs, long files, FsShell shell) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        PrintStream oldOut = System.out;
        System.setOut(out);
        Scanner in = null;
        String results = null;
        try {
            TestDFSShell.runCmd(shell, "-count", path);
            results = bytes.toString();
            in = new Scanner(results);
            TestDFSShell.assertEquals((long)dirs, (long)in.nextLong());
            TestDFSShell.assertEquals((long)files, (long)in.nextLong());
        }
        finally {
            if (in != null) {
                in.close();
            }
            IOUtils.closeStream((Closeable)out);
            System.setOut(oldOut);
            System.out.println("results:\n" + results);
        }
    }

    private static int runCmd(FsShell shell, String ... args) throws IOException {
        StringBuilder cmdline = new StringBuilder("RUN:");
        for (String arg : args) {
            cmdline.append(" " + arg);
        }
        LOG.info((Object)cmdline.toString());
        try {
            int exitCode = shell.run(args);
            LOG.info((Object)("RUN: " + args[0] + " exit=" + exitCode));
            return exitCode;
        }
        catch (IOException e) {
            LOG.error((Object)("RUN: " + args[0] + " IOException=" + e.getMessage()));
            throw e;
        }
        catch (RuntimeException e) {
            LOG.error((Object)("RUN: " + args[0] + " RuntimeException=" + e.getMessage()));
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("RUN: " + args[0] + " Exception=" + e.getMessage()));
            throw new IOException(StringUtils.stringifyException((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testChmod(Configuration conf, FileSystem fs, String chmodDir) throws IOException {
        FsShell shell = new FsShell();
        shell.setConf(conf);
        try {
            Path dir = new Path(chmodDir);
            fs.delete(dir, true);
            fs.mkdirs(dir);
            this.confirmPermissionChange("u+rwx,g=rw,o-rwx", "rwxrw----", fs, shell, dir);
            Path file = new Path(chmodDir, "file");
            TestDFSShell.writeFile(fs, file);
            this.confirmPermissionChange("644", "rw-r--r--", fs, shell, file);
            TestDFSShell.runCmd(shell, "-chmod", "-R", "a+rwX", chmodDir);
            TestDFSShell.assertEquals((String)"rwxrwxrwx", (String)fs.getFileStatus(dir).getPermission().toString());
            TestDFSShell.assertEquals((String)"rw-rw-rw-", (String)fs.getFileStatus(file).getPermission().toString());
            Path dir2 = new Path(dir, "stickybit");
            fs.mkdirs(dir2);
            LOG.info((Object)("Testing sticky bit on: " + dir2));
            LOG.info((Object)("Sticky bit directory initial mode: " + fs.getFileStatus(dir2).getPermission()));
            this.confirmPermissionChange("u=rwx,g=rx,o=rx", "rwxr-xr-x", fs, shell, dir2);
            this.confirmPermissionChange("+t", "rwxr-xr-t", fs, shell, dir2);
            this.confirmPermissionChange("-t", "rwxr-xr-x", fs, shell, dir2);
            this.confirmPermissionChange("=t", "--------T", fs, shell, dir2);
            this.confirmPermissionChange("0000", "---------", fs, shell, dir2);
            this.confirmPermissionChange("1666", "rw-rw-rwT", fs, shell, dir2);
            this.confirmPermissionChange("777", "rwxrwxrwt", fs, shell, dir2);
            fs.delete(dir2, true);
            fs.delete(dir, true);
        }
        finally {
            try {
                fs.close();
                shell.close();
            }
            catch (IOException ignored) {}
        }
    }

    private void confirmPermissionChange(String toApply, String expected, FileSystem fs, FsShell shell, Path dir2) throws IOException {
        LOG.info((Object)("Confirming permission change of " + toApply + " to " + expected));
        TestDFSShell.runCmd(shell, "-chmod", toApply, dir2.toString());
        String result = fs.getFileStatus(dir2).getPermission().toString();
        LOG.info((Object)("Permission change result: " + result));
        TestDFSShell.assertEquals((String)expected, (String)result);
    }

    private void confirmOwner(String owner, String group, FileSystem fs, Path ... paths) throws IOException {
        for (Path path : paths) {
            if (owner != null) {
                TestDFSShell.assertEquals((String)owner, (String)fs.getFileStatus(path).getOwner());
            }
            if (group == null) continue;
            TestDFSShell.assertEquals((String)group, (String)fs.getFileStatus(path).getGroup());
        }
    }

    public void testFilePermissions() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        this.testChmod((Configuration)conf, (FileSystem)fs, new File(TEST_ROOT_DIR, "chmodTest").getAbsolutePath());
        conf.set("dfs.permissions.enabled", "true");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        fs = cluster.getFileSystem();
        this.testChmod((Configuration)conf, (FileSystem)fs, "/tmp/chmodTest");
        FsShell shell = new FsShell();
        shell.setConf((Configuration)conf);
        fs = cluster.getFileSystem();
        String file = "/tmp/chownTest";
        Path path = new Path(file);
        Path parent = new Path("/tmp");
        Path root = new Path("/");
        TestDFSShell.writeFile((FileSystem)fs, path);
        TestDFSShell.runCmd(shell, "-chgrp", "-R", "herbivores", "/*", "unknownFile*");
        this.confirmOwner(null, "herbivores", (FileSystem)fs, parent, path);
        TestDFSShell.runCmd(shell, "-chgrp", "mammals", file);
        this.confirmOwner(null, "mammals", (FileSystem)fs, path);
        TestDFSShell.runCmd(shell, "-chown", "-R", ":reptiles", "/");
        this.confirmOwner(null, "reptiles", (FileSystem)fs, root, parent, path);
        TestDFSShell.runCmd(shell, "-chown", "python:", "/nonExistentFile", file);
        this.confirmOwner("python", "reptiles", (FileSystem)fs, path);
        TestDFSShell.runCmd(shell, "-chown", "-R", "hadoop:toys", "unknownFile", "/");
        this.confirmOwner("hadoop", "toys", (FileSystem)fs, root, parent, path);
        TestDFSShell.runCmd(shell, "-chown", "hdfs.user", file);
        this.confirmOwner("hdfs.user", null, (FileSystem)fs, path);
        TestDFSShell.runCmd(shell, "-chown", "_Hdfs.User-10:_hadoop.users--", file);
        this.confirmOwner("_Hdfs.User-10", "_hadoop.users--", (FileSystem)fs, path);
        TestDFSShell.runCmd(shell, "-chown", "hdfs/hadoop-core@apache.org:asf-projects", file);
        this.confirmOwner("hdfs/hadoop-core@apache.org", "asf-projects", (FileSystem)fs, path);
        TestDFSShell.runCmd(shell, "-chgrp", "hadoop-core@apache.org/100", file);
        this.confirmOwner(null, "hadoop-core@apache.org/100", (FileSystem)fs, path);
        cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDFSShell() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        FileSystem fs = cluster.getFileSystem();
        TestDFSShell.assertTrue((String)("Not a HDFS: " + fs.getUri()), (boolean)(fs instanceof DistributedFileSystem));
        DistributedFileSystem fileSys = (DistributedFileSystem)fs;
        FsShell shell = new FsShell();
        shell.setConf((Configuration)conf);
        try {
            Path myPath = new Path("/test/mkdirs");
            TestDFSShell.assertTrue((boolean)fileSys.mkdirs(myPath));
            TestDFSShell.assertTrue((boolean)fileSys.exists(myPath));
            TestDFSShell.assertTrue((boolean)fileSys.mkdirs(myPath));
            Path myFile = new Path("/test/mkdirs/myFile");
            TestDFSShell.writeFile((FileSystem)fileSys, myFile);
            TestDFSShell.assertTrue((boolean)fileSys.exists(myFile));
            Path myFile2 = new Path("/test/mkdirs/myFile2");
            TestDFSShell.writeFile((FileSystem)fileSys, myFile2);
            TestDFSShell.assertTrue((boolean)fileSys.exists(myFile2));
            String[] args = new String[]{"-rm", "/test/mkdirs/myFile*"};
            int val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            TestDFSShell.assertTrue((val == 0 ? 1 : 0) != 0);
            TestDFSShell.assertFalse((boolean)fileSys.exists(myFile));
            TestDFSShell.assertFalse((boolean)fileSys.exists(myFile2));
            TestDFSShell.writeFile((FileSystem)fileSys, myFile);
            TestDFSShell.assertTrue((boolean)fileSys.exists(myFile));
            TestDFSShell.writeFile((FileSystem)fileSys, myFile2);
            TestDFSShell.assertTrue((boolean)fileSys.exists(myFile2));
            args = new String[]{"-cat", "/test/mkdirs/myFile", "/test/mkdirs/myFile2"};
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run: " + StringUtils.stringifyException((Throwable)e));
            }
            TestDFSShell.assertTrue((val == 0 ? 1 : 0) != 0);
            fileSys.delete(myFile2, true);
            args = new String[]{"-cat", "/test/mkdirs/myFile1"};
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            TestDFSShell.assertTrue((val != 0 ? 1 : 0) != 0);
            args = new String[]{"-rm", "/test/mkdirs/myFile1"};
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            TestDFSShell.assertTrue((val != 0 ? 1 : 0) != 0);
            args = new String[]{"-rm", "/test/mkdirs/myFile"};
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            TestDFSShell.assertTrue((val == 0 ? 1 : 0) != 0);
            args = new String[]{"-test", "-e", "/test/mkdirs/noFileHere"};
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            TestDFSShell.assertEquals((int)1, (int)val);
            args[1] = "-z";
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            TestDFSShell.assertEquals((int)1, (int)val);
            args = new String[]{"-touchz", "/test/mkdirs/noFileHere"};
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            TestDFSShell.assertEquals((int)0, (int)val);
            args = new String[]{"-test", "-e", "/test/mkdirs/noFileHere"};
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            TestDFSShell.assertEquals((int)0, (int)val);
            args[1] = "-d";
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            TestDFSShell.assertEquals((int)1, (int)val);
            args[1] = "-z";
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            TestDFSShell.assertEquals((int)0, (int)val);
            args = new String[]{"-mkdir", "/test/dir1"};
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            TestDFSShell.assertEquals((int)0, (int)val);
            String[] args1 = new String[]{"-cp", "/test/dir1", "/test/dir1/dir2"};
            val = 0;
            try {
                val = shell.run(args1);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            TestDFSShell.assertEquals((int)1, (int)val);
            args1[0] = "-cp";
            args1[1] = "/test/dir1";
            args1[2] = "/test/dir1foo";
            val = -1;
            try {
                val = shell.run(args1);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            TestDFSShell.assertEquals((int)0, (int)val);
        }
        finally {
            try {
                fileSys.close();
            }
            catch (Exception e) {}
            cluster.shutdown();
        }
    }

    static List<File> getBlockFiles(MiniDFSCluster cluster) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        ArrayList<DataNode> datanodes = cluster.getDataNodes();
        String poolId = cluster.getNamesystem().getBlockPoolId();
        Iterable<Block>[] blocks = cluster.getAllBlockReports(poolId);
        for (int i = 0; i < blocks.length; ++i) {
            FSDataset ds = (FSDataset)((DataNode)datanodes.get(i)).getFSDataset();
            for (Block b : blocks[i]) {
                files.add(ds.getBlockFile(poolId, b));
            }
        }
        return files;
    }

    static void corrupt(List<File> files) throws IOException {
        for (File f : files) {
            StringBuilder content = new StringBuilder(DFSTestUtil.readFile(f));
            char c = content.charAt(0);
            c = (char)(c + '\u0001');
            content.setCharAt(0, c);
            PrintWriter out = new PrintWriter(f);
            out.print(content);
            out.flush();
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoteException() throws Exception {
        MiniDFSCluster dfs;
        block5: {
            UserGroupInformation tmpUGI = UserGroupInformation.createUserForTesting((String)"tmpname", (String[])new String[]{"mygroup"});
            dfs = null;
            PrintStream bak = null;
            try {
                HdfsConfiguration conf = new HdfsConfiguration();
                dfs = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
                FileSystem fs = dfs.getFileSystem();
                Path p = new Path("/foo");
                fs.mkdirs(p);
                fs.setPermission(p, new FsPermission(448));
                bak = System.err;
                tmpUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>((Configuration)conf){
                    final /* synthetic */ Configuration val$conf;
                    {
                        this.val$conf = configuration;
                    }

                    @Override
                    public Object run() throws Exception {
                        FsShell fshell = new FsShell(this.val$conf);
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        PrintStream tmp = new PrintStream(out);
                        System.setErr(tmp);
                        String[] args = new String[]{"-ls", "/foo"};
                        int ret = ToolRunner.run((Tool)fshell, (String[])args);
                        Assert.assertEquals((String)"returned should be 1", (int)1, (int)ret);
                        String str = out.toString();
                        Assert.assertTrue((String)"permission denied printed", (str.indexOf("Permission denied") != -1 ? 1 : 0) != 0);
                        out.reset();
                        return null;
                    }
                });
                if (bak == null) break block5;
            }
            catch (Throwable throwable) {
                if (bak != null) {
                    System.setErr(bak);
                }
                if (dfs != null) {
                    dfs.shutdown();
                }
                throw throwable;
            }
            System.setErr(bak);
        }
        if (dfs != null) {
            dfs.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGet() throws IOException {
        DFSTestUtil.setLogLevel2All(FSInputChecker.LOG);
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        DistributedFileSystem dfs = (DistributedFileSystem)cluster.getFileSystem();
        try {
            String fname = "testGet.txt";
            File localf = TestDFSShell.createLocalFile(new File(TEST_ROOT_DIR, "testGet.txt"));
            String localfcontent = DFSTestUtil.readFile(localf);
            Path root = TestDFSShell.mkdir((FileSystem)dfs, new Path("/test/get"));
            final Path remotef = new Path(root, "testGet.txt");
            dfs.copyFromLocalFile(false, false, new Path(localf.getPath()), remotef);
            final FsShell shell = new FsShell();
            shell.setConf((Configuration)conf);
            TestGetRunner runner = new TestGetRunner(){
                private int count = 0;

                @Override
                public String run(int exitcode, String ... options) throws IOException {
                    String dst = TEST_ROOT_DIR + "/" + "testGet.txt" + ++this.count;
                    String[] args = new String[options.length + 3];
                    args[0] = "-get";
                    args[args.length - 2] = remotef.toString();
                    args[args.length - 1] = dst;
                    for (int i = 0; i < options.length; ++i) {
                        args[i + 1] = options[i];
                    }
                    TestDFSShell.show("args=" + Arrays.asList(args));
                    try {
                        Assert.assertEquals((int)exitcode, (int)shell.run(args));
                    }
                    catch (Exception e) {
                        Assert.assertTrue((String)StringUtils.stringifyException((Throwable)e), (boolean)false);
                    }
                    return exitcode == 0 ? DFSTestUtil.readFile(new File(dst)) : null;
                }
            };
            TestDFSShell.assertEquals((String)localfcontent, (String)runner.run(0, new String[0]));
            TestDFSShell.assertEquals((String)localfcontent, (String)runner.run(0, "-ignoreCrc"));
            List<File> files = TestDFSShell.getBlockFiles(cluster);
            TestDFSShell.show("files=" + files);
            TestDFSShell.corrupt(files);
            TestDFSShell.assertEquals(null, (String)runner.run(1, new String[0]));
            String corruptedcontent = runner.run(0, "-ignoreCrc");
            TestDFSShell.assertEquals((String)localfcontent.substring(1), (String)corruptedcontent.substring(1));
            TestDFSShell.assertEquals((int)(localfcontent.charAt(0) + '\u0001'), (int)corruptedcontent.charAt(0));
            localf.delete();
        }
        finally {
            try {
                dfs.close();
            }
            catch (Exception e) {}
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLsr() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        DistributedFileSystem dfs = (DistributedFileSystem)cluster.getFileSystem();
        try {
            String root = TestDFSShell.createTree((FileSystem)dfs, "lsr");
            dfs.mkdirs(new Path(root, "zzz"));
            TestDFSShell.runLsr(new FsShell((Configuration)conf), root, 0);
            Path sub = new Path(root, "sub");
            dfs.setPermission(sub, new FsPermission(0));
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            String tmpusername = ugi.getShortUserName() + "1";
            UserGroupInformation tmpUGI = UserGroupInformation.createUserForTesting((String)tmpusername, (String[])new String[]{tmpusername});
            String results = (String)tmpUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>((Configuration)conf, root){
                final /* synthetic */ Configuration val$conf;
                final /* synthetic */ String val$root;
                {
                    this.val$conf = configuration;
                    this.val$root = string;
                }

                @Override
                public String run() throws Exception {
                    return TestDFSShell.runLsr(new FsShell(this.val$conf), this.val$root, 1);
                }
            });
            TestDFSShell.assertTrue((boolean)results.contains("zzz"));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String runLsr(FsShell shell, String root, int returnvalue) throws Exception {
        String results;
        System.out.println("root=" + root + ", returnvalue=" + returnvalue);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        System.setOut(out);
        System.setErr(out);
        try {
            TestDFSShell.assertEquals((int)returnvalue, (int)shell.run(new String[]{"-lsr", root}));
            results = bytes.toString();
        }
        finally {
            IOUtils.closeStream((Closeable)out);
            System.setOut(oldOut);
            System.setErr(oldErr);
        }
        System.out.println("results:\n" + results);
        return results;
    }

    public void testInvalidShell() throws Exception {
        Configuration conf = new Configuration();
        DFSAdmin admin = new DFSAdmin();
        admin.setConf(conf);
        int res = admin.run(new String[]{"-refreshNodes"});
        TestDFSShell.assertEquals((String)"expected to fail -1", (int)res, (int)-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyCommandsWithForceOption() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
        FsShell shell = null;
        FileSystem fs = null;
        File localFile = new File(TEST_ROOT_DIR, "testFileForPut");
        String localfilepath = localFile.getAbsolutePath();
        String testdir = TEST_ROOT_DIR + "/ForceTestDir";
        Path hdfsTestDir = new Path(testdir);
        try {
            fs = cluster.getFileSystem();
            fs.mkdirs(hdfsTestDir);
            localFile.createNewFile();
            TestDFSShell.writeFile(fs, new Path(TEST_ROOT_DIR, "testFileForPut"));
            shell = new FsShell();
            String[] argv = new String[]{"-put", "-f", localfilepath, testdir};
            int res = ToolRunner.run((Tool)shell, (String[])argv);
            int SUCCESS = 0;
            int ERROR = 1;
            TestDFSShell.assertEquals((String)"put -f is not working", (int)SUCCESS, (int)res);
            argv = new String[]{"-put", localfilepath, testdir};
            res = ToolRunner.run((Tool)shell, (String[])argv);
            TestDFSShell.assertEquals((String)"put command itself is able to overwrite the file", (int)ERROR, (int)res);
            argv = new String[]{"-copyFromLocal", "-f", localfilepath, testdir};
            res = ToolRunner.run((Tool)shell, (String[])argv);
            TestDFSShell.assertEquals((String)"copyFromLocal -f is not working", (int)SUCCESS, (int)res);
            argv = new String[]{"-copyFromLocal", localfilepath, testdir};
            res = ToolRunner.run((Tool)shell, (String[])argv);
            TestDFSShell.assertEquals((String)"copyFromLocal command itself is able to overwrite the file", (int)ERROR, (int)res);
            argv = new String[]{"-cp", "-f", localfilepath, testdir};
            res = ToolRunner.run((Tool)shell, (String[])argv);
            TestDFSShell.assertEquals((String)"cp -f is not working", (int)SUCCESS, (int)res);
            argv = new String[]{"-cp", localfilepath, testdir};
            res = ToolRunner.run((Tool)shell, (String[])argv);
            TestDFSShell.assertEquals((String)"cp command itself is able to overwrite the file", (int)ERROR, (int)res);
        }
        finally {
            if (null != shell) {
                shell.close();
            }
            if (localFile.exists()) {
                localFile.delete();
            }
            if (null != fs) {
                fs.delete(hdfsTestDir, true);
                fs.close();
            }
            cluster.shutdown();
        }
    }

    static interface TestGetRunner {
        public String run(int var1, String ... var2) throws IOException;
    }
}

