/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.Assert;
import org.junit.Test;

public class TestDFSClientExcludedNodes {
    @Test
    public void testExcludedNodes() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        FileSystem fs = cluster.getFileSystem();
        Path filePath = new Path("/testExcludedNodes");
        cluster.stopDataNode(AppendTestUtil.nextInt(3));
        FSDataOutputStream out = fs.create(filePath, true, 4096);
        out.write(20);
        try {
            out.close();
        }
        catch (Exception e) {
            Assert.fail((String)("DataNode failure should not result in a block abort: \n" + e.getMessage()));
        }
    }
}

