/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestClientProtocolForPipelineRecovery {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetNewStamp() throws IOException {
        int numDataNodes = 1;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.support.append", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(numDataNodes).build();
        try {
            cluster.waitActive();
            FileSystem fileSys = cluster.getFileSystem();
            NamenodeProtocols namenode = cluster.getNameNodeRpc();
            Path file = new Path("dataprotocol.dat");
            DFSTestUtil.createFile(fileSys, file, 1L, (short)numDataNodes, 0L);
            ExtendedBlock firstBlock = DFSTestUtil.getFirstBlock(fileSys, file);
            try {
                namenode.updateBlockForPipeline(firstBlock, "");
                Assert.fail((String)"Can not get a new GS from a finalized block");
            }
            catch (IOException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("is not under Construction"));
            }
            try {
                long newBlockId = firstBlock.getBlockId() + 1L;
                ExtendedBlock newBlock = new ExtendedBlock(firstBlock.getBlockPoolId(), newBlockId, 0L, firstBlock.getGenerationStamp());
                namenode.updateBlockForPipeline(newBlock, "");
                Assert.fail((String)"Cannot get a new GS from a non-existent block");
            }
            catch (IOException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("does not exist"));
            }
            DFSOutputStream out = null;
            try {
                out = (DFSOutputStream)fileSys.append(file).getWrappedStream();
                out.write(1);
                out.hflush();
                FSDataInputStream in = null;
                try {
                    in = fileSys.open(file);
                    firstBlock = DFSTestUtil.getAllBlocks(in).get(0).getBlock();
                }
                finally {
                    IOUtils.closeStream((Closeable)in);
                }
                DFSClient dfs = ((DistributedFileSystem)fileSys).dfs;
                try {
                    namenode.updateBlockForPipeline(firstBlock, "test" + dfs.clientName);
                    Assert.fail((String)"Cannot get a new GS for a non lease holder");
                }
                catch (LeaseExpiredException e) {
                    Assert.assertTrue((boolean)e.getMessage().startsWith("Lease mismatch"));
                }
                try {
                    namenode.updateBlockForPipeline(firstBlock, null);
                    Assert.fail((String)"Cannot get a new GS for a null lease holder");
                }
                catch (LeaseExpiredException e) {
                    Assert.assertTrue((boolean)e.getMessage().startsWith("Lease mismatch"));
                }
                namenode.updateBlockForPipeline(firstBlock, dfs.clientName);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(out);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)out);
        }
        finally {
            cluster.shutdown();
        }
    }
}

