/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ViewFsBaseTest;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestViewFsHdfs
extends ViewFsBaseTest {
    private static MiniDFSCluster cluster;
    private static Path defaultWorkingDirectory;
    private static HdfsConfiguration CONF;
    private static FileContext fc;

    @BeforeClass
    public static void clusterSetupAtBegining() throws IOException, LoginException, URISyntaxException {
        SupportsBlocks = true;
        CONF.setBoolean("dfs.namenode.delegation.token.always-use", true);
        cluster = new MiniDFSCluster.Builder((Configuration)CONF).numDataNodes(2).build();
        cluster.waitClusterUp();
        fc = FileContext.getFileContext((URI)cluster.getURI(0), (Configuration)CONF);
        defaultWorkingDirectory = fc.makeQualified(new Path("/user/" + UserGroupInformation.getCurrentUser().getShortUserName()));
        fc.mkdir(defaultWorkingDirectory, FileContext.DEFAULT_PERM, true);
    }

    @AfterClass
    public static void ClusterShutdownAtEnd() throws Exception {
        cluster.shutdown();
    }

    @Before
    public void setUp() throws Exception {
        this.fcTarget = fc;
        super.setUp();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testGetDelegationTokens() throws IOException {
        List delTokens = this.fcView.getDelegationTokens(new Path("/"), "sanjay");
        Assert.assertEquals((long)7L, (long)delTokens.size());
    }

    static {
        CONF = new HdfsConfiguration();
    }
}

