/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;

public class TestGlobPaths
extends TestCase {
    private static MiniDFSCluster dfsCluster;
    private static FileSystem fs;
    private static final int NUM_OF_PATHS = 4;
    static final String USER_DIR;
    private Path[] path = new Path[4];

    protected void setUp() throws Exception {
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            dfsCluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            fs = FileSystem.get((Configuration)conf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void tearDown() throws Exception {
        if (dfsCluster != null) {
            dfsCluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPathFilter() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a", USER_DIR + "/a/b"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/*/*", files, new RegexPathFilter("^.*" + Pattern.quote(USER_DIR) + "/a/b"));
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)1);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[1]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPathFilterWithFixedLastComponent() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a", USER_DIR + "/a/b", USER_DIR + "/c", USER_DIR + "/c/b"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/*/b", files, new RegexPathFilter("^.*" + Pattern.quote(USER_DIR) + "/a/b"));
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)1);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[1]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    public void testGlob() throws Exception {
        this.pTestJavaRegexSpecialChars();
        this.pTestCurlyBracket();
        this.pTestLiteral();
        this.pTestAny();
        this.pTestClosure();
        this.pTestSet();
        this.pTestRange();
        this.pTestSetExcl();
        this.pTestCombination();
        this.pTestRelativePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pTestLiteral() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a2c", USER_DIR + "/abc.d"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/abc.d", files);
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)1);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[1]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pTestEscape() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/ab\\[c.d"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/ab\\[c.d", files);
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)1);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pTestAny() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/abc", USER_DIR + "/a2c", USER_DIR + "/a.c", USER_DIR + "/abcd"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/a?c", files);
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)3);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[2]);
            TestGlobPaths.assertEquals((Object)matchedPath[1], (Object)this.path[1]);
            TestGlobPaths.assertEquals((Object)matchedPath[2], (Object)this.path[0]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    private void pTestClosure() throws IOException {
        this.pTestClosure1();
        this.pTestClosure2();
        this.pTestClosure3();
        this.pTestClosure4();
        this.pTestClosure5();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pTestClosure1() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a", USER_DIR + "/abc", USER_DIR + "/abc.p", USER_DIR + "/bacd"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/a*", files);
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)3);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            TestGlobPaths.assertEquals((Object)matchedPath[1], (Object)this.path[1]);
            TestGlobPaths.assertEquals((Object)matchedPath[2], (Object)this.path[2]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pTestClosure2() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a.", USER_DIR + "/a.txt", USER_DIR + "/a.old.java", USER_DIR + "/.java"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/a.*", files);
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)3);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            TestGlobPaths.assertEquals((Object)matchedPath[1], (Object)this.path[2]);
            TestGlobPaths.assertEquals((Object)matchedPath[2], (Object)this.path[1]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pTestClosure3() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a.txt.x", USER_DIR + "/ax", USER_DIR + "/ab37x", USER_DIR + "/bacd"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/a*x", files);
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)3);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            TestGlobPaths.assertEquals((Object)matchedPath[1], (Object)this.path[2]);
            TestGlobPaths.assertEquals((Object)matchedPath[2], (Object)this.path[1]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pTestClosure4() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/dir1/file1", USER_DIR + "/dir2/file2", USER_DIR + "/dir3/file1"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/*/file1", files);
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)2);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            TestGlobPaths.assertEquals((Object)matchedPath[1], (Object)this.path[2]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pTestClosure5() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/dir1/file1", USER_DIR + "/file1"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/*/file1", files);
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)1);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pTestSet() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a.c", USER_DIR + "/a.cpp", USER_DIR + "/a.hlp", USER_DIR + "/a.hxy"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/a.[ch]??", files);
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)3);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[1]);
            TestGlobPaths.assertEquals((Object)matchedPath[1], (Object)this.path[2]);
            TestGlobPaths.assertEquals((Object)matchedPath[2], (Object)this.path[3]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pTestRange() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a.d", USER_DIR + "/a.e", USER_DIR + "/a.f", USER_DIR + "/a.h"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/a.[d-fm]", files);
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)3);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            TestGlobPaths.assertEquals((Object)matchedPath[1], (Object)this.path[1]);
            TestGlobPaths.assertEquals((Object)matchedPath[2], (Object)this.path[2]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pTestSetExcl() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a.d", USER_DIR + "/a.e", USER_DIR + "/a.0", USER_DIR + "/a.h"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/a.[^a-cg-z0-9]", files);
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)2);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            TestGlobPaths.assertEquals((Object)matchedPath[1], (Object)this.path[1]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pTestCombination() throws IOException {
        try {
            String[] files = new String[]{"/user/aa/a.c", "/user/bb/a.cpp", "/user1/cc/b.hlp", "/user/dd/a.hxy"};
            Path[] matchedPath = this.prepareTesting("/use?/*/a.[ch]{lp,xy}", files);
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)1);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[3]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pTestRelativePath() throws IOException {
        try {
            String[] files = new String[]{"a", "abc", "abc.p", "bacd"};
            Path[] matchedPath = this.prepareTesting("a*", files);
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)3);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)new Path(USER_DIR, this.path[0]));
            TestGlobPaths.assertEquals((Object)matchedPath[1], (Object)new Path(USER_DIR, this.path[1]));
            TestGlobPaths.assertEquals((Object)matchedPath[2], (Object)new Path(USER_DIR, this.path[2]));
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pTestCurlyBracket() throws IOException {
        Path[] matchedPath;
        String[] files;
        try {
            files = new String[]{USER_DIR + "/a.abcxx", USER_DIR + "/a.abxy", USER_DIR + "/a.hlp", USER_DIR + "/a.jhyy"};
            matchedPath = this.prepareTesting(USER_DIR + "/a.{abc,jh}??", files);
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)2);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            TestGlobPaths.assertEquals((Object)matchedPath[1], (Object)this.path[3]);
        }
        finally {
            this.cleanupDFS();
        }
        try {
            files = new String[]{USER_DIR + "/a.abcxx", USER_DIR + "/a.abdxy", USER_DIR + "/a.hlp", USER_DIR + "/a.jhyy"};
            matchedPath = this.prepareTesting(USER_DIR + "/a.{ab{c,d},jh}??", files);
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)3);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            TestGlobPaths.assertEquals((Object)matchedPath[1], (Object)this.path[1]);
            TestGlobPaths.assertEquals((Object)matchedPath[2], (Object)this.path[3]);
        }
        finally {
            this.cleanupDFS();
        }
        try {
            files = new String[]{USER_DIR + "/a/b", USER_DIR + "/a/d", USER_DIR + "/c/b", USER_DIR + "/c/d"};
            matchedPath = this.prepareTesting(USER_DIR + "/{a/b,c/d}", files);
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)2);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            TestGlobPaths.assertEquals((Object)matchedPath[1], (Object)this.path[3]);
        }
        finally {
            this.cleanupDFS();
        }
        try {
            files = new String[]{"/a/b", "/a/d", "/c/b", "/c/d"};
            matchedPath = this.prepareTesting("{/a/b,/c/d}", files);
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)2);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            TestGlobPaths.assertEquals((Object)matchedPath[1], (Object)this.path[3]);
        }
        finally {
            this.cleanupDFS();
        }
        try {
            files = new String[]{USER_DIR + "/}bc", USER_DIR + "/}c"};
            matchedPath = this.prepareTesting(USER_DIR + "/}{a,b}c", files);
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)1);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            matchedPath = this.prepareTesting(USER_DIR + "/}{b}c", files);
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)1);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            matchedPath = this.prepareTesting(USER_DIR + "/}{}bc", files);
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)1);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            matchedPath = this.prepareTesting(USER_DIR + "/}{,}bc", files);
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)1);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            matchedPath = this.prepareTesting(USER_DIR + "/}{b,}c", files);
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)2);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            TestGlobPaths.assertEquals((Object)matchedPath[1], (Object)this.path[1]);
            matchedPath = this.prepareTesting(USER_DIR + "/}{,b}c", files);
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)2);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            TestGlobPaths.assertEquals((Object)matchedPath[1], (Object)this.path[1]);
            matchedPath = this.prepareTesting(USER_DIR + "/}{ac,?}", files);
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)1);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[1]);
            boolean hasException = false;
            try {
                this.prepareTesting(USER_DIR + "}{bc", files);
            }
            catch (IOException e) {
                TestGlobPaths.assertTrue((boolean)e.getMessage().startsWith("Illegal file pattern:"));
                hasException = true;
            }
            TestGlobPaths.assertTrue((boolean)hasException);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pTestJavaRegexSpecialChars() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/($.|+)bc", USER_DIR + "/abc"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/($.|+)*", files);
            TestGlobPaths.assertEquals((int)matchedPath.length, (int)1);
            TestGlobPaths.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    private Path[] prepareTesting(String pattern, String[] files) throws IOException {
        for (int i = 0; i < Math.min(4, files.length); ++i) {
            this.path[i] = fs.makeQualified(new Path(files[i]));
            if (fs.mkdirs(this.path[i])) continue;
            throw new IOException("Mkdirs failed to create " + this.path[i].toString());
        }
        Path patternPath = new Path(pattern);
        Path[] globResults = FileUtil.stat2Paths((FileStatus[])fs.globStatus(patternPath), (Path)patternPath);
        for (int i = 0; i < globResults.length; ++i) {
            globResults[i] = globResults[i].makeQualified(fs.getUri(), fs.getWorkingDirectory());
        }
        return globResults;
    }

    private Path[] prepareTesting(String pattern, String[] files, PathFilter filter) throws IOException {
        for (int i = 0; i < Math.min(4, files.length); ++i) {
            this.path[i] = fs.makeQualified(new Path(files[i]));
            if (fs.mkdirs(this.path[i])) continue;
            throw new IOException("Mkdirs failed to create " + this.path[i].toString());
        }
        Path patternPath = new Path(pattern);
        Path[] globResults = FileUtil.stat2Paths((FileStatus[])fs.globStatus(patternPath, filter), (Path)patternPath);
        for (int i = 0; i < globResults.length; ++i) {
            globResults[i] = globResults[i].makeQualified(fs.getUri(), fs.getWorkingDirectory());
        }
        return globResults;
    }

    private void cleanupDFS() throws IOException {
        fs.delete(new Path("/user"), true);
    }

    static {
        USER_DIR = "/user/" + System.getProperty("user.name");
    }

    static class RegexPathFilter
    implements PathFilter {
        private final String regex;

        public RegexPathFilter(String regex) {
            this.regex = regex;
        }

        public boolean accept(Path path) {
            return path.toString().matches(this.regex);
        }
    }
}

