// ThreeCanvas.js - http://github.com/mrdoob/three.js
'use strict';var THREE=THREE||{REVISION:"49"};self.Int32Array||(self.Int32Array=Array,self.Float32Array=Array);
(function(){for(var a=0,b=["ms","moz","webkit","o"],c=0;c<b.length&&!window.requestAnimationFrame;++c){window.requestAnimationFrame=window[b[c]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[b[c]+"CancelAnimationFrame"]||window[b[c]+"CancelRequestAnimationFrame"]}if(!window.requestAnimationFrame)window.requestAnimationFrame=function(b){var c=Date.now(),f=Math.max(0,16-(c-a)),g=window.setTimeout(function(){b(c+f)},f);a=c+f;return g};if(!window.cancelAnimationFrame)window.cancelAnimationFrame=
function(a){clearTimeout(a)}})();THREE.Color=function(a){a!==void 0&&this.setHex(a);return this};
THREE.Color.prototype={constructor:THREE.Color,r:1,g:1,b:1,copy:function(a){this.r=a.r;this.g=a.g;this.b=a.b;return this},copyGammaToLinear:function(a){this.r=a.r*a.r;this.g=a.g*a.g;this.b=a.b*a.b;return this},copyLinearToGamma:function(a){this.r=Math.sqrt(a.r);this.g=Math.sqrt(a.g);this.b=Math.sqrt(a.b);return this},convertGammaToLinear:function(){var a=this.r,b=this.g,c=this.b;this.r=a*a;this.g=b*b;this.b=c*c;return this},convertLinearToGamma:function(){this.r=Math.sqrt(this.r);this.g=Math.sqrt(this.g);
this.b=Math.sqrt(this.b);return this},setRGB:function(a,b,c){this.r=a;this.g=b;this.b=c;return this},setHSV:function(a,b,c){var d,e,f;if(c===0)this.r=this.g=this.b=0;else{d=Math.floor(a*6);e=a*6-d;a=c*(1-b);f=c*(1-b*e);b=c*(1-b*(1-e));switch(d){case 1:this.r=f;this.g=c;this.b=a;break;case 2:this.r=a;this.g=c;this.b=b;break;case 3:this.r=a;this.g=f;this.b=c;break;case 4:this.r=b;this.g=a;this.b=c;break;case 5:this.r=c;this.g=a;this.b=f;break;case 6:case 0:this.r=c;this.g=b;this.b=a}}return this},setHex:function(a){a=
Math.floor(a);this.r=(a>>16&255)/255;this.g=(a>>8&255)/255;this.b=(a&255)/255;return this},lerpSelf:function(a,b){this.r=this.r+(a.r-this.r)*b;this.g=this.g+(a.g-this.g)*b;this.b=this.b+(a.b-this.b)*b;return this},getHex:function(){return Math.floor(this.r*255)<<16^Math.floor(this.g*255)<<8^Math.floor(this.b*255)},getContextStyle:function(){return"rgb("+Math.floor(this.r*255)+","+Math.floor(this.g*255)+","+Math.floor(this.b*255)+")"},clone:function(){return(new THREE.Color).setRGB(this.r,this.g,this.b)}};
THREE.Vector2=function(a,b){this.x=a||0;this.y=b||0};
THREE.Vector2.prototype={constructor:THREE.Vector2,set:function(a,b){this.x=a;this.y=b;return this},copy:function(a){this.x=a.x;this.y=a.y;return this},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;return this},addSelf:function(a){this.x=this.x+a.x;this.y=this.y+a.y;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;return this},subSelf:function(a){this.x=this.x-a.x;this.y=this.y-a.y;return this},multiplyScalar:function(a){this.x=this.x*a;this.y=this.y*a;return this},divideScalar:function(a){if(a){this.x=
this.x/a;this.y=this.y/a}else this.set(0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var b=this.x-a.x,a=this.y-a.y;return b*b+a*a},setLength:function(a){return this.normalize().multiplyScalar(a)},
lerpSelf:function(a,b){this.x=this.x+(a.x-this.x)*b;this.y=this.y+(a.y-this.y)*b;return this},equals:function(a){return a.x===this.x&&a.y===this.y},isZero:function(){return this.lengthSq()<1.0E-4},clone:function(){return new THREE.Vector2(this.x,this.y)}};THREE.Vector3=function(a,b,c){this.x=a||0;this.y=b||0;this.z=c||0};
THREE.Vector3.prototype={constructor:THREE.Vector3,set:function(a,b,c){this.x=a;this.y=b;this.z=c;return this},setX:function(a){this.x=a;return this},setY:function(a){this.y=a;return this},setZ:function(a){this.z=a;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;return this},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;return this},addSelf:function(a){this.x=this.x+a.x;this.y=this.y+a.y;this.z=this.z+a.z;return this},addScalar:function(a){this.x=this.x+a;this.y=this.y+
a;this.z=this.z+a;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;return this},subSelf:function(a){this.x=this.x-a.x;this.y=this.y-a.y;this.z=this.z-a.z;return this},multiply:function(a,b){this.x=a.x*b.x;this.y=a.y*b.y;this.z=a.z*b.z;return this},multiplySelf:function(a){this.x=this.x*a.x;this.y=this.y*a.y;this.z=this.z*a.z;return this},multiplyScalar:function(a){this.x=this.x*a;this.y=this.y*a;this.z=this.z*a;return this},divideSelf:function(a){this.x=this.x/a.x;this.y=
this.y/a.y;this.z=this.z/a.z;return this},divideScalar:function(a){if(a){this.x=this.x/a;this.y=this.y/a;this.z=this.z/a}else this.z=this.y=this.x=0;return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.lengthSq())},lengthManhattan:function(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)},normalize:function(){return this.divideScalar(this.length())},
setLength:function(a){return this.normalize().multiplyScalar(a)},lerpSelf:function(a,b){this.x=this.x+(a.x-this.x)*b;this.y=this.y+(a.y-this.y)*b;this.z=this.z+(a.z-this.z)*b;return this},cross:function(a,b){this.x=a.y*b.z-a.z*b.y;this.y=a.z*b.x-a.x*b.z;this.z=a.x*b.y-a.y*b.x;return this},crossSelf:function(a){var b=this.x,c=this.y,d=this.z;this.x=c*a.z-d*a.y;this.y=d*a.x-b*a.z;this.z=b*a.y-c*a.x;return this},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){return(new THREE.Vector3).sub(this,
a).lengthSq()},getPositionFromMatrix:function(a){this.x=a.elements[12];this.y=a.elements[13];this.z=a.elements[14];return this},getRotationFromMatrix:function(a,b){var c=b?b.x:1,d=b?b.y:1,e=b?b.z:1,f=a.elements[0]/c,g=a.elements[4]/d,c=a.elements[1]/c,d=a.elements[5]/d,k=a.elements[9]/e,m=a.elements[10]/e;this.y=Math.asin(a.elements[8]/e);e=Math.cos(this.y);if(Math.abs(e)>1.0E-5){this.x=Math.atan2(-k/e,m/e);this.z=Math.atan2(-g/e,f/e)}else{this.x=0;this.z=Math.atan2(c,d)}return this},getScaleFromMatrix:function(a){var b=
this.set(a.elements[0],a.elements[1],a.elements[2]).length(),c=this.set(a.elements[4],a.elements[5],a.elements[6]).length(),a=this.set(a.elements[8],a.elements[9],a.elements[10]).length();this.x=b;this.y=c;this.z=a},equals:function(a){return a.x===this.x&&a.y===this.y&&a.z===this.z},isZero:function(){return this.lengthSq()<1.0E-4},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)}};THREE.Vector4=function(a,b,c,d){this.x=a||0;this.y=b||0;this.z=c||0;this.w=d!==void 0?d:1};
THREE.Vector4.prototype={constructor:THREE.Vector4,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w!==void 0?a.w:1;return this},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;this.w=a.w+b.w;return this},addSelf:function(a){this.x=this.x+a.x;this.y=this.y+a.y;this.z=this.z+a.z;this.w=this.w+a.w;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;this.w=a.w-b.w;return this},subSelf:function(a){this.x=
this.x-a.x;this.y=this.y-a.y;this.z=this.z-a.z;this.w=this.w-a.w;return this},multiplyScalar:function(a){this.x=this.x*a;this.y=this.y*a;this.z=this.z*a;this.w=this.w*a;return this},divideScalar:function(a){if(a){this.x=this.x/a;this.y=this.y/a;this.z=this.z/a;this.w=this.w/a}else{this.z=this.y=this.x=0;this.w=1}return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z+this.w*a.w},lengthSq:function(){return this.dot(this)},length:function(){return Math.sqrt(this.lengthSq())},
normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},lerpSelf:function(a,b){this.x=this.x+(a.x-this.x)*b;this.y=this.y+(a.y-this.y)*b;this.z=this.z+(a.z-this.z)*b;this.w=this.w+(a.w-this.w)*b;return this},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)}};THREE.Frustum=function(){this.planes=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4]};
THREE.Frustum.prototype.setFromMatrix=function(a){var b,c=this.planes,d=a.elements,a=d[0];b=d[1];var e=d[2],f=d[3],g=d[4],k=d[5],m=d[6],i=d[7],h=d[8],j=d[9],o=d[10],n=d[11],p=d[12],l=d[13],q=d[14],d=d[15];c[0].set(f-a,i-g,n-h,d-p);c[1].set(f+a,i+g,n+h,d+p);c[2].set(f+b,i+k,n+j,d+l);c[3].set(f-b,i-k,n-j,d-l);c[4].set(f-e,i-m,n-o,d-q);c[5].set(f+e,i+m,n+o,d+q);for(a=0;a<6;a++){b=c[a];b.divideScalar(Math.sqrt(b.x*b.x+b.y*b.y+b.z*b.z))}};
THREE.Frustum.prototype.contains=function(a){for(var b=this.planes,c=a.matrixWorld,d=c.elements,c=-a.geometry.boundingSphere.radius*c.getMaxScaleOnAxis(),e=0;e<6;e++){a=b[e].x*d[12]+b[e].y*d[13]+b[e].z*d[14]+b[e].w;if(a<=c)return false}return true};THREE.Frustum.__v1=new THREE.Vector3;
THREE.Ray=function(a,b){function c(a,b,c){p.sub(c,a);u=p.dot(b);s=l.add(a,q.copy(b).multiplyScalar(u));return z=c.distanceTo(s)}function d(a,b,c,d){p.sub(d,b);l.sub(c,b);q.sub(a,b);A=p.dot(p);v=p.dot(l);D=p.dot(q);x=l.dot(l);G=l.dot(q);t=1/(A*x-v*v);y=(x*D-v*G)*t;C=(A*G-v*D)*t;return y>=0&&C>=0&&y+C<1}this.origin=a||new THREE.Vector3;this.direction=b||new THREE.Vector3;var e=1.0E-4;this.setPrecision=function(a){e=a};var f=new THREE.Vector3,g=new THREE.Vector3,k=new THREE.Vector3,m=new THREE.Vector3,
i=new THREE.Vector3,h=new THREE.Vector3,j=new THREE.Vector3,o=new THREE.Vector3,n=new THREE.Vector3;this.intersectObject=function(a){var b,l=[];if(a instanceof THREE.Particle){var r=c(this.origin,this.direction,a.matrixWorld.getPosition());if(r>a.scale.x)return[];b={distance:r,point:a.position,face:null,object:a};l.push(b)}else if(a instanceof THREE.Mesh){var r=c(this.origin,this.direction,a.matrixWorld.getPosition()),p=THREE.Frustum.__v1.set(a.matrixWorld.getColumnX().length(),a.matrixWorld.getColumnY().length(),
a.matrixWorld.getColumnZ().length());if(r>a.geometry.boundingSphere.radius*Math.max(p.x,Math.max(p.y,p.z)))return l;var q,s,t=a.geometry,u=t.vertices,w;a.matrixRotationWorld.extractRotation(a.matrixWorld);r=0;for(p=t.faces.length;r<p;r++){b=t.faces[r];i.copy(this.origin);h.copy(this.direction);w=a.matrixWorld;j=w.multiplyVector3(j.copy(b.centroid)).subSelf(i);o=a.matrixRotationWorld.multiplyVector3(o.copy(b.normal));q=h.dot(o);if(!(Math.abs(q)<e)){s=o.dot(j)/q;if(!(s<0)&&(a.doubleSided||(a.flipSided?
q>0:q<0))){n.add(i,h.multiplyScalar(s));if(b instanceof THREE.Face3){f=w.multiplyVector3(f.copy(u[b.a]));g=w.multiplyVector3(g.copy(u[b.b]));k=w.multiplyVector3(k.copy(u[b.c]));if(d(n,f,g,k)){b={distance:i.distanceTo(n),point:n.clone(),face:b,object:a};l.push(b)}}else if(b instanceof THREE.Face4){f=w.multiplyVector3(f.copy(u[b.a]));g=w.multiplyVector3(g.copy(u[b.b]));k=w.multiplyVector3(k.copy(u[b.c]));m=w.multiplyVector3(m.copy(u[b.d]));if(d(n,f,g,m)||d(n,g,k,m)){b={distance:i.distanceTo(n),point:n.clone(),
face:b,object:a};l.push(b)}}}}}}return l};this.intersectObjects=function(a){for(var b=[],c=0,d=a.length;c<d;c++)Array.prototype.push.apply(b,this.intersectObject(a[c]));b.sort(function(a,b){return a.distance-b.distance});return b};var p=new THREE.Vector3,l=new THREE.Vector3,q=new THREE.Vector3,u,s,z,A,v,D,x,G,t,y,C};
THREE.Rectangle=function(){function a(){f=d-b;g=e-c}var b,c,d,e,f,g,k=true;this.getX=function(){return b};this.getY=function(){return c};this.getWidth=function(){return f};this.getHeight=function(){return g};this.getLeft=function(){return b};this.getTop=function(){return c};this.getRight=function(){return d};this.getBottom=function(){return e};this.set=function(f,g,h,j){k=false;b=f;c=g;d=h;e=j;a()};this.addPoint=function(f,g){if(k){k=false;b=f;c=g;d=f;e=g}else{b=b<f?b:f;c=c<g?c:g;d=d>f?d:f;e=e>g?
e:g}a()};this.add3Points=function(f,g,h,j,o,n){if(k){k=false;b=f<h?f<o?f:o:h<o?h:o;c=g<j?g<n?g:n:j<n?j:n;d=f>h?f>o?f:o:h>o?h:o;e=g>j?g>n?g:n:j>n?j:n}else{b=f<h?f<o?f<b?f:b:o<b?o:b:h<o?h<b?h:b:o<b?o:b;c=g<j?g<n?g<c?g:c:n<c?n:c:j<n?j<c?j:c:n<c?n:c;d=f>h?f>o?f>d?f:d:o>d?o:d:h>o?h>d?h:d:o>d?o:d;e=g>j?g>n?g>e?g:e:n>e?n:e:j>n?j>e?j:e:n>e?n:e}a()};this.addRectangle=function(f){if(k){k=false;b=f.getLeft();c=f.getTop();d=f.getRight();e=f.getBottom()}else{b=b<f.getLeft()?b:f.getLeft();c=c<f.getTop()?c:f.getTop();
d=d>f.getRight()?d:f.getRight();e=e>f.getBottom()?e:f.getBottom()}a()};this.inflate=function(f){b=b-f;c=c-f;d=d+f;e=e+f;a()};this.minSelf=function(f){b=b>f.getLeft()?b:f.getLeft();c=c>f.getTop()?c:f.getTop();d=d<f.getRight()?d:f.getRight();e=e<f.getBottom()?e:f.getBottom();a()};this.intersects=function(a){return d<a.getLeft()||b>a.getRight()||e<a.getTop()||c>a.getBottom()?false:true};this.empty=function(){k=true;e=d=c=b=0;a()};this.isEmpty=function(){return k}};
THREE.Math={clamp:function(a,b,c){return a<b?b:a>c?c:a},clampBottom:function(a,b){return a<b?b:a},mapLinear:function(a,b,c,d,e){return d+(a-b)*(e-d)/(c-b)},random16:function(){return(65280*Math.random()+255*Math.random())/65535},randInt:function(a,b){return a+Math.floor(Math.random()*(b-a+1))},randFloat:function(a,b){return a+Math.random()*(b-a)},randFloatSpread:function(a){return a*(0.5-Math.random())},sign:function(a){return a<0?-1:a>0?1:0}};THREE.Matrix3=function(){this.elements=new Float32Array(9)};
THREE.Matrix3.prototype={constructor:THREE.Matrix3,getInverse:function(a){var b=a.elements,a=b[10]*b[5]-b[6]*b[9],c=-b[10]*b[1]+b[2]*b[9],d=b[6]*b[1]-b[2]*b[5],e=-b[10]*b[4]+b[6]*b[8],f=b[10]*b[0]-b[2]*b[8],g=-b[6]*b[0]+b[2]*b[4],k=b[9]*b[4]-b[5]*b[8],m=-b[9]*b[0]+b[1]*b[8],i=b[5]*b[0]-b[1]*b[4],b=b[0]*a+b[1]*e+b[2]*k;b===0&&console.warn("Matrix3.getInverse(): determinant == 0");var b=1/b,h=this.elements;h[0]=b*a;h[1]=b*c;h[2]=b*d;h[3]=b*e;h[4]=b*f;h[5]=b*g;h[6]=b*k;h[7]=b*m;h[8]=b*i;return this},
transpose:function(){var a,b=this.elements;a=b[1];b[1]=b[3];b[3]=a;a=b[2];b[2]=b[6];b[6]=a;a=b[5];b[5]=b[7];b[7]=a;return this},transposeIntoArray:function(a){var b=this.m;a[0]=b[0];a[1]=b[3];a[2]=b[6];a[3]=b[1];a[4]=b[4];a[5]=b[7];a[6]=b[2];a[7]=b[5];a[8]=b[8];return this}};THREE.Matrix4=function(a,b,c,d,e,f,g,k,m,i,h,j,o,n,p,l){this.elements=new Float32Array(16);this.set(a!==void 0?a:1,b||0,c||0,d||0,e||0,f!==void 0?f:1,g||0,k||0,m||0,i||0,h!==void 0?h:1,j||0,o||0,n||0,p||0,l!==void 0?l:1)};
THREE.Matrix4.prototype={constructor:THREE.Matrix4,set:function(a,b,c,d,e,f,g,k,m,i,h,j,o,n,p,l){var q=this.elements;q[0]=a;q[4]=b;q[8]=c;q[12]=d;q[1]=e;q[5]=f;q[9]=g;q[13]=k;q[2]=m;q[6]=i;q[10]=h;q[14]=j;q[3]=o;q[7]=n;q[11]=p;q[15]=l;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(a){a=a.elements;this.set(a[0],a[4],a[8],a[12],a[1],a[5],a[9],a[13],a[2],a[6],a[10],a[14],a[3],a[7],a[11],a[15]);return this},lookAt:function(a,b,c){var d=this.elements,
e=THREE.Matrix4.__v1,f=THREE.Matrix4.__v2,g=THREE.Matrix4.__v3;g.sub(a,b).normalize();if(g.length()===0)g.z=1;e.cross(c,g).normalize();if(e.length()===0){g.x=g.x+1.0E-4;e.cross(c,g).normalize()}f.cross(g,e);d[0]=e.x;d[4]=f.x;d[8]=g.x;d[1]=e.y;d[5]=f.y;d[9]=g.y;d[2]=e.z;d[6]=f.z;d[10]=g.z;return this},multiply:function(a,b){var c=a.elements,d=b.elements,e=this.elements,f=c[0],g=c[4],k=c[8],m=c[12],i=c[1],h=c[5],j=c[9],o=c[13],n=c[2],p=c[6],l=c[10],q=c[14],u=c[3],s=c[7],z=c[11],c=c[15],A=d[0],v=d[4],
D=d[8],x=d[12],G=d[1],t=d[5],y=d[9],C=d[13],L=d[2],Q=d[6],N=d[10],r=d[14],E=d[3],F=d[7],H=d[11],d=d[15];e[0]=f*A+g*G+k*L+m*E;e[4]=f*v+g*t+k*Q+m*F;e[8]=f*D+g*y+k*N+m*H;e[12]=f*x+g*C+k*r+m*d;e[1]=i*A+h*G+j*L+o*E;e[5]=i*v+h*t+j*Q+o*F;e[9]=i*D+h*y+j*N+o*H;e[13]=i*x+h*C+j*r+o*d;e[2]=n*A+p*G+l*L+q*E;e[6]=n*v+p*t+l*Q+q*F;e[10]=n*D+p*y+l*N+q*H;e[14]=n*x+p*C+l*r+q*d;e[3]=u*A+s*G+z*L+c*E;e[7]=u*v+s*t+z*Q+c*F;e[11]=u*D+s*y+z*N+c*H;e[15]=u*x+s*C+z*r+c*d;return this},multiplySelf:function(a){return this.multiply(this,
a)},multiplyToArray:function(a,b,c){var d=this.elements;this.multiply(a,b);c[0]=d[0];c[1]=d[1];c[2]=d[2];c[3]=d[3];c[4]=d[4];c[5]=d[5];c[6]=d[6];c[7]=d[7];c[8]=d[8];c[9]=d[9];c[10]=d[10];c[11]=d[11];c[12]=d[12];c[13]=d[13];c[14]=d[14];c[15]=d[15];return this},multiplyScalar:function(a){var b=this.elements;b[0]=b[0]*a;b[4]=b[4]*a;b[8]=b[8]*a;b[12]=b[12]*a;b[1]=b[1]*a;b[5]=b[5]*a;b[9]=b[9]*a;b[13]=b[13]*a;b[2]=b[2]*a;b[6]=b[6]*a;b[10]=b[10]*a;b[14]=b[14]*a;b[3]=b[3]*a;b[7]=b[7]*a;b[11]=b[11]*a;b[15]=
b[15]*a;return this},multiplyVector3:function(a){var b=this.elements,c=a.x,d=a.y,e=a.z,f=1/(b[3]*c+b[7]*d+b[11]*e+b[15]);a.x=(b[0]*c+b[4]*d+b[8]*e+b[12])*f;a.y=(b[1]*c+b[5]*d+b[9]*e+b[13])*f;a.z=(b[2]*c+b[6]*d+b[10]*e+b[14])*f;return a},multiplyVector4:function(a){var b=this.elements,c=a.x,d=a.y,e=a.z,f=a.w;a.x=b[0]*c+b[4]*d+b[8]*e+b[12]*f;a.y=b[1]*c+b[5]*d+b[9]*e+b[13]*f;a.z=b[2]*c+b[6]*d+b[10]*e+b[14]*f;a.w=b[3]*c+b[7]*d+b[11]*e+b[15]*f;return a},rotateAxis:function(a){var b=this.elements,c=a.x,
d=a.y,e=a.z;a.x=c*b[0]+d*b[4]+e*b[8];a.y=c*b[1]+d*b[5]+e*b[9];a.z=c*b[2]+d*b[6]+e*b[10];a.normalize();return a},crossVector:function(a){var b=this.elements,c=new THREE.Vector4;c.x=b[0]*a.x+b[4]*a.y+b[8]*a.z+b[12]*a.w;c.y=b[1]*a.x+b[5]*a.y+b[9]*a.z+b[13]*a.w;c.z=b[2]*a.x+b[6]*a.y+b[10]*a.z+b[14]*a.w;c.w=a.w?b[3]*a.x+b[7]*a.y+b[11]*a.z+b[15]*a.w:1;return c},determinant:function(){var a=this.elements,b=a[0],c=a[4],d=a[8],e=a[12],f=a[1],g=a[5],k=a[9],m=a[13],i=a[2],h=a[6],j=a[10],o=a[14],n=a[3],p=a[7],
l=a[11],a=a[15];return e*k*h*n-d*m*h*n-e*g*j*n+c*m*j*n+d*g*o*n-c*k*o*n-e*k*i*p+d*m*i*p+e*f*j*p-b*m*j*p-d*f*o*p+b*k*o*p+e*g*i*l-c*m*i*l-e*f*h*l+b*m*h*l+c*f*o*l-b*g*o*l-d*g*i*a+c*k*i*a+d*f*h*a-b*k*h*a-c*f*j*a+b*g*j*a},transpose:function(){var a=this.elements,b;b=a[1];a[1]=a[4];a[4]=b;b=a[2];a[2]=a[8];a[8]=b;b=a[6];a[6]=a[9];a[9]=b;b=a[3];a[3]=a[12];a[12]=b;b=a[7];a[7]=a[13];a[13]=b;b=a[11];a[11]=a[14];a[14]=b;return this},flattenToArray:function(a){var b=this.elements;a[0]=b[0];a[1]=b[1];a[2]=b[2];
a[3]=b[3];a[4]=b[4];a[5]=b[5];a[6]=b[6];a[7]=b[7];a[8]=b[8];a[9]=b[9];a[10]=b[10];a[11]=b[11];a[12]=b[12];a[13]=b[13];a[14]=b[14];a[15]=b[15];return a},flattenToArrayOffset:function(a,b){var c=this.elements;a[b]=c[0];a[b+1]=c[1];a[b+2]=c[2];a[b+3]=c[3];a[b+4]=c[4];a[b+5]=c[5];a[b+6]=c[6];a[b+7]=c[7];a[b+8]=c[8];a[b+9]=c[9];a[b+10]=c[10];a[b+11]=c[11];a[b+12]=c[12];a[b+13]=c[13];a[b+14]=c[14];a[b+15]=c[15];return a},getPosition:function(){var a=this.elements;return THREE.Matrix4.__v1.set(a[12],a[13],
a[14])},setPosition:function(a){var b=this.elements;b[12]=a.x;b[13]=a.y;b[14]=a.z;return this},getColumnX:function(){var a=this.elements;return THREE.Matrix4.__v1.set(a[0],a[1],a[2])},getColumnY:function(){var a=this.elements;return THREE.Matrix4.__v1.set(a[4],a[5],a[6])},getColumnZ:function(){var a=this.elements;return THREE.Matrix4.__v1.set(a[8],a[9],a[10])},getInverse:function(a){var b=this.elements,c=a.elements,d=c[0],e=c[4],f=c[8],g=c[12],k=c[1],m=c[5],i=c[9],h=c[13],j=c[2],o=c[6],n=c[10],p=
c[14],l=c[3],q=c[7],u=c[11],c=c[15];b[0]=i*p*q-h*n*q+h*o*u-m*p*u-i*o*c+m*n*c;b[4]=g*n*q-f*p*q-g*o*u+e*p*u+f*o*c-e*n*c;b[8]=f*h*q-g*i*q+g*m*u-e*h*u-f*m*c+e*i*c;b[12]=g*i*o-f*h*o-g*m*n+e*h*n+f*m*p-e*i*p;b[1]=h*n*l-i*p*l-h*j*u+k*p*u+i*j*c-k*n*c;b[5]=f*p*l-g*n*l+g*j*u-d*p*u-f*j*c+d*n*c;b[9]=g*i*l-f*h*l-g*k*u+d*h*u+f*k*c-d*i*c;b[13]=f*h*j-g*i*j+g*k*n-d*h*n-f*k*p+d*i*p;b[2]=m*p*l-h*o*l+h*j*q-k*p*q-m*j*c+k*o*c;b[6]=g*o*l-e*p*l-g*j*q+d*p*q+e*j*c-d*o*c;b[10]=e*h*l-g*m*l+g*k*q-d*h*q-e*k*c+d*m*c;b[14]=g*m*j-
e*h*j-g*k*o+d*h*o+e*k*p-d*m*p;b[3]=i*o*l-m*n*l-i*j*q+k*n*q+m*j*u-k*o*u;b[7]=e*n*l-f*o*l+f*j*q-d*n*q-e*j*u+d*o*u;b[11]=f*m*l-e*i*l-f*k*q+d*i*q+e*k*u-d*m*u;b[15]=e*i*j-f*m*j+f*k*o-d*i*o-e*k*n+d*m*n;this.multiplyScalar(1/a.determinant());return this},setRotationFromEuler:function(a,b){var c=this.elements,d=a.x,e=a.y,f=a.z,g=Math.cos(d),d=Math.sin(d),k=Math.cos(e),e=Math.sin(e),m=Math.cos(f),f=Math.sin(f);switch(b){case "YXZ":var i=k*m,h=k*f,j=e*m,o=e*f;c[0]=i+o*d;c[4]=j*d-h;c[8]=g*e;c[1]=g*f;c[5]=g*
m;c[9]=-d;c[2]=h*d-j;c[6]=o+i*d;c[10]=g*k;break;case "ZXY":i=k*m;h=k*f;j=e*m;o=e*f;c[0]=i-o*d;c[4]=-g*f;c[8]=j+h*d;c[1]=h+j*d;c[5]=g*m;c[9]=o-i*d;c[2]=-g*e;c[6]=d;c[10]=g*k;break;case "ZYX":i=g*m;h=g*f;j=d*m;o=d*f;c[0]=k*m;c[4]=j*e-h;c[8]=i*e+o;c[1]=k*f;c[5]=o*e+i;c[9]=h*e-j;c[2]=-e;c[6]=d*k;c[10]=g*k;break;case "YZX":i=g*k;h=g*e;j=d*k;o=d*e;c[0]=k*m;c[4]=o-i*f;c[8]=j*f+h;c[1]=f;c[5]=g*m;c[9]=-d*m;c[2]=-e*m;c[6]=h*f+j;c[10]=i-o*f;break;case "XZY":i=g*k;h=g*e;j=d*k;o=d*e;c[0]=k*m;c[4]=-f;c[8]=e*m;
c[1]=i*f+o;c[5]=g*m;c[9]=h*f-j;c[2]=j*f-h;c[6]=d*m;c[10]=o*f+i;break;default:i=g*m;h=g*f;j=d*m;o=d*f;c[0]=k*m;c[4]=-k*f;c[8]=e;c[1]=h+j*e;c[5]=i-o*e;c[9]=-d*k;c[2]=o-i*e;c[6]=j+h*e;c[10]=g*k}return this},setRotationFromQuaternion:function(a){var b=this.elements,c=a.x,d=a.y,e=a.z,f=a.w,g=c+c,k=d+d,m=e+e,a=c*g,i=c*k,c=c*m,h=d*k,d=d*m,e=e*m,g=f*g,k=f*k,f=f*m;b[0]=1-(h+e);b[4]=i-f;b[8]=c+k;b[1]=i+f;b[5]=1-(a+e);b[9]=d-g;b[2]=c-k;b[6]=d+g;b[10]=1-(a+h);return this},compose:function(a,b,c){var d=this.elements,
e=THREE.Matrix4.__m1,f=THREE.Matrix4.__m2;e.identity();e.setRotationFromQuaternion(b);f.makeScale(c.x,c.y,c.z);this.multiply(e,f);d[12]=a.x;d[13]=a.y;d[14]=a.z;return this},decompose:function(a,b,c){var d=this.elements,e=THREE.Matrix4.__v1,f=THREE.Matrix4.__v2,g=THREE.Matrix4.__v3;e.set(d[0],d[1],d[2]);f.set(d[4],d[5],d[6]);g.set(d[8],d[9],d[10]);a=a instanceof THREE.Vector3?a:new THREE.Vector3;b=b instanceof THREE.Quaternion?b:new THREE.Quaternion;c=c instanceof THREE.Vector3?c:new THREE.Vector3;
c.x=e.length();c.y=f.length();c.z=g.length();a.x=d[12];a.y=d[13];a.z=d[14];d=THREE.Matrix4.__m1;d.copy(this);d.elements[0]=d.elements[0]/c.x;d.elements[1]=d.elements[1]/c.x;d.elements[2]=d.elements[2]/c.x;d.elements[4]=d.elements[4]/c.y;d.elements[5]=d.elements[5]/c.y;d.elements[6]=d.elements[6]/c.y;d.elements[8]=d.elements[8]/c.z;d.elements[9]=d.elements[9]/c.z;d.elements[10]=d.elements[10]/c.z;b.setFromRotationMatrix(d);return[a,b,c]},extractPosition:function(a){var b=this.elements,a=a.elements;
b[12]=a[12];b[13]=a[13];b[14]=a[14];return this},extractRotation:function(a){var b=this.elements,a=a.elements,c=THREE.Matrix4.__v1,d=1/c.set(a[0],a[1],a[2]).length(),e=1/c.set(a[4],a[5],a[6]).length(),c=1/c.set(a[8],a[9],a[10]).length();b[0]=a[0]*d;b[1]=a[1]*d;b[2]=a[2]*d;b[4]=a[4]*e;b[5]=a[5]*e;b[6]=a[6]*e;b[8]=a[8]*c;b[9]=a[9]*c;b[10]=a[10]*c;return this},translate:function(a){var b=this.elements,c=a.x,d=a.y,a=a.z;b[12]=b[0]*c+b[4]*d+b[8]*a+b[12];b[13]=b[1]*c+b[5]*d+b[9]*a+b[13];b[14]=b[2]*c+b[6]*
d+b[10]*a+b[14];b[15]=b[3]*c+b[7]*d+b[11]*a+b[15];return this},rotateX:function(a){var b=this.elements,c=b[4],d=b[5],e=b[6],f=b[7],g=b[8],k=b[9],m=b[10],i=b[11],h=Math.cos(a),a=Math.sin(a);b[4]=h*c+a*g;b[5]=h*d+a*k;b[6]=h*e+a*m;b[7]=h*f+a*i;b[8]=h*g-a*c;b[9]=h*k-a*d;b[10]=h*m-a*e;b[11]=h*i-a*f;return this},rotateY:function(a){var b=this.elements,c=b[0],d=b[1],e=b[2],f=b[3],g=b[8],k=b[9],m=b[10],i=b[11],h=Math.cos(a),a=Math.sin(a);b[0]=h*c-a*g;b[1]=h*d-a*k;b[2]=h*e-a*m;b[3]=h*f-a*i;b[8]=h*g+a*c;b[9]=
h*k+a*d;b[10]=h*m+a*e;b[11]=h*i+a*f;return this},rotateZ:function(a){var b=this.elements,c=b[0],d=b[1],e=b[2],f=b[3],g=b[4],k=b[5],m=b[6],i=b[7],h=Math.cos(a),a=Math.sin(a);b[0]=h*c+a*g;b[1]=h*d+a*k;b[2]=h*e+a*m;b[3]=h*f+a*i;b[4]=h*g-a*c;b[5]=h*k-a*d;b[6]=h*m-a*e;b[7]=h*i-a*f;return this},rotateByAxis:function(a,b){var c=this.elements;if(a.x===1&&a.y===0&&a.z===0)return this.rotateX(b);if(a.x===0&&a.y===1&&a.z===0)return this.rotateY(b);if(a.x===0&&a.y===0&&a.z===1)return this.rotateZ(b);var d=a.x,
e=a.y,f=a.z,g=Math.sqrt(d*d+e*e+f*f),d=d/g,e=e/g,f=f/g,g=d*d,k=e*e,m=f*f,i=Math.cos(b),h=Math.sin(b),j=1-i,o=d*e*j,n=d*f*j,j=e*f*j,d=d*h,p=e*h,h=f*h,f=g+(1-g)*i,g=o+h,e=n-p,o=o-h,k=k+(1-k)*i,h=j+d,n=n+p,j=j-d,m=m+(1-m)*i,i=c[0],d=c[1],p=c[2],l=c[3],q=c[4],u=c[5],s=c[6],z=c[7],A=c[8],v=c[9],D=c[10],x=c[11];c[0]=f*i+g*q+e*A;c[1]=f*d+g*u+e*v;c[2]=f*p+g*s+e*D;c[3]=f*l+g*z+e*x;c[4]=o*i+k*q+h*A;c[5]=o*d+k*u+h*v;c[6]=o*p+k*s+h*D;c[7]=o*l+k*z+h*x;c[8]=n*i+j*q+m*A;c[9]=n*d+j*u+m*v;c[10]=n*p+j*s+m*D;c[11]=
n*l+j*z+m*x;return this},scale:function(a){var b=this.elements,c=a.x,d=a.y,a=a.z;b[0]=b[0]*c;b[4]=b[4]*d;b[8]=b[8]*a;b[1]=b[1]*c;b[5]=b[5]*d;b[9]=b[9]*a;b[2]=b[2]*c;b[6]=b[6]*d;b[10]=b[10]*a;b[3]=b[3]*c;b[7]=b[7]*d;b[11]=b[11]*a;return this},getMaxScaleOnAxis:function(){var a=this.elements;return Math.sqrt(Math.max(a[0]*a[0]+a[1]*a[1]+a[2]*a[2],Math.max(a[4]*a[4]+a[5]*a[5]+a[6]*a[6],a[8]*a[8]+a[9]*a[9]+a[10]*a[10])))},makeTranslation:function(a,b,c){this.set(1,0,0,a,0,1,0,b,0,0,1,c,0,0,0,1);return this},
makeRotationX:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(1,0,0,0,0,b,-a,0,0,a,b,0,0,0,0,1);return this},makeRotationY:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,0,a,0,0,1,0,0,-a,0,b,0,0,0,0,1);return this},makeRotationZ:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,-a,0,0,a,b,0,0,0,0,1,0,0,0,0,1);return this},makeRotationAxis:function(a,b){var c=Math.cos(b),d=Math.sin(b),e=1-c,f=a.x,g=a.y,k=a.z,m=e*f,i=e*g;this.set(m*f+c,m*g-d*k,m*k+d*g,0,m*g+d*k,i*g+c,i*k-d*f,0,m*k-
d*g,i*k+d*f,e*k*k+c,0,0,0,0,1);return this},makeScale:function(a,b,c){this.set(a,0,0,0,0,b,0,0,0,0,c,0,0,0,0,1);return this},makeFrustum:function(a,b,c,d,e,f){var g=this.elements;g[0]=2*e/(b-a);g[4]=0;g[8]=(b+a)/(b-a);g[12]=0;g[1]=0;g[5]=2*e/(d-c);g[9]=(d+c)/(d-c);g[13]=0;g[2]=0;g[6]=0;g[10]=-(f+e)/(f-e);g[14]=-2*f*e/(f-e);g[3]=0;g[7]=0;g[11]=-1;g[15]=0;return this},makePerspective:function(a,b,c,d){var a=c*Math.tan(a*Math.PI/360),e=-a;return this.makeFrustum(e*b,a*b,e,a,c,d)},makeOrthographic:function(a,
b,c,d,e,f){var g=this.elements,k=b-a,m=c-d,i=f-e;g[0]=2/k;g[4]=0;g[8]=0;g[12]=-((b+a)/k);g[1]=0;g[5]=2/m;g[9]=0;g[13]=-((c+d)/m);g[2]=0;g[6]=0;g[10]=-2/i;g[14]=-((f+e)/i);g[3]=0;g[7]=0;g[11]=0;g[15]=1;return this},clone:function(){var a=this.elements;return new THREE.Matrix4(a[0],a[4],a[8],a[12],a[1],a[5],a[9],a[13],a[2],a[6],a[10],a[14],a[3],a[7],a[11],a[15])}};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;THREE.Matrix4.__m1=new THREE.Matrix4;
THREE.Matrix4.__m2=new THREE.Matrix4;
THREE.Object3D=function(){this.id=THREE.Object3DCount++;this.name="";this.parent=void 0;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.eulerOrder="XYZ";this.scale=new THREE.Vector3(1,1,1);this.flipSided=this.doubleSided=false;this.renderDepth=null;this.rotationAutoUpdate=true;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixWorldNeedsUpdate=this.matrixAutoUpdate=
true;this.quaternion=new THREE.Quaternion;this.useQuaternion=false;this.boundRadius=0;this.boundRadiusScale=1;this.visible=true;this.receiveShadow=this.castShadow=false;this.frustumCulled=true;this._vector=new THREE.Vector3};
THREE.Object3D.prototype={constructor:THREE.Object3D,applyMatrix:function(a){this.matrix.multiply(a,this.matrix);this.scale.getScaleFromMatrix(this.matrix);this.rotation.getRotationFromMatrix(this.matrix,this.scale);this.position.getPositionFromMatrix(this.matrix)},translate:function(a,b){this.matrix.rotateAxis(b);this.position.addSelf(b.multiplyScalar(a))},translateX:function(a){this.translate(a,this._vector.set(1,0,0))},translateY:function(a){this.translate(a,this._vector.set(0,1,0))},translateZ:function(a){this.translate(a,
this._vector.set(0,0,1))},lookAt:function(a){this.matrix.lookAt(a,this.position,this.up);this.rotationAutoUpdate&&this.rotation.getRotationFromMatrix(this.matrix)},add:function(a){if(a===this)console.warn("THREE.Object3D.add: An object can't be added as a child of itself.");else if(a instanceof THREE.Object3D){a.parent!==void 0&&a.parent.remove(a);a.parent=this;this.children.push(a);for(var b=this;b.parent!==void 0;)b=b.parent;b!==void 0&&b instanceof THREE.Scene&&b.__addObject(a)}},remove:function(a){var b=
this.children.indexOf(a);if(b!==-1){a.parent=void 0;this.children.splice(b,1);for(b=this;b.parent!==void 0;)b=b.parent;b!==void 0&&b instanceof THREE.Scene&&b.__removeObject(a)}},getChildByName:function(a,b){var c,d,e;c=0;for(d=this.children.length;c<d;c++){e=this.children[c];if(e.name===a)return e;if(b){e=e.getChildByName(a,b);if(e!==void 0)return e}}},updateMatrix:function(){this.matrix.setPosition(this.position);this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation,
this.eulerOrder);if(this.scale.x!==1||this.scale.y!==1||this.scale.z!==1){this.matrix.scale(this.scale);this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z))}this.matrixWorldNeedsUpdate=true},updateMatrixWorld:function(a){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||a){this.parent?this.matrixWorld.multiply(this.parent.matrixWorld,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixWorldNeedsUpdate=false;a=true}for(var b=0,c=this.children.length;b<
c;b++)this.children[b].updateMatrixWorld(a)}};THREE.Object3DCount=0;
THREE.Projector=function(){function a(){var a=g[f]=g[f]||new THREE.RenderableObject;f++;return a}function b(){var a=i[m]=i[m]||new THREE.RenderableVertex;m++;return a}function c(a,b){return b.z-a.z}function d(a,b){var c=0,d=1,f=a.z+a.w,e=b.z+b.w,g=-a.z+a.w,h=-b.z+b.w;if(f>=0&&e>=0&&g>=0&&h>=0)return true;if(f<0&&e<0||g<0&&h<0)return false;f<0?c=Math.max(c,f/(f-e)):e<0&&(d=Math.min(d,f/(f-e)));g<0?c=Math.max(c,g/(g-h)):h<0&&(d=Math.min(d,g/(g-h)));if(d<c)return false;a.lerpSelf(b,c);b.lerpSelf(a,1-
d);return true}var e,f,g=[],k,m,i=[],h,j,o=[],n,p=[],l,q,u=[],s,z,A=[],v={objects:[],sprites:[],lights:[],elements:[]},D=new THREE.Vector3,x=new THREE.Vector4,G=new THREE.Matrix4,t=new THREE.Matrix4,y=new THREE.Frustum,C=new THREE.Vector4,L=new THREE.Vector4;this.projectVector=function(a,b){b.matrixWorldInverse.getInverse(b.matrixWorld);G.multiply(b.projectionMatrix,b.matrixWorldInverse);G.multiplyVector3(a);return a};this.unprojectVector=function(a,b){b.projectionMatrixInverse.getInverse(b.projectionMatrix);
G.multiply(b.matrixWorld,b.projectionMatrixInverse);G.multiplyVector3(a);return a};this.pickingRay=function(a,b){var c;a.z=-1;c=new THREE.Vector3(a.x,a.y,1);this.unprojectVector(a,b);this.unprojectVector(c,b);c.subSelf(a).normalize();return new THREE.Ray(a,c)};this.projectGraph=function(b,d){f=0;v.objects.length=0;v.sprites.length=0;v.lights.length=0;var g=function(b){if(b.visible!==false){if((b instanceof THREE.Mesh||b instanceof THREE.Line)&&(b.frustumCulled===false||y.contains(b))){D.copy(b.matrixWorld.getPosition());
G.multiplyVector3(D);e=a();e.object=b;e.z=D.z;v.objects.push(e)}else if(b instanceof THREE.Sprite||b instanceof THREE.Particle){D.copy(b.matrixWorld.getPosition());G.multiplyVector3(D);e=a();e.object=b;e.z=D.z;v.sprites.push(e)}else b instanceof THREE.Light&&v.lights.push(b);for(var c=0,d=b.children.length;c<d;c++)g(b.children[c])}};g(b);d&&v.objects.sort(c);return v};this.projectScene=function(a,f,e){var g=f.near,D=f.far,H=false,P,O,w,U,M,T,S,W,B,J,I,K,R,ja,da;z=q=n=j=0;v.elements.length=0;if(f.parent===
void 0){console.warn("DEPRECATED: Camera hasn't been added to a Scene. Adding it...");a.add(f)}a.updateMatrixWorld();f.matrixWorldInverse.getInverse(f.matrixWorld);G.multiply(f.projectionMatrix,f.matrixWorldInverse);y.setFromMatrix(G);v=this.projectGraph(a,false);a=0;for(P=v.objects.length;a<P;a++){B=v.objects[a].object;J=B.matrixWorld;m=0;if(B instanceof THREE.Mesh){I=B.geometry;K=B.geometry.materials;U=I.vertices;R=I.faces;ja=I.faceVertexUvs;I=B.matrixRotationWorld.extractRotation(J);O=0;for(w=
U.length;O<w;O++){k=b();k.positionWorld.copy(U[O]);J.multiplyVector3(k.positionWorld);k.positionScreen.copy(k.positionWorld);G.multiplyVector4(k.positionScreen);k.positionScreen.x=k.positionScreen.x/k.positionScreen.w;k.positionScreen.y=k.positionScreen.y/k.positionScreen.w;k.visible=k.positionScreen.z>g&&k.positionScreen.z<D}U=0;for(O=R.length;U<O;U++){w=R[U];if(w instanceof THREE.Face3){M=i[w.a];T=i[w.b];S=i[w.c];if(M.visible&&T.visible&&S.visible){H=(S.positionScreen.x-M.positionScreen.x)*(T.positionScreen.y-
M.positionScreen.y)-(S.positionScreen.y-M.positionScreen.y)*(T.positionScreen.x-M.positionScreen.x)<0;if(B.doubleSided||H!=B.flipSided){W=o[j]=o[j]||new THREE.RenderableFace3;j++;h=W;h.v1.copy(M);h.v2.copy(T);h.v3.copy(S)}else continue}else continue}else if(w instanceof THREE.Face4){M=i[w.a];T=i[w.b];S=i[w.c];W=i[w.d];if(M.visible&&T.visible&&S.visible&&W.visible){H=(W.positionScreen.x-M.positionScreen.x)*(T.positionScreen.y-M.positionScreen.y)-(W.positionScreen.y-M.positionScreen.y)*(T.positionScreen.x-
M.positionScreen.x)<0||(T.positionScreen.x-S.positionScreen.x)*(W.positionScreen.y-S.positionScreen.y)-(T.positionScreen.y-S.positionScreen.y)*(W.positionScreen.x-S.positionScreen.x)<0;if(B.doubleSided||H!=B.flipSided){da=p[n]=p[n]||new THREE.RenderableFace4;n++;h=da;h.v1.copy(M);h.v2.copy(T);h.v3.copy(S);h.v4.copy(W)}else continue}else continue}h.normalWorld.copy(w.normal);!H&&(B.flipSided||B.doubleSided)&&h.normalWorld.negate();I.multiplyVector3(h.normalWorld);h.centroidWorld.copy(w.centroid);J.multiplyVector3(h.centroidWorld);
h.centroidScreen.copy(h.centroidWorld);G.multiplyVector3(h.centroidScreen);S=w.vertexNormals;M=0;for(T=S.length;M<T;M++){W=h.vertexNormalsWorld[M];W.copy(S[M]);!H&&(B.flipSided||B.doubleSided)&&W.negate();I.multiplyVector3(W)}M=0;for(T=ja.length;M<T;M++)if(da=ja[M][U]){S=0;for(W=da.length;S<W;S++)h.uvs[M][S]=da[S]}h.material=B.material;h.faceMaterial=w.materialIndex!==null?K[w.materialIndex]:null;h.z=h.centroidScreen.z;v.elements.push(h)}}else if(B instanceof THREE.Line){t.multiply(G,J);U=B.geometry.vertices;
M=b();M.positionScreen.copy(U[0]);t.multiplyVector4(M.positionScreen);J=B.type===THREE.LinePieces?2:1;O=1;for(w=U.length;O<w;O++){M=b();M.positionScreen.copy(U[O]);t.multiplyVector4(M.positionScreen);if(!((O+1)%J>0)){T=i[m-2];C.copy(M.positionScreen);L.copy(T.positionScreen);if(d(C,L)){C.multiplyScalar(1/C.w);L.multiplyScalar(1/L.w);K=u[q]=u[q]||new THREE.RenderableLine;q++;l=K;l.v1.positionScreen.copy(C);l.v2.positionScreen.copy(L);l.z=Math.max(C.z,L.z);l.material=B.material;v.elements.push(l)}}}}}a=
0;for(P=v.sprites.length;a<P;a++){B=v.sprites[a].object;J=B.matrixWorld;if(B instanceof THREE.Particle){x.set(J.elements[12],J.elements[13],J.elements[14],1);G.multiplyVector4(x);x.z=x.z/x.w;if(x.z>0&&x.z<1){g=A[z]=A[z]||new THREE.RenderableParticle;z++;s=g;s.x=x.x/x.w;s.y=x.y/x.w;s.z=x.z;s.rotation=B.rotation.z;s.scale.x=B.scale.x*Math.abs(s.x-(x.x+f.projectionMatrix.elements[0])/(x.w+f.projectionMatrix.elements[12]));s.scale.y=B.scale.y*Math.abs(s.y-(x.y+f.projectionMatrix.elements[5])/(x.w+f.projectionMatrix.elements[13]));
s.material=B.material;v.elements.push(s)}}}e&&v.elements.sort(c);return v}};THREE.Quaternion=function(a,b,c,d){this.x=a||0;this.y=b||0;this.z=c||0;this.w=d!==void 0?d:1};
THREE.Quaternion.prototype={constructor:THREE.Quaternion,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w;return this},setFromEuler:function(a){var b=Math.PI/360,c=a.x*b,d=a.y*b,e=a.z*b,a=Math.cos(d),d=Math.sin(d),b=Math.cos(-e),e=Math.sin(-e),f=Math.cos(c),c=Math.sin(c),g=a*b,k=d*e;this.w=g*f-k*c;this.x=g*c+k*f;this.y=d*b*f+a*e*c;this.z=a*e*f-d*b*c;return this},setFromAxisAngle:function(a,b){var c=b/2,d=Math.sin(c);
this.x=a.x*d;this.y=a.y*d;this.z=a.z*d;this.w=Math.cos(c);return this},setFromRotationMatrix:function(a){var b=Math.pow(a.determinant(),1/3);this.w=Math.sqrt(Math.max(0,b+a.elements[0]+a.elements[5]+a.elements[10]))/2;this.x=Math.sqrt(Math.max(0,b+a.elements[0]-a.elements[5]-a.elements[10]))/2;this.y=Math.sqrt(Math.max(0,b-a.elements[0]+a.elements[5]-a.elements[10]))/2;this.z=Math.sqrt(Math.max(0,b-a.elements[0]-a.elements[5]+a.elements[10]))/2;this.x=a.elements[6]-a.elements[9]<0?-Math.abs(this.x):
Math.abs(this.x);this.y=a.elements[8]-a.elements[2]<0?-Math.abs(this.y):Math.abs(this.y);this.z=a.elements[1]-a.elements[4]<0?-Math.abs(this.z):Math.abs(this.z);this.normalize();return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x=this.x*-1;this.y=this.y*-1;this.z=this.z*-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var a=
Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);if(a===0)this.w=this.z=this.y=this.x=0;else{a=1/a;this.x=this.x*a;this.y=this.y*a;this.z=this.z*a;this.w=this.w*a}return this},multiply:function(a,b){this.x=a.x*b.w+a.y*b.z-a.z*b.y+a.w*b.x;this.y=-a.x*b.z+a.y*b.w+a.z*b.x+a.w*b.y;this.z=a.x*b.y-a.y*b.x+a.z*b.w+a.w*b.z;this.w=-a.x*b.x-a.y*b.y-a.z*b.z+a.w*b.w;return this},multiplySelf:function(a){var b=this.x,c=this.y,d=this.z,e=this.w,f=a.x,g=a.y,k=a.z,a=a.w;this.x=b*a+e*f+c*k-d*g;this.y=
c*a+e*g+d*f-b*k;this.z=d*a+e*k+b*g-c*f;this.w=e*a-b*f-c*g-d*k;return this},multiplyVector3:function(a,b){b||(b=a);var c=a.x,d=a.y,e=a.z,f=this.x,g=this.y,k=this.z,m=this.w,i=m*c+g*e-k*d,h=m*d+k*c-f*e,j=m*e+f*d-g*c,c=-f*c-g*d-k*e;b.x=i*m+c*-f+h*-k-j*-g;b.y=h*m+c*-g+j*-f-i*-k;b.z=j*m+c*-k+i*-g-h*-f;return b},clone:function(){return new THREE.Quaternion(this.x,this.y,this.z,this.w)}};
THREE.Quaternion.slerp=function(a,b,c,d){var e=a.w*b.w+a.x*b.x+a.y*b.y+a.z*b.z;if(e<0){c.w=-b.w;c.x=-b.x;c.y=-b.y;c.z=-b.z;e=-e}else c.copy(b);if(Math.abs(e)>=1){c.w=a.w;c.x=a.x;c.y=a.y;c.z=a.z;return c}var f=Math.acos(e),e=Math.sqrt(1-e*e);if(Math.abs(e)<0.001){c.w=0.5*(a.w+b.w);c.x=0.5*(a.x+b.x);c.y=0.5*(a.y+b.y);c.z=0.5*(a.z+b.z);return c}b=Math.sin((1-d)*f)/e;d=Math.sin(d*f)/e;c.w=a.w*b+c.w*d;c.x=a.x*b+c.x*d;c.y=a.y*b+c.y*d;c.z=a.z*b+c.z*d;return c};THREE.Vertex=function(){console.warn("THREE.Vertex has been DEPRECATED. Use THREE.Vector3 instead.")};
THREE.Face3=function(a,b,c,d,e,f){this.a=a;this.b=b;this.c=c;this.normal=d instanceof THREE.Vector3?d:new THREE.Vector3;this.vertexNormals=d instanceof Array?d:[];this.color=e instanceof THREE.Color?e:new THREE.Color;this.vertexColors=e instanceof Array?e:[];this.vertexTangents=[];this.materialIndex=f;this.centroid=new THREE.Vector3};
THREE.Face3.prototype={constructor:THREE.Face3,clone:function(){var a=new THREE.Face3(this.a,this.b,this.c);a.normal.copy(this.normal);a.color.copy(this.color);a.centroid.copy(this.centroid);a.materialIndex=this.materialIndex;var b,c;b=0;for(c=this.vertexNormals.length;b<c;b++)a.vertexNormals[b]=this.vertexNormals[b].clone();b=0;for(c=this.vertexColors.length;b<c;b++)a.vertexColors[b]=this.vertexColors[b].clone();b=0;for(c=this.vertexTangents.length;b<c;b++)a.vertexTangents[b]=this.vertexTangents[b].clone();
return a}};THREE.Face4=function(a,b,c,d,e,f,g){this.a=a;this.b=b;this.c=c;this.d=d;this.normal=e instanceof THREE.Vector3?e:new THREE.Vector3;this.vertexNormals=e instanceof Array?e:[];this.color=f instanceof THREE.Color?f:new THREE.Color;this.vertexColors=f instanceof Array?f:[];this.vertexTangents=[];this.materialIndex=g;this.centroid=new THREE.Vector3};
THREE.Face4.prototype={constructor:THREE.Face4,clone:function(){var a=new THREE.Face4(this.a,this.b,this.c,this.d);a.normal.copy(this.normal);a.color.copy(this.color);a.centroid.copy(this.centroid);a.materialIndex=this.materialIndex;var b,c;b=0;for(c=this.vertexNormals.length;b<c;b++)a.vertexNormals[b]=this.vertexNormals[b].clone();b=0;for(c=this.vertexColors.length;b<c;b++)a.vertexColors[b]=this.vertexColors[b].clone();b=0;for(c=this.vertexTangents.length;b<c;b++)a.vertexTangents[b]=this.vertexTangents[b].clone();
return a}};THREE.UV=function(a,b){this.u=a||0;this.v=b||0};THREE.UV.prototype={constructor:THREE.UV,set:function(a,b){this.u=a;this.v=b;return this},copy:function(a){this.u=a.u;this.v=a.v;return this},lerpSelf:function(a,b){this.u=this.u+(a.u-this.u)*b;this.v=this.v+(a.v-this.v)*b;return this},clone:function(){return new THREE.UV(this.u,this.v)}};
THREE.Geometry=function(){this.id=THREE.GeometryCount++;this.vertices=[];this.colors=[];this.materials=[];this.faces=[];this.faceUvs=[[]];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphColors=[];this.morphNormals=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.dynamic=this.hasTangents=false};
THREE.Geometry.prototype={constructor:THREE.Geometry,applyMatrix:function(a){var b=new THREE.Matrix4;b.extractRotation(a);for(var c=0,d=this.vertices.length;c<d;c++)a.multiplyVector3(this.vertices[c]);c=0;for(d=this.faces.length;c<d;c++){var e=this.faces[c];b.multiplyVector3(e.normal);for(var f=0,g=e.vertexNormals.length;f<g;f++)b.multiplyVector3(e.vertexNormals[f]);a.multiplyVector3(e.centroid)}},computeCentroids:function(){var a,b,c;a=0;for(b=this.faces.length;a<b;a++){c=this.faces[a];c.centroid.set(0,
0,0);if(c instanceof THREE.Face3){c.centroid.addSelf(this.vertices[c.a]);c.centroid.addSelf(this.vertices[c.b]);c.centroid.addSelf(this.vertices[c.c]);c.centroid.divideScalar(3)}else if(c instanceof THREE.Face4){c.centroid.addSelf(this.vertices[c.a]);c.centroid.addSelf(this.vertices[c.b]);c.centroid.addSelf(this.vertices[c.c]);c.centroid.addSelf(this.vertices[c.d]);c.centroid.divideScalar(4)}}},computeFaceNormals:function(){var a,b,c,d,e,f,g=new THREE.Vector3,k=new THREE.Vector3;a=0;for(b=this.faces.length;a<
b;a++){c=this.faces[a];d=this.vertices[c.a];e=this.vertices[c.b];f=this.vertices[c.c];g.sub(f,e);k.sub(d,e);g.crossSelf(k);g.isZero()||g.normalize();c.normal.copy(g)}},computeVertexNormals:function(){var a,b,c,d;if(this.__tmpVertices===void 0){d=this.__tmpVertices=Array(this.vertices.length);a=0;for(b=this.vertices.length;a<b;a++)d[a]=new THREE.Vector3;a=0;for(b=this.faces.length;a<b;a++){c=this.faces[a];if(c instanceof THREE.Face3)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];
else if(c instanceof THREE.Face4)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}}else{d=this.__tmpVertices;a=0;for(b=this.vertices.length;a<b;a++)d[a].set(0,0,0)}a=0;for(b=this.faces.length;a<b;a++){c=this.faces[a];if(c instanceof THREE.Face3){d[c.a].addSelf(c.normal);d[c.b].addSelf(c.normal);d[c.c].addSelf(c.normal)}else if(c instanceof THREE.Face4){d[c.a].addSelf(c.normal);d[c.b].addSelf(c.normal);d[c.c].addSelf(c.normal);d[c.d].addSelf(c.normal)}}a=0;
for(b=this.vertices.length;a<b;a++)d[a].normalize();a=0;for(b=this.faces.length;a<b;a++){c=this.faces[a];if(c instanceof THREE.Face3){c.vertexNormals[0].copy(d[c.a]);c.vertexNormals[1].copy(d[c.b]);c.vertexNormals[2].copy(d[c.c])}else if(c instanceof THREE.Face4){c.vertexNormals[0].copy(d[c.a]);c.vertexNormals[1].copy(d[c.b]);c.vertexNormals[2].copy(d[c.c]);c.vertexNormals[3].copy(d[c.d])}}},computeMorphNormals:function(){var a,b,c,d,e;c=0;for(d=this.faces.length;c<d;c++){e=this.faces[c];e.__originalFaceNormal?
e.__originalFaceNormal.copy(e.normal):e.__originalFaceNormal=e.normal.clone();if(!e.__originalVertexNormals)e.__originalVertexNormals=[];a=0;for(b=e.vertexNormals.length;a<b;a++)e.__originalVertexNormals[a]?e.__originalVertexNormals[a].copy(e.vertexNormals[a]):e.__originalVertexNormals[a]=e.vertexNormals[a].clone()}var f=new THREE.Geometry;f.faces=this.faces;a=0;for(b=this.morphTargets.length;a<b;a++){if(!this.morphNormals[a]){this.morphNormals[a]={};this.morphNormals[a].faceNormals=[];this.morphNormals[a].vertexNormals=
[];var g=this.morphNormals[a].faceNormals,k=this.morphNormals[a].vertexNormals,m,i;c=0;for(d=this.faces.length;c<d;c++){e=this.faces[c];m=new THREE.Vector3;i=e instanceof THREE.Face3?{a:new THREE.Vector3,b:new THREE.Vector3,c:new THREE.Vector3}:{a:new THREE.Vector3,b:new THREE.Vector3,c:new THREE.Vector3,d:new THREE.Vector3};g.push(m);k.push(i)}}g=this.morphNormals[a];f.vertices=this.morphTargets[a].vertices;f.computeFaceNormals();f.computeVertexNormals();c=0;for(d=this.faces.length;c<d;c++){e=this.faces[c];
m=g.faceNormals[c];i=g.vertexNormals[c];m.copy(e.normal);if(e instanceof THREE.Face3){i.a.copy(e.vertexNormals[0]);i.b.copy(e.vertexNormals[1]);i.c.copy(e.vertexNormals[2])}else{i.a.copy(e.vertexNormals[0]);i.b.copy(e.vertexNormals[1]);i.c.copy(e.vertexNormals[2]);i.d.copy(e.vertexNormals[3])}}}c=0;for(d=this.faces.length;c<d;c++){e=this.faces[c];e.normal=e.__originalFaceNormal;e.vertexNormals=e.__originalVertexNormals}},computeTangents:function(){function a(a,b,c,d,f,e,M){k=a.vertices[b];m=a.vertices[c];
i=a.vertices[d];h=g[f];j=g[e];o=g[M];n=m.x-k.x;p=i.x-k.x;l=m.y-k.y;q=i.y-k.y;u=m.z-k.z;s=i.z-k.z;z=j.u-h.u;A=o.u-h.u;v=j.v-h.v;D=o.v-h.v;x=1/(z*D-A*v);C.set((D*n-v*p)*x,(D*l-v*q)*x,(D*u-v*s)*x);L.set((z*p-A*n)*x,(z*q-A*l)*x,(z*s-A*u)*x);t[b].addSelf(C);t[c].addSelf(C);t[d].addSelf(C);y[b].addSelf(L);y[c].addSelf(L);y[d].addSelf(L)}var b,c,d,e,f,g,k,m,i,h,j,o,n,p,l,q,u,s,z,A,v,D,x,G,t=[],y=[],C=new THREE.Vector3,L=new THREE.Vector3,Q=new THREE.Vector3,N=new THREE.Vector3,r=new THREE.Vector3;b=0;for(c=
this.vertices.length;b<c;b++){t[b]=new THREE.Vector3;y[b]=new THREE.Vector3}b=0;for(c=this.faces.length;b<c;b++){f=this.faces[b];g=this.faceVertexUvs[0][b];if(f instanceof THREE.Face3)a(this,f.a,f.b,f.c,0,1,2);else if(f instanceof THREE.Face4){a(this,f.a,f.b,f.d,0,1,3);a(this,f.b,f.c,f.d,1,2,3)}}var E=["a","b","c","d"];b=0;for(c=this.faces.length;b<c;b++){f=this.faces[b];for(d=0;d<f.vertexNormals.length;d++){r.copy(f.vertexNormals[d]);e=f[E[d]];G=t[e];Q.copy(G);Q.subSelf(r.multiplyScalar(r.dot(G))).normalize();
N.cross(f.vertexNormals[d],G);e=N.dot(y[e]);e=e<0?-1:1;f.vertexTangents[d]=new THREE.Vector4(Q.x,Q.y,Q.z,e)}}this.hasTangents=true},computeBoundingBox:function(){if(!this.boundingBox)this.boundingBox={min:new THREE.Vector3,max:new THREE.Vector3};if(this.vertices.length>0){var a;a=this.vertices[0];this.boundingBox.min.copy(a);this.boundingBox.max.copy(a);for(var b=this.boundingBox.min,c=this.boundingBox.max,d=1,e=this.vertices.length;d<e;d++){a=this.vertices[d];if(a.x<b.x)b.x=a.x;else if(a.x>c.x)c.x=
a.x;if(a.y<b.y)b.y=a.y;else if(a.y>c.y)c.y=a.y;if(a.z<b.z)b.z=a.z;else if(a.z>c.z)c.z=a.z}}else{this.boundingBox.min.set(0,0,0);this.boundingBox.max.set(0,0,0)}},computeBoundingSphere:function(){if(!this.boundingSphere)this.boundingSphere={radius:0};for(var a,b=0,c=0,d=this.vertices.length;c<d;c++){a=this.vertices[c].length();a>b&&(b=a)}this.boundingSphere.radius=b},mergeVertices:function(){var a={},b=[],c=[],d,e=Math.pow(10,4),f,g,k;f=0;for(g=this.vertices.length;f<g;f++){d=this.vertices[f];d=[Math.round(d.x*
e),Math.round(d.y*e),Math.round(d.z*e)].join("_");if(a[d]===void 0){a[d]=f;b.push(this.vertices[f]);c[f]=b.length-1}else c[f]=c[a[d]]}f=0;for(g=this.faces.length;f<g;f++){e=this.faces[f];if(e instanceof THREE.Face3){e.a=c[e.a];e.b=c[e.b];e.c=c[e.c]}else if(e instanceof THREE.Face4){e.a=c[e.a];e.b=c[e.b];e.c=c[e.c];e.d=c[e.d];d=[e.a,e.b,e.c,e.d];for(a=3;a>0;a--)if(d.indexOf(e["abcd"[a]])!=a){d.splice(a,1);this.faces[f]=new THREE.Face3(d[0],d[1],d[2]);e=0;for(d=this.faceVertexUvs.length;e<d;e++)(k=
this.faceVertexUvs[e][f])&&k.splice(a,1);break}}}c=this.vertices.length-b.length;this.vertices=b;return c}};THREE.GeometryCount=0;THREE.Camera=function(){THREE.Object3D.call(this);this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=new THREE.Matrix4;this.projectionMatrixInverse=new THREE.Matrix4};THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;
THREE.Camera.prototype.lookAt=function(a){this.matrix.lookAt(this.position,a,this.up);this.rotationAutoUpdate&&this.rotation.getRotationFromMatrix(this.matrix)};THREE.OrthographicCamera=function(a,b,c,d,e,f){THREE.Camera.call(this);this.left=a;this.right=b;this.top=c;this.bottom=d;this.near=e!==void 0?e:0.1;this.far=f!==void 0?f:2E3;this.updateProjectionMatrix()};THREE.OrthographicCamera.prototype=new THREE.Camera;THREE.OrthographicCamera.prototype.constructor=THREE.OrthographicCamera;
THREE.OrthographicCamera.prototype.updateProjectionMatrix=function(){this.projectionMatrix.makeOrthographic(this.left,this.right,this.top,this.bottom,this.near,this.far)};THREE.PerspectiveCamera=function(a,b,c,d){THREE.Camera.call(this);this.fov=a!==void 0?a:50;this.aspect=b!==void 0?b:1;this.near=c!==void 0?c:0.1;this.far=d!==void 0?d:2E3;this.updateProjectionMatrix()};THREE.PerspectiveCamera.prototype=new THREE.Camera;THREE.PerspectiveCamera.prototype.constructor=THREE.PerspectiveCamera;
THREE.PerspectiveCamera.prototype.setLens=function(a,b){this.fov=2*Math.atan((b!==void 0?b:24)/(a*2))*(180/Math.PI);this.updateProjectionMatrix()};THREE.PerspectiveCamera.prototype.setViewOffset=function(a,b,c,d,e,f){this.fullWidth=a;this.fullHeight=b;this.x=c;this.y=d;this.width=e;this.height=f;this.updateProjectionMatrix()};
THREE.PerspectiveCamera.prototype.updateProjectionMatrix=function(){if(this.fullWidth){var a=this.fullWidth/this.fullHeight,b=Math.tan(this.fov*Math.PI/360)*this.near,c=-b,d=a*c,a=Math.abs(a*b-d),c=Math.abs(b-c);this.projectionMatrix.makeFrustum(d+this.x*a/this.fullWidth,d+(this.x+this.width)*a/this.fullWidth,b-(this.y+this.height)*c/this.fullHeight,b-this.y*c/this.fullHeight,this.near,this.far)}else this.projectionMatrix.makePerspective(this.fov,this.aspect,this.near,this.far)};
THREE.Light=function(a){THREE.Object3D.call(this);this.color=new THREE.Color(a)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;
THREE.DirectionalLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.target=new THREE.Object3D;this.intensity=b!==void 0?b:1;this.distance=c!==void 0?c:0;this.onlyShadow=this.castShadow=false;this.shadowCameraNear=50;this.shadowCameraFar=5E3;this.shadowCameraLeft=-500;this.shadowCameraTop=this.shadowCameraRight=500;this.shadowCameraBottom=-500;this.shadowCameraVisible=false;this.shadowBias=0;this.shadowDarkness=0.5;this.shadowMapHeight=this.shadowMapWidth=512;
this.shadowCascade=false;this.shadowCascadeOffset=new THREE.Vector3(0,0,-1E3);this.shadowCascadeCount=2;this.shadowCascadeBias=[0,0,0];this.shadowCascadeWidth=[512,512,512];this.shadowCascadeHeight=[512,512,512];this.shadowCascadeNearZ=[-1,0.99,0.998];this.shadowCascadeFarZ=[0.99,0.998,1];this.shadowCascadeArray=[];this.shadowMatrix=this.shadowCamera=this.shadowMapSize=this.shadowMap=null};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;
THREE.PointLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,0,0);this.intensity=b!==void 0?b:1;this.distance=c!==void 0?c:0};THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;THREE.Loader=function(a){this.statusDomElement=(this.showStatus=a)?THREE.Loader.prototype.addStatusElement():null;this.onLoadStart=function(){};this.onLoadProgress=function(){};this.onLoadComplete=function(){}};
THREE.Loader.prototype={constructor:THREE.Loader,crossOrigin:"anonymous",addStatusElement:function(){var a=document.createElement("div");a.style.position="absolute";a.style.right="0px";a.style.top="0px";a.style.fontSize="0.8em";a.style.textAlign="left";a.style.background="rgba(0,0,0,0.25)";a.style.color="#fff";a.style.width="120px";a.style.padding="0.5em 0.5em 0.5em 0.5em";a.style.zIndex=1E3;a.innerHTML="Loading ...";return a},updateProgress:function(a){var b="Loaded ",b=a.total?b+((100*a.loaded/
a.total).toFixed(0)+"%"):b+((a.loaded/1E3).toFixed(2)+" KB");this.statusDomElement.innerHTML=b},extractUrlBase:function(a){a=a.split("/");a.pop();return(a.length<1?".":a.join("/"))+"/"},initMaterials:function(a,b,c){a.materials=[];for(var d=0;d<b.length;++d)a.materials[d]=THREE.Loader.prototype.createMaterial(b[d],c)},hasNormals:function(a){var b,c,d=a.materials.length;for(c=0;c<d;c++){b=a.materials[c];if(b instanceof THREE.ShaderMaterial)return true}return false},createMaterial:function(a,b){function c(a){a=
Math.log(a)/Math.LN2;return Math.floor(a)==a}function d(a){a=Math.log(a)/Math.LN2;return Math.pow(2,Math.round(a))}function e(a,b){var f=new Image;f.onload=function(){if(!c(this.width)||!c(this.height)){var b=d(this.width),f=d(this.height);a.image.width=b;a.image.height=f;a.image.getContext("2d").drawImage(this,0,0,b,f)}else a.image=this;a.needsUpdate=true};f.crossOrigin=k.crossOrigin;f.src=b}function f(a,c,d,f,g,h){var k=document.createElement("canvas");a[c]=new THREE.Texture(k);a[c].sourceFile=
d;if(f){a[c].repeat.set(f[0],f[1]);if(f[0]!=1)a[c].wrapS=THREE.RepeatWrapping;if(f[1]!=1)a[c].wrapT=THREE.RepeatWrapping}g&&a[c].offset.set(g[0],g[1]);if(h){f={repeat:THREE.RepeatWrapping,mirror:THREE.MirroredRepeatWrapping};if(f[h[0]]!==void 0)a[c].wrapS=f[h[0]];if(f[h[1]]!==void 0)a[c].wrapT=f[h[1]]}e(a[c],b+"/"+d)}function g(a){return(a[0]*255<<16)+(a[1]*255<<8)+a[2]*255}var k=this,m="MeshLambertMaterial",i={color:15658734,opacity:1,map:null,lightMap:null,normalMap:null,wireframe:a.wireframe};
if(a.shading){var h=a.shading.toLowerCase();h==="phong"?m="MeshPhongMaterial":h==="basic"&&(m="MeshBasicMaterial")}if(a.blending!==void 0&&THREE[a.blending]!==void 0)i.blending=THREE[a.blending];if(a.transparent!==void 0||a.opacity<1)i.transparent=a.transparent;if(a.depthTest!==void 0)i.depthTest=a.depthTest;if(a.depthWrite!==void 0)i.depthWrite=a.depthWrite;if(a.vertexColors!==void 0)if(a.vertexColors=="face")i.vertexColors=THREE.FaceColors;else if(a.vertexColors)i.vertexColors=THREE.VertexColors;
if(a.colorDiffuse)i.color=g(a.colorDiffuse);else if(a.DbgColor)i.color=a.DbgColor;if(a.colorSpecular)i.specular=g(a.colorSpecular);if(a.colorAmbient)i.ambient=g(a.colorAmbient);if(a.transparency)i.opacity=a.transparency;if(a.specularCoef)i.shininess=a.specularCoef;a.mapDiffuse&&b&&f(i,"map",a.mapDiffuse,a.mapDiffuseRepeat,a.mapDiffuseOffset,a.mapDiffuseWrap);a.mapLight&&b&&f(i,"lightMap",a.mapLight,a.mapLightRepeat,a.mapLightOffset,a.mapLightWrap);a.mapNormal&&b&&f(i,"normalMap",a.mapNormal,a.mapNormalRepeat,
a.mapNormalOffset,a.mapNormalWrap);a.mapSpecular&&b&&f(i,"specularMap",a.mapSpecular,a.mapSpecularRepeat,a.mapSpecularOffset,a.mapSpecularWrap);if(a.mapNormal){m=THREE.ShaderUtils.lib.normal;h=THREE.UniformsUtils.clone(m.uniforms);h.tNormal.texture=i.normalMap;if(a.mapNormalFactor)h.uNormalScale.value=a.mapNormalFactor;if(i.map){h.tDiffuse.texture=i.map;h.enableDiffuse.value=true}if(i.specularMap){h.tSpecular.texture=i.specularMap;h.enableSpecular.value=true}if(i.lightMap){h.tAO.texture=i.lightMap;
h.enableAO.value=true}h.uDiffuseColor.value.setHex(i.color);h.uSpecularColor.value.setHex(i.specular);h.uAmbientColor.value.setHex(i.ambient);h.uShininess.value=i.shininess;if(i.opacity!==void 0)h.uOpacity.value=i.opacity;i=new THREE.ShaderMaterial({fragmentShader:m.fragmentShader,vertexShader:m.vertexShader,uniforms:h,lights:true,fog:true})}else i=new THREE[m](i);if(a.DbgName!==void 0)i.name=a.DbgName;return i}};THREE.BinaryLoader=function(a){THREE.Loader.call(this,a)};
THREE.BinaryLoader.prototype=new THREE.Loader;THREE.BinaryLoader.prototype.constructor=THREE.BinaryLoader;THREE.BinaryLoader.prototype.load=function(a,b,c,d){var c=c?c:this.extractUrlBase(a),d=d?d:this.extractUrlBase(a),e=this.showProgress?THREE.Loader.prototype.updateProgress:null;this.onLoadStart();this.loadAjaxJSON(this,a,b,c,d,e)};
THREE.BinaryLoader.prototype.loadAjaxJSON=function(a,b,c,d,e,f){var g=new XMLHttpRequest;g.onreadystatechange=function(){if(g.readyState==4)if(g.status==200||g.status==0){var k=JSON.parse(g.responseText);a.loadAjaxBuffers(k,c,e,d,f)}else console.error("THREE.BinaryLoader: Couldn't load ["+b+"] ["+g.status+"]")};g.open("GET",b,true);g.overrideMimeType&&g.overrideMimeType("text/plain; charset=x-user-defined");g.setRequestHeader("Content-Type","text/plain");g.send(null)};
THREE.BinaryLoader.prototype.loadAjaxBuffers=function(a,b,c,d,e){var f=new XMLHttpRequest,g=c+"/"+a.buffers,k=0;f.onreadystatechange=function(){if(f.readyState==4)f.status==200||f.status==0?THREE.BinaryLoader.prototype.createBinModel(f.response,b,d,a.materials):console.error("THREE.BinaryLoader: Couldn't load ["+g+"] ["+f.status+"]");else if(f.readyState==3){if(e){k==0&&(k=f.getResponseHeader("Content-Length"));e({total:k,loaded:f.responseText.length})}}else f.readyState==2&&(k=f.getResponseHeader("Content-Length"))};
f.open("GET",g,true);f.responseType="arraybuffer";f.send(null)};
THREE.BinaryLoader.prototype.createBinModel=function(a,b,c,d){var e=function(b){var c,e,m,i,h,j,o,n,p,l,q,u,s,z,A;function v(a){return a%4?4-a%4:0}function D(a,b){return(new Uint8Array(a,b,1))[0]}function x(a,b){return(new Uint32Array(a,b,1))[0]}function G(b,c){var d,f,e,g,h,k,l,i,m=new Uint32Array(a,c,3*b);for(d=0;d<b;d++){f=m[d*3];e=m[d*3+1];g=m[d*3+2];h=F[f*2];f=F[f*2+1];k=F[e*2];l=F[e*2+1];e=F[g*2];i=F[g*2+1];g=N.faceVertexUvs[0];var n=[];n.push(new THREE.UV(h,f));n.push(new THREE.UV(k,l));n.push(new THREE.UV(e,
i));g.push(n)}}function t(b,c){var d,f,e,g,h,k,l,i,m,n,o=new Uint32Array(a,c,4*b);for(d=0;d<b;d++){f=o[d*4];e=o[d*4+1];g=o[d*4+2];h=o[d*4+3];k=F[f*2];f=F[f*2+1];l=F[e*2];m=F[e*2+1];i=F[g*2];n=F[g*2+1];g=F[h*2];e=F[h*2+1];h=N.faceVertexUvs[0];var j=[];j.push(new THREE.UV(k,f));j.push(new THREE.UV(l,m));j.push(new THREE.UV(i,n));j.push(new THREE.UV(g,e));h.push(j)}}function y(b,c,d){for(var f,e,g,h,c=new Uint32Array(a,c,3*b),k=new Uint16Array(a,d,b),d=0;d<b;d++){f=c[d*3];e=c[d*3+1];g=c[d*3+2];h=k[d];
N.faces.push(new THREE.Face3(f,e,g,null,null,h))}}function C(b,c,d){for(var f,e,g,h,k,c=new Uint32Array(a,c,4*b),l=new Uint16Array(a,d,b),d=0;d<b;d++){f=c[d*4];e=c[d*4+1];g=c[d*4+2];h=c[d*4+3];k=l[d];N.faces.push(new THREE.Face4(f,e,g,h,null,null,k))}}function L(b,c,d,f){for(var e,g,h,k,l,i,m,c=new Uint32Array(a,c,3*b),d=new Uint32Array(a,d,3*b),n=new Uint16Array(a,f,b),f=0;f<b;f++){e=c[f*3];g=c[f*3+1];h=c[f*3+2];l=d[f*3];i=d[f*3+1];m=d[f*3+2];k=n[f];var j=E[i*3],o=E[i*3+1];i=E[i*3+2];var p=E[m*3],
q=E[m*3+1];m=E[m*3+2];N.faces.push(new THREE.Face3(e,g,h,[new THREE.Vector3(E[l*3],E[l*3+1],E[l*3+2]),new THREE.Vector3(j,o,i),new THREE.Vector3(p,q,m)],null,k))}}function Q(b,c,d,f){for(var e,g,h,k,l,i,m,n,j,c=new Uint32Array(a,c,4*b),d=new Uint32Array(a,d,4*b),o=new Uint16Array(a,f,b),f=0;f<b;f++){e=c[f*4];g=c[f*4+1];h=c[f*4+2];k=c[f*4+3];i=d[f*4];m=d[f*4+1];n=d[f*4+2];j=d[f*4+3];l=o[f];var p=E[m*3],q=E[m*3+1];m=E[m*3+2];var r=E[n*3],s=E[n*3+1];n=E[n*3+2];var t=E[j*3],u=E[j*3+1];j=E[j*3+2];N.faces.push(new THREE.Face4(e,
g,h,k,[new THREE.Vector3(E[i*3],E[i*3+1],E[i*3+2]),new THREE.Vector3(p,q,m),new THREE.Vector3(r,s,n),new THREE.Vector3(t,u,j)],null,l))}}var N=this,r=0,E=[],F=[],H,P,O;THREE.Geometry.call(this);THREE.Loader.prototype.initMaterials(N,d,b);(function(a,b,c){for(var a=new Uint8Array(a,b,c),d="",f=0;f<c;f++)d=d+String.fromCharCode(a[b+f]);return d})(a,r,12);c=D(a,r+12);D(a,r+13);D(a,r+14);D(a,r+15);e=D(a,r+16);m=D(a,r+17);i=D(a,r+18);h=D(a,r+19);j=x(a,r+20);o=x(a,r+20+4);n=x(a,r+20+8);b=x(a,r+20+12);p=
x(a,r+20+16);l=x(a,r+20+20);q=x(a,r+20+24);u=x(a,r+20+28);s=x(a,r+20+32);z=x(a,r+20+36);A=x(a,r+20+40);r=r+c;c=e*3+h;O=e*4+h;H=b*c;P=p*(c+m*3);e=l*(c+i*3);h=q*(c+m*3+i*3);c=u*O;m=s*(O+m*4);i=z*(O+i*4);r=r+function(b){var b=new Float32Array(a,b,j*3),c,d,f,e;for(c=0;c<j;c++){d=b[c*3];f=b[c*3+1];e=b[c*3+2];N.vertices.push(new THREE.Vector3(d,f,e))}return j*3*Float32Array.BYTES_PER_ELEMENT}(r);r=r+function(b){if(o){var b=new Int8Array(a,b,o*3),c,d,f,e;for(c=0;c<o;c++){d=b[c*3];f=b[c*3+1];e=b[c*3+2];E.push(d/
127,f/127,e/127)}}return o*3*Int8Array.BYTES_PER_ELEMENT}(r);r=r+v(o*3);r=r+function(b){if(n){var b=new Float32Array(a,b,n*2),c,d,f;for(c=0;c<n;c++){d=b[c*2];f=b[c*2+1];F.push(d,f)}}return n*2*Float32Array.BYTES_PER_ELEMENT}(r);H=r+H+v(b*2);P=H+P+v(p*2);e=P+e+v(l*2);h=e+h+v(q*2);c=h+c+v(u*2);m=c+m+v(s*2);i=m+i+v(z*2);(function(a){if(l){var b=a+l*Uint32Array.BYTES_PER_ELEMENT*3;y(l,a,b+l*Uint32Array.BYTES_PER_ELEMENT*3);G(l,b)}})(P);(function(a){if(q){var b=a+q*Uint32Array.BYTES_PER_ELEMENT*3,c=b+
q*Uint32Array.BYTES_PER_ELEMENT*3;L(q,a,b,c+q*Uint32Array.BYTES_PER_ELEMENT*3);G(q,c)}})(e);(function(a){if(z){var b=a+z*Uint32Array.BYTES_PER_ELEMENT*4;C(z,a,b+z*Uint32Array.BYTES_PER_ELEMENT*4);t(z,b)}})(m);(function(a){if(A){var b=a+A*Uint32Array.BYTES_PER_ELEMENT*4,c=b+A*Uint32Array.BYTES_PER_ELEMENT*4;Q(A,a,b,c+A*Uint32Array.BYTES_PER_ELEMENT*4);t(A,c)}})(i);b&&y(b,r,r+b*Uint32Array.BYTES_PER_ELEMENT*3);(function(a){if(p){var b=a+p*Uint32Array.BYTES_PER_ELEMENT*3;L(p,a,b,b+p*Uint32Array.BYTES_PER_ELEMENT*
3)}})(H);u&&C(u,h,h+u*Uint32Array.BYTES_PER_ELEMENT*4);(function(a){if(s){var b=a+s*Uint32Array.BYTES_PER_ELEMENT*4;Q(s,a,b,b+s*Uint32Array.BYTES_PER_ELEMENT*4)}})(c);this.computeCentroids();this.computeFaceNormals();THREE.Loader.prototype.hasNormals(this)&&this.computeTangents()};e.prototype=new THREE.Geometry;e.prototype.constructor=e;b(new e(c))};THREE.JSONLoader=function(a){THREE.Loader.call(this,a)};THREE.JSONLoader.prototype=new THREE.Loader;THREE.JSONLoader.prototype.constructor=THREE.JSONLoader;
THREE.JSONLoader.prototype.load=function(a,b,c){c=c?c:this.extractUrlBase(a);this.onLoadStart();this.loadAjaxJSON(this,a,b,c)};
THREE.JSONLoader.prototype.loadAjaxJSON=function(a,b,c,d,e){var f=new XMLHttpRequest,g=0;f.onreadystatechange=function(){if(f.readyState===f.DONE)if(f.status===200||f.status===0){if(f.responseText){var k=JSON.parse(f.responseText);a.createModel(k,c,d)}else console.warn("THREE.JSONLoader: ["+b+"] seems to be unreachable or file there is empty");a.onLoadComplete()}else console.error("THREE.JSONLoader: Couldn't load ["+b+"] ["+f.status+"]");else if(f.readyState===f.LOADING){if(e){g===0&&(g=f.getResponseHeader("Content-Length"));
e({total:g,loaded:f.responseText.length})}}else f.readyState===f.HEADERS_RECEIVED&&(g=f.getResponseHeader("Content-Length"))};f.open("GET",b,true);f.overrideMimeType&&f.overrideMimeType("text/plain; charset=x-user-defined");f.setRequestHeader("Content-Type","text/plain");f.send(null)};
THREE.JSONLoader.prototype.createModel=function(a,b,c){var d=new THREE.Geometry,e=a.scale!==void 0?1/a.scale:1;this.initMaterials(d,a.materials,c);(function(b){var c,e,m,i,h,j,o,n,p,l,q,u,s,z,A=a.faces;j=a.vertices;var v=a.normals,D=a.colors,x=0;for(c=0;c<a.uvs.length;c++)a.uvs[c].length&&x++;for(c=0;c<x;c++){d.faceUvs[c]=[];d.faceVertexUvs[c]=[]}i=0;for(h=j.length;i<h;){o=new THREE.Vector3;o.x=j[i++]*b;o.y=j[i++]*b;o.z=j[i++]*b;d.vertices.push(o)}i=0;for(h=A.length;i<h;){b=A[i++];j=b&1;m=b&2;c=b&
4;e=b&8;n=b&16;o=b&32;l=b&64;b=b&128;if(j){q=new THREE.Face4;q.a=A[i++];q.b=A[i++];q.c=A[i++];q.d=A[i++];j=4}else{q=new THREE.Face3;q.a=A[i++];q.b=A[i++];q.c=A[i++];j=3}if(m){m=A[i++];q.materialIndex=m}m=d.faces.length;if(c)for(c=0;c<x;c++){u=a.uvs[c];p=A[i++];z=u[p*2];p=u[p*2+1];d.faceUvs[c][m]=new THREE.UV(z,p)}if(e)for(c=0;c<x;c++){u=a.uvs[c];s=[];for(e=0;e<j;e++){p=A[i++];z=u[p*2];p=u[p*2+1];s[e]=new THREE.UV(z,p)}d.faceVertexUvs[c][m]=s}if(n){n=A[i++]*3;e=new THREE.Vector3;e.x=v[n++];e.y=v[n++];
e.z=v[n];q.normal=e}if(o)for(c=0;c<j;c++){n=A[i++]*3;e=new THREE.Vector3;e.x=v[n++];e.y=v[n++];e.z=v[n];q.vertexNormals.push(e)}if(l){o=A[i++];o=new THREE.Color(D[o]);q.color=o}if(b)for(c=0;c<j;c++){o=A[i++];o=new THREE.Color(D[o]);q.vertexColors.push(o)}d.faces.push(q)}})(e);(function(){var b,c,e,m;if(a.skinWeights){b=0;for(c=a.skinWeights.length;b<c;b=b+2){e=a.skinWeights[b];m=a.skinWeights[b+1];d.skinWeights.push(new THREE.Vector4(e,m,0,0))}}if(a.skinIndices){b=0;for(c=a.skinIndices.length;b<c;b=
b+2){e=a.skinIndices[b];m=a.skinIndices[b+1];d.skinIndices.push(new THREE.Vector4(e,m,0,0))}}d.bones=a.bones;d.animation=a.animation})();(function(b){if(a.morphTargets!==void 0){var c,e,m,i,h,j;c=0;for(e=a.morphTargets.length;c<e;c++){d.morphTargets[c]={};d.morphTargets[c].name=a.morphTargets[c].name;d.morphTargets[c].vertices=[];h=d.morphTargets[c].vertices;j=a.morphTargets[c].vertices;m=0;for(i=j.length;m<i;m=m+3){var o=new THREE.Vector3;o.x=j[m]*b;o.y=j[m+1]*b;o.z=j[m+2]*b;h.push(o)}}}if(a.morphColors!==
void 0){c=0;for(e=a.morphColors.length;c<e;c++){d.morphColors[c]={};d.morphColors[c].name=a.morphColors[c].name;d.morphColors[c].colors=[];i=d.morphColors[c].colors;h=a.morphColors[c].colors;b=0;for(m=h.length;b<m;b=b+3){j=new THREE.Color(16755200);j.setRGB(h[b],h[b+1],h[b+2]);i.push(j)}}}})(e);d.computeCentroids();d.computeFaceNormals();this.hasNormals(d)&&d.computeTangents();b(d)};
THREE.SceneLoader=function(){this.onLoadStart=function(){};this.onLoadProgress=function(){};this.onLoadComplete=function(){};this.callbackSync=function(){};this.callbackProgress=function(){}};THREE.SceneLoader.prototype.constructor=THREE.SceneLoader;
THREE.SceneLoader.prototype.load=function(a,b){var c=this,d=new XMLHttpRequest;d.onreadystatechange=function(){if(d.readyState==4)if(d.status==200||d.status==0){var e=JSON.parse(d.responseText);c.createScene(e,b,a)}else console.error("THREE.SceneLoader: Couldn't load ["+a+"] ["+d.status+"]")};d.open("GET",a,true);d.overrideMimeType&&d.overrideMimeType("text/plain; charset=x-user-defined");d.setRequestHeader("Content-Type","text/plain");d.send(null)};
THREE.SceneLoader.prototype.createScene=function(a,b,c){function d(a,b){return b=="relativeToHTML"?a:i+"/"+a}function e(){var a;for(o in r.objects)if(!w.objects[o]){u=r.objects[o];if(u.geometry!==void 0){if(C=w.geometries[u.geometry]){a=false;L=w.materials[u.materials[0]];(a=L instanceof THREE.ShaderMaterial)&&C.computeTangents();v=u.position;D=u.rotation;x=u.quaternion;G=u.scale;s=u.matrix;x=0;u.materials.length==0&&(L=new THREE.MeshFaceMaterial);u.materials.length>1&&(L=new THREE.MeshFaceMaterial);
a=new THREE.Mesh(C,L);a.name=o;if(s){a.matrixAutoUpdate=false;a.matrix.set(s[0],s[1],s[2],s[3],s[4],s[5],s[6],s[7],s[8],s[9],s[10],s[11],s[12],s[13],s[14],s[15])}else{a.position.set(v[0],v[1],v[2]);if(x){a.quaternion.set(x[0],x[1],x[2],x[3]);a.useQuaternion=true}else a.rotation.set(D[0],D[1],D[2]);a.scale.set(G[0],G[1],G[2])}a.visible=u.visible;a.doubleSided=u.doubleSided;a.castShadow=u.castShadow;a.receiveShadow=u.receiveShadow;w.scene.add(a);w.objects[o]=a}}else{v=u.position;D=u.rotation;x=u.quaternion;
G=u.scale;x=0;a=new THREE.Object3D;a.name=o;a.position.set(v[0],v[1],v[2]);if(x){a.quaternion.set(x[0],x[1],x[2],x[3]);a.useQuaternion=true}else a.rotation.set(D[0],D[1],D[2]);a.scale.set(G[0],G[1],G[2]);a.visible=u.visible!==void 0?u.visible:false;w.scene.add(a);w.objects[o]=a;w.empties[o]=a}}}function f(a){return function(b){w.geometries[a]=b;e();F=F-1;m.onLoadComplete();k()}}function g(a){return function(b){w.geometries[a]=b}}function k(){m.callbackProgress({totalModels:P,totalTextures:O,loadedModels:P-
F,loadedTextures:O-H},w);m.onLoadProgress();F==0&&H==0&&b(w)}var m=this,i=THREE.Loader.prototype.extractUrlBase(c),h,j,o,n,p,l,q,u,s,z,A,v,D,x,G,t,y,C,L,Q,N,r,E,F,H,P,O,w;r=a;c=new THREE.BinaryLoader;E=new THREE.JSONLoader;H=F=0;w={scene:new THREE.Scene,geometries:{},materials:{},textures:{},objects:{},cameras:{},lights:{},fogs:{},empties:{}};if(r.transform){a=r.transform.position;z=r.transform.rotation;t=r.transform.scale;a&&w.scene.position.set(a[0],a[1],a[2]);z&&w.scene.rotation.set(z[0],z[1],
z[2]);t&&w.scene.scale.set(t[0],t[1],t[2]);if(a||z||t){w.scene.updateMatrix();w.scene.updateMatrixWorld()}}a=function(){H=H-1;k();m.onLoadComplete()};for(p in r.cameras){t=r.cameras[p];t.type=="perspective"?Q=new THREE.PerspectiveCamera(t.fov,t.aspect,t.near,t.far):t.type=="ortho"&&(Q=new THREE.OrthographicCamera(t.left,t.right,t.top,t.bottom,t.near,t.far));v=t.position;z=t.target;t=t.up;Q.position.set(v[0],v[1],v[2]);Q.target=new THREE.Vector3(z[0],z[1],z[2]);t&&Q.up.set(t[0],t[1],t[2]);w.cameras[p]=
Q}for(n in r.lights){z=r.lights[n];p=z.color!==void 0?z.color:16777215;Q=z.intensity!==void 0?z.intensity:1;if(z.type=="directional"){v=z.direction;A=new THREE.DirectionalLight(p,Q);A.position.set(v[0],v[1],v[2]);A.position.normalize()}else if(z.type=="point"){v=z.position;A=z.distance;A=new THREE.PointLight(p,Q,A);A.position.set(v[0],v[1],v[2])}else z.type=="ambient"&&(A=new THREE.AmbientLight(p));w.scene.add(A);w.lights[n]=A}for(l in r.fogs){n=r.fogs[l];n.type=="linear"?N=new THREE.Fog(0,n.near,
n.far):n.type=="exp2"&&(N=new THREE.FogExp2(0,n.density));t=n.color;N.color.setRGB(t[0],t[1],t[2]);w.fogs[l]=N}if(w.cameras&&r.defaults.camera)w.currentCamera=w.cameras[r.defaults.camera];if(w.fogs&&r.defaults.fog)w.scene.fog=w.fogs[r.defaults.fog];t=r.defaults.bgcolor;w.bgColor=new THREE.Color;w.bgColor.setRGB(t[0],t[1],t[2]);w.bgColorAlpha=r.defaults.bgalpha;for(h in r.geometries){l=r.geometries[h];if(l.type=="bin_mesh"||l.type=="ascii_mesh"){F=F+1;m.onLoadStart()}}P=F;for(h in r.geometries){l=
r.geometries[h];if(l.type=="cube"){C=new THREE.CubeGeometry(l.width,l.height,l.depth,l.segmentsWidth,l.segmentsHeight,l.segmentsDepth,null,l.flipped,l.sides);w.geometries[h]=C}else if(l.type=="plane"){C=new THREE.PlaneGeometry(l.width,l.height,l.segmentsWidth,l.segmentsHeight);w.geometries[h]=C}else if(l.type=="sphere"){C=new THREE.SphereGeometry(l.radius,l.segmentsWidth,l.segmentsHeight);w.geometries[h]=C}else if(l.type=="cylinder"){C=new THREE.CylinderGeometry(l.topRad,l.botRad,l.height,l.radSegs,
l.heightSegs);w.geometries[h]=C}else if(l.type=="torus"){C=new THREE.TorusGeometry(l.radius,l.tube,l.segmentsR,l.segmentsT);w.geometries[h]=C}else if(l.type=="icosahedron"){C=new THREE.IcosahedronGeometry(l.radius,l.subdivisions);w.geometries[h]=C}else if(l.type=="bin_mesh")c.load(d(l.url,r.urlBaseType),f(h));else if(l.type=="ascii_mesh")E.load(d(l.url,r.urlBaseType),f(h));else if(l.type=="embedded_mesh"){l=r.embeds[l.id];l.metadata=r.metadata;l&&E.createModel(l,g(h),"")}}for(q in r.textures){h=r.textures[q];
if(h.url instanceof Array){H=H+h.url.length;for(l=0;l<h.url.length;l++)m.onLoadStart()}else{H=H+1;m.onLoadStart()}}O=H;for(q in r.textures){h=r.textures[q];if(h.mapping!=void 0&&THREE[h.mapping]!=void 0)h.mapping=new THREE[h.mapping];if(h.url instanceof Array){l=[];for(N=0;N<h.url.length;N++)l[N]=d(h.url[N],r.urlBaseType);l=THREE.ImageUtils.loadTextureCube(l,h.mapping,a)}else{l=THREE.ImageUtils.loadTexture(d(h.url,r.urlBaseType),h.mapping,a);if(THREE[h.minFilter]!=void 0)l.minFilter=THREE[h.minFilter];
if(THREE[h.magFilter]!=void 0)l.magFilter=THREE[h.magFilter];if(h.repeat){l.repeat.set(h.repeat[0],h.repeat[1]);if(h.repeat[0]!=1)l.wrapS=THREE.RepeatWrapping;if(h.repeat[1]!=1)l.wrapT=THREE.RepeatWrapping}h.offset&&l.offset.set(h.offset[0],h.offset[1]);if(h.wrap){N={repeat:THREE.RepeatWrapping,mirror:THREE.MirroredRepeatWrapping};if(N[h.wrap[0]]!==void 0)l.wrapS=N[h.wrap[0]];if(N[h.wrap[1]]!==void 0)l.wrapT=N[h.wrap[1]]}}w.textures[q]=l}for(j in r.materials){s=r.materials[j];for(y in s.parameters)if(y==
"envMap"||y=="map"||y=="lightMap")s.parameters[y]=w.textures[s.parameters[y]];else if(y=="shading")s.parameters[y]=s.parameters[y]=="flat"?THREE.FlatShading:THREE.SmoothShading;else if(y=="blending")s.parameters[y]=THREE[s.parameters[y]]?THREE[s.parameters[y]]:THREE.NormalBlending;else if(y=="combine")s.parameters[y]=s.parameters[y]=="MixOperation"?THREE.MixOperation:THREE.MultiplyOperation;else if(y=="vertexColors")if(s.parameters[y]=="face")s.parameters[y]=THREE.FaceColors;else if(s.parameters[y])s.parameters[y]=
THREE.VertexColors;if(s.parameters.opacity!==void 0&&s.parameters.opacity<1)s.parameters.transparent=true;if(s.parameters.normalMap){q=THREE.ShaderUtils.lib.normal;a=THREE.UniformsUtils.clone(q.uniforms);h=s.parameters.color;l=s.parameters.specular;N=s.parameters.ambient;c=s.parameters.shininess;a.tNormal.texture=w.textures[s.parameters.normalMap];if(s.parameters.normalMapFactor)a.uNormalScale.value=s.parameters.normalMapFactor;if(s.parameters.map){a.tDiffuse.texture=s.parameters.map;a.enableDiffuse.value=
true}if(s.parameters.lightMap){a.tAO.texture=s.parameters.lightMap;a.enableAO.value=true}if(s.parameters.specularMap){a.tSpecular.texture=w.textures[s.parameters.specularMap];a.enableSpecular.value=true}a.uDiffuseColor.value.setHex(h);a.uSpecularColor.value.setHex(l);a.uAmbientColor.value.setHex(N);a.uShininess.value=c;if(s.parameters.opacity)a.uOpacity.value=s.parameters.opacity;L=new THREE.ShaderMaterial({fragmentShader:q.fragmentShader,vertexShader:q.vertexShader,uniforms:a,lights:true,fog:true})}else L=
new THREE[s.type](s.parameters);w.materials[j]=L}e();m.callbackSync(w);k()};
THREE.Material=function(a){a=a||{};this.id=THREE.MaterialCount++;this.name="";this.opacity=a.opacity!==void 0?a.opacity:1;this.transparent=a.transparent!==void 0?a.transparent:false;this.blending=a.blending!==void 0?a.blending:THREE.NormalBlending;this.blendSrc=a.blendSrc!==void 0?a.blendSrc:THREE.SrcAlphaFactor;this.blendDst=a.blendDst!==void 0?a.blendDst:THREE.OneMinusSrcAlphaFactor;this.blendEquation=a.blendEquation!==void 0?a.blendEquation:THREE.AddEquation;this.depthTest=a.depthTest!==void 0?
a.depthTest:true;this.depthWrite=a.depthWrite!==void 0?a.depthWrite:true;this.polygonOffset=a.polygonOffset!==void 0?a.polygonOffset:false;this.polygonOffsetFactor=a.polygonOffsetFactor!==void 0?a.polygonOffsetFactor:0;this.polygonOffsetUnits=a.polygonOffsetUnits!==void 0?a.polygonOffsetUnits:0;this.alphaTest=a.alphaTest!==void 0?a.alphaTest:0;this.overdraw=a.overdraw!==void 0?a.overdraw:false;this.needsUpdate=this.visible=true};THREE.MaterialCount=0;THREE.NoShading=0;THREE.FlatShading=1;
THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;THREE.VertexColors=2;THREE.NoBlending=0;THREE.NormalBlending=1;THREE.AdditiveBlending=2;THREE.SubtractiveBlending=3;THREE.MultiplyBlending=4;THREE.AdditiveAlphaBlending=5;THREE.CustomBlending=6;THREE.AddEquation=100;THREE.SubtractEquation=101;THREE.ReverseSubtractEquation=102;THREE.ZeroFactor=200;THREE.OneFactor=201;THREE.SrcColorFactor=202;THREE.OneMinusSrcColorFactor=203;THREE.SrcAlphaFactor=204;THREE.OneMinusSrcAlphaFactor=205;
THREE.DstAlphaFactor=206;THREE.OneMinusDstAlphaFactor=207;THREE.DstColorFactor=208;THREE.OneMinusDstColorFactor=209;THREE.SrcAlphaSaturateFactor=210;
THREE.LineBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.linewidth=a.linewidth!==void 0?a.linewidth:1;this.linecap=a.linecap!==void 0?a.linecap:"round";this.linejoin=a.linejoin!==void 0?a.linejoin:"round";this.vertexColors=a.vertexColors?a.vertexColors:false;this.fog=a.fog!==void 0?a.fog:true};THREE.LineBasicMaterial.prototype=new THREE.Material;THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.MeshBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.fog=a.fog!==void 0?a.fog:
true;this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:false;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:THREE.NoColors;this.skinning=a.skinning!==void 0?a.skinning:false;this.morphTargets=a.morphTargets!==
void 0?a.morphTargets:false};THREE.MeshBasicMaterial.prototype=new THREE.Material;THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.MeshLambertMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=a.ambient!==void 0?new THREE.Color(a.ambient):new THREE.Color(16777215);this.emissive=a.emissive!==void 0?new THREE.Color(a.emissive):new THREE.Color(0);this.wrapAround=a.wrapAround!==void 0?a.wrapAround:false;this.wrapRGB=new THREE.Vector3(1,1,1);this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=
a.envMap!==void 0?a.envMap:null;this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.fog=a.fog!==void 0?a.fog:true;this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:false;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?
a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:THREE.NoColors;this.skinning=a.skinning!==void 0?a.skinning:false;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:false;this.morphNormals=a.morphNormals!==void 0?a.morphNormals:false};THREE.MeshLambertMaterial.prototype=new THREE.Material;THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;
THREE.MeshPhongMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=a.ambient!==void 0?new THREE.Color(a.ambient):new THREE.Color(16777215);this.emissive=a.emissive!==void 0?new THREE.Color(a.emissive):new THREE.Color(0);this.specular=a.specular!==void 0?new THREE.Color(a.specular):new THREE.Color(1118481);this.shininess=a.shininess!==void 0?a.shininess:30;this.metal=a.metal!==void 0?a.metal:false;this.perPixel=
a.perPixel!==void 0?a.perPixel:false;this.wrapAround=a.wrapAround!==void 0?a.wrapAround:false;this.wrapRGB=new THREE.Vector3(1,1,1);this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.fog=a.fog!==void 0?a.fog:true;this.shading=
a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:false;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:THREE.NoColors;this.skinning=a.skinning!==void 0?a.skinning:false;this.morphTargets=a.morphTargets!==void 0?
a.morphTargets:false;this.morphNormals=a.morphNormals!==void 0?a.morphNormals:false};THREE.MeshPhongMaterial.prototype=new THREE.Material;THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;THREE.MeshDepthMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:false;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1};
THREE.MeshDepthMaterial.prototype=new THREE.Material;THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;THREE.MeshNormalMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading?a.shading:THREE.FlatShading;this.wireframe=a.wireframe?a.wireframe:false;this.wireframeLinewidth=a.wireframeLinewidth?a.wireframeLinewidth:1};THREE.MeshNormalMaterial.prototype=new THREE.Material;THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;
THREE.MeshFaceMaterial=function(){};THREE.ParticleBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.size=a.size!==void 0?a.size:1;this.sizeAttenuation=a.sizeAttenuation!==void 0?a.sizeAttenuation:true;this.vertexColors=a.vertexColors!==void 0?a.vertexColors:false;this.fog=a.fog!==void 0?a.fog:true};THREE.ParticleBasicMaterial.prototype=new THREE.Material;
THREE.ParticleBasicMaterial.prototype.constructor=THREE.ParticleBasicMaterial;THREE.ParticleCanvasMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.program=a.program!==void 0?a.program:function(){}};THREE.ParticleCanvasMaterial.prototype=new THREE.Material;THREE.ParticleCanvasMaterial.prototype.constructor=THREE.ParticleCanvasMaterial;
THREE.Texture=function(a,b,c,d,e,f,g,k){this.id=THREE.TextureCount++;this.image=a;this.mapping=b!==void 0?b:new THREE.UVMapping;this.wrapS=c!==void 0?c:THREE.ClampToEdgeWrapping;this.wrapT=d!==void 0?d:THREE.ClampToEdgeWrapping;this.magFilter=e!==void 0?e:THREE.LinearFilter;this.minFilter=f!==void 0?f:THREE.LinearMipMapLinearFilter;this.format=g!==void 0?g:THREE.RGBAFormat;this.type=k!==void 0?k:THREE.UnsignedByteType;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.generateMipmaps=
true;this.needsUpdate=this.premultiplyAlpha=false;this.onUpdate=null};THREE.Texture.prototype={constructor:THREE.Texture,clone:function(){var a=new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter,this.format,this.type);a.offset.copy(this.offset);a.repeat.copy(this.repeat);return a}};THREE.TextureCount=0;THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.UVMapping=function(){};THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};
THREE.SphericalReflectionMapping=function(){};THREE.SphericalRefractionMapping=function(){};THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;THREE.ShortType=11;THREE.UnsignedShortType=12;THREE.IntType=13;THREE.UnsignedIntType=14;THREE.FloatType=15;
THREE.AlphaFormat=16;THREE.RGBFormat=17;THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;THREE.DataTexture=function(a,b,c,d,e,f,g,k,m,i){THREE.Texture.call(this,null,f,g,k,m,i,d,e);this.image={data:a,width:b,height:c}};THREE.DataTexture.prototype=new THREE.Texture;THREE.DataTexture.prototype.constructor=THREE.DataTexture;
THREE.DataTexture.prototype.clone=function(){var a=new THREE.DataTexture(this.image.data,this.image.width,this.image.height,this.format,this.type,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter);a.offset.copy(this.offset);a.repeat.copy(this.repeat);return a};THREE.Particle=function(a){THREE.Object3D.call(this);this.material=a};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;
THREE.Line=function(a,b,c){THREE.Object3D.call(this);this.geometry=a;this.material=b!==void 0?b:new THREE.LineBasicMaterial({color:Math.random()*16777215});this.type=c!==void 0?c:THREE.LineStrip;this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere())};THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.material=b!==void 0?b:new THREE.MeshBasicMaterial({color:Math.random()*16777215,wireframe:true});if(this.geometry){this.geometry.boundingSphere||this.geometry.computeBoundingSphere();this.boundRadius=a.boundingSphere.radius;if(this.geometry.morphTargets.length){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};for(var c=0;c<this.geometry.morphTargets.length;c++){this.morphTargetInfluences.push(0);
this.morphTargetDictionary[this.geometry.morphTargets[c].name]=c}}}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;THREE.Mesh.prototype.getMorphTargetIndexByName=function(a){if(this.morphTargetDictionary[a]!==void 0)return this.morphTargetDictionary[a];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+a+" does not exist. Returning 0.");return 0};
THREE.Bone=function(a){THREE.Object3D.call(this);this.skin=a;this.skinMatrix=new THREE.Matrix4};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(a,b){this.matrixAutoUpdate&&(b=b|this.updateMatrix());if(b||this.matrixWorldNeedsUpdate){a?this.skinMatrix.multiply(a,this.matrix):this.skinMatrix.copy(this.matrix);this.matrixWorldNeedsUpdate=false;b=true}var c,d=this.children.length;for(c=0;c<d;c++)this.children[c].update(this.skinMatrix,b)};
THREE.Sprite=function(a){THREE.Object3D.call(this);this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:new THREE.Texture;this.blending=a.blending!==void 0?a.blending:THREE.NormalBlending;this.blendSrc=a.blendSrc!==void 0?a.blendSrc:THREE.SrcAlphaFactor;this.blendDst=a.blendDst!==void 0?a.blendDst:THREE.OneMinusSrcAlphaFactor;this.blendEquation=a.blendEquation!==void 0?a.blendEquation:THREE.AddEquation;this.useScreenCoordinates=a.useScreenCoordinates!==
void 0?a.useScreenCoordinates:true;this.mergeWith3D=a.mergeWith3D!==void 0?a.mergeWith3D:!this.useScreenCoordinates;this.affectedByDistance=a.affectedByDistance!==void 0?a.affectedByDistance:!this.useScreenCoordinates;this.scaleByViewport=a.scaleByViewport!==void 0?a.scaleByViewport:!this.affectedByDistance;this.alignment=a.alignment instanceof THREE.Vector2?a.alignment:THREE.SpriteAlignment.center;this.rotation3d=this.rotation;this.rotation=0;this.opacity=1;this.uvOffset=new THREE.Vector2(0,0);this.uvScale=
new THREE.Vector2(1,1)};THREE.Sprite.prototype=new THREE.Object3D;THREE.Sprite.prototype.constructor=THREE.Sprite;THREE.Sprite.prototype.updateMatrix=function(){this.matrix.setPosition(this.position);this.rotation3d.set(0,0,this.rotation);this.matrix.setRotationFromEuler(this.rotation3d);if(this.scale.x!==1||this.scale.y!==1){this.matrix.scale(this.scale);this.boundRadiusScale=Math.max(this.scale.x,this.scale.y)}this.matrixWorldNeedsUpdate=true};THREE.SpriteAlignment={};
THREE.SpriteAlignment.topLeft=new THREE.Vector2(1,-1);THREE.SpriteAlignment.topCenter=new THREE.Vector2(0,-1);THREE.SpriteAlignment.topRight=new THREE.Vector2(-1,-1);THREE.SpriteAlignment.centerLeft=new THREE.Vector2(1,0);THREE.SpriteAlignment.center=new THREE.Vector2(0,0);THREE.SpriteAlignment.centerRight=new THREE.Vector2(-1,0);THREE.SpriteAlignment.bottomLeft=new THREE.Vector2(1,1);THREE.SpriteAlignment.bottomCenter=new THREE.Vector2(0,1);
THREE.SpriteAlignment.bottomRight=new THREE.Vector2(-1,1);THREE.Scene=function(){THREE.Object3D.call(this);this.overrideMaterial=this.fog=null;this.matrixAutoUpdate=false;this.__objects=[];this.__lights=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;
THREE.Scene.prototype.__addObject=function(a){if(a instanceof THREE.Light)this.__lights.indexOf(a)===-1&&this.__lights.push(a);else if(!(a instanceof THREE.Camera||a instanceof THREE.Bone)&&this.__objects.indexOf(a)===-1){this.__objects.push(a);this.__objectsAdded.push(a);var b=this.__objectsRemoved.indexOf(a);b!==-1&&this.__objectsRemoved.splice(b,1)}for(b=0;b<a.children.length;b++)this.__addObject(a.children[b])};
THREE.Scene.prototype.__removeObject=function(a){if(a instanceof THREE.Light){var b=this.__lights.indexOf(a);b!==-1&&this.__lights.splice(b,1)}else if(!(a instanceof THREE.Camera)){b=this.__objects.indexOf(a);if(b!==-1){this.__objects.splice(b,1);this.__objectsRemoved.push(a);b=this.__objectsAdded.indexOf(a);b!==-1&&this.__objectsAdded.splice(b,1)}}for(b=0;b<a.children.length;b++)this.__removeObject(a.children[b])};
THREE.CanvasRenderer=function(a){function b(a){if(s!=a)l.globalAlpha=s=a}function c(a){if(z!=a){switch(a){case THREE.NormalBlending:l.globalCompositeOperation="source-over";break;case THREE.AdditiveBlending:l.globalCompositeOperation="lighter"}z=a}}function d(a){if(A!=a)l.strokeStyle=A=a}function e(a){if(v!=a)l.fillStyle=v=a}console.log("THREE.CanvasRenderer",THREE.REVISION);var a=a||{},f=this,g,k,m,i=new THREE.Projector,h=a.canvas!==void 0?a.canvas:document.createElement("canvas"),j,o,n,p,l=h.getContext("2d"),
q=new THREE.Color(0),u=0,s=1,z=0,A=null,v=null,D=null,x=null,G=null,t,y,C,L,Q=new THREE.RenderableVertex,N=new THREE.RenderableVertex,r,E,F,H,P,O,w,U,M,T,S,W,B=new THREE.Color,J=new THREE.Color,I=new THREE.Color,K=new THREE.Color,R=new THREE.Color,ja=[],da=[],ea,fa,ca,ka,za,Aa,Ba,Ca,Da,Ea,la=new THREE.Rectangle,$=new THREE.Rectangle,Z=new THREE.Rectangle,xa=false,Y=new THREE.Color,ma=new THREE.Color,na=new THREE.Color,V=new THREE.Vector3,ra,sa,ya,aa,ta,ua,a=16;ra=document.createElement("canvas");
ra.width=ra.height=2;sa=ra.getContext("2d");sa.fillStyle="rgba(0,0,0,1)";sa.fillRect(0,0,2,2);ya=sa.getImageData(0,0,2,2);aa=ya.data;ta=document.createElement("canvas");ta.width=ta.height=a;ua=ta.getContext("2d");ua.translate(-a/2,-a/2);ua.scale(a,a);a--;this.domElement=h;this.sortElements=this.sortObjects=this.autoClear=true;this.info={render:{vertices:0,faces:0}};this.setSize=function(a,b){j=a;o=b;n=Math.floor(j/2);p=Math.floor(o/2);h.width=j;h.height=o;la.set(-n,-p,n,p);$.set(-n,-p,n,p);s=1;z=
0;G=x=D=v=A=null};this.setClearColor=function(a,b){q.copy(a);u=b!==void 0?b:1;$.set(-n,-p,n,p)};this.setClearColorHex=function(a,b){q.setHex(a);u=b!==void 0?b:1;$.set(-n,-p,n,p)};this.clear=function(){l.setTransform(1,0,0,-1,n,p);if(!$.isEmpty()){$.minSelf(la);$.inflate(2);u<1&&l.clearRect(Math.floor($.getX()),Math.floor($.getY()),Math.floor($.getWidth()),Math.floor($.getHeight()));if(u>0){c(THREE.NormalBlending);b(1);e("rgba("+Math.floor(q.r*255)+","+Math.floor(q.g*255)+","+Math.floor(q.b*255)+","+
u+")");l.fillRect(Math.floor($.getX()),Math.floor($.getY()),Math.floor($.getWidth()),Math.floor($.getHeight()))}$.empty()}};this.render=function(a,h){function j(a){var b,c,d,e;Y.setRGB(0,0,0);ma.setRGB(0,0,0);na.setRGB(0,0,0);b=0;for(c=a.length;b<c;b++){d=a[b];e=d.color;if(d instanceof THREE.AmbientLight){Y.r=Y.r+e.r;Y.g=Y.g+e.g;Y.b=Y.b+e.b}else if(d instanceof THREE.DirectionalLight){ma.r=ma.r+e.r;ma.g=ma.g+e.g;ma.b=ma.b+e.b}else if(d instanceof THREE.PointLight){na.r=na.r+e.r;na.g=na.g+e.g;na.b=
na.b+e.b}}}function o(a,b,c,d){var e,f,g,h,l,i;e=0;for(f=a.length;e<f;e++){g=a[e];h=g.color;if(g instanceof THREE.DirectionalLight){l=g.matrixWorld.getPosition();i=c.dot(l);if(!(i<=0)){i=i*g.intensity;d.r=d.r+h.r*i;d.g=d.g+h.g*i;d.b=d.b+h.b*i}}else if(g instanceof THREE.PointLight){l=g.matrixWorld.getPosition();i=c.dot(V.sub(l,b).normalize());if(!(i<=0)){i=i*(g.distance==0?1:1-Math.min(b.distanceTo(l)/g.distance,1));if(i!=0){i=i*g.intensity;d.r=d.r+h.r*i;d.g=d.g+h.g*i;d.b=d.b+h.b*i}}}}}function q(a,
f,g){b(g.opacity);c(g.blending);var h,i,m,k,o,j;if(g instanceof THREE.ParticleBasicMaterial){if(g.map){k=g.map.image;o=k.width>>1;j=k.height>>1;g=f.scale.x*n;m=f.scale.y*p;h=g*o;i=m*j;Z.set(a.x-h,a.y-i,a.x+h,a.y+i);if(la.intersects(Z)){l.save();l.translate(a.x,a.y);l.rotate(-f.rotation);l.scale(g,-m);l.translate(-o,-j);l.drawImage(k,0,0);l.restore()}}}else if(g instanceof THREE.ParticleCanvasMaterial){h=f.scale.x*n;i=f.scale.y*p;Z.set(a.x-h,a.y-i,a.x+h,a.y+i);if(la.intersects(Z)){d(g.color.getContextStyle());
e(g.color.getContextStyle());l.save();l.translate(a.x,a.y);l.rotate(-f.rotation);l.scale(h,i);g.program(l);l.restore()}}}function s(a,e,f,g){b(g.opacity);c(g.blending);l.beginPath();l.moveTo(a.positionScreen.x,a.positionScreen.y);l.lineTo(e.positionScreen.x,e.positionScreen.y);l.closePath();if(g instanceof THREE.LineBasicMaterial){a=g.linewidth;if(D!=a)l.lineWidth=D=a;a=g.linecap;if(x!=a)l.lineCap=x=a;a=g.linejoin;if(G!=a)l.lineJoin=G=a;d(g.color.getContextStyle());l.stroke();Z.inflate(g.linewidth*
2)}}function u(a,d,e,g,i,l,k,j){f.info.render.vertices=f.info.render.vertices+3;f.info.render.faces++;b(j.opacity);c(j.blending);r=a.positionScreen.x;E=a.positionScreen.y;F=d.positionScreen.x;H=d.positionScreen.y;P=e.positionScreen.x;O=e.positionScreen.y;z(r,E,F,H,P,O);if(j instanceof THREE.MeshBasicMaterial)if(j.map){if(j.map.mapping instanceof THREE.UVMapping){ka=k.uvs[0];Fa(r,E,F,H,P,O,ka[g].u,ka[g].v,ka[i].u,ka[i].v,ka[l].u,ka[l].v,j.map)}}else if(j.envMap){if(j.envMap.mapping instanceof THREE.SphericalReflectionMapping){a=
h.matrixWorldInverse;V.copy(k.vertexNormalsWorld[g]);za=(V.x*a.elements[0]+V.y*a.elements[4]+V.z*a.elements[8])*0.5+0.5;Aa=-(V.x*a.elements[1]+V.y*a.elements[5]+V.z*a.elements[9])*0.5+0.5;V.copy(k.vertexNormalsWorld[i]);Ba=(V.x*a.elements[0]+V.y*a.elements[4]+V.z*a.elements[8])*0.5+0.5;Ca=-(V.x*a.elements[1]+V.y*a.elements[5]+V.z*a.elements[9])*0.5+0.5;V.copy(k.vertexNormalsWorld[l]);Da=(V.x*a.elements[0]+V.y*a.elements[4]+V.z*a.elements[8])*0.5+0.5;Ea=-(V.x*a.elements[1]+V.y*a.elements[5]+V.z*a.elements[9])*
0.5+0.5;Fa(r,E,F,H,P,O,za,Aa,Ba,Ca,Da,Ea,j.envMap)}}else j.wireframe?ha(j.color,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ga(j.color);else if(j instanceof THREE.MeshLambertMaterial)if(xa)if(!j.wireframe&&j.shading==THREE.SmoothShading&&k.vertexNormalsWorld.length==3){J.r=I.r=K.r=Y.r;J.g=I.g=K.g=Y.g;J.b=I.b=K.b=Y.b;o(m,k.v1.positionWorld,k.vertexNormalsWorld[0],J);o(m,k.v2.positionWorld,k.vertexNormalsWorld[1],I);o(m,k.v3.positionWorld,k.vertexNormalsWorld[2],K);J.r=Math.max(0,Math.min(j.color.r*
J.r,1));J.g=Math.max(0,Math.min(j.color.g*J.g,1));J.b=Math.max(0,Math.min(j.color.b*J.b,1));I.r=Math.max(0,Math.min(j.color.r*I.r,1));I.g=Math.max(0,Math.min(j.color.g*I.g,1));I.b=Math.max(0,Math.min(j.color.b*I.b,1));K.r=Math.max(0,Math.min(j.color.r*K.r,1));K.g=Math.max(0,Math.min(j.color.g*K.g,1));K.b=Math.max(0,Math.min(j.color.b*K.b,1));R.r=(I.r+K.r)*0.5;R.g=(I.g+K.g)*0.5;R.b=(I.b+K.b)*0.5;ca=va(J,I,K,R);pa(r,E,F,H,P,O,0,0,1,0,0,1,ca)}else{B.r=Y.r;B.g=Y.g;B.b=Y.b;o(m,k.centroidWorld,k.normalWorld,
B);B.r=Math.max(0,Math.min(j.color.r*B.r,1));B.g=Math.max(0,Math.min(j.color.g*B.g,1));B.b=Math.max(0,Math.min(j.color.b*B.b,1));j.wireframe?ha(B,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ga(B)}else j.wireframe?ha(j.color,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ga(j.color);else if(j instanceof THREE.MeshDepthMaterial){ea=h.near;fa=h.far;J.r=J.g=J.b=1-oa(a.positionScreen.z,ea,fa);I.r=I.g=I.b=1-oa(d.positionScreen.z,ea,fa);K.r=K.g=K.b=1-oa(e.positionScreen.z,
ea,fa);R.r=(I.r+K.r)*0.5;R.g=(I.g+K.g)*0.5;R.b=(I.b+K.b)*0.5;ca=va(J,I,K,R);pa(r,E,F,H,P,O,0,0,1,0,0,1,ca)}else if(j instanceof THREE.MeshNormalMaterial){B.r=qa(k.normalWorld.x);B.g=qa(k.normalWorld.y);B.b=qa(k.normalWorld.z);j.wireframe?ha(B,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ga(B)}}function v(a,d,e,g,i,l,k,j,n){f.info.render.vertices=f.info.render.vertices+4;f.info.render.faces++;b(j.opacity);c(j.blending);if(j.map||j.envMap){u(a,d,g,0,1,3,k,j,n);u(i,e,l,1,2,3,k,j,n)}else{r=
a.positionScreen.x;E=a.positionScreen.y;F=d.positionScreen.x;H=d.positionScreen.y;P=e.positionScreen.x;O=e.positionScreen.y;w=g.positionScreen.x;U=g.positionScreen.y;M=i.positionScreen.x;T=i.positionScreen.y;S=l.positionScreen.x;W=l.positionScreen.y;if(j instanceof THREE.MeshBasicMaterial){A(r,E,F,H,P,O,w,U);j.wireframe?ha(j.color,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ga(j.color)}else if(j instanceof THREE.MeshLambertMaterial)if(xa)if(!j.wireframe&&j.shading==THREE.SmoothShading&&
k.vertexNormalsWorld.length==4){J.r=I.r=K.r=R.r=Y.r;J.g=I.g=K.g=R.g=Y.g;J.b=I.b=K.b=R.b=Y.b;o(m,k.v1.positionWorld,k.vertexNormalsWorld[0],J);o(m,k.v2.positionWorld,k.vertexNormalsWorld[1],I);o(m,k.v4.positionWorld,k.vertexNormalsWorld[3],K);o(m,k.v3.positionWorld,k.vertexNormalsWorld[2],R);J.r=Math.max(0,Math.min(j.color.r*J.r,1));J.g=Math.max(0,Math.min(j.color.g*J.g,1));J.b=Math.max(0,Math.min(j.color.b*J.b,1));I.r=Math.max(0,Math.min(j.color.r*I.r,1));I.g=Math.max(0,Math.min(j.color.g*I.g,1));
I.b=Math.max(0,Math.min(j.color.b*I.b,1));K.r=Math.max(0,Math.min(j.color.r*K.r,1));K.g=Math.max(0,Math.min(j.color.g*K.g,1));K.b=Math.max(0,Math.min(j.color.b*K.b,1));R.r=Math.max(0,Math.min(j.color.r*R.r,1));R.g=Math.max(0,Math.min(j.color.g*R.g,1));R.b=Math.max(0,Math.min(j.color.b*R.b,1));ca=va(J,I,K,R);z(r,E,F,H,w,U);pa(r,E,F,H,w,U,0,0,1,0,0,1,ca);z(M,T,P,O,S,W);pa(M,T,P,O,S,W,1,0,1,1,0,1,ca)}else{B.r=Y.r;B.g=Y.g;B.b=Y.b;o(m,k.centroidWorld,k.normalWorld,B);B.r=Math.max(0,Math.min(j.color.r*
B.r,1));B.g=Math.max(0,Math.min(j.color.g*B.g,1));B.b=Math.max(0,Math.min(j.color.b*B.b,1));A(r,E,F,H,P,O,w,U);j.wireframe?ha(B,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ga(B)}else{A(r,E,F,H,P,O,w,U);j.wireframe?ha(j.color,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ga(j.color)}else if(j instanceof THREE.MeshNormalMaterial){B.r=qa(k.normalWorld.x);B.g=qa(k.normalWorld.y);B.b=qa(k.normalWorld.z);A(r,E,F,H,P,O,w,U);j.wireframe?ha(B,j.wireframeLinewidth,j.wireframeLinecap,
j.wireframeLinejoin):ga(B)}else if(j instanceof THREE.MeshDepthMaterial){ea=h.near;fa=h.far;J.r=J.g=J.b=1-oa(a.positionScreen.z,ea,fa);I.r=I.g=I.b=1-oa(d.positionScreen.z,ea,fa);K.r=K.g=K.b=1-oa(g.positionScreen.z,ea,fa);R.r=R.g=R.b=1-oa(e.positionScreen.z,ea,fa);ca=va(J,I,K,R);z(r,E,F,H,w,U);pa(r,E,F,H,w,U,0,0,1,0,0,1,ca);z(M,T,P,O,S,W);pa(M,T,P,O,S,W,1,0,1,1,0,1,ca)}}}function z(a,b,c,d,e,f){l.beginPath();l.moveTo(a,b);l.lineTo(c,d);l.lineTo(e,f);l.lineTo(a,b);l.closePath()}function A(a,b,c,d,e,
f,g,h){l.beginPath();l.moveTo(a,b);l.lineTo(c,d);l.lineTo(e,f);l.lineTo(g,h);l.lineTo(a,b);l.closePath()}function ha(a,b,c,e){if(D!=b)l.lineWidth=D=b;if(x!=c)l.lineCap=x=c;if(G!=e)l.lineJoin=G=e;d(a.getContextStyle());l.stroke();Z.inflate(b*2)}function ga(a){e(a.getContextStyle());l.fill()}function Fa(a,b,c,d,f,g,h,i,j,k,m,o,n){if(n.image.width!=0){if(n.needsUpdate==true||ja[n.id]==void 0){var p=n.wrapS==THREE.RepeatWrapping,q=n.wrapT==THREE.RepeatWrapping;ja[n.id]=l.createPattern(n.image,p&&q?"repeat":
p&&!q?"repeat-x":!p&&q?"repeat-y":"no-repeat");n.needsUpdate=false}e(ja[n.id]);var p=n.offset.x/n.repeat.x,q=n.offset.y/n.repeat.y,r=n.image.width*n.repeat.x,s=n.image.height*n.repeat.y,h=(h+p)*r,i=(i+q)*s,c=c-a,d=d-b,f=f-a,g=g-b,j=(j+p)*r-h,k=(k+q)*s-i,m=(m+p)*r-h,o=(o+q)*s-i,p=j*o-m*k;if(p==0){if(da[n.id]===void 0){b=document.createElement("canvas");b.width=n.image.width;b.height=n.image.height;b=b.getContext("2d");b.drawImage(n.image,0,0);da[n.id]=b.getImageData(0,0,n.image.width,n.image.height).data}b=
da[n.id];h=(Math.floor(h)+Math.floor(i)*n.image.width)*4;B.setRGB(b[h]/255,b[h+1]/255,b[h+2]/255);ga(B)}else{p=1/p;n=(o*c-k*f)*p;k=(o*d-k*g)*p;c=(j*f-m*c)*p;d=(j*g-m*d)*p;a=a-n*h-c*i;h=b-k*h-d*i;l.save();l.transform(n,k,c,d,a,h);l.fill();l.restore()}}}function pa(a,b,c,d,e,f,g,h,i,j,k,m,n){var o,p;o=n.width-1;p=n.height-1;g=g*o;h=h*p;c=c-a;d=d-b;e=e-a;f=f-b;i=i*o-g;j=j*p-h;k=k*o-g;m=m*p-h;p=1/(i*m-k*j);o=(m*c-j*e)*p;j=(m*d-j*f)*p;c=(i*e-k*c)*p;d=(i*f-k*d)*p;a=a-o*g-c*h;b=b-j*g-d*h;l.save();l.transform(o,
j,c,d,a,b);l.clip();l.drawImage(n,0,0);l.restore()}function va(a,b,c,d){var e=~~(a.r*255),f=~~(a.g*255),a=~~(a.b*255),g=~~(b.r*255),h=~~(b.g*255),b=~~(b.b*255),i=~~(c.r*255),j=~~(c.g*255),c=~~(c.b*255),k=~~(d.r*255),l=~~(d.g*255),d=~~(d.b*255);aa[0]=e<0?0:e>255?255:e;aa[1]=f<0?0:f>255?255:f;aa[2]=a<0?0:a>255?255:a;aa[4]=g<0?0:g>255?255:g;aa[5]=h<0?0:h>255?255:h;aa[6]=b<0?0:b>255?255:b;aa[8]=i<0?0:i>255?255:i;aa[9]=j<0?0:j>255?255:j;aa[10]=c<0?0:c>255?255:c;aa[12]=k<0?0:k>255?255:k;aa[13]=l<0?0:l>
255?255:l;aa[14]=d<0?0:d>255?255:d;sa.putImageData(ya,0,0);ua.drawImage(ra,0,0);return ta}function oa(a,b,c){a=(a-b)/(c-b);return a*a*(3-2*a)}function qa(a){a=(a+1)*0.5;return a<0?0:a>1?1:a}function ia(a,b){var c=b.x-a.x,d=b.y-a.y,e=c*c+d*d;if(e!=0){e=1/Math.sqrt(e);c=c*e;d=d*e;b.x=b.x+c;b.y=b.y+d;a.x=a.x-c;a.y=a.y-d}}var wa,Ga,X,ba;this.autoClear?this.clear():l.setTransform(1,0,0,-1,n,p);f.info.render.vertices=0;f.info.render.faces=0;g=i.projectScene(a,h,this.sortElements);k=g.elements;m=g.lights;
(xa=m.length>0)&&j(m);wa=0;for(Ga=k.length;wa<Ga;wa++){X=k[wa];ba=X.material;ba=ba instanceof THREE.MeshFaceMaterial?X.faceMaterial:ba;if(!(ba===void 0||ba.visible===false)){Z.empty();if(X instanceof THREE.RenderableParticle){t=X;t.x=t.x*n;t.y=t.y*p;q(t,X,ba,a)}else if(X instanceof THREE.RenderableLine){t=X.v1;y=X.v2;t.positionScreen.x=t.positionScreen.x*n;t.positionScreen.y=t.positionScreen.y*p;y.positionScreen.x=y.positionScreen.x*n;y.positionScreen.y=y.positionScreen.y*p;Z.addPoint(t.positionScreen.x,
t.positionScreen.y);Z.addPoint(y.positionScreen.x,y.positionScreen.y);la.intersects(Z)&&s(t,y,X,ba,a)}else if(X instanceof THREE.RenderableFace3){t=X.v1;y=X.v2;C=X.v3;t.positionScreen.x=t.positionScreen.x*n;t.positionScreen.y=t.positionScreen.y*p;y.positionScreen.x=y.positionScreen.x*n;y.positionScreen.y=y.positionScreen.y*p;C.positionScreen.x=C.positionScreen.x*n;C.positionScreen.y=C.positionScreen.y*p;if(ba.overdraw){ia(t.positionScreen,y.positionScreen);ia(y.positionScreen,C.positionScreen);ia(C.positionScreen,
t.positionScreen)}Z.add3Points(t.positionScreen.x,t.positionScreen.y,y.positionScreen.x,y.positionScreen.y,C.positionScreen.x,C.positionScreen.y);la.intersects(Z)&&u(t,y,C,0,1,2,X,ba,a)}else if(X instanceof THREE.RenderableFace4){t=X.v1;y=X.v2;C=X.v3;L=X.v4;t.positionScreen.x=t.positionScreen.x*n;t.positionScreen.y=t.positionScreen.y*p;y.positionScreen.x=y.positionScreen.x*n;y.positionScreen.y=y.positionScreen.y*p;C.positionScreen.x=C.positionScreen.x*n;C.positionScreen.y=C.positionScreen.y*p;L.positionScreen.x=
L.positionScreen.x*n;L.positionScreen.y=L.positionScreen.y*p;Q.positionScreen.copy(y.positionScreen);N.positionScreen.copy(L.positionScreen);if(ba.overdraw){ia(t.positionScreen,y.positionScreen);ia(y.positionScreen,L.positionScreen);ia(L.positionScreen,t.positionScreen);ia(C.positionScreen,Q.positionScreen);ia(C.positionScreen,N.positionScreen)}Z.addPoint(t.positionScreen.x,t.positionScreen.y);Z.addPoint(y.positionScreen.x,y.positionScreen.y);Z.addPoint(C.positionScreen.x,C.positionScreen.y);Z.addPoint(L.positionScreen.x,
L.positionScreen.y);la.intersects(Z)&&v(t,y,C,L,Q,N,X,ba,a)}$.addRectangle(Z)}}l.setTransform(1,0,0,1,0,0)}};THREE.RenderableVertex=function(){this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.visible=true};THREE.RenderableVertex.prototype.copy=function(a){this.positionWorld.copy(a.positionWorld);this.positionScreen.copy(a.positionScreen)};
THREE.RenderableFace3=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterial=this.material=null;this.uvs=[[]];this.z=null};
THREE.RenderableFace4=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.v4=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterial=this.material=null;this.uvs=[[]];this.z=null};THREE.RenderableObject=function(){this.z=this.object=null};
THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.material=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.material=null};
