// ThreeCanvas.js r42 - http://github.com/mrdoob/three.js
var THREE=THREE||{};if(!window.Int32Array)window.Int32Array=Array,window.Float32Array=Array;THREE.Color=function(a){this.setHex(a)};
THREE.Color.prototype={copy:function(a){this.r=a.r;this.g=a.g;this.b=a.b;this.hex=a.hex},setHex:function(a){this.hex=~~a&16777215;this.updateRGB()},setRGB:function(a,b,c){this.r=a;this.g=b;this.b=c;this.updateHex()},setHSV:function(a,b,c){var d,f,g,e,h,i;if(c==0)d=f=g=0;else switch(e=Math.floor(a*6),h=a*6-e,a=c*(1-b),i=c*(1-b*h),b=c*(1-b*(1-h)),e){case 1:d=i;f=c;g=a;break;case 2:d=a;f=c;g=b;break;case 3:d=a;f=i;g=c;break;case 4:d=b;f=a;g=c;break;case 5:d=c;f=a;g=i;break;case 6:case 0:d=c,f=b,g=a}this.setRGB(d,
f,g)},updateHex:function(){this.hex=~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},updateRGB:function(){this.r=(this.hex>>16&255)/255;this.g=(this.hex>>8&255)/255;this.b=(this.hex&255)/255},clone:function(){return new THREE.Color(this.hex)}};THREE.Vector2=function(a,b){this.set(a||0,b||0)};
THREE.Vector2.prototype={set:function(a,b){this.x=a;this.y=b;return this},copy:function(a){this.x=a.x;this.y=a.y;return this},clone:function(){return new THREE.Vector2(this.x,this.y)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;return this},divideScalar:function(a){a?
(this.x/=a,this.y/=a):this.set(0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var b=this.x-a.x,a=this.y-a.y;return b*b+a*a},setLength:function(a){return this.normalize().multiplyScalar(a)},
unit:function(){return this.normalize()},equals:function(a){return a.x==this.x&&a.y==this.y}};THREE.Vector3=function(a,b,c){this.set(a||0,b||0,c||0)};
THREE.Vector3.prototype={set:function(a,b,c){this.x=a;this.y=b;this.z=c;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;return this},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;return this},addScalar:function(a){this.x+=a;this.y+=a;this.z+=a;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;return this},subSelf:function(a){this.x-=
a.x;this.y-=a.y;this.z-=a.z;return this},multiply:function(a,b){this.x=a.x*b.x;this.y=a.y*b.y;this.z=a.z*b.z;return this},multiplySelf:function(a){this.x*=a.x;this.y*=a.y;this.z*=a.y;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;return this},divideSelf:function(a){return this.divide(this,a)},divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a):this.set(0,0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*
a.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.lengthSq())},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},cross:function(a,b){this.x=a.y*b.z-a.z*b.y;this.y=a.z*b.x-a.x*b.z;this.z=a.x*b.y-a.y*b.x;return this},crossSelf:function(a){return this.set(this.y*a.z-this.z*a.y,this.z*a.x-this.x*a.z,this.x*
a.y-this.y*a.x)},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){return(new THREE.Vector3).sub(this,a).lengthSq()},setPositionFromMatrix:function(a){this.x=a.n14;this.y=a.n24;this.z=a.n34},setRotationFromMatrix:function(a){var b=Math.cos(this.y);this.y=Math.asin(a.n13);Math.abs(b)>1.0E-5?(this.x=Math.atan2(-a.n23/b,a.n33/b),this.z=Math.atan2(-a.n12/b,a.n11/b)):(this.x=0,this.z=Math.atan2(a.n21,a.n22))},isZero:function(){return this.lengthSq()<1.0E-4}};
THREE.Vector4=function(a,b,c,d){this.set(a||0,b||0,c||0,d||1)};
THREE.Vector4.prototype={set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){return this.set(a.x,a.y,a.z,a.w||1)},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;this.w=a.w+b.w;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;this.w+=a.w;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;this.w=a.w-b.w;return this},subSelf:function(a){this.x-=
a.x;this.y-=a.y;this.z-=a.z;this.w-=a.w;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;this.w*=a;return this},divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a,this.w/=a):this.set(0,0,0,1);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z+this.w*a.w},lengthSq:function(){return this.dot(this)},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},
setLength:function(a){return this.normalize().multiplyScalar(a)},lerpSelf:function(a,b){this.x+=(a.x-this.x)*b;this.y+=(a.y-this.y)*b;this.z+=(a.z-this.z)*b;this.w+=(a.w-this.w)*b;return this}};THREE.Ray=function(a,b){this.origin=a||new THREE.Vector3;this.direction=b||new THREE.Vector3};
THREE.Ray.prototype={intersectScene:function(a){return this.intersectObjects(a.objects)},intersectObjects:function(a){var b,c,d=[];b=0;for(c=a.length;b<c;b++)d=d.concat(this.intersectObject(a[b]));d.sort(function(a,b){return a.distance-b.distance});return d},intersectObject:function(a){function b(a,b,c){var d,c=c.matrixWorld.getPosition();d=c.clone().subSelf(a).dot(b);a=a.clone().addSelf(b.clone().multiplyScalar(d));return c.distanceTo(a)}function c(a,b,c,d){var d=d.clone().subSelf(b),c=c.clone().subSelf(b),
f=a.clone().subSelf(b),a=d.dot(d),b=d.dot(c),d=d.dot(f),e=c.dot(c),c=c.dot(f),f=1/(a*e-b*b),e=(e*d-b*c)*f,a=(a*c-b*d)*f;return e>0&&a>0&&e+a<1}if(a instanceof THREE.Particle){var d=b(this.origin,this.direction,a);if(!d||d>a.scale.x)return[];return[{distance:d,point:a.position,face:null,object:a}]}else if(a instanceof THREE.Mesh){d=b(this.origin,this.direction,a);if(!d||d>a.geometry.boundingSphere.radius*Math.max(a.scale.x,Math.max(a.scale.y,a.scale.z)))return[];var f,g,e,h,i,l,m,j,n,o,k=a.geometry,
q=k.vertices,v=[],d=0;for(f=k.faces.length;d<f;d++)if(g=k.faces[d],n=this.origin.clone(),o=this.direction.clone(),l=a.matrixWorld,e=l.multiplyVector3(q[g.a].position.clone()),h=l.multiplyVector3(q[g.b].position.clone()),i=l.multiplyVector3(q[g.c].position.clone()),l=g instanceof THREE.Face4?l.multiplyVector3(q[g.d].position.clone()):null,m=a.matrixRotationWorld.multiplyVector3(g.normal.clone()),j=o.dot(m),a.doubleSided||(a.flipSided?j>0:j<0))if(m=m.dot((new THREE.Vector3).sub(e,n))/j,n=n.addSelf(o.multiplyScalar(m)),
g instanceof THREE.Face3)c(n,e,h,i)&&(g={distance:this.origin.distanceTo(n),point:n,face:g,object:a},v.push(g));else if(g instanceof THREE.Face4&&(c(n,e,h,l)||c(n,h,i,l)))g={distance:this.origin.distanceTo(n),point:n,face:g,object:a},v.push(g);return v}else return[]}};
THREE.Rectangle=function(){function a(){g=d-b;e=f-c}var b,c,d,f,g,e,h=!0;this.getX=function(){return b};this.getY=function(){return c};this.getWidth=function(){return g};this.getHeight=function(){return e};this.getLeft=function(){return b};this.getTop=function(){return c};this.getRight=function(){return d};this.getBottom=function(){return f};this.set=function(e,g,m,j){h=!1;b=e;c=g;d=m;f=j;a()};this.addPoint=function(e,g){h?(h=!1,b=e,c=g,d=e,f=g):(b=b<e?b:e,c=c<g?c:g,d=d>e?d:e,f=f>g?f:g);a()};this.add3Points=
function(e,g,m,j,n,o){h?(h=!1,b=e<m?e<n?e:n:m<n?m:n,c=g<j?g<o?g:o:j<o?j:o,d=e>m?e>n?e:n:m>n?m:n,f=g>j?g>o?g:o:j>o?j:o):(b=e<m?e<n?e<b?e:b:n<b?n:b:m<n?m<b?m:b:n<b?n:b,c=g<j?g<o?g<c?g:c:o<c?o:c:j<o?j<c?j:c:o<c?o:c,d=e>m?e>n?e>d?e:d:n>d?n:d:m>n?m>d?m:d:n>d?n:d,f=g>j?g>o?g>f?g:f:o>f?o:f:j>o?j>f?j:f:o>f?o:f);a()};this.addRectangle=function(e){h?(h=!1,b=e.getLeft(),c=e.getTop(),d=e.getRight(),f=e.getBottom()):(b=b<e.getLeft()?b:e.getLeft(),c=c<e.getTop()?c:e.getTop(),d=d>e.getRight()?d:e.getRight(),f=f>
e.getBottom()?f:e.getBottom());a()};this.inflate=function(e){b-=e;c-=e;d+=e;f+=e;a()};this.minSelf=function(e){b=b>e.getLeft()?b:e.getLeft();c=c>e.getTop()?c:e.getTop();d=d<e.getRight()?d:e.getRight();f=f<e.getBottom()?f:e.getBottom();a()};this.instersects=function(a){return Math.min(d,a.getRight())-Math.max(b,a.getLeft())>=0&&Math.min(f,a.getBottom())-Math.max(c,a.getTop())>=0};this.empty=function(){h=!0;f=d=c=b=0;a()};this.isEmpty=function(){return h}};THREE.Matrix3=function(){this.m=[]};
THREE.Matrix3.prototype={transpose:function(){var a,b=this.m;a=b[1];b[1]=b[3];b[3]=a;a=b[2];b[2]=b[6];b[6]=a;a=b[5];b[5]=b[7];b[7]=a;return this},transposeIntoArray:function(a){var b=this.m;a[0]=b[0];a[1]=b[3];a[2]=b[6];a[3]=b[1];a[4]=b[4];a[5]=b[7];a[6]=b[2];a[7]=b[5];a[8]=b[8];return this}};THREE.Matrix4=function(a,b,c,d,f,g,e,h,i,l,m,j,n,o,k,q){this.set(a||1,b||0,c||0,d||0,f||0,g||1,e||0,h||0,i||0,l||0,m||1,j||0,n||0,o||0,k||0,q||1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={set:function(a,b,c,d,f,g,e,h,i,l,m,j,n,o,k,q){this.n11=a;this.n12=b;this.n13=c;this.n14=d;this.n21=f;this.n22=g;this.n23=e;this.n24=h;this.n31=i;this.n32=l;this.n33=m;this.n34=j;this.n41=n;this.n42=o;this.n43=k;this.n44=q;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(a){this.set(a.n11,a.n12,a.n13,a.n14,a.n21,a.n22,a.n23,a.n24,a.n31,a.n32,a.n33,a.n34,a.n41,a.n42,a.n43,a.n44);return this},lookAt:function(a,b,c){var d=THREE.Matrix4.__v1,
f=THREE.Matrix4.__v2,g=THREE.Matrix4.__v3;g.sub(a,b).normalize();if(g.length()===0)g.z=1;d.cross(c,g).normalize();d.length()===0&&(g.x+=1.0E-4,d.cross(c,g).normalize());f.cross(g,d).normalize();this.n11=d.x;this.n12=f.x;this.n13=g.x;this.n21=d.y;this.n22=f.y;this.n23=g.y;this.n31=d.z;this.n32=f.z;this.n33=g.z;return this},multiplyVector3:function(a){var b=a.x,c=a.y,d=a.z,f=1/(this.n41*b+this.n42*c+this.n43*d+this.n44);a.x=(this.n11*b+this.n12*c+this.n13*d+this.n14)*f;a.y=(this.n21*b+this.n22*c+this.n23*
d+this.n24)*f;a.z=(this.n31*b+this.n32*c+this.n33*d+this.n34)*f;return a},multiplyVector4:function(a){var b=a.x,c=a.y,d=a.z,f=a.w;a.x=this.n11*b+this.n12*c+this.n13*d+this.n14*f;a.y=this.n21*b+this.n22*c+this.n23*d+this.n24*f;a.z=this.n31*b+this.n32*c+this.n33*d+this.n34*f;a.w=this.n41*b+this.n42*c+this.n43*d+this.n44*f;return a},rotateAxis:function(a){var b=a.x,c=a.y,d=a.z;a.x=b*this.n11+c*this.n12+d*this.n13;a.y=b*this.n21+c*this.n22+d*this.n23;a.z=b*this.n31+c*this.n32+d*this.n33;a.normalize();
return a},crossVector:function(a){var b=new THREE.Vector4;b.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;b.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;b.z=this.n31*a.x+this.n32*a.y+this.n33*a.z+this.n34*a.w;b.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return b},multiply:function(a,b){var c=a.n11,d=a.n12,f=a.n13,g=a.n14,e=a.n21,h=a.n22,i=a.n23,l=a.n24,m=a.n31,j=a.n32,n=a.n33,o=a.n34,k=a.n41,q=a.n42,v=a.n43,s=a.n44,J=b.n11,N=b.n12,x=b.n13,B=b.n14,p=b.n21,O=b.n22,
r=b.n23,u=b.n24,y=b.n31,R=b.n32,$=b.n33,Z=b.n34,C=b.n41,F=b.n42,L=b.n43,D=b.n44;this.n11=c*J+d*p+f*y+g*C;this.n12=c*N+d*O+f*R+g*F;this.n13=c*x+d*r+f*$+g*L;this.n14=c*B+d*u+f*Z+g*D;this.n21=e*J+h*p+i*y+l*C;this.n22=e*N+h*O+i*R+l*F;this.n23=e*x+h*r+i*$+l*L;this.n24=e*B+h*u+i*Z+l*D;this.n31=m*J+j*p+n*y+o*C;this.n32=m*N+j*O+n*R+o*F;this.n33=m*x+j*r+n*$+o*L;this.n34=m*B+j*u+n*Z+o*D;this.n41=k*J+q*p+v*y+s*C;this.n42=k*N+q*O+v*R+s*F;this.n43=k*x+q*r+v*$+s*L;this.n44=k*B+q*u+v*Z+s*D;return this},multiplyToArray:function(a,
b,c){this.multiply(a,b);c[0]=this.n11;c[1]=this.n21;c[2]=this.n31;c[3]=this.n41;c[4]=this.n12;c[5]=this.n22;c[6]=this.n32;c[7]=this.n42;c[8]=this.n13;c[9]=this.n23;c[10]=this.n33;c[11]=this.n43;c[12]=this.n14;c[13]=this.n24;c[14]=this.n34;c[15]=this.n44;return this},multiplySelf:function(a){this.multiply(this,a);return this},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=a;this.n14*=a;this.n21*=a;this.n22*=a;this.n23*=a;this.n24*=a;this.n31*=a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=
a;this.n42*=a;this.n43*=a;this.n44*=a;return this},determinant:function(){var a=this.n11,b=this.n12,c=this.n13,d=this.n14,f=this.n21,g=this.n22,e=this.n23,h=this.n24,i=this.n31,l=this.n32,m=this.n33,j=this.n34,n=this.n41,o=this.n42,k=this.n43,q=this.n44;return d*e*l*n-c*h*l*n-d*g*m*n+b*h*m*n+c*g*j*n-b*e*j*n-d*e*i*o+c*h*i*o+d*f*m*o-a*h*m*o-c*f*j*o+a*e*j*o+d*g*i*k-b*h*i*k-d*f*l*k+a*h*l*k+b*f*j*k-a*g*j*k-c*g*i*q+b*e*i*q+c*f*l*q-a*e*l*q-b*f*m*q+a*g*m*q},transpose:function(){var a;a=this.n21;this.n21=
this.n12;this.n12=a;a=this.n31;this.n31=this.n13;this.n13=a;a=this.n32;this.n32=this.n23;this.n23=a;a=this.n41;this.n41=this.n14;this.n14=a;a=this.n42;this.n42=this.n24;this.n24=a;a=this.n43;this.n43=this.n34;this.n43=a;return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;a.n41=this.n41;a.n42=this.n42;a.n43=this.n43;a.n44=
this.n44;return a},flatten:function(){this.flat[0]=this.n11;this.flat[1]=this.n21;this.flat[2]=this.n31;this.flat[3]=this.n41;this.flat[4]=this.n12;this.flat[5]=this.n22;this.flat[6]=this.n32;this.flat[7]=this.n42;this.flat[8]=this.n13;this.flat[9]=this.n23;this.flat[10]=this.n33;this.flat[11]=this.n43;this.flat[12]=this.n14;this.flat[13]=this.n24;this.flat[14]=this.n34;this.flat[15]=this.n44;return this.flat},flattenToArray:function(a){a[0]=this.n11;a[1]=this.n21;a[2]=this.n31;a[3]=this.n41;a[4]=
this.n12;a[5]=this.n22;a[6]=this.n32;a[7]=this.n42;a[8]=this.n13;a[9]=this.n23;a[10]=this.n33;a[11]=this.n43;a[12]=this.n14;a[13]=this.n24;a[14]=this.n34;a[15]=this.n44;return a},flattenToArrayOffset:function(a,b){a[b]=this.n11;a[b+1]=this.n21;a[b+2]=this.n31;a[b+3]=this.n41;a[b+4]=this.n12;a[b+5]=this.n22;a[b+6]=this.n32;a[b+7]=this.n42;a[b+8]=this.n13;a[b+9]=this.n23;a[b+10]=this.n33;a[b+11]=this.n43;a[b+12]=this.n14;a[b+13]=this.n24;a[b+14]=this.n34;a[b+15]=this.n44;return a},setTranslation:function(a,
b,c){this.set(1,0,0,a,0,1,0,b,0,0,1,c,0,0,0,1);return this},setScale:function(a,b,c){this.set(a,0,0,0,0,b,0,0,0,0,c,0,0,0,0,1);return this},setRotationX:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(1,0,0,0,0,b,-a,0,0,a,b,0,0,0,0,1);return this},setRotationY:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,0,a,0,0,1,0,0,-a,0,b,0,0,0,0,1);return this},setRotationZ:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,-a,0,0,a,b,0,0,0,0,1,0,0,0,0,1);return this},setRotationAxis:function(a,
b){var c=Math.cos(b),d=Math.sin(b),f=1-c,g=a.x,e=a.y,h=a.z,i=f*g,l=f*e;this.set(i*g+c,i*e-d*h,i*h+d*e,0,i*e+d*h,l*e+c,l*h-d*g,0,i*h-d*e,l*h+d*g,f*h*h+c,0,0,0,0,1);return this},setPosition:function(a){this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},getPosition:function(){if(!this.position)this.position=new THREE.Vector3;this.position.set(this.n14,this.n24,this.n34);return this.position},getColumnX:function(){if(!this.columnX)this.columnX=new THREE.Vector3;this.columnX.set(this.n11,this.n21,this.n31);
return this.columnX},getColumnY:function(){if(!this.columnY)this.columnY=new THREE.Vector3;this.columnY.set(this.n12,this.n22,this.n32);return this.columnY},getColumnZ:function(){if(!this.columnZ)this.columnZ=new THREE.Vector3;this.columnZ.set(this.n13,this.n23,this.n33);return this.columnZ},setRotationFromEuler:function(a,b){var c=a.x,d=a.y,f=a.z,g=Math.cos(c),c=Math.sin(c),e=Math.cos(d),d=Math.sin(d),h=Math.cos(f),f=Math.sin(f);switch(b){case "YXZ":var i=e*h,l=e*f,m=d*h,j=d*f;this.n11=i+j*c;this.n12=
m*c-l;this.n13=g*d;this.n21=g*f;this.n22=g*h;this.n23=-c;this.n31=l*c-m;this.n32=j+i*c;this.n33=g*e;break;case "ZXY":i=e*h;l=e*f;m=d*h;j=d*f;this.n11=i-j*c;this.n12=-g*f;this.n13=m+l*c;this.n21=l+m*c;this.n22=g*h;this.n23=j-i*c;this.n31=-g*d;this.n32=c;this.n33=g*e;break;case "ZYX":i=g*h;l=g*f;m=c*h;j=c*f;this.n11=e*h;this.n12=m*d-l;this.n13=i*d+j;this.n21=e*f;this.n22=j*d+i;this.n23=l*d-m;this.n31=-d;this.n32=c*e;this.n33=g*e;break;case "YZX":i=g*e;l=g*d;m=c*e;j=c*d;this.n11=e*h;this.n12=j-i*f;this.n13=
m*f+l;this.n21=f;this.n22=g*h;this.n23=-c*h;this.n31=-d*h;this.n32=l*f+m;this.n33=i-j*f;break;case "XZY":i=g*e;l=g*d;m=c*e;j=c*d;this.n11=e*h;this.n12=-f;this.n13=d*h;this.n21=i*f+j;this.n22=g*h;this.n23=l*f-m;this.n31=m*f-l;this.n32=c*h;this.n33=j*f+i;break;default:i=g*h,l=g*f,m=c*h,j=c*f,this.n11=e*h,this.n12=-e*f,this.n13=d,this.n21=l+m*d,this.n22=i-j*d,this.n23=-c*e,this.n31=j-i*d,this.n32=m+l*d,this.n33=g*e}return this},setRotationFromQuaternion:function(a){var b=a.x,c=a.y,d=a.z,f=a.w,g=b+b,
e=c+c,h=d+d,a=b*g,i=b*e;b*=h;var l=c*e;c*=h;d*=h;g*=f;e*=f;f*=h;this.n11=1-(l+d);this.n12=i-f;this.n13=b+e;this.n21=i+f;this.n22=1-(a+d);this.n23=c-g;this.n31=b-e;this.n32=c+g;this.n33=1-(a+l);return this},scale:function(a){var b=a.x,c=a.y,a=a.z;this.n11*=b;this.n12*=c;this.n13*=a;this.n21*=b;this.n22*=c;this.n23*=a;this.n31*=b;this.n32*=c;this.n33*=a;this.n41*=b;this.n42*=c;this.n43*=a;return this},extractPosition:function(a){this.n14=a.n14;this.n24=a.n24;this.n34=a.n34},extractRotation:function(a,
b){var c=1/b.x,d=1/b.y,f=1/b.z;this.n11=a.n11*c;this.n21=a.n21*c;this.n31=a.n31*c;this.n12=a.n12*d;this.n22=a.n22*d;this.n32=a.n32*d;this.n13=a.n13*f;this.n23=a.n23*f;this.n33=a.n33*f}};
THREE.Matrix4.makeInvert=function(a,b){var c=a.n11,d=a.n12,f=a.n13,g=a.n14,e=a.n21,h=a.n22,i=a.n23,l=a.n24,m=a.n31,j=a.n32,n=a.n33,o=a.n34,k=a.n41,q=a.n42,v=a.n43,s=a.n44;b===void 0&&(b=new THREE.Matrix4);b.n11=i*o*q-l*n*q+l*j*v-h*o*v-i*j*s+h*n*s;b.n12=g*n*q-f*o*q-g*j*v+d*o*v+f*j*s-d*n*s;b.n13=f*l*q-g*i*q+g*h*v-d*l*v-f*h*s+d*i*s;b.n14=g*i*j-f*l*j-g*h*n+d*l*n+f*h*o-d*i*o;b.n21=l*n*k-i*o*k-l*m*v+e*o*v+i*m*s-e*n*s;b.n22=f*o*k-g*n*k+g*m*v-c*o*v-f*m*s+c*n*s;b.n23=g*i*k-f*l*k-g*e*v+c*l*v+f*e*s-c*i*s;b.n24=
f*l*m-g*i*m+g*e*n-c*l*n-f*e*o+c*i*o;b.n31=h*o*k-l*j*k+l*m*q-e*o*q-h*m*s+e*j*s;b.n32=g*j*k-d*o*k-g*m*q+c*o*q+d*m*s-c*j*s;b.n33=f*l*k-g*h*k+g*e*q-c*l*q-d*e*s+c*h*s;b.n34=g*h*m-d*l*m-g*e*j+c*l*j+d*e*o-c*h*o;b.n41=i*j*k-h*n*k-i*m*q+e*n*q+h*m*v-e*j*v;b.n42=d*n*k-f*j*k+f*m*q-c*n*q-d*m*v+c*j*v;b.n43=f*h*k-d*i*k-f*e*q+c*i*q+d*e*v-c*h*v;b.n44=d*i*m-f*h*m+f*e*j-c*i*j-d*e*n+c*h*n;b.multiplyScalar(1/a.determinant());return b};
THREE.Matrix4.makeInvert3x3=function(a){var b=a.m33,c=b.m,d=a.n33*a.n22-a.n32*a.n23,f=-a.n33*a.n21+a.n31*a.n23,g=a.n32*a.n21-a.n31*a.n22,e=-a.n33*a.n12+a.n32*a.n13,h=a.n33*a.n11-a.n31*a.n13,i=-a.n32*a.n11+a.n31*a.n12,l=a.n23*a.n12-a.n22*a.n13,m=-a.n23*a.n11+a.n21*a.n13,j=a.n22*a.n11-a.n21*a.n12,a=a.n11*d+a.n21*e+a.n31*l;a==0&&console.error("THREE.Matrix4.makeInvert3x3: Matrix not invertible.");a=1/a;c[0]=a*d;c[1]=a*f;c[2]=a*g;c[3]=a*e;c[4]=a*h;c[5]=a*i;c[6]=a*l;c[7]=a*m;c[8]=a*j;return b};
THREE.Matrix4.makeFrustum=function(a,b,c,d,f,g){var e;e=new THREE.Matrix4;e.n11=2*f/(b-a);e.n12=0;e.n13=(b+a)/(b-a);e.n14=0;e.n21=0;e.n22=2*f/(d-c);e.n23=(d+c)/(d-c);e.n24=0;e.n31=0;e.n32=0;e.n33=-(g+f)/(g-f);e.n34=-2*g*f/(g-f);e.n41=0;e.n42=0;e.n43=-1;e.n44=0;return e};THREE.Matrix4.makePerspective=function(a,b,c,d){var f,a=c*Math.tan(a*Math.PI/360);f=-a;return THREE.Matrix4.makeFrustum(f*b,a*b,f,a,c,d)};
THREE.Matrix4.makeOrtho=function(a,b,c,d,f,g){var e,h,i,l;e=new THREE.Matrix4;h=b-a;i=c-d;l=g-f;e.n11=2/h;e.n12=0;e.n13=0;e.n14=-((b+a)/h);e.n21=0;e.n22=2/i;e.n23=0;e.n24=-((c+d)/i);e.n31=0;e.n32=0;e.n33=-2/l;e.n34=-((g+f)/l);e.n41=0;e.n42=0;e.n43=0;e.n44=1;return e};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;
THREE.Object3D=function(){this.parent=void 0;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.eulerOrder="XYZ";this.scale=new THREE.Vector3(1,1,1);this.flipSided=this.doubleSided=this.dynamic=!1;this.renderDepth=null;this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixWorldNeedsUpdate=this.matrixAutoUpdate=!0;this.quaternion=new THREE.Quaternion;
this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;this.visible=!0;this._vector=new THREE.Vector3;this.name=""};
THREE.Object3D.prototype={translate:function(a,b){this.matrix.rotateAxis(b);this.position.addSelf(b.multiplyScalar(a))},translateX:function(a){this.translate(a,this._vector.set(1,0,0))},translateY:function(a){this.translate(a,this._vector.set(0,1,0))},translateZ:function(a){this.translate(a,this._vector.set(0,0,1))},lookAt:function(a){this.matrix.lookAt(a,this.position,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)},addChild:function(a){if(this.children.indexOf(a)===
-1){a.parent!==void 0&&a.parent.removeChild(a);a.parent=this;this.children.push(a);for(var b=this;b.parent!==void 0;)b=b.parent;b!==void 0&&b instanceof THREE.Scene&&b.addChildRecurse(a)}},removeChild:function(a){var b=this.children.indexOf(a);if(b!==-1)a.parent=void 0,this.children.splice(b,1)},getChildByName:function(a,b){var c,d,f;c=0;for(d=this.children.length;c<d;c++){f=this.children[c];if(f.name===a)return f;if(b&&(f=f.getChildByName(a,b),f!==void 0))return f}},updateMatrix:function(){this.matrix.setPosition(this.position);
this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation,this.eulerOrder);if(this.scale.x!==1||this.scale.y!==1||this.scale.z!==1)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z));this.matrixWorldNeedsUpdate=!0},update:function(a,b,c){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||b)a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix),
this.matrixRotationWorld.extractRotation(this.matrixWorld,this.scale),this.matrixWorldNeedsUpdate=!1,b=!0;for(var a=0,d=this.children.length;a<d;a++)this.children[a].update(this.matrixWorld,b,c)}};THREE.Quaternion=function(a,b,c,d){this.set(a||0,b||0,c||0,d!==void 0?d:1)};
THREE.Quaternion.prototype={set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w;return this},setFromEuler:function(a){var b=0.5*Math.PI/360,c=a.x*b,d=a.y*b,f=a.z*b,a=Math.cos(d),d=Math.sin(d),b=Math.cos(-f),f=Math.sin(-f),g=Math.cos(c),c=Math.sin(c),e=a*b,h=d*f;this.w=e*g-h*c;this.x=e*c+h*g;this.y=d*b*g+a*f*c;this.z=a*f*g-d*b*c;return this},setFromAxisAngle:function(a,b){var c=b/2,d=Math.sin(c);this.x=a.x*d;this.y=a.y*
d;this.z=a.z*d;this.w=Math.cos(c);return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var a=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);a==0?this.w=this.z=this.y=this.x=0:(a=1/a,this.x*=a,this.y*=a,this.z*=a,this.w*=a);return this},
multiplySelf:function(a){var b=this.x,c=this.y,d=this.z,f=this.w,g=a.x,e=a.y,h=a.z,a=a.w;this.x=b*a+f*g+c*h-d*e;this.y=c*a+f*e+d*g-b*h;this.z=d*a+f*h+b*e-c*g;this.w=f*a-b*g-c*e-d*h;return this},multiply:function(a,b){this.x=a.x*b.w+a.y*b.z-a.z*b.y+a.w*b.x;this.y=-a.x*b.z+a.y*b.w+a.z*b.x+a.w*b.y;this.z=a.x*b.y-a.y*b.x+a.z*b.w+a.w*b.z;this.w=-a.x*b.x-a.y*b.y-a.z*b.z+a.w*b.w;return this},multiplyVector3:function(a,b){b||(b=a);var c=a.x,d=a.y,f=a.z,g=this.x,e=this.y,h=this.z,i=this.w,l=i*c+e*f-h*d,m=
i*d+h*c-g*f,j=i*f+g*d-e*c,c=-g*c-e*d-h*f;b.x=l*i+c*-g+m*-h-j*-e;b.y=m*i+c*-e+j*-g-l*-h;b.z=j*i+c*-h+l*-e-m*-g;return b}};
THREE.Quaternion.slerp=function(a,b,c,d){var f=a.w*b.w+a.x*b.x+a.y*b.y+a.z*b.z;if(Math.abs(f)>=1)return c.w=a.w,c.x=a.x,c.y=a.y,c.z=a.z,c;var g=Math.acos(f),e=Math.sqrt(1-f*f);if(Math.abs(e)<0.001)return c.w=0.5*(a.w+b.w),c.x=0.5*(a.x+b.x),c.y=0.5*(a.y+b.y),c.z=0.5*(a.z+b.z),c;f=Math.sin((1-d)*g)/e;d=Math.sin(d*g)/e;c.w=a.w*f+b.w*d;c.x=a.x*f+b.x*d;c.y=a.y*f+b.y*d;c.z=a.z*f+b.z*d;return c};THREE.Vertex=function(a){this.position=a||new THREE.Vector3};
THREE.Face3=function(a,b,c,d,f,g){this.a=a;this.b=b;this.c=c;this.normal=d instanceof THREE.Vector3?d:new THREE.Vector3;this.vertexNormals=d instanceof Array?d:[];this.color=f instanceof THREE.Color?f:new THREE.Color;this.vertexColors=f instanceof Array?f:[];this.vertexTangents=[];this.materials=g instanceof Array?g:[g];this.centroid=new THREE.Vector3};
THREE.Face4=function(a,b,c,d,f,g,e){this.a=a;this.b=b;this.c=c;this.d=d;this.normal=f instanceof THREE.Vector3?f:new THREE.Vector3;this.vertexNormals=f instanceof Array?f:[];this.color=g instanceof THREE.Color?g:new THREE.Color;this.vertexColors=g instanceof Array?g:[];this.vertexTangents=[];this.materials=e instanceof Array?e:[e];this.centroid=new THREE.Vector3};THREE.UV=function(a,b){this.set(a||0,b||0)};
THREE.UV.prototype={set:function(a,b){this.u=a;this.v=b;return this},copy:function(a){this.set(a.u,a.v);return this}};THREE.Geometry=function(){this.id="Geometry"+THREE.GeometryIdCounter++;this.vertices=[];this.colors=[];this.faces=[];this.edges=[];this.faceUvs=[[]];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphColors=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.hasTangents=!1};
THREE.Geometry.prototype={computeCentroids:function(){var a,b,c;a=0;for(b=this.faces.length;a<b;a++)c=this.faces[a],c.centroid.set(0,0,0),c instanceof THREE.Face3?(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),c.centroid.divideScalar(3)):c instanceof THREE.Face4&&(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),
c.centroid.addSelf(this.vertices[c.d].position),c.centroid.divideScalar(4))},computeFaceNormals:function(a){var b,c,d,f,g,e,h=new THREE.Vector3,i=new THREE.Vector3;d=0;for(f=this.faces.length;d<f;d++){g=this.faces[d];if(a&&g.vertexNormals.length){h.set(0,0,0);b=0;for(c=g.vertexNormals.length;b<c;b++)h.addSelf(g.vertexNormals[b]);h.divideScalar(3)}else b=this.vertices[g.a],c=this.vertices[g.b],e=this.vertices[g.c],h.sub(e.position,c.position),i.sub(b.position,c.position),h.crossSelf(i);h.isZero()||
h.normalize();g.normal.copy(h)}},computeVertexNormals:function(){var a,b,c,d;if(this.__tmpVertices==void 0){d=this.__tmpVertices=Array(this.vertices.length);a=0;for(b=this.vertices.length;a<b;a++)d[a]=new THREE.Vector3;a=0;for(b=this.faces.length;a<b;a++)if(c=this.faces[a],c instanceof THREE.Face3)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(c instanceof THREE.Face4)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}else{d=
this.__tmpVertices;a=0;for(b=this.vertices.length;a<b;a++)d[a].set(0,0,0)}a=0;for(b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof THREE.Face3?(d[c.a].addSelf(c.normal),d[c.b].addSelf(c.normal),d[c.c].addSelf(c.normal)):c instanceof THREE.Face4&&(d[c.a].addSelf(c.normal),d[c.b].addSelf(c.normal),d[c.c].addSelf(c.normal),d[c.d].addSelf(c.normal));a=0;for(b=this.vertices.length;a<b;a++)d[a].normalize();a=0;for(b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof THREE.Face3?(c.vertexNormals[0].copy(d[c.a]),
c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c])):c instanceof THREE.Face4&&(c.vertexNormals[0].copy(d[c.a]),c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c]),c.vertexNormals[3].copy(d[c.d]))},computeTangents:function(){function a(a,b,c,d,f,g,r){h=a.vertices[b].position;i=a.vertices[c].position;l=a.vertices[d].position;m=e[f];j=e[g];n=e[r];o=i.x-h.x;k=l.x-h.x;q=i.y-h.y;v=l.y-h.y;s=i.z-h.z;J=l.z-h.z;N=j.u-m.u;x=n.u-m.u;B=j.v-m.v;p=n.v-m.v;O=1/(N*p-x*B);R.set((p*o-B*k)*
O,(p*q-B*v)*O,(p*s-B*J)*O);$.set((N*k-x*o)*O,(N*v-x*q)*O,(N*J-x*s)*O);u[b].addSelf(R);u[c].addSelf(R);u[d].addSelf(R);y[b].addSelf($);y[c].addSelf($);y[d].addSelf($)}var b,c,d,f,g,e,h,i,l,m,j,n,o,k,q,v,s,J,N,x,B,p,O,r,u=[],y=[],R=new THREE.Vector3,$=new THREE.Vector3,Z=new THREE.Vector3,C=new THREE.Vector3,F=new THREE.Vector3;b=0;for(c=this.vertices.length;b<c;b++)u[b]=new THREE.Vector3,y[b]=new THREE.Vector3;b=0;for(c=this.faces.length;b<c;b++)g=this.faces[b],e=this.faceVertexUvs[0][b],g instanceof
THREE.Face3?a(this,g.a,g.b,g.c,0,1,2):g instanceof THREE.Face4&&(a(this,g.a,g.b,g.c,0,1,2),a(this,g.a,g.b,g.d,0,1,3));var L=["a","b","c","d"];b=0;for(c=this.faces.length;b<c;b++){g=this.faces[b];for(d=0;d<g.vertexNormals.length;d++)F.copy(g.vertexNormals[d]),f=g[L[d]],r=u[f],Z.copy(r),Z.subSelf(F.multiplyScalar(F.dot(r))).normalize(),C.cross(g.vertexNormals[d],r),f=C.dot(y[f]),f=f<0?-1:1,g.vertexTangents[d]=new THREE.Vector4(Z.x,Z.y,Z.z,f)}this.hasTangents=!0},computeBoundingBox:function(){var a;
if(this.vertices.length>0){this.boundingBox={x:[this.vertices[0].position.x,this.vertices[0].position.x],y:[this.vertices[0].position.y,this.vertices[0].position.y],z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var b=1,c=this.vertices.length;b<c;b++){a=this.vertices[b];if(a.position.x<this.boundingBox.x[0])this.boundingBox.x[0]=a.position.x;else if(a.position.x>this.boundingBox.x[1])this.boundingBox.x[1]=a.position.x;if(a.position.y<this.boundingBox.y[0])this.boundingBox.y[0]=a.position.y;
else if(a.position.y>this.boundingBox.y[1])this.boundingBox.y[1]=a.position.y;if(a.position.z<this.boundingBox.z[0])this.boundingBox.z[0]=a.position.z;else if(a.position.z>this.boundingBox.z[1])this.boundingBox.z[1]=a.position.z}}},computeBoundingSphere:function(){for(var a=0,b=0,c=this.vertices.length;b<c;b++)a=Math.max(a,this.vertices[b].position.length());this.boundingSphere={radius:a}},computeEdgeFaces:function(){function a(a,b){return Math.min(a,b)+"_"+Math.max(a,b)}function b(a,b,c){a[b]===
void 0?(a[b]={set:{},array:[]},a[b].set[c]=1,a[b].array.push(c)):a[b].set[c]===void 0&&(a[b].set[c]=1,a[b].array.push(c))}var c,d,f,g,e,h={};c=0;for(d=this.faces.length;c<d;c++)e=this.faces[c],e instanceof THREE.Face3?(f=a(e.a,e.b),b(h,f,c),f=a(e.b,e.c),b(h,f,c),f=a(e.a,e.c),b(h,f,c)):e instanceof THREE.Face4&&(f=a(e.b,e.d),b(h,f,c),f=a(e.a,e.b),b(h,f,c),f=a(e.a,e.d),b(h,f,c),f=a(e.b,e.c),b(h,f,c),f=a(e.c,e.d),b(h,f,c));c=0;for(d=this.edges.length;c<d;c++){e=this.edges[c];f=e.vertexIndices[0];g=e.vertexIndices[1];
e.faceIndices=h[a(f,g)].array;for(f=0;f<e.faceIndices.length;f++)g=e.faceIndices[f],e.faces.push(this.faces[g])}}};THREE.GeometryIdCounter=0;THREE.Camera=function(a,b,c,d,f){THREE.Object3D.call(this);this.fov=a||50;this.aspect=b||1;this.near=c||0.1;this.far=d||2E3;this.target=f||new THREE.Object3D;this.useTarget=!0;this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=null;this.updateProjectionMatrix()};THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;
THREE.Camera.prototype.supr=THREE.Object3D.prototype;THREE.Camera.prototype.translate=function(a,b){this.matrix.rotateAxis(b);b.multiplyScalar(a);this.position.addSelf(b);this.target.position.addSelf(b)};
THREE.Camera.prototype.updateProjectionMatrix=function(){if(this.fullWidth){var a=this.fullWidth/this.fullHeight,b=Math.tan(this.fov*Math.PI/360)*this.near,c=-b,d=a*c,a=Math.abs(a*b-d),c=Math.abs(b-c);this.projectionMatrix=THREE.Matrix4.makeFrustum(d+this.x*a/this.fullWidth,d+(this.x+this.width)*a/this.fullWidth,b-(this.y+this.height)*c/this.fullHeight,b-this.y*c/this.fullHeight,this.near,this.far)}else this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,this.far)};
THREE.Camera.prototype.setViewOffset=function(a,b,c,d,f,g){this.fullWidth=a;this.fullHeight=b;this.x=c;this.y=d;this.width=f;this.height=g;this.updateProjectionMatrix()};
THREE.Camera.prototype.update=function(a,b,c){if(this.useTarget)this.matrix.lookAt(this.position,this.target.position,this.up),this.matrix.setPosition(this.position),a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix),THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse),b=!0;else if(this.matrixAutoUpdate&&this.updateMatrix(),b||this.matrixWorldNeedsUpdate)a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=
!1,b=!0,THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse);for(a=0;a<this.children.length;a++)this.children[a].update(this.matrixWorld,b,c)};THREE.Light=function(a){THREE.Object3D.call(this);this.color=new THREE.Color(a)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;
THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;THREE.DirectionalLight=function(a,b,c,d){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.intensity=b||1;this.distance=c||0;this.castShadow=d!==void 0?d:!1};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.PointLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3;this.intensity=b||1;this.distance=c||0};
THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;
THREE.Material=function(a){this.id=THREE.MaterialCounter.value++;a=a||{};this.opacity=a.opacity!==void 0?a.opacity:1;this.transparent=a.transparent!==void 0?a.transparent:!1;this.blending=a.blending!==void 0?a.blending:THREE.NormalBlending;this.depthTest=a.depthTest!==void 0?a.depthTest:!0;this.polygonOffset=a.polygonOffset!==void 0?a.polygonOffset:!1;this.polygonOffsetFactor=a.polygonOffsetFactor!==void 0?a.polygonOffsetFactor:0;this.polygonOffsetUnits=a.polygonOffsetUnits!==void 0?a.polygonOffsetUnits:
0};THREE.NoShading=0;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;THREE.VertexColors=2;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;THREE.MultiplyBlending=3;THREE.AdditiveAlphaBlending=4;THREE.MaterialCounter={value:0};THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};THREE.LatitudeReflectionMapping=function(){};THREE.LatitudeRefractionMapping=function(){};THREE.SphericalReflectionMapping=function(){};
THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};THREE.LineBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.linewidth=a.linewidth!==void 0?a.linewidth:1;this.linecap=a.linecap!==void 0?a.linecap:"round";this.linejoin=a.linejoin!==void 0?a.linejoin:"round";this.vertexColors=a.vertexColors?a.vertexColors:!1};THREE.LineBasicMaterial.prototype=new THREE.Material;
THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.MeshBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.shading=a.shading!==
void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:!1};
THREE.MeshBasicMaterial.prototype=new THREE.Material;THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.MeshLambertMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.shading=a.shading!==
void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:!1};
THREE.MeshLambertMaterial.prototype=new THREE.Material;THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;
THREE.MeshPhongMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=a.ambient!==void 0?new THREE.Color(a.ambient):new THREE.Color(328965);this.specular=a.specular!==void 0?new THREE.Color(a.specular):new THREE.Color(1118481);this.shininess=a.shininess!==void 0?a.shininess:30;this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;
this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==
void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:!1};THREE.MeshPhongMaterial.prototype=new THREE.Material;THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;
THREE.MeshDepthMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1};THREE.MeshDepthMaterial.prototype=new THREE.Material;THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;
THREE.MeshNormalMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading?a.shading:THREE.FlatShading;this.wireframe=a.wireframe?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth?a.wireframeLinewidth:1};THREE.MeshNormalMaterial.prototype=new THREE.Material;THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;THREE.MeshFaceMaterial=function(){};
THREE.ParticleBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.size=a.size!==void 0?a.size:1;this.sizeAttenuation=a.sizeAttenuation!==void 0?a.sizeAttenuation:!0;this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1};THREE.ParticleBasicMaterial.prototype=new THREE.Material;THREE.ParticleBasicMaterial.prototype.constructor=THREE.ParticleBasicMaterial;
THREE.ParticleCanvasMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.program=a.program!==void 0?a.program:function(){}};THREE.ParticleCanvasMaterial.prototype=new THREE.Material;THREE.ParticleCanvasMaterial.prototype.constructor=THREE.ParticleCanvasMaterial;
THREE.Texture=function(a,b,c,d,f,g){this.image=a;this.mapping=b!==void 0?b:new THREE.UVMapping;this.wrapS=c!==void 0?c:THREE.ClampToEdgeWrapping;this.wrapT=d!==void 0?d:THREE.ClampToEdgeWrapping;this.magFilter=f!==void 0?f:THREE.LinearFilter;this.minFilter=g!==void 0?g:THREE.LinearMipMapLinearFilter;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.needsUpdate=!1};
THREE.Texture.prototype={clone:function(){return new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter)}};THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;
THREE.ShortType=11;THREE.UnsignedShortType=12;THREE.IntType=13;THREE.UnsignedIntType=14;THREE.FloatType=15;THREE.AlphaFormat=16;THREE.RGBFormat=17;THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;THREE.Particle=function(a){THREE.Object3D.call(this);this.materials=a instanceof Array?a:[a]};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;
THREE.Line=function(a,b,c){THREE.Object3D.call(this);this.geometry=a;this.materials=b instanceof Array?b:[b];this.type=c!=void 0?c:THREE.LineStrip};THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.materials=b&&b.length?b:[b];this.overdraw=!1;if(this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere(),this.boundRadius=a.boundingSphere.radius,this.geometry.morphTargets.length)){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};for(var c=0;c<this.geometry.morphTargets.length;c++)this.morphTargetInfluences.push(0),this.morphTargetDictionary[this.geometry.morphTargets[c].name]=
c}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;THREE.Mesh.prototype.getMorphTargetIndexByName=function(a){if(this.morphTargetDictionary[a]!==void 0)return this.morphTargetDictionary[a];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+a+" does not exist. Returning 0.");return 0};
THREE.Bone=function(a){THREE.Object3D.call(this);this.skin=a;this.skinMatrix=new THREE.Matrix4;this.hasNoneBoneChildren=!1};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(a,b,c){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixWorldNeedsUpdate)a?this.skinMatrix.multiply(a,this.matrix):this.skinMatrix.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,b=!0;var d,f=this.children.length;if(this.hasNoneBoneChildren){this.matrixWorld.multiply(this.skin.matrixWorld,this.skinMatrix);for(d=0;d<f;d++)a=this.children[d],a instanceof THREE.Bone?a.update(this.skinMatrix,b,c):a.update(this.matrixWorld,!0,c)}else for(d=0;d<f;d++)this.children[d].update(this.skinMatrix,
b,c)};THREE.Bone.prototype.addChild=function(a){if(this.children.indexOf(a)===-1&&(a.parent!==void 0&&a.parent.removeChild(a),a.parent=this,this.children.push(a),!(a instanceof THREE.Bone)))this.hasNoneBoneChildren=!0};THREE.Scene=function(){THREE.Object3D.call(this);this.matrixAutoUpdate=!1;this.collisions=this.overrideMaterial=this.fog=null;this.objects=[];this.lights=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;
THREE.Scene.prototype.supr=THREE.Object3D.prototype;THREE.Scene.prototype.addChild=function(a){this.supr.addChild.call(this,a);this.addChildRecurse(a)};THREE.Scene.prototype.addChildRecurse=function(a){if(a instanceof THREE.Light)this.lights.indexOf(a)===-1&&this.lights.push(a);else if(!(a instanceof THREE.Camera||a instanceof THREE.Bone)&&this.objects.indexOf(a)===-1)this.objects.push(a),this.__objectsAdded.push(a);for(var b=0;b<a.children.length;b++)this.addChildRecurse(a.children[b])};
THREE.Scene.prototype.removeChild=function(a){this.supr.removeChild.call(this,a);this.removeChildRecurse(a)};THREE.Scene.prototype.removeChildRecurse=function(a){if(a instanceof THREE.Light){var b=this.lights.indexOf(a);b!==-1&&this.lights.splice(b,1)}else a instanceof THREE.Camera||(b=this.objects.indexOf(a),b!==-1&&(this.objects.splice(b,1),this.__objectsRemoved.push(a)));for(b=0;b<a.children.length;b++)this.removeChildRecurse(a.children[b])};THREE.Scene.prototype.addObject=THREE.Scene.prototype.addChild;
THREE.Scene.prototype.removeObject=THREE.Scene.prototype.removeChild;THREE.Scene.prototype.addLight=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeLight=THREE.Scene.prototype.removeChild;
THREE.Projector=function(){function a(){var a=i[h]=i[h]||new THREE.RenderableVertex;h++;return a}function b(a,b){return b.z-a.z}function c(a,b){var c=0,d=1,e=a.z+a.w,f=b.z+b.w,g=-a.z+a.w,h=-b.z+b.w;return e>=0&&f>=0&&g>=0&&h>=0?!0:e<0&&f<0||g<0&&h<0?!1:(e<0?c=Math.max(c,e/(e-f)):f<0&&(d=Math.min(d,e/(e-f))),g<0?c=Math.max(c,g/(g-h)):h<0&&(d=Math.min(d,g/(g-h))),d<c?!1:(a.lerpSelf(b,c),b.lerpSelf(a,1-d),!0))}var d,f,g=[],e,h,i=[],l,m,j=[],n,o=[],k,q,v=[],s,J,N=[],x=new THREE.Vector4,B=new THREE.Vector4,
p=new THREE.Matrix4,O=new THREE.Matrix4,r=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],u=new THREE.Vector4,y=new THREE.Vector4;this.projectVector=function(a,b){p.multiply(b.projectionMatrix,b.matrixWorldInverse);p.multiplyVector3(a);return a};this.unprojectVector=function(a,b){p.multiply(b.matrixWorld,THREE.Matrix4.makeInvert(b.projectionMatrix));p.multiplyVector3(a);return a};this.projectObjects=function(a,c,e){var c=[],h,l,k;f=0;l=
a.objects;a=0;for(h=l.length;a<h;a++){k=l[a];var i;if(!(i=!k.visible))if(i=k instanceof THREE.Mesh){a:{i=void 0;for(var m=k.matrixWorld,n=-k.geometry.boundingSphere.radius*Math.max(k.scale.x,Math.max(k.scale.y,k.scale.z)),j=0;j<6;j++)if(i=r[j].x*m.n14+r[j].y*m.n24+r[j].z*m.n34+r[j].w,i<=n){i=!1;break a}i=!0}i=!i}if(!i)i=g[f]=g[f]||new THREE.RenderableObject,f++,d=i,x.copy(k.position),p.multiplyVector3(x),d.object=k,d.z=x.z,c.push(d)}e&&c.sort(b);return c};this.projectScene=function(d,f,g){var C=[],
F=f.near,L=f.far,D,G,z,P,w,M,K,S,x,t,H,E,I,T,W,ca,X;J=q=n=m=0;f.matrixAutoUpdate&&f.update(void 0,!0);d.update(void 0,!1,f);p.multiply(f.projectionMatrix,f.matrixWorldInverse);r[0].set(p.n41-p.n11,p.n42-p.n12,p.n43-p.n13,p.n44-p.n14);r[1].set(p.n41+p.n11,p.n42+p.n12,p.n43+p.n13,p.n44+p.n14);r[2].set(p.n41+p.n21,p.n42+p.n22,p.n43+p.n23,p.n44+p.n24);r[3].set(p.n41-p.n21,p.n42-p.n22,p.n43-p.n23,p.n44-p.n24);r[4].set(p.n41-p.n31,p.n42-p.n32,p.n43-p.n33,p.n44-p.n34);r[5].set(p.n41+p.n31,p.n42+p.n32,p.n43+
p.n33,p.n44+p.n34);for(D=0;D<6;D++)x=r[D],x.divideScalar(Math.sqrt(x.x*x.x+x.y*x.y+x.z*x.z));x=this.projectObjects(d,f,!0);d=0;for(D=x.length;d<D;d++)if(t=x[d].object,t.visible)if(H=t.matrixWorld,E=t.matrixRotationWorld,I=t.materials,T=t.overdraw,h=0,t instanceof THREE.Mesh){W=t.geometry;P=W.vertices;ca=W.faces;W=W.faceVertexUvs;G=0;for(z=P.length;G<z;G++)e=a(),e.positionWorld.copy(P[G].position),H.multiplyVector3(e.positionWorld),e.positionScreen.copy(e.positionWorld),p.multiplyVector4(e.positionScreen),
e.positionScreen.x/=e.positionScreen.w,e.positionScreen.y/=e.positionScreen.w,e.visible=e.positionScreen.z>F&&e.positionScreen.z<L;P=0;for(G=ca.length;P<G;P++){z=ca[P];if(z instanceof THREE.Face3)if(w=i[z.a],M=i[z.b],K=i[z.c],w.visible&&M.visible&&K.visible&&(t.doubleSided||t.flipSided!=(K.positionScreen.x-w.positionScreen.x)*(M.positionScreen.y-w.positionScreen.y)-(K.positionScreen.y-w.positionScreen.y)*(M.positionScreen.x-w.positionScreen.x)<0))S=j[m]=j[m]||new THREE.RenderableFace3,m++,l=S,l.v1.copy(w),
l.v2.copy(M),l.v3.copy(K);else continue;else if(z instanceof THREE.Face4)if(w=i[z.a],M=i[z.b],K=i[z.c],S=i[z.d],w.visible&&M.visible&&K.visible&&S.visible&&(t.doubleSided||t.flipSided!=((S.positionScreen.x-w.positionScreen.x)*(M.positionScreen.y-w.positionScreen.y)-(S.positionScreen.y-w.positionScreen.y)*(M.positionScreen.x-w.positionScreen.x)<0||(M.positionScreen.x-K.positionScreen.x)*(S.positionScreen.y-K.positionScreen.y)-(M.positionScreen.y-K.positionScreen.y)*(S.positionScreen.x-K.positionScreen.x)<
0)))X=o[n]=o[n]||new THREE.RenderableFace4,n++,l=X,l.v1.copy(w),l.v2.copy(M),l.v3.copy(K),l.v4.copy(S);else continue;l.normalWorld.copy(z.normal);E.multiplyVector3(l.normalWorld);l.centroidWorld.copy(z.centroid);H.multiplyVector3(l.centroidWorld);l.centroidScreen.copy(l.centroidWorld);p.multiplyVector3(l.centroidScreen);K=z.vertexNormals;w=0;for(M=K.length;w<M;w++)S=l.vertexNormalsWorld[w],S.copy(K[w]),E.multiplyVector3(S);w=0;for(M=W.length;w<M;w++)if(X=W[w][P]){K=0;for(S=X.length;K<S;K++)l.uvs[w][K]=
X[K]}l.meshMaterials=I;l.faceMaterials=z.materials;l.overdraw=T;l.z=l.centroidScreen.z;C.push(l)}}else if(t instanceof THREE.Line){O.multiply(p,H);P=t.geometry.vertices;w=a();w.positionScreen.copy(P[0].position);O.multiplyVector4(w.positionScreen);G=1;for(z=P.length;G<z;G++)if(w=a(),w.positionScreen.copy(P[G].position),O.multiplyVector4(w.positionScreen),M=i[h-2],u.copy(w.positionScreen),y.copy(M.positionScreen),c(u,y))u.multiplyScalar(1/u.w),y.multiplyScalar(1/y.w),H=v[q]=v[q]||new THREE.RenderableLine,
q++,k=H,k.v1.positionScreen.copy(u),k.v2.positionScreen.copy(y),k.z=Math.max(u.z,y.z),k.materials=t.materials,C.push(k)}else if(t instanceof THREE.Particle&&(B.set(t.matrixWorld.n14,t.matrixWorld.n24,t.matrixWorld.n34,1),p.multiplyVector4(B),B.z/=B.w,B.z>0&&B.z<1))H=N[J]=N[J]||new THREE.RenderableParticle,J++,s=H,s.x=B.x/B.w,s.y=B.y/B.w,s.z=B.z,s.rotation=t.rotation.z,s.scale.x=t.scale.x*Math.abs(s.x-(B.x+f.projectionMatrix.n11)/(B.w+f.projectionMatrix.n14)),s.scale.y=t.scale.y*Math.abs(s.y-(B.y+
f.projectionMatrix.n22)/(B.w+f.projectionMatrix.n24)),s.materials=t.materials,C.push(s);g&&C.sort(b);return C}};
THREE.CanvasRenderer=function(a){function b(a){if(s!=a)k.globalAlpha=s=a}function c(a){if(J!=a){switch(a){case THREE.NormalBlending:k.globalCompositeOperation="source-over";break;case THREE.AdditiveBlending:k.globalCompositeOperation="lighter";break;case THREE.SubtractiveBlending:k.globalCompositeOperation="darker"}J=a}}function d(a){if(N!=a.hex)N=a.hex,k.strokeStyle="#"+g(N.toString(16))}function f(a){if(x!=a.hex)x=a.hex,k.fillStyle="#"+g(x.toString(16))}function g(a){for(;a.length<6;)a="0"+a;return a}
var e=this,h=null,i=new THREE.Projector,a=a||{},l=a.canvas!==void 0?a.canvas:document.createElement("canvas"),m,j,n,o,k=l.getContext("2d"),q=new THREE.Color(0),v=0,s=1,J=0,N=null,x=null,B=null,p=null,O=null,r,u,y,R,$=new THREE.RenderableVertex,Z=new THREE.RenderableVertex,C,F,L,D,G,z,P,w,M,K,S,oa,t=new THREE.Color(0),H=new THREE.Color(0),E=new THREE.Color(0),I=new THREE.Color(0),T=new THREE.Color(0),W,ca,X,aa,Ba,Ca,Da,Ea,Fa,Ga,ka=new THREE.Rectangle,da=new THREE.Rectangle,V=new THREE.Rectangle,ya=
!1,ba=new THREE.Color,Y=new THREE.Color,sa=new THREE.Color,ta=new THREE.Color,Q=new THREE.Vector3,pa,qa,za,ea,ra,ua,a=16;pa=document.createElement("canvas");pa.width=pa.height=2;qa=pa.getContext("2d");qa.fillStyle="rgba(0,0,0,1)";qa.fillRect(0,0,2,2);za=qa.getImageData(0,0,2,2);ea=za.data;ra=document.createElement("canvas");ra.width=ra.height=a;ua=ra.getContext("2d");ua.translate(-a/2,-a/2);ua.scale(a,a);a--;this.domElement=l;this.sortElements=this.sortObjects=this.autoClear=!0;this.data={vertices:0,
faces:0};this.setSize=function(a,b){m=a;j=b;n=m/2;o=j/2;l.width=m;l.height=j;ka.set(-n,-o,n,o);s=1;J=0;O=p=B=x=N=null};this.setClearColor=function(a,b){q=a;v=b};this.setClearColorHex=function(a,b){q.setHex(a);v=b};this.clear=function(){k.setTransform(1,0,0,-1,n,o);if(!da.isEmpty())da.inflate(1),da.minSelf(ka),q.hex==0&&v==0?k.clearRect(da.getX(),da.getY(),da.getWidth(),da.getHeight()):(c(THREE.NormalBlending),b(1),k.fillStyle="rgba("+Math.floor(q.r*255)+","+Math.floor(q.g*255)+","+Math.floor(q.b*
255)+","+v+")",k.fillRect(da.getX(),da.getY(),da.getWidth(),da.getHeight())),da.empty()};this.render=function(a,g){function l(a){var b,c,d,f=a.lights;Y.setRGB(0,0,0);sa.setRGB(0,0,0);ta.setRGB(0,0,0);a=0;for(b=f.length;a<b;a++)c=f[a],d=c.color,c instanceof THREE.AmbientLight?(Y.r+=d.r,Y.g+=d.g,Y.b+=d.b):c instanceof THREE.DirectionalLight?(sa.r+=d.r,sa.g+=d.g,sa.b+=d.b):c instanceof THREE.PointLight&&(ta.r+=d.r,ta.g+=d.g,ta.b+=d.b)}function m(a,b,c,d){var f,e,g,h,l=a.lights,a=0;for(f=l.length;a<f;a++)e=
l[a],g=e.color,e instanceof THREE.DirectionalLight?(h=c.dot(e.position),h<=0||(h*=e.intensity,d.r+=g.r*h,d.g+=g.g*h,d.b+=g.b*h)):e instanceof THREE.PointLight&&(h=c.dot(Q.sub(e.position,b).normalize()),h<=0||(h*=e.distance==0?1:1-Math.min(b.distanceTo(e.position)/e.distance,1),h!=0&&(h*=e.intensity,d.r+=g.r*h,d.g+=g.g*h,d.b+=g.b*h)))}function j(a,e,g){b(g.opacity);c(g.blending);var h,l,i,m,Aa,p;if(g instanceof THREE.ParticleBasicMaterial){if(g.map)m=g.map.image,Aa=m.width>>1,p=m.height>>1,g=e.scale.x*
n,i=e.scale.y*o,h=g*Aa,l=i*p,V.set(a.x-h,a.y-l,a.x+h,a.y+l),ka.instersects(V)&&(k.save(),k.translate(a.x,a.y),k.rotate(-e.rotation),k.scale(g,-i),k.translate(-Aa,-p),k.drawImage(m,0,0),k.restore())}else g instanceof THREE.ParticleCanvasMaterial&&(h=e.scale.x*n,l=e.scale.y*o,V.set(a.x-h,a.y-l,a.x+h,a.y+l),ka.instersects(V)&&(d(g.color),f(g.color),k.save(),k.translate(a.x,a.y),k.rotate(-e.rotation),k.scale(h,l),g.program(k),k.restore()))}function q(a,e,f,g){b(g.opacity);c(g.blending);k.beginPath();
k.moveTo(a.positionScreen.x,a.positionScreen.y);k.lineTo(e.positionScreen.x,e.positionScreen.y);k.closePath();if(g instanceof THREE.LineBasicMaterial){a=g.linewidth;if(B!=a)k.lineWidth=B=a;a=g.linecap;if(p!=a)k.lineCap=p=a;a=g.linejoin;if(O!=a)k.lineJoin=O=a;d(g.color);k.stroke();V.inflate(g.linewidth*2)}}function s(a,d,f,h,l,i,k,j,n){e.data.vertices+=3;e.data.faces++;b(j.opacity);c(j.blending);C=a.positionScreen.x;F=a.positionScreen.y;L=d.positionScreen.x;D=d.positionScreen.y;G=f.positionScreen.x;
z=f.positionScreen.y;x(C,F,L,D,G,z);if(j instanceof THREE.MeshBasicMaterial)if(j.map)j.map.mapping instanceof THREE.UVMapping&&(aa=k.uvs[0],ga(C,F,L,D,G,z,j.map.image,aa[h].u,aa[h].v,aa[l].u,aa[l].v,aa[i].u,aa[i].v));else if(j.envMap){if(j.envMap.mapping instanceof THREE.SphericalReflectionMapping)a=g.matrixWorldInverse,Q.copy(k.vertexNormalsWorld[0]),Ba=(Q.x*a.n11+Q.y*a.n12+Q.z*a.n13)*0.5+0.5,Ca=-(Q.x*a.n21+Q.y*a.n22+Q.z*a.n23)*0.5+0.5,Q.copy(k.vertexNormalsWorld[1]),Da=(Q.x*a.n11+Q.y*a.n12+Q.z*
a.n13)*0.5+0.5,Ea=-(Q.x*a.n21+Q.y*a.n22+Q.z*a.n23)*0.5+0.5,Q.copy(k.vertexNormalsWorld[2]),Fa=(Q.x*a.n11+Q.y*a.n12+Q.z*a.n13)*0.5+0.5,Ga=-(Q.x*a.n21+Q.y*a.n22+Q.z*a.n23)*0.5+0.5,ga(C,F,L,D,G,z,j.envMap.image,Ba,Ca,Da,Ea,Fa,Ga)}else j.wireframe?J(j.color,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ha(j.color);else if(j instanceof THREE.MeshLambertMaterial)j.map&&!j.wireframe&&(j.map.mapping instanceof THREE.UVMapping&&(aa=k.uvs[0],ga(C,F,L,D,G,z,j.map.image,aa[h].u,aa[h].v,aa[l].u,
aa[l].v,aa[i].u,aa[i].v)),c(THREE.SubtractiveBlending)),ya?!j.wireframe&&j.shading==THREE.SmoothShading&&k.vertexNormalsWorld.length==3?(H.r=E.r=I.r=Y.r,H.g=E.g=I.g=Y.g,H.b=E.b=I.b=Y.b,m(n,k.v1.positionWorld,k.vertexNormalsWorld[0],H),m(n,k.v2.positionWorld,k.vertexNormalsWorld[1],E),m(n,k.v3.positionWorld,k.vertexNormalsWorld[2],I),T.r=(E.r+I.r)*0.5,T.g=(E.g+I.g)*0.5,T.b=(E.b+I.b)*0.5,X=va(H,E,I,T),ga(C,F,L,D,G,z,X,0,0,1,0,0,1)):(ba.r=Y.r,ba.g=Y.g,ba.b=Y.b,m(n,k.centroidWorld,k.normalWorld,ba),t.r=
Math.max(0,Math.min(j.color.r*ba.r,1)),t.g=Math.max(0,Math.min(j.color.g*ba.g,1)),t.b=Math.max(0,Math.min(j.color.b*ba.b,1)),t.updateHex(),j.wireframe?J(t,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ha(t)):j.wireframe?J(j.color,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ha(j.color);else if(j instanceof THREE.MeshDepthMaterial)W=g.near,ca=g.far,H.r=H.g=H.b=1-la(a.positionScreen.z,W,ca),E.r=E.g=E.b=1-la(d.positionScreen.z,W,ca),I.r=I.g=I.b=1-la(f.positionScreen.z,
W,ca),T.r=(E.r+I.r)*0.5,T.g=(E.g+I.g)*0.5,T.b=(E.b+I.b)*0.5,X=va(H,E,I,T),ga(C,F,L,D,G,z,X,0,0,1,0,0,1);else if(j instanceof THREE.MeshNormalMaterial)t.r=ma(k.normalWorld.x),t.g=ma(k.normalWorld.y),t.b=ma(k.normalWorld.z),t.updateHex(),j.wireframe?J(t,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ha(t)}function v(a,d,f,h,j,l,k,i,n){e.data.vertices+=4;e.data.faces++;b(i.opacity);c(i.blending);if(i.map||i.envMap)s(a,d,h,0,1,3,k,i,n),s(j,f,l,1,2,3,k,i,n);else if(C=a.positionScreen.x,F=
a.positionScreen.y,L=d.positionScreen.x,D=d.positionScreen.y,G=f.positionScreen.x,z=f.positionScreen.y,P=h.positionScreen.x,w=h.positionScreen.y,M=j.positionScreen.x,K=j.positionScreen.y,S=l.positionScreen.x,oa=l.positionScreen.y,i instanceof THREE.MeshBasicMaterial)N(C,F,L,D,G,z,P,w),i.wireframe?J(i.color,i.wireframeLinewidth,i.wireframeLinecap,i.wireframeLinejoin):ha(i.color);else if(i instanceof THREE.MeshLambertMaterial)ya?!i.wireframe&&i.shading==THREE.SmoothShading&&k.vertexNormalsWorld.length==
4?(H.r=E.r=I.r=T.r=Y.r,H.g=E.g=I.g=T.g=Y.g,H.b=E.b=I.b=T.b=Y.b,m(n,k.v1.positionWorld,k.vertexNormalsWorld[0],H),m(n,k.v2.positionWorld,k.vertexNormalsWorld[1],E),m(n,k.v4.positionWorld,k.vertexNormalsWorld[3],I),m(n,k.v3.positionWorld,k.vertexNormalsWorld[2],T),X=va(H,E,I,T),x(C,F,L,D,P,w),ga(C,F,L,D,P,w,X,0,0,1,0,0,1),x(M,K,G,z,S,oa),ga(M,K,G,z,S,oa,X,1,0,1,1,0,1)):(ba.r=Y.r,ba.g=Y.g,ba.b=Y.b,m(n,k.centroidWorld,k.normalWorld,ba),t.r=Math.max(0,Math.min(i.color.r*ba.r,1)),t.g=Math.max(0,Math.min(i.color.g*
ba.g,1)),t.b=Math.max(0,Math.min(i.color.b*ba.b,1)),t.updateHex(),N(C,F,L,D,G,z,P,w),i.wireframe?J(t,i.wireframeLinewidth,i.wireframeLinecap,i.wireframeLinejoin):ha(t)):(N(C,F,L,D,G,z,P,w),i.wireframe?J(i.color,i.wireframeLinewidth,i.wireframeLinecap,i.wireframeLinejoin):ha(i.color));else if(i instanceof THREE.MeshNormalMaterial)t.r=ma(k.normalWorld.x),t.g=ma(k.normalWorld.y),t.b=ma(k.normalWorld.z),t.updateHex(),N(C,F,L,D,G,z,P,w),i.wireframe?J(t,i.wireframeLinewidth,i.wireframeLinecap,i.wireframeLinejoin):
ha(t);else if(i instanceof THREE.MeshDepthMaterial)W=g.near,ca=g.far,H.r=H.g=H.b=1-la(a.positionScreen.z,W,ca),E.r=E.g=E.b=1-la(d.positionScreen.z,W,ca),I.r=I.g=I.b=1-la(h.positionScreen.z,W,ca),T.r=T.g=T.b=1-la(f.positionScreen.z,W,ca),X=va(H,E,I,T),x(C,F,L,D,P,w),ga(C,F,L,D,P,w,X,0,0,1,0,0,1),x(M,K,G,z,S,oa),ga(M,K,G,z,S,oa,X,1,0,1,1,0,1)}function x(a,b,c,d,e,f){k.beginPath();k.moveTo(a,b);k.lineTo(c,d);k.lineTo(e,f);k.lineTo(a,b);k.closePath()}function N(a,b,c,d,e,f,g,h){k.beginPath();k.moveTo(a,
b);k.lineTo(c,d);k.lineTo(e,f);k.lineTo(g,h);k.lineTo(a,b);k.closePath()}function J(a,b,c,e){if(B!=b)k.lineWidth=B=b;if(p!=c)k.lineCap=p=c;if(O!=e)k.lineJoin=O=e;d(a);k.stroke();V.inflate(b*2)}function ha(a){f(a);k.fill()}function ga(a,b,c,d,e,f,g,h,i,j,l,m,n){var o,p;o=g.width-1;p=g.height-1;h*=o;i*=p;j*=o;l*=p;m*=o;n*=p;c-=a;d-=b;e-=a;f-=b;j-=h;l-=i;m-=h;n-=i;o=j*n-m*l;o!=0&&(p=1/o,o=(n*c-l*e)*p,l=(n*d-l*f)*p,c=(j*e-m*c)*p,d=(j*f-m*d)*p,a=a-o*h-c*i,b=b-l*h-d*i,k.save(),k.transform(o,l,c,d,a,b),
k.clip(),k.drawImage(g,0,0),k.restore())}function va(a,b,c,d){var e=~~(a.r*255),f=~~(a.g*255),a=~~(a.b*255),g=~~(b.r*255),h=~~(b.g*255),b=~~(b.b*255),i=~~(c.r*255),j=~~(c.g*255),c=~~(c.b*255),k=~~(d.r*255),l=~~(d.g*255),d=~~(d.b*255);ea[0]=e<0?0:e>255?255:e;ea[1]=f<0?0:f>255?255:f;ea[2]=a<0?0:a>255?255:a;ea[4]=g<0?0:g>255?255:g;ea[5]=h<0?0:h>255?255:h;ea[6]=b<0?0:b>255?255:b;ea[8]=i<0?0:i>255?255:i;ea[9]=j<0?0:j>255?255:j;ea[10]=c<0?0:c>255?255:c;ea[12]=k<0?0:k>255?255:k;ea[13]=l<0?0:l>255?255:l;
ea[14]=d<0?0:d>255?255:d;qa.putImageData(za,0,0);ua.drawImage(pa,0,0);return ra}function la(a,b,c){a=(a-b)/(c-b);return a*a*(3-2*a)}function ma(a){a=(a+1)*0.5;return a<0?0:a>1?1:a}function ia(a,b){var c=b.x-a.x,d=b.y-a.y,e=1/Math.sqrt(c*c+d*d);c*=e;d*=e;b.x+=c;b.y+=d;a.x-=c;a.y-=d}var wa,Ha,A,fa,ja,na,xa,U;this.autoClear?this.clear():k.setTransform(1,0,0,-1,n,o);e.data.vertices=0;e.data.faces=0;h=i.projectScene(a,g,this.sortElements);(ya=a.lights.length>0)&&l(a);wa=0;for(Ha=h.length;wa<Ha;wa++){A=
h[wa];V.empty();if(A instanceof THREE.RenderableParticle){r=A;r.x*=n;r.y*=o;fa=0;for(ja=A.materials.length;fa<ja;)U=A.materials[fa++],U.opacity!=0&&j(r,A,U,a)}else if(A instanceof THREE.RenderableLine){if(r=A.v1,u=A.v2,r.positionScreen.x*=n,r.positionScreen.y*=o,u.positionScreen.x*=n,u.positionScreen.y*=o,V.addPoint(r.positionScreen.x,r.positionScreen.y),V.addPoint(u.positionScreen.x,u.positionScreen.y),ka.instersects(V)){fa=0;for(ja=A.materials.length;fa<ja;)U=A.materials[fa++],U.opacity!=0&&q(r,
u,A,U,a)}}else if(A instanceof THREE.RenderableFace3){if(r=A.v1,u=A.v2,y=A.v3,r.positionScreen.x*=n,r.positionScreen.y*=o,u.positionScreen.x*=n,u.positionScreen.y*=o,y.positionScreen.x*=n,y.positionScreen.y*=o,A.overdraw&&(ia(r.positionScreen,u.positionScreen),ia(u.positionScreen,y.positionScreen),ia(y.positionScreen,r.positionScreen)),V.add3Points(r.positionScreen.x,r.positionScreen.y,u.positionScreen.x,u.positionScreen.y,y.positionScreen.x,y.positionScreen.y),ka.instersects(V)){fa=0;for(ja=A.meshMaterials.length;fa<
ja;)if(U=A.meshMaterials[fa++],U instanceof THREE.MeshFaceMaterial){na=0;for(xa=A.faceMaterials.length;na<xa;)(U=A.faceMaterials[na++])&&U.opacity!=0&&s(r,u,y,0,1,2,A,U,a)}else U.opacity!=0&&s(r,u,y,0,1,2,A,U,a)}}else if(A instanceof THREE.RenderableFace4&&(r=A.v1,u=A.v2,y=A.v3,R=A.v4,r.positionScreen.x*=n,r.positionScreen.y*=o,u.positionScreen.x*=n,u.positionScreen.y*=o,y.positionScreen.x*=n,y.positionScreen.y*=o,R.positionScreen.x*=n,R.positionScreen.y*=o,$.positionScreen.copy(u.positionScreen),
Z.positionScreen.copy(R.positionScreen),A.overdraw&&(ia(r.positionScreen,u.positionScreen),ia(u.positionScreen,R.positionScreen),ia(R.positionScreen,r.positionScreen),ia(y.positionScreen,$.positionScreen),ia(y.positionScreen,Z.positionScreen)),V.addPoint(r.positionScreen.x,r.positionScreen.y),V.addPoint(u.positionScreen.x,u.positionScreen.y),V.addPoint(y.positionScreen.x,y.positionScreen.y),V.addPoint(R.positionScreen.x,R.positionScreen.y),ka.instersects(V))){fa=0;for(ja=A.meshMaterials.length;fa<
ja;)if(U=A.meshMaterials[fa++],U instanceof THREE.MeshFaceMaterial){na=0;for(xa=A.faceMaterials.length;na<xa;)(U=A.faceMaterials[na++])&&U.opacity!=0&&v(r,u,y,R,$,Z,A,U,a)}else U.opacity!=0&&v(r,u,y,R,$,Z,A,U,a)}da.addRectangle(V)}k.setTransform(1,0,0,1,0,0)}};THREE.RenderableVertex=function(){this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.visible=!0};THREE.RenderableVertex.prototype.copy=function(a){this.positionWorld.copy(a.positionWorld);this.positionScreen.copy(a.positionScreen)};
THREE.RenderableFace3=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableFace4=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.v4=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableObject=function(){this.z=this.object=null};THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.materials=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.materials=null};
