
## The Big Picture

* [How we think](overview/how-we-think.md)
* [How it looks](overview/how-it-looks.md)
* [How it works](overview/how-it-works.md)
* [Tools](overview/tools.md)
* [Platform CLI](overview/cli.md)
* [Pricing](overview/pricing.md)
* [Getting help](overview/getting-help.md)


## Configuration

* [Routes](configuration/routes.md)
  * [HTTP Cache](configuration/routes/cache.md)
  * [Redirects](configuration/routes/redirects.md)
  * [Server Side Includes](configuration/routes/ssi.md)
* [Services](configuration/services.md)
  * [MySQL](configuration/services/mysql.md)
  * [PostgreSQL](configuration/services/postgresql.md)
  * [MongoDB](configuration/services/mongodb.md)
  * [Redis](configuration/services/redis.md)
  * [Solr](configuration/services/solr.md)
  * [Elasticsearch](configuration/services/elasticsearch.md)
  * [RabbitMQ](configuration/services/rabbitmq.md)
* [App Containers](configuration/app-containers.md)
  * [Multiple Apps](configuration/app/multi-app.md)
  * [Upgrading](configuration/app/upgrading.md)

## Languages

* [Node.js](languages/nodejs.md)
* [PHP](languages/php.md)
* [Python (beta)](languages/python.md)
* [Ruby (beta)](languages/ruby.md)

## Development

* [Local development](development/local.md)
* [Environment variables](development/environment-variables.md)
* [Private repositories](development/private-repository.md)
* [Git submodules](development/submodules.md)
* [Using SSH](development/ssh.md)
* [Public IPs](development/public-ips.md)
* [Protective block](development/protective-block.md)
* [Going live](development/going-live.md)
* [FAQ](development/faq.md)

## Administration

* [Users](administration/users.md)
* [Snapshot and restore](administration/snapshot-and-restore.md)
* [External integrations](administration/integrations.md)
  * [Bitbucket](administration/integrations/bitbucket.md)
  * [Blackfire](administration/integrations/blackfire.md)
  * [GitHub](administration/integrations/github.md)
  * [HipChat](administration/integrations/hipchat.md)
  * [Web hooks](administration/integrations/webhooks.md)
* [Web interface](administration/web.md)
  * [Project configuration](administration/web/configure-project.md)
  * [Environments](administration/web/environments.md)
  * [Configure environments (tmp)](administration/web/configure-environment.md)
  * [Email](administration/web/email.md)

## Featured frameworks

* [Drupal 7](frameworks/drupal7.md)
  * [Developing with Drupal](frameworks/drupal7/developing-with-drupal.md)
  * [Migrating](frameworks/drupal7/migrating.md)
  * [Customizing settings.php](frameworks/drupal7/customizing-settings-php.md)
  * [Drush](frameworks/drupal7/customizing-settings-php.md)
  * [Redis](frameworks/drupal7/redis.md)
  * [Solr](frameworks/drupal7/solr.md)
  * [FAQ](frameworks/drupal7/faq.md)
* [Drupal 8](frameworks/drupal8.md)
  * [Developing with Drupal](frameworks/drupal8/developing-with-drupal.md)
  * [Drush](frameworks/drupal8/drush.md)
  * [Redis](frameworks/drupal8/redis.md)
  * [Solr](frameworks/drupal8/solr.md)
  * [FAQ](frameworks/drupal8/faq.md)
* [Symfony](frameworks/symfony.md)
  * [Migrating](frameworks/symfony/migrating.md)
  * [FAQ](frameworks/symfony/faq.md)
