# Customizing settings.php

Platform.sh allows you to use your own `settings.php` that you commit to
your Git repository.

If you do so, make sure you include a `settings.local.php` file which
will be generated by Platform.sh on each of your environments.

Here is a default `settings.php`:

```php
<?php
$update_free_access = FALSE;

$local_settings = dirname(__FILE__) . '/settings.local.php';
if (file_exists($local_settings)) {
  require_once($local_settings);
}
```

Any `settings*.php` file will be copied. It means you can use
`settings.dev.php` and `settings.staging.php`, then include the right
one depending on environment variables.

For example, you can load a development file for any development
environment, by providing the `drupal:load_development_overrides`
environment variable, and adding this code at the end of the
`settings.php`:

```php
if (!empty($conf['load_development_overrides'])) {
  require_once dirname(__FILE__) . '/settings.dev.php';
}
```

It means the `settings.dev.php` file must exist in your repository root
folder.

> **note**
> The `drupal:*` environment variables are included in the `settings.local.php` file, so include it first.

> **note**
> The `settings.local.php` file will always be overwritten by Platform.sh.

> **note**
> You also need to add a custom `$drupal_hash_salt`.

## Shared variables

You can use your custom `settings.php` to define configuration that is
shared among all your environments.

For example, you can extract the `PLATFORM_RELATIONSHIPS` variable to
get the configuration of all services deployed on your environment.
Since the `PLATFORM_RELATIONSHIPS` is JSON encoded, you'll need to
decode it before using it.

Here is an example to define the Redis configuration:

```php
// Platform redis connection info.
if (!empty($_SERVER['PLATFORM_RELATIONSHIPS'])) {
  $relationships = json_decode(base64_decode($_SERVER['PLATFORM_RELATIONSHIPS']));
  if (!empty($relationships->redis)) {
    $conf['redis_client_host'] = $relationships->redis[0]->host;
    $conf['redis_client_port'] = $relationships->redis[0]->port;
  }
}
```
