
USE openmrs;

REPLACE INTO `ptme_reporting_indicator` (`indicator_id`,`name`,`description`,`indicator_sql_script`,`template_code`,`uuid`,`creator`,`date_created`,`changed_by`,`date_changed`,`voided`,`voided_by`,`date_voided`,`void_reason`) VALUES 
 (1,'Nombre de femmes enceintes reçues en CPN 1 et se connaissant déjà  séropositives au VIH',NULL,'SELECT COUNT(*) nb FROM ptme_prenatal p, ptme_hiv_service h, ptme_consultation c\r\nWHERE\r\n  p.consultation_id = hiv_service_id AND\r\n  p.consultation_id = c.consultation_id AND\r\n  hiv_status_at_reception = 1\r\n  AND rank = \'CPN 1\'\r\n  AND consultation_date BETWEEN :startDate AND :endDate\r\n  AND c.location_id = :locationId','I01','c75f655d-6a16-415c-bcc4-0488cc31b188',1,'2018-11-05 19:24:19',1,'2018-11-12 14:47:25',0,NULL,NULL,NULL),
 (2,'Nombre de femmes enceintes conseillées et testées qui ont reçu leur résultat du test VIH en CPN',NULL,'SELECT COUNT(*) nb FROM ptme_prenatal p, ptme_consultation c, ptme_hiv_service h\r\nWHERE\r\n  c.consultation_id = p.consultation_id AND\r\n  c.consultation_id = h.hiv_service_id AND\r\n  h.test_proposal = 1 AND h.result_announcement = 1 AND\r\n  c.consultation_date BETWEEN :startDate AND :endDate AND\r\n  c.location_id = :locationId','I02','82f6bd42-f970-44f2-b8a0-286aa92a0c64',1,'2018-11-05 19:25:04',1,'2018-11-12 14:48:39',0,NULL,NULL,NULL),
 (3,'Nombre de femmes enceintes conseillées et testées qui ont reçu leur résultat du test VIH en maternité',NULL,'SELECT COUNT(*) nb FROM ptme_birth b, ptme_consultation c, ptme_hiv_service h\r\nWHERE\r\n  c.consultation_id = b.consultation_id AND\r\n  c.consultation_id = h.hiv_service_id AND\r\n  result_announcement = 1\r\n  AND c.consultation_date BETWEEN :startDate AND :endDate\r\n  AND c.location_id = :locationId','I03','ebda5b85-d7ca-4815-9d37-1d4ab4c51617',1,'2018-11-05 19:25:36',1,'2018-11-12 14:48:29',0,NULL,NULL,NULL),
 (4,'Nombre de femmes enceintes dépistée séropositives au VIH en CPN',NULL,'SELECT COUNT(*) nb FROM ptme_prenatal p, ptme_consultation c, ptme_hiv_service h\r\nWHERE\r\n  c.consultation_id = p.consultation_id AND\r\n  c.consultation_id = h.hiv_service_id AND\r\n  h.test_result = 1\r\n  AND c.consultation_date BETWEEN :startDate AND :endDate\r\n  AND c.location_id = :locationId','I04','6f19786f-688a-41e3-a6b5-6badf0c0b631',1,'2018-11-05 19:26:35',1,'2018-11-12 14:48:10',0,NULL,NULL,NULL),
 (5,'Nombre de femmes enceintes dépistée séropositives au VIH en maternité',NULL,'SELECT COUNT(*) nb FROM ptme_birth b, ptme_consultation c, ptme_hiv_service h\r\nWHERE\r\n  c.consultation_id = b.consultation_id AND\r\n  c.consultation_id = h.hiv_service_id AND\r\n  h.test_result = 1\r\n  AND c.consultation_date BETWEEN :startDate AND :endDate\r\n  AND c.location_id = :locationId','I05','2035bcfa-ad13-476e-a1f0-e7c71a6545c0',1,'2018-11-05 19:27:28',1,'2018-11-12 14:47:59',0,NULL,NULL,NULL),
 (6,'Nombre de femmes enceintes déjà sous traitement ARV et reçu en CPN 1',NULL,'SELECT COUNT(*) nb FROM ptme_prenatal p, ptme_hiv_service h, ptme_consultation c\r\nWHERE\r\n  p.consultation_id = hiv_service_id AND\r\n  p.consultation_id = c.consultation_id AND\r\n  h.arv_status = 1\r\n  AND rank = \'CPN 1\'\r\n  AND consultation_date BETWEEN :startDate AND :endDate\r\n  AND c.location_id = :locationId','I06','b199ce01-1e8c-49af-a420-279f060c72b7',1,'2018-11-05 19:28:07',1,'2018-11-12 14:48:20',0,NULL,NULL,NULL),
 (7,'Nombre de femmes enceintes séropositives au VIH dont l\'accouchement a été enregistré dans l\'établissement sanitaire',NULL,'SELECT COUNT(DISTINCT pregnant_patient_id) nb FROM ptme_birth b, ptme_consultation c, ptme_hiv_service h\r\nWHERE\r\n  c.consultation_id = b.consultation_id AND\r\n  c.consultation_id = h.hiv_service_id AND\r\n  (h.test_result = 1 OR h.hiv_status_at_reception = 1) AND b.home_birth = 0\r\n  AND c.consultation_date BETWEEN :startDate AND :endDate\r\n  AND c.location_id = :locationId','I07','dc2f035a-b08d-491a-b3aa-8c37caa67de7',1,'2018-11-05 19:29:09',1,'2018-11-12 14:47:47',0,NULL,NULL,NULL),
 (8,'Nombre d\'enfants nés vivants de mères séropositives au VIH',NULL,'SELECT COUNT(*) nb FROM ptme_birth b, ptme_consultation c, ptme_hiv_service h\r\nWHERE\r\n  c.consultation_id = b.consultation_id AND\r\n  c.consultation_id = h.hiv_service_id AND\r\n  (h.test_result = 1 OR h.hiv_status_at_reception = 1) AND b.child_state = 1\r\n  AND b.delivery_date BETWEEN :startDate AND :endDate\r\n  AND c.location_id = :locationId','I08','be47503a-feb9-46d7-a47c-ff858bd211ce',1,'2018-11-09 19:47:00',1,'2018-11-12 14:48:50',0,NULL,NULL,NULL),
 (9,'Nombre d’enfants nés de mères  séropositives au VIH ayant reçu des ARV dans les 72 h après la naissance',NULL,'SELECT\r\n  COUNT(pregnant_patient_id) nb\r\nFROM ptme_birth b, ptme_consultation c, ptme_hiv_service h\r\nWHERE\r\n  b.consultation_id = c.consultation_id AND\r\n  h.hiv_service_id = c.consultation_id AND\r\n  h.child_arv_prophylaxis = 1 AND\r\n  consultation_date BETWEEN :startDate AND :endDate AND\r\n  c.location_id = :locationId','I09','f18c171e-9fe7-4b2c-811f-3d6e8ff862e3',1,'2018-11-09 19:48:23',1,'2018-11-12 14:47:35',0,NULL,NULL,NULL),
 (10,'Nombre d\'enfants nés de mères séropositives au VIH initiant la prophylaxie au Cotrimoxazole avant 02 mois',NULL,'SELECT\r\n  COUNT(child_id) nb\r\nFROM ptme_child_followup f, ptme_child c\r\nWHERE\r\n  c.child_id = f.child_followup_id AND\r\n  f.ctx_initiation_date BETWEEN :startDate AND :endDate AND\r\n  (DATEDIFF(f.ctx_initiation_date, c.birth_date)/7) BETWEEN 6 AND 8 AND\r\n  f.location_id = :locationId','I10','b5b2012b-0936-487e-830c-d33e6453b036',1,'2018-11-09 19:49:21',NULL,NULL,0,NULL,NULL,NULL),
 (11,'Nombre de mères séropositives au VIH bénéficiant des services de Planification familiale en  Post Natal (6 semaines après l’accouchement)',NULL,'SELECT\r\n  COUNT(c.child_id) nb\r\nFROM\r\n  (SELECT MAX(visit_date) derniereVisite, child_id FROM ptme_child_followup_visit WHERE visit_date <= :endDate GROUP BY child_id) lv,\r\n  (SELECT * FROM ptme_child_followup_visit) v,\r\n  ptme_child c\r\nWHERE\r\n  (lv.derniereVisite = v.visit_date AND lv.child_id = v.child_id) AND\r\n  c.child_id = v.child_id AND\r\n  v.modern_contraceptive_method = 1 AND visit_date BETWEEN :startDate AND :endDate AND\r\n  (DATEDIFF(v.visit_date, c.birth_date)/7) BETWEEN 6 AND 8 AND\r\n  v.location_id = :locationId','I11','4b9568ef-e712-4629-b9a5-3f67bceac7d1',1,'2018-11-09 19:51:07',NULL,NULL,0,NULL,NULL,NULL),
 (12,'Nombre d\'enfants nés de mères séropositives au VIH dépistés précocement (avant 2 mois)',NULL,'SELECT\r\n  COUNT(child_id) nb\r\nFROM ptme_child_followup f, ptme_child c\r\nWHERE\r\n  c.child_id = f.child_followup_id AND\r\n  f.pcr1_sampling_date BETWEEN :startDate AND :endDate AND\r\n  (DATEDIFF(f.pcr1_sampling_date, c.birth_date) / 30) < 2 AND\r\n  f.location_id = :locationId','I12','e819d548-d52f-4dac-8e10-c196be45a2d0',1,'2018-11-11 22:33:45',NULL,NULL,0,NULL,NULL,NULL),
 (13,'Nombre d\'enfants nés de mères séropositives au VIH dépistés précocement (2 à 09 mois)',NULL,'SELECT\r\n  COUNT(child_id) nb\r\nFROM ptme_child_followup f, ptme_child c\r\nWHERE\r\n  c.child_id = f.child_followup_id AND\r\n  f.pcr1_sampling_date BETWEEN :startDate AND :endDate AND\r\n  (DATEDIFF(f.pcr1_sampling_date, c.birth_date) / 30) BETWEEN 2 AND 9 AND\r\n  f.location_id = :locationId','I13','d1d400ab-6d75-4dbe-ada0-232640ca81ea',1,'2018-11-11 22:34:28',NULL,NULL,0,NULL,NULL,NULL),
 (14,'Nombre d\'enfants nés de mères séropositives au VIH dépistés tardivement (10 à 18 mois)',NULL,'SELECT\r\n  COUNT(child_id) nb\r\nFROM ptme_child_followup f, ptme_child c\r\nWHERE\r\n  c.child_id = f.child_followup_id AND\r\n  f.pcr1_sampling_date BETWEEN :startDate AND :endDate AND\r\n  (DATEDIFF(f.pcr1_sampling_date, c.birth_date) / 30) BETWEEN 10 AND 18 AND\r\n  f.location_id = :locationId','I14','1bad3894-da5a-4d60-a9e7-df96ea317544',1,'2018-11-11 22:36:07',NULL,NULL,0,NULL,NULL,NULL),
 (15,'Nombre d\'enfants nés de mères séropositives au VIH dépistés VIH positif',NULL,'SELECT\r\n  COUNT(child_id) nb\r\nFROM ptme_child_followup f, ptme_child c\r\nWHERE\r\n  c.child_id = f.child_followup_id AND\r\n  (\r\n    (f.pcr1_sampling_date BETWEEN :startDate AND :endDate AND f.pcr1_result = 1) OR\r\n    (f.pcr2_sampling_date BETWEEN :startDate AND :endDate AND f.pcr2_result = 1) OR\r\n    (f.pcr3_sampling_date BETWEEN :startDate AND :endDate AND f.pcr3_result = 1) OR\r\n    (f.hiv_serology1_date BETWEEN :startDate AND :endDate AND f.hiv_serology1_result = 1) OR\r\n    (f.hiv_serology2_date BETWEEN :startDate AND :endDate AND f.hiv_serology2_result = 1)\r\n  ) AND\r\n  f.location_id = :locationId','I15','cd6a5ae4-0fd4-48fa-b4d1-825c41a08aae',1,'2018-11-11 22:36:37',NULL,NULL,0,NULL,NULL,NULL),
 (16,'Nombre  d\'enfants  nés de mères séropositives au VIH  dépistés VIH positif et référés dans une structure offrant la PEC',NULL,'SELECT\r\n  COUNT(child_id) nb\r\nFROM ptme_child_followup f, ptme_child c\r\nWHERE\r\n  c.child_id = f.child_followup_id AND\r\n  (f.followup_end_date BETWEEN :startDate AND :endDate AND f.followup_result = 3) AND\r\n  f.location_id = :locationId','I16','73b8df47-f3c6-425b-b817-e282f2007f14',1,'2018-11-11 22:37:21',NULL,NULL,0,NULL,NULL,NULL),
 (17,'Nombre de conjoints de femmes enceintes séropositives au VIH dépistés positifs',NULL,'SELECT COUNT(DISTINCT pregnant_patient_id) nb\r\nFROM (\r\n       SELECT\r\n         p.pregnant_patient_id\r\n       FROM ptme_mother_followup pmf, ptme_pregnant_patient p\r\n       WHERE\r\n         pmf.pregnant_patient_id = p.pregnant_patient_id AND\r\n         pmf.spousal_screening_date BETWEEN :startDate AND :endDate AND\r\n         pmf.spousal_screening_result = 1 AND\r\n         pmf.location_id = :locationId\r\n       UNION\r\n\r\n       SELECT\r\n         c.pregnant_patient_id\r\n       FROM ptme_consultation c, ptme_prenatal p, ptme_hiv_service h\r\n       WHERE\r\n         c.consultation_id = h.hiv_service_id AND\r\n         (h.hiv_status_at_reception = 1 OR h.test_result = 1) AND\r\n         c.consultation_id = p.consultation_id AND\r\n         c.consultation_date BETWEEN :startDate AND :endDate AND\r\n         p.spousal_screening_result = 1 AND\r\n         c.location_id = :locationId\r\n     ) _','I17','17dbb54d-17b8-4181-9858-53ae02dd2335',1,'2018-11-12 08:51:16',1,'2018-11-12 08:56:21',0,NULL,NULL,NULL),
 (18,'Nombre de conjoints de femmes enceintes séropositives au VIH dépistés négatifs',NULL,'SELECT COUNT(DISTINCT pregnant_patient_id) nb\r\nFROM (\r\n  SELECT p.pregnant_patient_id\r\n  FROM ptme_mother_followup pmf, ptme_pregnant_patient p\r\n  WHERE\r\n    pmf.pregnant_patient_id = p.pregnant_patient_id AND\r\n    pmf.spousal_screening_date BETWEEN :startDate AND :endDate AND\r\n    pmf.spousal_screening_result = 0 AND\r\n    pmf.location_id = :locationId\r\n\r\n  UNION\r\n\r\n  SELECT c.pregnant_patient_id\r\n  FROM ptme_consultation c, ptme_prenatal p, ptme_hiv_service h\r\n  WHERE\r\n    c.consultation_id = h.hiv_service_id AND\r\n    (h.hiv_status_at_reception = 1 OR h.test_result = 1) AND\r\n    c.consultation_id = p.consultation_id AND\r\n    c.consultation_date BETWEEN :startDate AND :endDate AND\r\n    p.spousal_screening_result = 0 AND\r\n    c.location_id = :locationId\r\n) _','I18','06b00672-ea33-4da7-a871-45eb6e6e03c5',1,'2018-11-12 08:51:51',1,'2018-11-12 08:56:35',0,NULL,NULL,NULL),
 (19,'Femmes enceintes ou allaitantes depistées positives nouvellement mises sous traitement ARV à M1 du début de TARV',NULL,'SELECT\r\n   count(DISTINCT p.patient_id) nb\r\n\r\nFROM\r\n  (\r\n    SELECT\r\n      DateDebutSuiviPTME, MV.pregnant_patient_id, start_date, arv_status_at_registering, mother_followup_id, pregnancy_outcome\r\n    FROM\r\n      (\r\n        SELECT\r\n          MAX(start_date) DateDebutSuiviPTME, pregnant_patient_id\r\n        FROM ptme_mother_followup WHERE start_date < :startDate AND voided = 0 AND location_id = :locationId\r\n        GROUP BY pregnant_patient_id\r\n      ) MV\r\n      ,\r\n      (SELECT start_date, pregnant_patient_id, arv_status_at_registering, mother_followup_id, pregnancy_outcome FROM ptme_mother_followup) S\r\n    WHERE S.pregnant_patient_id = MV.pregnant_patient_id AND S.start_date = MV.DateDebutSuiviPTME\r\n  ) V\r\n  INNER JOIN (SELECT pregnant_patient_id, patient_id, hiv_care_number FROM ptme_pregnant_patient WHERE voided = 0) p\r\n    ON p.pregnant_patient_id = V.pregnant_patient_id\r\n  LEFT JOIN\r\n    (\r\n      SELECT\r\n        mother, pc.child_id, eating_type\r\n      FROM\r\n        ptme_child pc,\r\n        ptme_child_followup pcf,\r\n        ptme_child_followup_visit pcfv,\r\n        (SELECT MAX(visit_date) MaxVisitDate, child_id FROM ptme_child_followup_visit WHERE visit_date <= :endDate AND location_id = :locationId GROUP BY child_id ) mpcfv\r\n      WHERE\r\n        pc.child_id = pcf.child_followup_id AND pc.child_id = pcfv.child_id AND mpcfv.MaxVisitDate = pcfv.visit_date AND mpcfv.child_id = pcfv.child_id\r\n    ) cf ON cf.mother = p.patient_id\r\n  LEFT JOIN (SELECT value_datetime DateDebutARV, person_id\r\n             FROM obs\r\n             WHERE concept_id IN (159599, 164588, 165032) AND ADDDATE(value_datetime, INTERVAL 1 MONTH) BETWEEN :startDate AND :endDate AND voided = 0 GROUP BY person_id) ARV\r\n    ON ARV.person_id = p.patient_id\r\nWHERE\r\n  (pregnancy_outcome IS NULL OR (pregnancy_outcome IS NOT NULL AND eating_type = 1)) AND\r\n  arv_status_at_registering IN (0,2) AND DateDebutARV IS NOT NULL','I19','593b50f8-f3a9-4fbd-9fd3-508966192e0f',1,'2018-12-05 15:12:02',1,'2018-12-05 18:12:14',0,NULL,NULL,NULL),
 (20,'Femmes enceintes ou allaitantes depistées positives nouvellement mises sous traitement ARV à M2 du début de TARV',NULL,'SELECT\r\n   count(DISTINCT p.patient_id) nb\r\n\r\nFROM\r\n  (\r\n    SELECT\r\n      DateDebutSuiviPTME, MV.pregnant_patient_id, start_date, arv_status_at_registering, mother_followup_id, pregnancy_outcome\r\n    FROM\r\n      (\r\n        SELECT\r\n          MAX(start_date) DateDebutSuiviPTME, pregnant_patient_id\r\n        FROM ptme_mother_followup WHERE start_date < :startDate AND voided = 0 AND location_id = :locationId\r\n        GROUP BY pregnant_patient_id\r\n      ) MV\r\n      ,\r\n      (SELECT start_date, pregnant_patient_id, arv_status_at_registering, mother_followup_id, pregnancy_outcome FROM ptme_mother_followup) S\r\n    WHERE S.pregnant_patient_id = MV.pregnant_patient_id AND S.start_date = MV.DateDebutSuiviPTME\r\n  ) V\r\n  INNER JOIN (SELECT pregnant_patient_id, patient_id, hiv_care_number FROM ptme_pregnant_patient WHERE voided = 0) p\r\n    ON p.pregnant_patient_id = V.pregnant_patient_id\r\n  LEFT JOIN\r\n    (\r\n      SELECT\r\n        mother, pc.child_id, eating_type\r\n      FROM\r\n        ptme_child pc,\r\n        ptme_child_followup pcf,\r\n        ptme_child_followup_visit pcfv,\r\n        (SELECT MAX(visit_date) MaxVisitDate, child_id FROM ptme_child_followup_visit WHERE visit_date <= :endDate AND location_id = :locationId GROUP BY child_id ) mpcfv\r\n      WHERE\r\n        pc.child_id = pcf.child_followup_id AND pc.child_id = pcfv.child_id AND mpcfv.MaxVisitDate = pcfv.visit_date AND mpcfv.child_id = pcfv.child_id\r\n    ) cf ON cf.mother = p.patient_id\r\n  LEFT JOIN (SELECT value_datetime DateDebutARV, person_id\r\n             FROM obs\r\n             WHERE concept_id IN (159599, 164588, 165032) AND ADDDATE(value_datetime, INTERVAL 2 MONTH) BETWEEN :startDate AND :endDate AND voided = 0 GROUP BY person_id) ARV\r\n    ON ARV.person_id = p.patient_id\r\nWHERE\r\n  (pregnancy_outcome IS NULL OR (pregnancy_outcome IS NOT NULL AND eating_type = 1)) AND\r\n  arv_status_at_registering IN (0,2) AND DateDebutARV IS NOT NULL','I20','85438351-d26e-4aac-8702-51ddd76d55d2',1,'2018-12-05 15:13:02',1,'2018-12-05 18:12:57',0,NULL,NULL,NULL),
 (21,'Femmes enceintes ou allaitantes depistées positives nouvellement mises sous traitement ARV à M3 du début de TARV',NULL,'SELECT\r\n   count(DISTINCT p.patient_id) nb\r\n\r\nFROM\r\n  (\r\n    SELECT\r\n      DateDebutSuiviPTME, MV.pregnant_patient_id, start_date, arv_status_at_registering, mother_followup_id, pregnancy_outcome\r\n    FROM\r\n      (\r\n        SELECT\r\n          MAX(start_date) DateDebutSuiviPTME, pregnant_patient_id\r\n        FROM ptme_mother_followup WHERE start_date < :startDate AND voided = 0 AND location_id = :locationId\r\n        GROUP BY pregnant_patient_id\r\n      ) MV\r\n      ,\r\n      (SELECT start_date, pregnant_patient_id, arv_status_at_registering, mother_followup_id, pregnancy_outcome FROM ptme_mother_followup) S\r\n    WHERE S.pregnant_patient_id = MV.pregnant_patient_id AND S.start_date = MV.DateDebutSuiviPTME\r\n  ) V\r\n  INNER JOIN (SELECT pregnant_patient_id, patient_id, hiv_care_number FROM ptme_pregnant_patient WHERE voided = 0) p\r\n    ON p.pregnant_patient_id = V.pregnant_patient_id\r\n  LEFT JOIN\r\n    (\r\n      SELECT\r\n        mother, pc.child_id, eating_type\r\n      FROM\r\n        ptme_child pc,\r\n        ptme_child_followup pcf,\r\n        ptme_child_followup_visit pcfv,\r\n        (SELECT MAX(visit_date) MaxVisitDate, child_id FROM ptme_child_followup_visit WHERE visit_date <= :endDate AND location_id = :locationId GROUP BY child_id ) mpcfv\r\n      WHERE\r\n        pc.child_id = pcf.child_followup_id AND pc.child_id = pcfv.child_id AND mpcfv.MaxVisitDate = pcfv.visit_date AND mpcfv.child_id = pcfv.child_id\r\n    ) cf ON cf.mother = p.patient_id\r\n  LEFT JOIN (SELECT value_datetime DateDebutARV, person_id\r\n             FROM obs\r\n             WHERE concept_id IN (159599, 164588, 165032) AND ADDDATE(value_datetime, INTERVAL 3 MONTH) BETWEEN :startDate AND :endDate AND voided = 0 GROUP BY person_id) ARV\r\n    ON ARV.person_id = p.patient_id\r\nWHERE\r\n  (pregnancy_outcome IS NULL OR (pregnancy_outcome IS NOT NULL AND eating_type = 1)) AND\r\n  arv_status_at_registering IN (0,2) AND DateDebutARV IS NOT NULL','I21','aae14110-218b-4d1c-8895-5b14bff55bc8',1,'2018-12-05 15:14:50',1,'2018-12-05 18:13:21',0,NULL,NULL,NULL),
 (22,'Femmes enceintes ou allaitantes depistées positives nouvellement mises sous traitement ARV à M6 du début de TARV',NULL,'SELECT\r\n   count(DISTINCT p.patient_id) nb\r\n\r\nFROM\r\n  (\r\n    SELECT\r\n      DateDebutSuiviPTME, MV.pregnant_patient_id, start_date, arv_status_at_registering, mother_followup_id, pregnancy_outcome\r\n    FROM\r\n      (\r\n        SELECT\r\n          MAX(start_date) DateDebutSuiviPTME, pregnant_patient_id\r\n        FROM ptme_mother_followup WHERE start_date < :startDate AND voided = 0 AND location_id = :locationId\r\n        GROUP BY pregnant_patient_id\r\n      ) MV\r\n      ,\r\n      (SELECT start_date, pregnant_patient_id, arv_status_at_registering, mother_followup_id, pregnancy_outcome FROM ptme_mother_followup) S\r\n    WHERE S.pregnant_patient_id = MV.pregnant_patient_id AND S.start_date = MV.DateDebutSuiviPTME\r\n  ) V\r\n  INNER JOIN (SELECT pregnant_patient_id, patient_id, hiv_care_number FROM ptme_pregnant_patient WHERE voided = 0) p\r\n    ON p.pregnant_patient_id = V.pregnant_patient_id\r\n  LEFT JOIN\r\n    (\r\n      SELECT\r\n        mother, pc.child_id, eating_type\r\n      FROM\r\n        ptme_child pc,\r\n        ptme_child_followup pcf,\r\n        ptme_child_followup_visit pcfv,\r\n        (SELECT MAX(visit_date) MaxVisitDate, child_id FROM ptme_child_followup_visit WHERE visit_date <= :endDate AND location_id = :locationId GROUP BY child_id ) mpcfv\r\n      WHERE\r\n        pc.child_id = pcf.child_followup_id AND pc.child_id = pcfv.child_id AND mpcfv.MaxVisitDate = pcfv.visit_date AND mpcfv.child_id = pcfv.child_id\r\n    ) cf ON cf.mother = p.patient_id\r\n  LEFT JOIN (SELECT value_datetime DateDebutARV, person_id\r\n             FROM obs\r\n             WHERE concept_id IN (159599, 164588, 165032) AND ADDDATE(value_datetime, INTERVAL 6 MONTH) BETWEEN :startDate AND :endDate AND voided = 0 GROUP BY person_id) ARV\r\n    ON ARV.person_id = p.patient_id\r\nWHERE\r\n  (pregnancy_outcome IS NULL OR (pregnancy_outcome IS NOT NULL AND eating_type = 1)) AND\r\n  arv_status_at_registering IN (0,2) AND DateDebutARV IS NOT NULL','I22','ead64c49-8319-4cd5-a425-afccae940758',1,'2018-12-05 15:17:13',1,'2018-12-05 18:13:40',0,NULL,NULL,NULL),
 (23,'Femmes enceintes ou allaitantes depistées positives nouvellement mises sous traitement ARV à M12 du début de TARV',NULL,'SELECT\r\n   count(DISTINCT p.patient_id) nb\r\n\r\nFROM\r\n  (\r\n    SELECT\r\n      DateDebutSuiviPTME, MV.pregnant_patient_id, start_date, arv_status_at_registering, mother_followup_id, pregnancy_outcome\r\n    FROM\r\n      (\r\n        SELECT\r\n          MAX(start_date) DateDebutSuiviPTME, pregnant_patient_id\r\n        FROM ptme_mother_followup WHERE start_date < :startDate AND voided = 0 AND location_id = :locationId\r\n        GROUP BY pregnant_patient_id\r\n      ) MV\r\n      ,\r\n      (SELECT start_date, pregnant_patient_id, arv_status_at_registering, mother_followup_id, pregnancy_outcome FROM ptme_mother_followup) S\r\n    WHERE S.pregnant_patient_id = MV.pregnant_patient_id AND S.start_date = MV.DateDebutSuiviPTME\r\n  ) V\r\n  INNER JOIN (SELECT pregnant_patient_id, patient_id, hiv_care_number FROM ptme_pregnant_patient WHERE voided = 0) p\r\n    ON p.pregnant_patient_id = V.pregnant_patient_id\r\n  LEFT JOIN\r\n    (\r\n      SELECT\r\n        mother, pc.child_id, eating_type\r\n      FROM\r\n        ptme_child pc,\r\n        ptme_child_followup pcf,\r\n        ptme_child_followup_visit pcfv,\r\n        (SELECT MAX(visit_date) MaxVisitDate, child_id FROM ptme_child_followup_visit WHERE visit_date <= :endDate AND location_id = :locationId GROUP BY child_id ) mpcfv\r\n      WHERE\r\n        pc.child_id = pcf.child_followup_id AND pc.child_id = pcfv.child_id AND mpcfv.MaxVisitDate = pcfv.visit_date AND mpcfv.child_id = pcfv.child_id\r\n    ) cf ON cf.mother = p.patient_id\r\n  LEFT JOIN (SELECT value_datetime DateDebutARV, person_id\r\n             FROM obs\r\n             WHERE concept_id IN (159599, 164588, 165032) AND ADDDATE(value_datetime, INTERVAL 12 MONTH) BETWEEN :startDate AND :endDate AND voided = 0 GROUP BY person_id) ARV\r\n    ON ARV.person_id = p.patient_id\r\nWHERE\r\n  (pregnancy_outcome IS NULL OR (pregnancy_outcome IS NOT NULL AND eating_type = 1)) AND\r\n  arv_status_at_registering IN (0,2) AND DateDebutARV IS NOT NULL','I23','9306139b-ab2b-4f68-81f1-6f5f0f3add4a',1,'2018-12-05 15:17:41',1,'2018-12-05 18:12:40',0,NULL,NULL,NULL),
 (24,'Femmes enceintes ou allaitantes depistées positives nouvellement en vie et sous traitement ARV à M1 du début de TARV',NULL,'SELECT\r\n  count(p.patient_id) nb\r\n\r\nFROM\r\n  (\r\n    SELECT\r\n      DateDebutSuiviPTME, MV.pregnant_patient_id, start_date, arv_status_at_registering, mother_followup_id, pregnancy_outcome\r\n    FROM\r\n      (\r\n        SELECT\r\n          MAX(start_date) DateDebutSuiviPTME, pregnant_patient_id\r\n        FROM ptme_mother_followup WHERE start_date < :startDate AND voided = 0 AND location_id = :locationId\r\n        GROUP BY pregnant_patient_id\r\n      ) MV\r\n      ,\r\n      (SELECT start_date, pregnant_patient_id, arv_status_at_registering, mother_followup_id, pregnancy_outcome FROM ptme_mother_followup) S\r\n    WHERE S.pregnant_patient_id = MV.pregnant_patient_id AND S.start_date = MV.DateDebutSuiviPTME) V\r\n  INNER JOIN (SELECT pregnant_patient_id, patient_id, hiv_care_number FROM ptme_pregnant_patient WHERE voided = 0) p\r\n    ON p.pregnant_patient_id = V.pregnant_patient_id\r\n  LEFT JOIN (SELECT value_datetime DateDebutARV, person_id\r\n             FROM obs\r\n             WHERE concept_id IN (159599, 164588, 165032) AND ADDDATE(value_datetime, INTERVAL 1 MONTH) BETWEEN :startDate AND :endDate AND voided = 0 GROUP BY person_id) DARV\r\n    ON DARV.person_id = p.patient_id\r\n\r\n  LEFT JOIN (SELECT MAX(visit_date) DateDerniereVisite, mother_followup_id FROM ptme_mother_followup_visit WHERE visit_date <= :endDate GROUP BY mother_followup_id) mpmfv\r\n    ON mpmfv.mother_followup_id = V.mother_followup_id\r\n  LEFT JOIN (SELECT continuing_arv, mother_followup_id, visit_date FROM ptme_mother_followup_visit) pmfv\r\n    ON mpmfv.mother_followup_id = pmfv.mother_followup_id AND mpmfv.DateDerniereVisite = pmfv.visit_date\r\n  LEFT JOIN\r\n  (\r\n    SELECT o.person_id, value_coded StatutARV\r\n    FROM\r\n      obs o,\r\n      (\r\n        SELECT MAX(obs_datetime) DateDernierARV, person_id\r\n        FROM obs WHERE concept_id = 1255 AND value_coded IN (1257, 1256, 1259) AND obs_datetime <= :endDate GROUP BY person_id) e\r\n    WHERE concept_id = 1255 AND o.person_id = e.person_id AND DateDernierARV = obs_datetime\r\n  ) ARV ON ARV.person_id = p.patient_id\r\n\r\n  LEFT JOIN\r\n    (\r\n      SELECT\r\n        mother, pc.child_id, eating_type\r\n      FROM\r\n        ptme_child pc,\r\n        ptme_child_followup pcf,\r\n        ptme_child_followup_visit pcfv,\r\n        (SELECT MAX(visit_date) MaxVisitDate, child_id FROM ptme_child_followup_visit WHERE visit_date <= :endDate AND location_id = :locationId GROUP BY child_id ) mpcfv\r\n      WHERE\r\n        pc.child_id = pcf.child_followup_id AND pc.child_id = pcfv.child_id AND mpcfv.MaxVisitDate = pcfv.visit_date AND mpcfv.child_id = pcfv.child_id\r\n    ) cf ON cf.mother = p.patient_id\r\n\r\n  LEFT JOIN (SELECT person_id FROM obs WHERE concept_id = 1543 AND value_datetime <= :endDate AND voided = 0) Deces ON Deces.person_id = p.patient_id\r\n\r\n  LEFT JOIN (SELECT person_id, value_datetime FROM obs WHERE concept_id = 164595 AND voided = 0 AND location_id = :locationId) Transf\r\n    ON Transf.person_id = p.patient_id AND (Transf.value_datetime BETWEEN V.DateDebutSuiviPTME AND :endDate)\r\nWHERE\r\n  Transf.person_id IS NULL AND Deces.person_id IS NULL AND\r\n  arv_status_at_registering IN (0,2) AND DateDebutARV IS NOT NULL AND\r\n  (pregnancy_outcome IS NULL OR (pregnancy_outcome IS NOT NULL AND eating_type = 1)) AND\r\n  (continuing_arv = 1 OR StatutARV IS NOT NULL)','I24','f7e6bc04-dd16-4536-8912-98be194a1659',1,'2018-12-05 16:59:37',1,'2018-12-06 08:27:53',0,NULL,NULL,NULL),
 (25,'Femmes enceintes ou allaitantes depistées positives nouvellement en vie et sous traitement ARV à M2 du début de TARV',NULL,'SELECT\r\n  count(p.patient_id) nb\r\n\r\nFROM\r\n  (\r\n    SELECT\r\n      DateDebutSuiviPTME, MV.pregnant_patient_id, start_date, arv_status_at_registering, mother_followup_id, pregnancy_outcome\r\n    FROM\r\n      (\r\n        SELECT\r\n          MAX(start_date) DateDebutSuiviPTME, pregnant_patient_id\r\n        FROM ptme_mother_followup WHERE start_date < :startDate AND voided = 0 AND location_id = :locationId\r\n        GROUP BY pregnant_patient_id\r\n      ) MV\r\n      ,\r\n      (SELECT start_date, pregnant_patient_id, arv_status_at_registering, mother_followup_id, pregnancy_outcome FROM ptme_mother_followup) S\r\n    WHERE S.pregnant_patient_id = MV.pregnant_patient_id AND S.start_date = MV.DateDebutSuiviPTME) V\r\n  INNER JOIN (SELECT pregnant_patient_id, patient_id, hiv_care_number FROM ptme_pregnant_patient WHERE voided = 0) p\r\n    ON p.pregnant_patient_id = V.pregnant_patient_id\r\n  LEFT JOIN (SELECT value_datetime DateDebutARV, person_id\r\n             FROM obs\r\n             WHERE concept_id IN (159599, 164588, 165032) AND ADDDATE(value_datetime, INTERVAL 2 MONTH) BETWEEN :startDate AND :endDate AND voided = 0 GROUP BY person_id) DARV\r\n    ON DARV.person_id = p.patient_id\r\n\r\n  LEFT JOIN (SELECT MAX(visit_date) DateDerniereVisite, mother_followup_id FROM ptme_mother_followup_visit WHERE visit_date <= :endDate GROUP BY mother_followup_id) mpmfv\r\n    ON mpmfv.mother_followup_id = V.mother_followup_id\r\n  LEFT JOIN (SELECT continuing_arv, mother_followup_id, visit_date FROM ptme_mother_followup_visit) pmfv\r\n    ON mpmfv.mother_followup_id = pmfv.mother_followup_id AND mpmfv.DateDerniereVisite = pmfv.visit_date\r\n  LEFT JOIN\r\n  (\r\n    SELECT o.person_id, value_coded StatutARV\r\n    FROM\r\n      obs o,\r\n      (\r\n        SELECT MAX(obs_datetime) DateDernierARV, person_id\r\n        FROM obs WHERE concept_id = 1255 AND value_coded IN (1257, 1256, 1259) AND obs_datetime <= :endDate GROUP BY person_id) e\r\n    WHERE concept_id = 1255 AND o.person_id = e.person_id AND DateDernierARV = obs_datetime\r\n  ) ARV ON ARV.person_id = p.patient_id\r\n\r\n  LEFT JOIN\r\n    (\r\n      SELECT\r\n        mother, pc.child_id, eating_type\r\n      FROM\r\n        ptme_child pc,\r\n        ptme_child_followup pcf,\r\n        ptme_child_followup_visit pcfv,\r\n        (SELECT MAX(visit_date) MaxVisitDate, child_id FROM ptme_child_followup_visit WHERE visit_date <= :endDate AND location_id = :locationId GROUP BY child_id ) mpcfv\r\n      WHERE\r\n        pc.child_id = pcf.child_followup_id AND pc.child_id = pcfv.child_id AND mpcfv.MaxVisitDate = pcfv.visit_date AND mpcfv.child_id = pcfv.child_id\r\n    ) cf ON cf.mother = p.patient_id\r\n\r\n  LEFT JOIN (SELECT person_id FROM obs WHERE concept_id = 1543 AND value_datetime <= :endDate AND voided = 0) Deces ON Deces.person_id = p.patient_id\r\n\r\n  LEFT JOIN (SELECT person_id, value_datetime FROM obs WHERE concept_id = 164595 AND voided = 0 AND location_id = :locationId) Transf\r\n    ON Transf.person_id = p.patient_id AND (Transf.value_datetime BETWEEN V.DateDebutSuiviPTME AND :endDate)\r\nWHERE\r\n  Transf.person_id IS NULL AND Deces.person_id IS NULL AND\r\n  arv_status_at_registering IN (0,2) AND DateDebutARV IS NOT NULL AND\r\n  (pregnancy_outcome IS NULL OR (pregnancy_outcome IS NOT NULL AND eating_type = 1)) AND\r\n  (continuing_arv = 1 OR StatutARV IS NOT NULL)','I25','343be81f-0795-4eb1-ac72-04d87d8f8542',1,'2018-12-05 17:01:10',1,'2018-12-06 08:27:36',0,NULL,NULL,NULL),
 (26,'Femmes enceintes ou allaitantes depistées positives nouvellement en vie et sous traitement ARV à M3 du début de TARV',NULL,'SELECT\r\n  count(p.patient_id) nb\r\n\r\nFROM\r\n  (\r\n    SELECT\r\n      DateDebutSuiviPTME, MV.pregnant_patient_id, start_date, arv_status_at_registering, mother_followup_id, pregnancy_outcome\r\n    FROM\r\n      (\r\n        SELECT\r\n          MAX(start_date) DateDebutSuiviPTME, pregnant_patient_id\r\n        FROM ptme_mother_followup WHERE start_date < :startDate AND voided = 0 AND location_id = :locationId\r\n        GROUP BY pregnant_patient_id\r\n      ) MV\r\n      ,\r\n      (SELECT start_date, pregnant_patient_id, arv_status_at_registering, mother_followup_id, pregnancy_outcome FROM ptme_mother_followup) S\r\n    WHERE S.pregnant_patient_id = MV.pregnant_patient_id AND S.start_date = MV.DateDebutSuiviPTME) V\r\n  INNER JOIN (SELECT pregnant_patient_id, patient_id, hiv_care_number FROM ptme_pregnant_patient WHERE voided = 0) p\r\n    ON p.pregnant_patient_id = V.pregnant_patient_id\r\n  LEFT JOIN (SELECT value_datetime DateDebutARV, person_id\r\n             FROM obs\r\n             WHERE concept_id IN (159599, 164588, 165032) AND ADDDATE(value_datetime, INTERVAL 3 MONTH) BETWEEN :startDate AND :endDate AND voided = 0 GROUP BY person_id) DARV\r\n    ON DARV.person_id = p.patient_id\r\n\r\n  LEFT JOIN (SELECT MAX(visit_date) DateDerniereVisite, mother_followup_id FROM ptme_mother_followup_visit WHERE visit_date <= :endDate GROUP BY mother_followup_id) mpmfv\r\n    ON mpmfv.mother_followup_id = V.mother_followup_id\r\n  LEFT JOIN (SELECT continuing_arv, mother_followup_id, visit_date FROM ptme_mother_followup_visit) pmfv\r\n    ON mpmfv.mother_followup_id = pmfv.mother_followup_id AND mpmfv.DateDerniereVisite = pmfv.visit_date\r\n  LEFT JOIN\r\n  (\r\n    SELECT o.person_id, value_coded StatutARV\r\n    FROM\r\n      obs o,\r\n      (\r\n        SELECT MAX(obs_datetime) DateDernierARV, person_id\r\n        FROM obs WHERE concept_id = 1255 AND value_coded IN (1257, 1256, 1259) AND obs_datetime <= :endDate GROUP BY person_id) e\r\n    WHERE concept_id = 1255 AND o.person_id = e.person_id AND DateDernierARV = obs_datetime\r\n  ) ARV ON ARV.person_id = p.patient_id\r\n\r\n  LEFT JOIN\r\n    (\r\n      SELECT\r\n        mother, pc.child_id, eating_type\r\n      FROM\r\n        ptme_child pc,\r\n        ptme_child_followup pcf,\r\n        ptme_child_followup_visit pcfv,\r\n        (SELECT MAX(visit_date) MaxVisitDate, child_id FROM ptme_child_followup_visit WHERE visit_date <= :endDate AND location_id = :locationId GROUP BY child_id ) mpcfv\r\n      WHERE\r\n        pc.child_id = pcf.child_followup_id AND pc.child_id = pcfv.child_id AND mpcfv.MaxVisitDate = pcfv.visit_date AND mpcfv.child_id = pcfv.child_id\r\n    ) cf ON cf.mother = p.patient_id\r\n\r\n  LEFT JOIN (SELECT person_id FROM obs WHERE concept_id = 1543 AND value_datetime <= :endDate AND voided = 0) Deces ON Deces.person_id = p.patient_id\r\n\r\n  LEFT JOIN (SELECT person_id, value_datetime FROM obs WHERE concept_id = 164595 AND voided = 0 AND location_id = :locationId) Transf\r\n    ON Transf.person_id = p.patient_id AND (Transf.value_datetime BETWEEN V.DateDebutSuiviPTME AND :endDate)\r\nWHERE\r\n  Transf.person_id IS NULL AND Deces.person_id IS NULL AND\r\n  arv_status_at_registering IN (0,2) AND DateDebutARV IS NOT NULL AND\r\n  (pregnancy_outcome IS NULL OR (pregnancy_outcome IS NOT NULL AND eating_type = 1)) AND\r\n  (continuing_arv = 1 OR StatutARV IS NOT NULL)','I26','4afb7994-e83c-45a2-9096-25bcdde2e277',1,'2018-12-05 17:02:05',1,'2018-12-06 08:27:20',0,NULL,NULL,NULL),
 (27,'Femmes enceintes ou allaitantes depistées positives nouvellement en vie et sous traitement ARV à M6 du début de TARV',NULL,'SELECT\r\n  count(p.patient_id) nb\r\n\r\nFROM\r\n  (\r\n    SELECT\r\n      DateDebutSuiviPTME, MV.pregnant_patient_id, start_date, arv_status_at_registering, mother_followup_id, pregnancy_outcome\r\n    FROM\r\n      (\r\n        SELECT\r\n          MAX(start_date) DateDebutSuiviPTME, pregnant_patient_id\r\n        FROM ptme_mother_followup WHERE start_date < :startDate AND voided = 0 AND location_id = :locationId\r\n        GROUP BY pregnant_patient_id\r\n      ) MV\r\n      ,\r\n      (SELECT start_date, pregnant_patient_id, arv_status_at_registering, mother_followup_id, pregnancy_outcome FROM ptme_mother_followup) S\r\n    WHERE S.pregnant_patient_id = MV.pregnant_patient_id AND S.start_date = MV.DateDebutSuiviPTME) V\r\n  INNER JOIN (SELECT pregnant_patient_id, patient_id, hiv_care_number FROM ptme_pregnant_patient WHERE voided = 0) p\r\n    ON p.pregnant_patient_id = V.pregnant_patient_id\r\n  LEFT JOIN (SELECT value_datetime DateDebutARV, person_id\r\n             FROM obs\r\n             WHERE concept_id IN (159599, 164588, 165032) AND ADDDATE(value_datetime, INTERVAL 6 MONTH) BETWEEN :startDate AND :endDate AND voided = 0 GROUP BY person_id) DARV\r\n    ON DARV.person_id = p.patient_id\r\n\r\n  LEFT JOIN (SELECT MAX(visit_date) DateDerniereVisite, mother_followup_id FROM ptme_mother_followup_visit WHERE visit_date <= :endDate GROUP BY mother_followup_id) mpmfv\r\n    ON mpmfv.mother_followup_id = V.mother_followup_id\r\n  LEFT JOIN (SELECT continuing_arv, mother_followup_id, visit_date FROM ptme_mother_followup_visit) pmfv\r\n    ON mpmfv.mother_followup_id = pmfv.mother_followup_id AND mpmfv.DateDerniereVisite = pmfv.visit_date\r\n  LEFT JOIN\r\n  (\r\n    SELECT o.person_id, value_coded StatutARV\r\n    FROM\r\n      obs o,\r\n      (\r\n        SELECT MAX(obs_datetime) DateDernierARV, person_id\r\n        FROM obs WHERE concept_id = 1255 AND value_coded IN (1257, 1256, 1259) AND obs_datetime <= :endDate GROUP BY person_id) e\r\n    WHERE concept_id = 1255 AND o.person_id = e.person_id AND DateDernierARV = obs_datetime\r\n  ) ARV ON ARV.person_id = p.patient_id\r\n\r\n  LEFT JOIN\r\n    (\r\n      SELECT\r\n        mother, pc.child_id, eating_type\r\n      FROM\r\n        ptme_child pc,\r\n        ptme_child_followup pcf,\r\n        ptme_child_followup_visit pcfv,\r\n        (SELECT MAX(visit_date) MaxVisitDate, child_id FROM ptme_child_followup_visit WHERE visit_date <= :endDate AND location_id = :locationId GROUP BY child_id ) mpcfv\r\n      WHERE\r\n        pc.child_id = pcf.child_followup_id AND pc.child_id = pcfv.child_id AND mpcfv.MaxVisitDate = pcfv.visit_date AND mpcfv.child_id = pcfv.child_id\r\n    ) cf ON cf.mother = p.patient_id\r\n\r\n  LEFT JOIN (SELECT person_id FROM obs WHERE concept_id = 1543 AND value_datetime <= :endDate AND voided = 0) Deces ON Deces.person_id = p.patient_id\r\n\r\n  LEFT JOIN (SELECT person_id, value_datetime FROM obs WHERE concept_id = 164595 AND voided = 0 AND location_id = :locationId) Transf\r\n    ON Transf.person_id = p.patient_id AND (Transf.value_datetime BETWEEN V.DateDebutSuiviPTME AND :endDate)\r\nWHERE\r\n  Transf.person_id IS NULL AND Deces.person_id IS NULL AND\r\n  arv_status_at_registering IN (0,2) AND DateDebutARV IS NOT NULL AND\r\n  (pregnancy_outcome IS NULL OR (pregnancy_outcome IS NOT NULL AND eating_type = 1)) AND\r\n  (continuing_arv = 1 OR StatutARV IS NOT NULL)','I27','21fb3a5d-1fe0-4da4-abdd-3d3a6deea605',1,'2018-12-05 17:02:45',1,'2018-12-06 08:27:01',0,NULL,NULL,NULL),
 (28,'Femmes enceintes ou allaitantes depistées positives nouvellement en vie et sous traitement ARV à M12 du début de TARV',NULL,'SELECT\r\n  count(p.patient_id) nb\r\n\r\nFROM\r\n  (\r\n    SELECT\r\n      DateDebutSuiviPTME, MV.pregnant_patient_id, start_date, arv_status_at_registering, mother_followup_id, pregnancy_outcome\r\n    FROM\r\n      (\r\n        SELECT\r\n          MAX(start_date) DateDebutSuiviPTME, pregnant_patient_id\r\n        FROM ptme_mother_followup WHERE start_date < :startDate AND voided = 0 AND location_id = :locationId\r\n        GROUP BY pregnant_patient_id\r\n      ) MV\r\n      ,\r\n      (SELECT start_date, pregnant_patient_id, arv_status_at_registering, mother_followup_id, pregnancy_outcome FROM ptme_mother_followup) S\r\n    WHERE S.pregnant_patient_id = MV.pregnant_patient_id AND S.start_date = MV.DateDebutSuiviPTME) V\r\n  INNER JOIN (SELECT pregnant_patient_id, patient_id, hiv_care_number FROM ptme_pregnant_patient WHERE voided = 0) p\r\n    ON p.pregnant_patient_id = V.pregnant_patient_id\r\n  LEFT JOIN (SELECT value_datetime DateDebutARV, person_id\r\n             FROM obs\r\n             WHERE concept_id IN (159599, 164588, 165032) AND ADDDATE(value_datetime, INTERVAL 12 MONTH) BETWEEN :startDate AND :endDate AND voided = 0 GROUP BY person_id) DARV\r\n    ON DARV.person_id = p.patient_id\r\n\r\n  LEFT JOIN (SELECT MAX(visit_date) DateDerniereVisite, mother_followup_id FROM ptme_mother_followup_visit WHERE visit_date <= :endDate GROUP BY mother_followup_id) mpmfv\r\n    ON mpmfv.mother_followup_id = V.mother_followup_id\r\n  LEFT JOIN (SELECT continuing_arv, mother_followup_id, visit_date FROM ptme_mother_followup_visit) pmfv\r\n    ON mpmfv.mother_followup_id = pmfv.mother_followup_id AND mpmfv.DateDerniereVisite = pmfv.visit_date\r\n  LEFT JOIN\r\n  (\r\n    SELECT o.person_id, value_coded StatutARV\r\n    FROM\r\n      obs o,\r\n      (\r\n        SELECT MAX(obs_datetime) DateDernierARV, person_id\r\n        FROM obs WHERE concept_id = 1255 AND value_coded IN (1257, 1256, 1259) AND obs_datetime <= :endDate GROUP BY person_id) e\r\n    WHERE concept_id = 1255 AND o.person_id = e.person_id AND DateDernierARV = obs_datetime\r\n  ) ARV ON ARV.person_id = p.patient_id\r\n\r\n  LEFT JOIN\r\n    (\r\n      SELECT\r\n        mother, pc.child_id, eating_type\r\n      FROM\r\n        ptme_child pc,\r\n        ptme_child_followup pcf,\r\n        ptme_child_followup_visit pcfv,\r\n        (SELECT MAX(visit_date) MaxVisitDate, child_id FROM ptme_child_followup_visit WHERE visit_date <= :endDate AND location_id = :locationId GROUP BY child_id ) mpcfv\r\n      WHERE\r\n        pc.child_id = pcf.child_followup_id AND pc.child_id = pcfv.child_id AND mpcfv.MaxVisitDate = pcfv.visit_date AND mpcfv.child_id = pcfv.child_id\r\n    ) cf ON cf.mother = p.patient_id\r\n\r\n  LEFT JOIN (SELECT person_id FROM obs WHERE concept_id = 1543 AND value_datetime <= :endDate AND voided = 0) Deces ON Deces.person_id = p.patient_id\r\n\r\n  LEFT JOIN (SELECT person_id, value_datetime FROM obs WHERE concept_id = 164595 AND voided = 0 AND location_id = :locationId) Transf\r\n    ON Transf.person_id = p.patient_id AND (Transf.value_datetime BETWEEN V.DateDebutSuiviPTME AND :endDate)\r\nWHERE\r\n  Transf.person_id IS NULL AND Deces.person_id IS NULL AND\r\n  arv_status_at_registering IN (0,2) AND DateDebutARV IS NOT NULL AND\r\n  (pregnancy_outcome IS NULL OR (pregnancy_outcome IS NOT NULL AND eating_type = 1)) AND\r\n  (continuing_arv = 1 OR StatutARV IS NOT NULL)','I28','bd2fb20d-006b-45db-91f0-0d47f6f3eac5',1,'2018-12-05 17:03:43',1,'2018-12-06 08:26:39',0,NULL,NULL,NULL),
 (29,'Femmes enceintes ou allaitantes déjà sous ARV contractant une nouvelle grossesse à M1 de la 1ere CPN',NULL,'SELECT\r\n  count(DISTINCT p.patient_id) nb\r\n\r\nFROM\r\n  (\r\n    SELECT\r\n      DateDebutSuiviPTME, MV.pregnant_patient_id, start_date, arv_status_at_registering, mother_followup_id, pregnancy_outcome\r\n    FROM\r\n      (\r\n        SELECT\r\n          MAX(start_date) DateDebutSuiviPTME, pregnant_patient_id\r\n        FROM ptme_mother_followup WHERE start_date < :startDate AND voided = 0 AND location_id = :locationId\r\n        GROUP BY pregnant_patient_id\r\n      ) MV\r\n      ,\r\n      (SELECT start_date, pregnant_patient_id, arv_status_at_registering, mother_followup_id, pregnancy_outcome FROM ptme_mother_followup) S\r\n    WHERE S.pregnant_patient_id = MV.pregnant_patient_id AND S.start_date = MV.DateDebutSuiviPTME\r\n  ) V\r\n\r\n  INNER JOIN (SELECT pregnant_patient_id, patient_id, hiv_care_number FROM ptme_pregnant_patient WHERE voided = 0) p\r\n    ON p.pregnant_patient_id = V.pregnant_patient_id\r\n\r\n  LEFT JOIN\r\n    (\r\n      SELECT\r\n        mother, pc.child_id, eating_type\r\n      FROM\r\n        ptme_child pc,\r\n        ptme_child_followup pcf,\r\n        ptme_child_followup_visit pcfv,\r\n        (SELECT MAX(visit_date) MaxVisitDate, child_id FROM ptme_child_followup_visit WHERE visit_date <= :endDate AND location_id = :locationId GROUP BY child_id ) mpcfv\r\n      WHERE\r\n        pc.child_id = pcf.child_followup_id AND pc.child_id = pcfv.child_id AND mpcfv.MaxVisitDate = pcfv.visit_date AND mpcfv.child_id = pcfv.child_id\r\n    ) cf ON cf.mother = p.patient_id\r\n\r\n  LEFT JOIN (SELECT MAX(value_datetime) DateDebutARV, person_id\r\n             FROM obs o, encounter e\r\n             WHERE o.encounter_id = e.encounter_id AND concept_id IN (159599, 164588, 165032) AND o.voided = 0 GROUP BY person_id) ARV\r\n    ON ARV.person_id = p.patient_id\r\nWHERE\r\n  arv_status_at_registering = 1\r\n  AND DateDebutARV IS NOT NULL\r\n  AND (pregnancy_outcome IS NULL OR (pregnancy_outcome IN (1,2) AND eating_type = 1))\r\n  AND ADDDATE(start_date, INTERVAL 1 MONTH) BETWEEN :startDate AND :endDate','I29','18e7e7ee-1d2e-4591-82e2-161ae178a5b1',1,'2018-12-09 11:43:47',1,'2018-12-09 12:10:47',0,NULL,NULL,NULL),
 (30,'Femmes enceintes ou allaitantes déjà sous ARV contractant une nouvelle grossesse à M2 de la 1ere CPN',NULL,'SELECT\r\n  count(DISTINCT p.patient_id) nb\r\n\r\nFROM\r\n  (\r\n    SELECT\r\n      DateDebutSuiviPTME, MV.pregnant_patient_id, start_date, arv_status_at_registering, mother_followup_id, pregnancy_outcome\r\n    FROM\r\n      (\r\n        SELECT\r\n          MAX(start_date) DateDebutSuiviPTME, pregnant_patient_id\r\n        FROM ptme_mother_followup WHERE start_date < :startDate AND voided = 0 AND location_id = :locationId\r\n        GROUP BY pregnant_patient_id\r\n      ) MV\r\n      ,\r\n      (SELECT start_date, pregnant_patient_id, arv_status_at_registering, mother_followup_id, pregnancy_outcome FROM ptme_mother_followup) S\r\n    WHERE S.pregnant_patient_id = MV.pregnant_patient_id AND S.start_date = MV.DateDebutSuiviPTME\r\n  ) V\r\n\r\n  INNER JOIN (SELECT pregnant_patient_id, patient_id, hiv_care_number FROM ptme_pregnant_patient WHERE voided = 0) p\r\n    ON p.pregnant_patient_id = V.pregnant_patient_id\r\n\r\n  LEFT JOIN\r\n    (\r\n      SELECT\r\n        mother, pc.child_id, eating_type\r\n      FROM\r\n        ptme_child pc,\r\n        ptme_child_followup pcf,\r\n        ptme_child_followup_visit pcfv,\r\n        (SELECT MAX(visit_date) MaxVisitDate, child_id FROM ptme_child_followup_visit WHERE visit_date <= :endDate AND location_id = :locationId GROUP BY child_id ) mpcfv\r\n      WHERE\r\n        pc.child_id = pcf.child_followup_id AND pc.child_id = pcfv.child_id AND mpcfv.MaxVisitDate = pcfv.visit_date AND mpcfv.child_id = pcfv.child_id\r\n    ) cf ON cf.mother = p.patient_id\r\n\r\n  LEFT JOIN (SELECT MAX(value_datetime) DateDebutARV, person_id\r\n             FROM obs o, encounter e\r\n             WHERE o.encounter_id = e.encounter_id AND concept_id IN (159599, 164588, 165032) AND o.voided = 0 GROUP BY person_id) ARV\r\n    ON ARV.person_id = p.patient_id\r\nWHERE\r\n  arv_status_at_registering = 1\r\n  AND DateDebutARV IS NOT NULL\r\n  AND (pregnancy_outcome IS NULL OR (pregnancy_outcome IN (1,2) AND eating_type = 1))\r\n  AND ADDDATE(start_date, INTERVAL 2 MONTH) BETWEEN :startDate AND :endDate','I30','043694a1-e290-4450-9377-fec4a9bc2c37',1,'2018-12-09 11:47:31',1,'2018-12-09 12:08:47',0,NULL,NULL,NULL),
 (31,'Femmes  enceintes ou allaitantes déjà sous ARV contractant une nouvelle grossesse à M3 de la 1ere CPN',NULL,'SELECT\r\n  count(DISTINCT p.patient_id) nb\r\n\r\nFROM\r\n  (\r\n    SELECT\r\n      DateDebutSuiviPTME, MV.pregnant_patient_id, start_date, arv_status_at_registering, mother_followup_id, pregnancy_outcome\r\n    FROM\r\n      (\r\n        SELECT\r\n          MAX(start_date) DateDebutSuiviPTME, pregnant_patient_id\r\n        FROM ptme_mother_followup WHERE start_date < :startDate AND voided = 0 AND location_id = :locationId\r\n        GROUP BY pregnant_patient_id\r\n      ) MV\r\n      ,\r\n      (SELECT start_date, pregnant_patient_id, arv_status_at_registering, mother_followup_id, pregnancy_outcome FROM ptme_mother_followup) S\r\n    WHERE S.pregnant_patient_id = MV.pregnant_patient_id AND S.start_date = MV.DateDebutSuiviPTME\r\n  ) V\r\n\r\n  INNER JOIN (SELECT pregnant_patient_id, patient_id, hiv_care_number FROM ptme_pregnant_patient WHERE voided = 0) p\r\n    ON p.pregnant_patient_id = V.pregnant_patient_id\r\n\r\n  LEFT JOIN\r\n    (\r\n      SELECT\r\n        mother, pc.child_id, eating_type\r\n      FROM\r\n        ptme_child pc,\r\n        ptme_child_followup pcf,\r\n        ptme_child_followup_visit pcfv,\r\n        (SELECT MAX(visit_date) MaxVisitDate, child_id FROM ptme_child_followup_visit WHERE visit_date <= :endDate AND location_id = :locationId GROUP BY child_id ) mpcfv\r\n      WHERE\r\n        pc.child_id = pcf.child_followup_id AND pc.child_id = pcfv.child_id AND mpcfv.MaxVisitDate = pcfv.visit_date AND mpcfv.child_id = pcfv.child_id\r\n    ) cf ON cf.mother = p.patient_id\r\n\r\n  LEFT JOIN (SELECT MAX(value_datetime) DateDebutARV, person_id\r\n             FROM obs o, encounter e\r\n             WHERE o.encounter_id = e.encounter_id AND concept_id IN (159599, 164588, 165032) AND o.voided = 0 GROUP BY person_id) ARV\r\n    ON ARV.person_id = p.patient_id\r\nWHERE\r\n  arv_status_at_registering = 1\r\n  AND DateDebutARV IS NOT NULL\r\n  AND (pregnancy_outcome IS NULL OR (pregnancy_outcome IN (1,2) AND eating_type = 1))\r\n  AND ADDDATE(start_date, INTERVAL 3 MONTH) BETWEEN :startDate AND :endDate','I31','3d36b009-fa26-45ab-a433-a0ff2518a9ab',1,'2018-12-09 11:50:41',1,'2018-12-09 12:09:10',0,NULL,NULL,NULL),
 (32,'Femmes enceintes ou allaitantes déjà sous ARV contractant une nouvelle grossesse à M6 de la 1ere CPN',NULL,'SELECT\r\n  count(DISTINCT p.patient_id) nb\r\n\r\nFROM\r\n  (\r\n    SELECT\r\n      DateDebutSuiviPTME, MV.pregnant_patient_id, start_date, arv_status_at_registering, mother_followup_id, pregnancy_outcome\r\n    FROM\r\n      (\r\n        SELECT\r\n          MAX(start_date) DateDebutSuiviPTME, pregnant_patient_id\r\n        FROM ptme_mother_followup WHERE start_date < :startDate AND voided = 0 AND location_id = :locationId\r\n        GROUP BY pregnant_patient_id\r\n      ) MV\r\n      ,\r\n      (SELECT start_date, pregnant_patient_id, arv_status_at_registering, mother_followup_id, pregnancy_outcome FROM ptme_mother_followup) S\r\n    WHERE S.pregnant_patient_id = MV.pregnant_patient_id AND S.start_date = MV.DateDebutSuiviPTME\r\n  ) V\r\n\r\n  INNER JOIN (SELECT pregnant_patient_id, patient_id, hiv_care_number FROM ptme_pregnant_patient WHERE voided = 0) p\r\n    ON p.pregnant_patient_id = V.pregnant_patient_id\r\n\r\n  LEFT JOIN\r\n    (\r\n      SELECT\r\n        mother, pc.child_id, eating_type\r\n      FROM\r\n        ptme_child pc,\r\n        ptme_child_followup pcf,\r\n        ptme_child_followup_visit pcfv,\r\n        (SELECT MAX(visit_date) MaxVisitDate, child_id FROM ptme_child_followup_visit WHERE visit_date <= :endDate AND location_id = :locationId GROUP BY child_id ) mpcfv\r\n      WHERE\r\n        pc.child_id = pcf.child_followup_id AND pc.child_id = pcfv.child_id AND mpcfv.MaxVisitDate = pcfv.visit_date AND mpcfv.child_id = pcfv.child_id\r\n    ) cf ON cf.mother = p.patient_id\r\n\r\n  LEFT JOIN (SELECT MAX(value_datetime) DateDebutARV, person_id\r\n             FROM obs o, encounter e\r\n             WHERE o.encounter_id = e.encounter_id AND concept_id IN (159599, 164588, 165032) AND o.voided = 0 GROUP BY person_id) ARV\r\n    ON ARV.person_id = p.patient_id\r\nWHERE\r\n  arv_status_at_registering = 1\r\n  AND DateDebutARV IS NOT NULL\r\n  AND (pregnancy_outcome IS NULL OR (pregnancy_outcome IN (1,2) AND eating_type = 1))\r\n  AND ADDDATE(start_date, INTERVAL 6 MONTH) BETWEEN :startDate AND :endDate','I32','5e01ba24-e401-4fbb-bdb5-e9f44b3f0537',1,'2018-12-09 11:52:43',1,'2018-12-09 12:09:46',0,NULL,NULL,NULL),
 (33,'Femmes enceintes ou allaitantes déjà sous ARV contractant une nouvelle grossesse à M12 de la 1ere CPN',NULL,'SELECT\r\n  count(DISTINCT p.patient_id) nb\r\n\r\nFROM\r\n  (\r\n    SELECT\r\n      DateDebutSuiviPTME, MV.pregnant_patient_id, start_date, arv_status_at_registering, mother_followup_id, pregnancy_outcome\r\n    FROM\r\n      (\r\n        SELECT\r\n          MAX(start_date) DateDebutSuiviPTME, pregnant_patient_id\r\n        FROM ptme_mother_followup WHERE start_date < :startDate AND voided = 0 AND location_id = :locationId\r\n        GROUP BY pregnant_patient_id\r\n      ) MV\r\n      ,\r\n      (SELECT start_date, pregnant_patient_id, arv_status_at_registering, mother_followup_id, pregnancy_outcome FROM ptme_mother_followup) S\r\n    WHERE S.pregnant_patient_id = MV.pregnant_patient_id AND S.start_date = MV.DateDebutSuiviPTME\r\n  ) V\r\n\r\n  INNER JOIN (SELECT pregnant_patient_id, patient_id, hiv_care_number FROM ptme_pregnant_patient WHERE voided = 0) p\r\n    ON p.pregnant_patient_id = V.pregnant_patient_id\r\n\r\n  LEFT JOIN\r\n    (\r\n      SELECT\r\n        mother, pc.child_id, eating_type\r\n      FROM\r\n        ptme_child pc,\r\n        ptme_child_followup pcf,\r\n        ptme_child_followup_visit pcfv,\r\n        (SELECT MAX(visit_date) MaxVisitDate, child_id FROM ptme_child_followup_visit WHERE visit_date <= :endDate AND location_id = :locationId GROUP BY child_id ) mpcfv\r\n      WHERE\r\n        pc.child_id = pcf.child_followup_id AND pc.child_id = pcfv.child_id AND mpcfv.MaxVisitDate = pcfv.visit_date AND mpcfv.child_id = pcfv.child_id\r\n    ) cf ON cf.mother = p.patient_id\r\n\r\n  LEFT JOIN (SELECT MAX(value_datetime) DateDebutARV, person_id\r\n             FROM obs o, encounter e\r\n             WHERE o.encounter_id = e.encounter_id AND concept_id IN (159599, 164588, 165032) AND o.voided = 0 GROUP BY person_id) ARV\r\n    ON ARV.person_id = p.patient_id\r\nWHERE\r\n  arv_status_at_registering = 1\r\n  AND DateDebutARV IS NOT NULL\r\n  AND (pregnancy_outcome IS NULL OR (pregnancy_outcome IN (1,2) AND eating_type = 1))\r\n  AND ADDDATE(start_date, INTERVAL 12 MONTH) BETWEEN :startDate AND :endDate','I33','e6023e1e-0cd2-46c7-8a43-b57bf5e577a8',1,'2018-12-09 11:58:04',1,'2018-12-09 12:08:01',0,NULL,NULL,NULL),
 (34,'Femmes enceintes ou allaitantes déjà sous ARV contractant une nouvelle grossesse en vie et sous traitement ARV à M1 de la 1ere CPN',NULL,'SELECT\r\n  count(DISTINCT p.patient_id) nb\r\n\r\nFROM\r\n  (\r\n    SELECT\r\n      DateDebutSuiviPTME, MV.pregnant_patient_id, start_date, arv_status_at_registering, S.mother_followup_id, pregnancy_outcome, continuing_arv\r\n    FROM\r\n      (\r\n        SELECT\r\n          MAX(start_date) DateDebutSuiviPTME, pregnant_patient_id\r\n        FROM ptme_mother_followup WHERE start_date < :startDate AND voided = 0 AND location_id = :locationId\r\n        GROUP BY pregnant_patient_id\r\n      ) MV\r\n      ,\r\n      (SELECT start_date, pregnant_patient_id, arv_status_at_registering, mother_followup_id, pregnancy_outcome, end_date FROM ptme_mother_followup) S,\r\n      (SELECT * FROM ptme_mother_followup_visit WHERE location_id = :locationId) V\r\n    WHERE\r\n      V.mother_followup_id = S.mother_followup_id AND\r\n      S.pregnant_patient_id = MV.pregnant_patient_id AND\r\n      S.start_date = MV.DateDebutSuiviPTME AND\r\n      V.visit_date = S.end_date\r\n  ) V\r\n\r\n  INNER JOIN (SELECT pregnant_patient_id, patient_id, hiv_care_number FROM ptme_pregnant_patient WHERE voided = 0) p\r\n    ON p.pregnant_patient_id = V.pregnant_patient_id\r\n\r\n  LEFT JOIN\r\n    (\r\n      SELECT\r\n        mother, pc.child_id, eating_type\r\n      FROM\r\n        ptme_child pc,\r\n        ptme_child_followup pcf,\r\n        ptme_child_followup_visit pcfv,\r\n        (SELECT MAX(visit_date) MaxVisitDate, child_id FROM ptme_child_followup_visit WHERE visit_date <= :endDate AND location_id = :locationId GROUP BY child_id ) mpcfv\r\n      WHERE\r\n        pc.child_id = pcf.child_followup_id AND pc.child_id = pcfv.child_id AND mpcfv.MaxVisitDate = pcfv.visit_date AND mpcfv.child_id = pcfv.child_id\r\n    ) cf ON cf.mother = p.patient_id\r\n\r\n  LEFT JOIN\r\n  (\r\n    SELECT o.person_id, value_coded StatutARV\r\n    FROM\r\n      obs o,\r\n      (\r\n        SELECT MAX(obs_datetime) DateDernierARV, person_id\r\n        FROM obs WHERE concept_id = 1255 AND value_coded IN (1257, 1256, 1259) AND obs_datetime <= :endDate GROUP BY person_id\r\n      ) e\r\n    WHERE concept_id = 1255 AND o.person_id = e.person_id AND DateDernierARV = obs_datetime\r\n  ) TTT ON TTT.person_id = p.patient_id\r\n\r\n  LEFT JOIN (SELECT value_datetime DateDebutARV, person_id\r\n             FROM obs\r\n             WHERE concept_id IN (159599, 164588, 165032) AND voided = 0 GROUP BY person_id) ARV\r\n    ON ARV.person_id = p.patient_id\r\n  LEFT JOIN (SELECT person_id FROM obs WHERE concept_id = 1543 AND value_datetime <= :endDate AND voided = 0) Deces ON Deces.person_id = p.patient_id\r\n\r\n  LEFT JOIN (SELECT person_id, value_datetime FROM obs WHERE concept_id = 164595 AND voided = 0 AND location_id = :locationId) Transf\r\n    ON Transf.person_id = p.patient_id AND (Transf.value_datetime BETWEEN V.DateDebutSuiviPTME AND :endDate)\r\nWHERE\r\n  Transf.person_id IS NULL AND Deces.person_id IS NULL AND\r\n  arv_status_at_registering IN (1)\r\n  AND DateDebutARV IS NOT NULL\r\n  AND (StatutARV IS NOT NULL OR continuing_arv = 1)\r\n  AND (pregnancy_outcome IS NULL OR (pregnancy_outcome IN (1,2) AND eating_type = 1))\r\n  AND ADDDATE(start_date, INTERVAL 1 MONTH) BETWEEN :startDate AND :endDate','I34','283515e6-4098-4588-9946-90aa4032d138',1,'2018-12-09 12:02:04',NULL,NULL,0,NULL,NULL,NULL),
 (35,'Femmes enceintes ou allaitantes déjà sous ARV contractant une nouvelle grossesse en vie et sous traitement ARV à M2 de la 1ere CPN',NULL,'SELECT\r\n  count(DISTINCT p.patient_id) nb\r\n\r\nFROM\r\n  (\r\n    SELECT\r\n      DateDebutSuiviPTME, MV.pregnant_patient_id, start_date, arv_status_at_registering, S.mother_followup_id, pregnancy_outcome, continuing_arv\r\n    FROM\r\n      (\r\n        SELECT\r\n          MAX(start_date) DateDebutSuiviPTME, pregnant_patient_id\r\n        FROM ptme_mother_followup WHERE start_date < :startDate AND voided = 0 AND location_id = :locationId\r\n        GROUP BY pregnant_patient_id\r\n      ) MV\r\n      ,\r\n      (SELECT start_date, pregnant_patient_id, arv_status_at_registering, mother_followup_id, pregnancy_outcome, end_date FROM ptme_mother_followup) S,\r\n      (SELECT * FROM ptme_mother_followup_visit WHERE location_id = :locationId) V\r\n    WHERE\r\n      V.mother_followup_id = S.mother_followup_id AND\r\n      S.pregnant_patient_id = MV.pregnant_patient_id AND\r\n      S.start_date = MV.DateDebutSuiviPTME AND\r\n      V.visit_date = S.end_date\r\n  ) V\r\n\r\n  INNER JOIN (SELECT pregnant_patient_id, patient_id, hiv_care_number FROM ptme_pregnant_patient WHERE voided = 0) p\r\n    ON p.pregnant_patient_id = V.pregnant_patient_id\r\n\r\n  LEFT JOIN\r\n    (\r\n      SELECT\r\n        mother, pc.child_id, eating_type\r\n      FROM\r\n        ptme_child pc,\r\n        ptme_child_followup pcf,\r\n        ptme_child_followup_visit pcfv,\r\n        (SELECT MAX(visit_date) MaxVisitDate, child_id FROM ptme_child_followup_visit WHERE visit_date <= :endDate AND location_id = :locationId GROUP BY child_id ) mpcfv\r\n      WHERE\r\n        pc.child_id = pcf.child_followup_id AND pc.child_id = pcfv.child_id AND mpcfv.MaxVisitDate = pcfv.visit_date AND mpcfv.child_id = pcfv.child_id\r\n    ) cf ON cf.mother = p.patient_id\r\n\r\n  LEFT JOIN\r\n  (\r\n    SELECT o.person_id, value_coded StatutARV\r\n    FROM\r\n      obs o,\r\n      (\r\n        SELECT MAX(obs_datetime) DateDernierARV, person_id\r\n        FROM obs WHERE concept_id = 1255 AND value_coded IN (1257, 1256, 1259) AND obs_datetime <= :endDate GROUP BY person_id\r\n      ) e\r\n    WHERE concept_id = 1255 AND o.person_id = e.person_id AND DateDernierARV = obs_datetime\r\n  ) TTT ON TTT.person_id = p.patient_id\r\n\r\n  LEFT JOIN (SELECT value_datetime DateDebutARV, person_id\r\n             FROM obs\r\n             WHERE concept_id IN (159599, 164588, 165032) AND voided = 0 GROUP BY person_id) ARV\r\n    ON ARV.person_id = p.patient_id\r\n  LEFT JOIN (SELECT person_id FROM obs WHERE concept_id = 1543 AND value_datetime <= :endDate AND voided = 0) Deces ON Deces.person_id = p.patient_id\r\n\r\n  LEFT JOIN (SELECT person_id, value_datetime FROM obs WHERE concept_id = 164595 AND voided = 0 AND location_id = :locationId) Transf\r\n    ON Transf.person_id = p.patient_id AND (Transf.value_datetime BETWEEN V.DateDebutSuiviPTME AND :endDate)\r\nWHERE\r\n  Transf.person_id IS NULL AND Deces.person_id IS NULL AND\r\n  arv_status_at_registering IN (1)\r\n  AND DateDebutARV IS NOT NULL\r\n  AND (StatutARV IS NOT NULL OR continuing_arv = 1)\r\n  AND (pregnancy_outcome IS NULL OR (pregnancy_outcome IN (1,2) AND eating_type = 1))\r\n  AND ADDDATE(start_date, INTERVAL 2 MONTH) BETWEEN :startDate AND :endDate','I35','b870d8a2-80a6-4f69-9270-5ea6a138f3d2',1,'2018-12-09 12:03:16',NULL,NULL,0,NULL,NULL,NULL),
 (36,'Femmes enceintes ou allaitantes déjà sous ARV contractant une nouvelle grossesse en vie et sous traitement ARV à M3 de la 1ere CPN',NULL,'SELECT\r\n  count(DISTINCT p.patient_id) nb\r\n\r\nFROM\r\n  (\r\n    SELECT\r\n      DateDebutSuiviPTME, MV.pregnant_patient_id, start_date, arv_status_at_registering, S.mother_followup_id, pregnancy_outcome, continuing_arv\r\n    FROM\r\n      (\r\n        SELECT\r\n          MAX(start_date) DateDebutSuiviPTME, pregnant_patient_id\r\n        FROM ptme_mother_followup WHERE start_date < :startDate AND voided = 0 AND location_id = :locationId\r\n        GROUP BY pregnant_patient_id\r\n      ) MV\r\n      ,\r\n      (SELECT start_date, pregnant_patient_id, arv_status_at_registering, mother_followup_id, pregnancy_outcome, end_date FROM ptme_mother_followup) S,\r\n      (SELECT * FROM ptme_mother_followup_visit WHERE location_id = :locationId) V\r\n    WHERE\r\n      V.mother_followup_id = S.mother_followup_id AND\r\n      S.pregnant_patient_id = MV.pregnant_patient_id AND\r\n      S.start_date = MV.DateDebutSuiviPTME AND\r\n      V.visit_date = S.end_date\r\n  ) V\r\n\r\n  INNER JOIN (SELECT pregnant_patient_id, patient_id, hiv_care_number FROM ptme_pregnant_patient WHERE voided = 0) p\r\n    ON p.pregnant_patient_id = V.pregnant_patient_id\r\n\r\n  LEFT JOIN\r\n    (\r\n      SELECT\r\n        mother, pc.child_id, eating_type\r\n      FROM\r\n        ptme_child pc,\r\n        ptme_child_followup pcf,\r\n        ptme_child_followup_visit pcfv,\r\n        (SELECT MAX(visit_date) MaxVisitDate, child_id FROM ptme_child_followup_visit WHERE visit_date <= :endDate AND location_id = :locationId GROUP BY child_id ) mpcfv\r\n      WHERE\r\n        pc.child_id = pcf.child_followup_id AND pc.child_id = pcfv.child_id AND mpcfv.MaxVisitDate = pcfv.visit_date AND mpcfv.child_id = pcfv.child_id\r\n    ) cf ON cf.mother = p.patient_id\r\n\r\n  LEFT JOIN\r\n  (\r\n    SELECT o.person_id, value_coded StatutARV\r\n    FROM\r\n      obs o,\r\n      (\r\n        SELECT MAX(obs_datetime) DateDernierARV, person_id\r\n        FROM obs WHERE concept_id = 1255 AND value_coded IN (1257, 1256, 1259) AND obs_datetime <= :endDate GROUP BY person_id\r\n      ) e\r\n    WHERE concept_id = 1255 AND o.person_id = e.person_id AND DateDernierARV = obs_datetime\r\n  ) TTT ON TTT.person_id = p.patient_id\r\n\r\n  LEFT JOIN (SELECT value_datetime DateDebutARV, person_id\r\n             FROM obs\r\n             WHERE concept_id IN (159599, 164588, 165032) AND voided = 0 GROUP BY person_id) ARV\r\n    ON ARV.person_id = p.patient_id\r\n  LEFT JOIN (SELECT person_id FROM obs WHERE concept_id = 1543 AND value_datetime <= :endDate AND voided = 0) Deces ON Deces.person_id = p.patient_id\r\n\r\n  LEFT JOIN (SELECT person_id, value_datetime FROM obs WHERE concept_id = 164595 AND voided = 0 AND location_id = :locationId) Transf\r\n    ON Transf.person_id = p.patient_id AND (Transf.value_datetime BETWEEN V.DateDebutSuiviPTME AND :endDate)\r\nWHERE\r\n  Transf.person_id IS NULL AND Deces.person_id IS NULL AND\r\n  arv_status_at_registering IN (1)\r\n  AND DateDebutARV IS NOT NULL\r\n  AND (StatutARV IS NOT NULL OR continuing_arv = 1)\r\n  AND (pregnancy_outcome IS NULL OR (pregnancy_outcome IN (1,2) AND eating_type = 1))\r\n  AND ADDDATE(start_date, INTERVAL 3 MONTH) BETWEEN :startDate AND :endDate','I36','9d2154ae-64e2-4d52-a090-285daea579f5',1,'2018-12-09 12:04:26',NULL,NULL,0,NULL,NULL,NULL),
 (37,'Femmes enceintes ou allaitantes déjà sous ARV contractant une nouvelle grossesse en vie et sous traitement ARV à M6 de la 1ere CPN',NULL,'SELECT\r\n  count(DISTINCT p.patient_id) nb\r\n\r\nFROM\r\n  (\r\n    SELECT\r\n      DateDebutSuiviPTME, MV.pregnant_patient_id, start_date, arv_status_at_registering, S.mother_followup_id, pregnancy_outcome, continuing_arv\r\n    FROM\r\n      (\r\n        SELECT\r\n          MAX(start_date) DateDebutSuiviPTME, pregnant_patient_id\r\n        FROM ptme_mother_followup WHERE start_date < :startDate AND voided = 0 AND location_id = :locationId\r\n        GROUP BY pregnant_patient_id\r\n      ) MV\r\n      ,\r\n      (SELECT start_date, pregnant_patient_id, arv_status_at_registering, mother_followup_id, pregnancy_outcome, end_date FROM ptme_mother_followup) S,\r\n      (SELECT * FROM ptme_mother_followup_visit WHERE location_id = :locationId) V\r\n    WHERE\r\n      V.mother_followup_id = S.mother_followup_id AND\r\n      S.pregnant_patient_id = MV.pregnant_patient_id AND\r\n      S.start_date = MV.DateDebutSuiviPTME AND\r\n      V.visit_date = S.end_date\r\n  ) V\r\n\r\n  INNER JOIN (SELECT pregnant_patient_id, patient_id, hiv_care_number FROM ptme_pregnant_patient WHERE voided = 0) p\r\n    ON p.pregnant_patient_id = V.pregnant_patient_id\r\n\r\n  LEFT JOIN\r\n    (\r\n      SELECT\r\n        mother, pc.child_id, eating_type\r\n      FROM\r\n        ptme_child pc,\r\n        ptme_child_followup pcf,\r\n        ptme_child_followup_visit pcfv,\r\n        (SELECT MAX(visit_date) MaxVisitDate, child_id FROM ptme_child_followup_visit WHERE visit_date <= :endDate AND location_id = :locationId GROUP BY child_id ) mpcfv\r\n      WHERE\r\n        pc.child_id = pcf.child_followup_id AND pc.child_id = pcfv.child_id AND mpcfv.MaxVisitDate = pcfv.visit_date AND mpcfv.child_id = pcfv.child_id\r\n    ) cf ON cf.mother = p.patient_id\r\n\r\n  LEFT JOIN\r\n  (\r\n    SELECT o.person_id, value_coded StatutARV\r\n    FROM\r\n      obs o,\r\n      (\r\n        SELECT MAX(obs_datetime) DateDernierARV, person_id\r\n        FROM obs WHERE concept_id = 1255 AND value_coded IN (1257, 1256, 1259) AND obs_datetime <= :endDate GROUP BY person_id\r\n      ) e\r\n    WHERE concept_id = 1255 AND o.person_id = e.person_id AND DateDernierARV = obs_datetime\r\n  ) TTT ON TTT.person_id = p.patient_id\r\n\r\n  LEFT JOIN (SELECT value_datetime DateDebutARV, person_id\r\n             FROM obs\r\n             WHERE concept_id IN (159599, 164588, 165032) AND voided = 0 GROUP BY person_id) ARV\r\n    ON ARV.person_id = p.patient_id\r\n  LEFT JOIN (SELECT person_id FROM obs WHERE concept_id = 1543 AND value_datetime <= :endDate AND voided = 0) Deces ON Deces.person_id = p.patient_id\r\n\r\n  LEFT JOIN (SELECT person_id, value_datetime FROM obs WHERE concept_id = 164595 AND voided = 0 AND location_id = :locationId) Transf\r\n    ON Transf.person_id = p.patient_id AND (Transf.value_datetime BETWEEN V.DateDebutSuiviPTME AND :endDate)\r\nWHERE\r\n  Transf.person_id IS NULL AND Deces.person_id IS NULL AND\r\n  arv_status_at_registering IN (1)\r\n  AND DateDebutARV IS NOT NULL\r\n  AND (StatutARV IS NOT NULL OR continuing_arv = 1)\r\n  AND (pregnancy_outcome IS NULL OR (pregnancy_outcome IN (1,2) AND eating_type = 1))\r\n  AND ADDDATE(start_date, INTERVAL 6 MONTH) BETWEEN :startDate AND :endDate','I37','25c80352-13cb-4d4b-a5f2-377d65140e13',1,'2018-12-09 12:05:56',NULL,NULL,0,NULL,NULL,NULL),
 (38,'Femmes enceintes ou allaitantes déjà sous ARV contractant une nouvelle grossesse en vie et sous traitement ARV à M12 de la 1ere CPN',NULL,'SELECT\r\n  count(DISTINCT p.patient_id) nb\r\n\r\nFROM\r\n  (\r\n    SELECT\r\n      DateDebutSuiviPTME, MV.pregnant_patient_id, start_date, arv_status_at_registering, S.mother_followup_id, pregnancy_outcome, continuing_arv\r\n    FROM\r\n      (\r\n        SELECT\r\n          MAX(start_date) DateDebutSuiviPTME, pregnant_patient_id\r\n        FROM ptme_mother_followup WHERE start_date < :startDate AND voided = 0 AND location_id = :locationId\r\n        GROUP BY pregnant_patient_id\r\n      ) MV\r\n      ,\r\n      (SELECT start_date, pregnant_patient_id, arv_status_at_registering, mother_followup_id, pregnancy_outcome, end_date FROM ptme_mother_followup) S,\r\n      (SELECT * FROM ptme_mother_followup_visit WHERE location_id = :locationId) V\r\n    WHERE\r\n      V.mother_followup_id = S.mother_followup_id AND\r\n      S.pregnant_patient_id = MV.pregnant_patient_id AND\r\n      S.start_date = MV.DateDebutSuiviPTME AND\r\n      V.visit_date = S.end_date\r\n  ) V\r\n\r\n  INNER JOIN (SELECT pregnant_patient_id, patient_id, hiv_care_number FROM ptme_pregnant_patient WHERE voided = 0) p\r\n    ON p.pregnant_patient_id = V.pregnant_patient_id\r\n\r\n  LEFT JOIN\r\n    (\r\n      SELECT\r\n        mother, pc.child_id, eating_type\r\n      FROM\r\n        ptme_child pc,\r\n        ptme_child_followup pcf,\r\n        ptme_child_followup_visit pcfv,\r\n        (SELECT MAX(visit_date) MaxVisitDate, child_id FROM ptme_child_followup_visit WHERE visit_date <= :endDate AND location_id = :locationId GROUP BY child_id ) mpcfv\r\n      WHERE\r\n        pc.child_id = pcf.child_followup_id AND pc.child_id = pcfv.child_id AND mpcfv.MaxVisitDate = pcfv.visit_date AND mpcfv.child_id = pcfv.child_id\r\n    ) cf ON cf.mother = p.patient_id\r\n\r\n  LEFT JOIN\r\n  (\r\n    SELECT o.person_id, value_coded StatutARV\r\n    FROM\r\n      obs o,\r\n      (\r\n        SELECT MAX(obs_datetime) DateDernierARV, person_id\r\n        FROM obs WHERE concept_id = 1255 AND value_coded IN (1257, 1256, 1259) AND obs_datetime <= :endDate GROUP BY person_id\r\n      ) e\r\n    WHERE concept_id = 1255 AND o.person_id = e.person_id AND DateDernierARV = obs_datetime\r\n  ) TTT ON TTT.person_id = p.patient_id\r\n\r\n  LEFT JOIN (SELECT value_datetime DateDebutARV, person_id\r\n             FROM obs\r\n             WHERE concept_id IN (159599, 164588, 165032) AND voided = 0 GROUP BY person_id) ARV\r\n    ON ARV.person_id = p.patient_id\r\n  LEFT JOIN (SELECT person_id FROM obs WHERE concept_id = 1543 AND value_datetime <= :endDate AND voided = 0) Deces ON Deces.person_id = p.patient_id\r\n\r\n  LEFT JOIN (SELECT person_id, value_datetime FROM obs WHERE concept_id = 164595 AND voided = 0 AND location_id = :locationId) Transf\r\n    ON Transf.person_id = p.patient_id AND (Transf.value_datetime BETWEEN V.DateDebutSuiviPTME AND :endDate)\r\nWHERE\r\n  Transf.person_id IS NULL AND Deces.person_id IS NULL AND\r\n  arv_status_at_registering IN (1)\r\n  AND DateDebutARV IS NOT NULL\r\n  AND (StatutARV IS NOT NULL OR continuing_arv = 1)\r\n  AND (pregnancy_outcome IS NULL OR (pregnancy_outcome IN (1,2) AND eating_type = 1))\r\n  AND ADDDATE(start_date, INTERVAL 12 MONTH) BETWEEN :startDate AND :endDate','I38','f0ccf460-ae77-43a7-97a4-a58d059910b0',1,'2018-12-09 12:06:44',NULL,NULL,0,NULL,NULL,NULL);
REPLACE INTO `ptme_reporting_indicator` (`indicator_id`,`name`,`description`,`indicator_sql_script`,`template_code`,`uuid`,`creator`,`date_created`,`changed_by`,`date_changed`,`voided`,`voided_by`,`date_voided`,`void_reason`) VALUES
 (39,'Enfants nés de mère séropositives au VIH attendus pour le dépistage précoce et l\'initiation du Cotrimoxazole avant l\'age de 02 mois S1 & S2',NULL,'SELECT\r\n  COUNT(pc.child_id) nb\r\n\r\nFROM\r\n  ptme_child pc\r\nWHERE\r\n  DATEDIFF(ADDDATE(:startDate, INTERVAL 2 WEEK), pc.birth_date) BETWEEN 0 AND 59 AND location_id = :locationId','I39','9048aed6-8704-4a63-bf67-5366d610efb3',1,'2018-12-09 12:22:24',NULL,NULL,0,NULL,NULL,NULL),
 (40,'Enfants nés de mère séropositives au VIH attendus pour le dépistage précoce et l\'initiation du Cotrimoxazole avant l\'age de 02 mois S3 & S4',NULL,'SELECT\r\n  COUNT(DISTINCT pc.child_id) nb\r\n\r\nFROM\r\n  ptme_child pc\r\nWHERE\r\n  DATEDIFF(:endDate, pc.birth_date) BETWEEN 0 AND 59\r\n  AND location_id = :locationId \r\n  AND pc.child_id NOT IN (\r\n    SELECT pc.child_id\r\n    FROM\r\n      ptme_child pc\r\n    WHERE\r\n      DATEDIFF(ADDDATE(:startDate, INTERVAL 2 WEEK), pc.birth_date) BETWEEN 0 AND 59\r\n  )','I40','17afbce4-8dd7-4992-b6cb-e055bfef5006',1,'2018-12-09 12:24:28',NULL,NULL,0,NULL,NULL,NULL),
 (41,'Enfants nés de mère séropositives au VIH ayant bénéficié du dépistage précoce et de l\'initiation du Cotrimoxazole avant 2 mois S1 & S2',NULL,'SELECT\r\n  COUNT(DISTINCT child_id) nb\r\nFROM\r\n  ptme_child pc\r\n  LEFT JOIN ptme_child_followup pcf ON pc.child_id = pcf.child_followup_id\r\nWHERE\r\n  DATEDIFF(pcf.ctx_initiation_date, pc.birth_date) < 60 AND\r\n  pcf.ctx_initiation_date BETWEEN :startDate AND ADDDATE(:endDate, INTERVAL -2 WEEK) AND\r\n  pcf.pcr1_sampling_date <= ADDDATE(:endDate, INTERVAL -2 WEEK) AND pcf.location_id = :locationId','I41','43320188-2bba-4c1e-a2dc-0880306a285e',1,'2018-12-09 12:25:53',NULL,NULL,0,NULL,NULL,NULL),
 (42,'Enfants nés de mère séropositives au VIH ayant bénéficié du dépistage précoce et de l\'initiation du Cotrimoxazole avant 2 mois S3 & S4',NULL,'SELECT\r\n  COUNT(DISTINCT child_id) nb\r\nFROM\r\n  ptme_child pc\r\n  LEFT JOIN ptme_child_followup pcf ON pc.child_id = pcf.child_followup_id\r\nWHERE\r\n  DATEDIFF(pcf.ctx_initiation_date, pc.birth_date) < 60 AND\r\n  pcf.ctx_initiation_date BETWEEN ADDDATE(:startDate, INTERVAL 2 WEEK) AND :endDate AND\r\n  pcf.pcr1_sampling_date <= ADDDATE(:endDate, INTERVAL -2 WEEK) AND pcf.location_id = :locationId','I42','83ef423b-4480-41b3-b966-c03798a36065',1,'2018-12-09 12:29:39',NULL,NULL,0,NULL,NULL,NULL);

REPLACE INTO `ptme_reporting_dataset` (`dataset_id`,`name`,`code`,`uuid`,`creator`,`date_created`,`changed_by`,`date_changed`,`voided`,`voided_by`,`date_voided`,`void_reason`) VALUES 
 (1,'Conseil et dépistage en CPN et en Maternité','DS1','25357924-ab0b-4b5b-ba9d-1582e17831d7',1,'2018-11-05 19:29:59',1,'2018-11-07 17:00:40',0,NULL,NULL,NULL),
 (2,'Suivi des mères et des enfants nés de mères séropositives au VIH','DS2','27a53cfa-9c10-4d22-9c9e-d7138449dccc',1,'2018-11-09 19:53:48',NULL,NULL,0,NULL,NULL,NULL),
 (3,'Dépistage du VIH chez les enfants nés de mère séropositive au VIH','DS3','da403c6b-57b9-49c2-84dd-2dc60dc67d4a',1,'2018-11-11 22:38:22',NULL,NULL,0,NULL,NULL,NULL),
 (4,'Dépistage des conjoints des femmes enceintes','DS4','d483ae85-d669-41d5-aa2b-5b9aee1a4841',1,'2018-11-12 08:53:21',NULL,NULL,0,NULL,NULL,NULL),
 (5,'Femmes enceintes ou allaitantes depistées positives nouvellement mises sous traitement ARV','DS5','5a35e688-ab91-454f-8f2a-2462af0e3336',1,'2018-12-09 12:35:50',NULL,NULL,0,NULL,NULL,NULL),
 (6,'Femmes déjà sous ARV contractant une nouvelle grossesse','DS6','8dbe3ab5-8925-4991-b4b2-e08bc8ebade3',1,'2018-12-09 12:37:10',1,'2018-12-09 12:55:19',0,NULL,NULL,NULL),
 (7,'Suivi des rendez-vous des enfants avant 2 mois','DS7','ee7867de-e5df-4dfe-a43f-911f340d730a',1,'2018-12-09 12:38:08',NULL,NULL,0,NULL,NULL,NULL);

REPLACE INTO `ptme_reporting_dataset_indicator` (`indicator_id`,`dataset_id`) VALUES 
 (1,1),
 (2,1),
 (3,1),
 (4,1),
 (5,1),
 (6,1),
 (7,1),
 (8,2),
 (9,2),
 (10,2),
 (11,2),
 (12,3),
 (13,3),
 (14,3),
 (15,3),
 (16,3),
 (17,4),
 (18,4),
 (19,5),
 (20,5),
 (21,5),
 (22,5),
 (23,5),
 (24,5),
 (25,5),
 (26,5),
 (27,5),
 (28,5),
 (29,6),
 (30,6),
 (31,6),
 (32,6),
 (33,6),
 (34,6),
 (35,6),
 (36,6),
 (37,6),
 (38,6),
 (39,7),
 (40,7),
 (41,7),
 (42,7);

 
REPLACE INTO `ptme_reporting_template` (`template_id`,`name`,`description`,`content`,`uuid`,`creator`,`date_created`,`changed_by`,`date_changed`,`voided`,`voided_by`,`date_voided`,`void_reason`) VALUES 
 (1,'Template PTME',NULL,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,'1234567890azertyuiopmlkjhgfdsqwxcvbn',1,'2018-11-05 00:00:00',1,'2018-12-09 12:48:14',0,NULL,NULL,NULL),
 (2,'Template Suivi PTME',NULL,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,'90e159f5-dc1b-41ca-ae09-487b00e4edd7',1,'2018-12-09 12:48:43',NULL,NULL,0,NULL,NULL,NULL);
--
-- Dumping data for table `ptme_reporting_report`
--

REPLACE INTO `ptme_reporting_report` (`report_id`,`report_label`,`description`,`reporting_template_id`,`uuid`,`creator`,`date_created`,`changed_by`,`date_changed`,`voided`,`voided_by`,`date_voided`,`void_reason`) VALUES 
 (1,'Rapport Mensuel de la Prévention de la Transmission Mère - Enfant (PTME)',NULL,1,'145c0d54-44fc-44a6-9fbd-bdb4cd897b82',1,'2018-11-05 19:37:31',1,'2018-11-12 08:53:54',0,NULL,NULL,NULL),
 (2,'Rapport Mensuel de Suivi de Cohorte en PTME',NULL,2,'81d44e0e-380b-4b7a-a64d-6ba924cf2437',1,'2018-12-09 12:49:33',1,'2018-12-09 12:49:54',0,NULL,NULL,NULL);

--
-- Dumping data for table `ptme_reporting_report_dataset`
--

REPLACE INTO `ptme_reporting_report_dataset` (`report_id`,`dataset_id`) VALUES 
 (1,1),
 (1,2),
 (1,3),
 (1,4),
 (2,5),
 (2,6),
 (2,7);
