## API Report File for "git-documentdb"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { JSONOp } from 'ot-json1';
import { Logger } from 'tslog';
import { TLogLevelName } from 'tslog';

// @public
export type AcceptedConflict = {
    fatDoc: FatDoc;
    strategy: ConflictResolutionStrategyLabels;
    operation: WriteOperation;
};

// @public
export type BinaryDocMetadata = {
    name: string;
    fileOid: string;
    type: 'binary';
};

// @public
export type ChangedFile = ChangedFileInsert | ChangedFileUpdate | ChangedFileDelete;

// @public
export type ChangedFileDelete = {
    operation: 'delete';
    old: FatDoc;
};

// @public
export type ChangedFileInsert = {
    operation: 'insert';
    new: FatDoc;
};

// @public
export type ChangedFileUpdate = {
    operation: 'update';
    old: FatDoc;
    new: FatDoc;
};

// @public
export class Collection implements ICollection {
    constructor(gitDDB: GitDDBInterface, collectionPathFromParent?: CollectionPath, parent?: ICollection, options?: CollectionOptions);
    collection(collectionPath: CollectionPath, options?: CollectionOptions): ICollection;
    get collectionPath(): string;
    delete(_id: string, options?: DeleteOptions): Promise<DeleteResultJsonDoc>;
    delete(jsonDoc: JsonDoc, options?: DeleteOptions): Promise<DeleteResultJsonDoc>;
    // @internal (undocumented)
    delete(shortIdOrDoc: string | JsonDoc, options?: DeleteOptions): Promise<DeleteResultJsonDoc>;
    deleteFatDoc(shortName: string, options?: DeleteOptions): Promise<DeleteResult>;
    find(options?: FindOptions): Promise<JsonDoc[]>;
    findFatDoc(options?: FindOptions): Promise<FatDoc[]>;
    generateId(): string;
    get(_id: string): Promise<JsonDoc | undefined>;
    getCollections(dirPath?: string): Promise<ICollection[]>;
    getDocByOid(fileOid: string, docType?: DocType): Promise<Doc | undefined>;
    getFatDoc(shortName: string, getOptions?: GetOptions): Promise<FatDoc | undefined>;
    getFatDocHistory(shortName: string, historyOptions?: HistoryOptions, getOptions?: GetOptions): Promise<(FatDoc | undefined)[]>;
    getFatDocOldRevision(shortName: string, revision: number, historyOptions?: HistoryOptions, getOptions?: GetOptions): Promise<FatDoc | undefined>;
    getHistory(_id: string, historyOptions?: HistoryOptions): Promise<(JsonDoc | undefined)[]>;
    getOldRevision(shortId: string, revision: number, historyOptions?: HistoryOptions): Promise<JsonDoc | undefined>;
    insert(jsonDoc: JsonDoc, options?: PutOptions): Promise<PutResultJsonDoc>;
    insert(shortId: string | undefined | null, jsonDoc: JsonDoc, options?: PutOptions): Promise<PutResultJsonDoc>;
    // @internal (undocumented)
    insert(shortIdOrDoc: string | undefined | null | JsonDoc, jsonDocOrOptions?: JsonDoc | PutOptions, options?: PutOptions): Promise<PutResultJsonDoc>;
    insertFatDoc(shortName: string | undefined | null, doc: JsonDoc | string | Uint8Array, options?: PutOptions): Promise<PutResult>;
    // @eventProperty
    offSyncEvent(remoteURL: string, event: SyncEvent, callback: SyncCallback): void;
    // @eventProperty
    offSyncEvent(sync: SyncInterface, event: SyncEvent, callback: SyncCallback): void;
    // @internal (undocumented)
    offSyncEvent(remoteURLorSync: string | SyncInterface, event: SyncEvent, callback: SyncCallback): void;
    // @eventProperty
    onSyncEvent(remoteURL: string, event: SyncEvent, callback: SyncCallback): SyncInterface;
    // @eventProperty
    onSyncEvent(sync: SyncInterface, event: SyncEvent, callback: SyncCallback): SyncInterface;
    // @internal (undocumented)
    onSyncEvent(remoteURLorSync: string | SyncInterface, event: SyncEvent, callback: SyncCallback): SyncInterface;
    get options(): CollectionOptions;
    get parent(): ICollection | undefined;
    put(jsonDoc: JsonDoc, options?: PutOptions): Promise<PutResultJsonDoc>;
    put(shortId: string | undefined | null, jsonDoc: JsonDoc, options?: PutOptions): Promise<PutResultJsonDoc>;
    // @internal
    put(shortIdOrDoc: string | undefined | null | JsonDoc, jsonDocOrOptions?: JsonDoc | PutOptions, options?: PutOptions): Promise<PutResultJsonDoc>;
    putFatDoc(shortName: string | undefined | null, doc: JsonDoc | Uint8Array | string, options?: PutOptions): Promise<PutResult>;
    update(jsonDoc: JsonDoc, options?: PutOptions): Promise<PutResultJsonDoc>;
    update(_id: string | undefined | null, jsonDoc: JsonDoc, options?: PutOptions): Promise<PutResultJsonDoc>;
    // @internal (undocumented)
    update(shortIdOrDoc: string | undefined | null | JsonDoc, jsonDocOrOptions?: JsonDoc | PutOptions, options?: PutOptions): Promise<PutResultJsonDoc>;
    updateFatDoc(shortName: string | undefined | null, doc: JsonDoc | string | Uint8Array, options?: PutOptions): Promise<PutResult>;
}

// @public
export interface CollectionInterface {
    // (undocumented)
    collection(collectionPath: CollectionPath, options?: CollectionOptions): ICollection;
    // (undocumented)
    getCollections(dirPath: string): Promise<ICollection[]>;
}

// @public
export type CollectionOptions = {
    namePrefix?: string;
    debounceTime?: number;
};

// @public
export type CollectionPath = string;

// @public
export type CombineDbStrategies = 'throw-error' | 'combine-head-with-ours' | 'combine-head-with-theirs' | 'combine-history-with-ours' | 'combine-history-with-theirs' | 'replace-with-ours' | 'replace-with-theirs';

// @public
export type ConflictResolutionStrategies = ConflictResolutionStrategyLabels | ((ours?: FatDoc, theirs?: FatDoc) => ConflictResolutionStrategyLabels);

// @public (undocumented)
export type ConflictResolutionStrategyLabels = 'ours-diff' | 'theirs-diff' | 'ours' | 'theirs';

// @public
export type ConnectionSettings = ConnectionSettingsNone | ConnectionSettingsGitHub | ConnectionSettingsSSH;

// @public
export type ConnectionSettingsGitHub = {
    type: 'github';
    engine?: string;
    personalAccessToken?: string;
    private?: boolean;
};

// @public
export type ConnectionSettingsNone = {
    type: 'none';
    engine?: string;
};

// @public
export type ConnectionSettingsSSH = {
    type: 'ssh';
    engine?: string;
    privateKeyPath: string;
    publicKeyPath: string;
    passPhrase?: string;
};

// @public
export interface CRUDInterface {
    // (undocumented)
    delete(jsonDoc: JsonDoc, options?: DeleteOptions): Promise<DeleteResultJsonDoc>;
    // (undocumented)
    delete(_id: string, options?: DeleteOptions): Promise<DeleteResultJsonDoc>;
    // @internal (undocumented)
    delete(shortIdOrDoc: string | JsonDoc, options?: DeleteOptions): Promise<DeleteResultJsonDoc>;
    // (undocumented)
    deleteFatDoc(name: string, options?: DeleteOptions): Promise<DeleteResult>;
    // (undocumented)
    find(options?: FindOptions): Promise<JsonDoc[]>;
    // (undocumented)
    findFatDoc(options?: FindOptions): Promise<FatDoc[]>;
    // (undocumented)
    get(_id: string, getOptions?: GetOptions): Promise<JsonDoc | undefined>;
    // (undocumented)
    getDocByOid(fileOid: string, docType?: DocType): Promise<Doc | undefined>;
    // (undocumented)
    getFatDoc(name: string, getOptions?: GetOptions): Promise<FatDoc | undefined>;
    // (undocumented)
    getFatDocHistory(name: string, historyOptions?: HistoryOptions, getOptions?: GetOptions): Promise<(FatDoc | undefined)[]>;
    // (undocumented)
    getFatDocOldRevision(name: string, revision: number, historyOptions?: HistoryOptions, getOptions?: GetOptions): Promise<FatDoc | undefined>;
    // (undocumented)
    getHistory(_id: string, historyOptions?: HistoryOptions): Promise<(JsonDoc | undefined)[]>;
    // (undocumented)
    getOldRevision(_id: string, revision: number, historyOptions?: HistoryOptions, getOptions?: GetOptions): Promise<JsonDoc | undefined>;
    // (undocumented)
    insert(jsonDoc: JsonDoc, options?: PutOptions): Promise<PutResult>;
    // (undocumented)
    insert(_id: string | undefined | null, data: JsonDoc | Uint8Array | string, options?: PutOptions): Promise<PutResultJsonDoc>;
    // @internal (undocumented)
    insert(shortIdOrDoc: string | undefined | null | JsonDoc, jsonDocOrOptions?: JsonDoc | PutOptions, options?: PutOptions): Promise<PutResultJsonDoc>;
    // (undocumented)
    insertFatDoc(name: string | undefined | null, data: JsonDoc | Uint8Array | string, options?: PutOptions): Promise<PutResult>;
    // (undocumented)
    put(jsonDoc: JsonDoc, options?: PutOptions): Promise<PutResult>;
    // (undocumented)
    put(_id: string | undefined | null, data: JsonDoc | Uint8Array | string, options?: PutOptions): Promise<PutResultJsonDoc>;
    // @internal (undocumented)
    put(shortIdOrDoc: string | undefined | null | JsonDoc, jsonDocOrOptions?: JsonDoc | PutOptions, options?: PutOptions): Promise<PutResultJsonDoc>;
    // (undocumented)
    putFatDoc(name: string | undefined | null, data: JsonDoc | Uint8Array | string, options?: PutOptions): Promise<PutResult>;
    // (undocumented)
    update(jsonDoc: JsonDoc, options?: PutOptions): Promise<PutResult>;
    // (undocumented)
    update(_id: string | undefined | null, data: JsonDoc | Uint8Array | string, options?: PutOptions): Promise<PutResultJsonDoc>;
    // @internal (undocumented)
    update(shortIdOrDoc: string | undefined | null | JsonDoc, jsonDocOrOptions?: JsonDoc | PutOptions, options?: PutOptions): Promise<PutResultJsonDoc>;
    // (undocumented)
    updateFatDoc(name: string | undefined | null, data: JsonDoc | Uint8Array | string, options?: PutOptions): Promise<PutResult>;
}

// @public (undocumented)
export const DATABASE_CREATOR = "GitDocumentDB";

// @public (undocumented)
export const DATABASE_VERSION = "1.0";

// @public
export type DatabaseCloseOption = {
    force?: boolean;
    timeout?: number;
};

// @public
export type DatabaseInfo = {
    dbId: string;
    creator: string;
    version: string;
};

// @public
export type DatabaseOpenResult = DatabaseInfo & {
    isNew: boolean;
    isCreatedByGitDDB: boolean;
    isValidVersion: boolean;
};

// @public
export type DatabaseOptions = {
    localDir?: string;
    dbName: string;
    logLevel?: TLogLevelName;
    schema?: Schema;
};

// @public (undocumented)
export const DEFAULT_COMBINE_DB_STRATEGY = "combine-head-with-theirs";

// @public (undocumented)
export const DEFAULT_CONFLICT_RESOLUTION_STRATEGY = "ours-diff";

// @public (undocumented)
export const DEFAULT_LOCAL_DIR = "./git-documentdb";

// @public (undocumented)
export const DEFAULT_LOG_LEVEL = "info";

// @public (undocumented)
export const DEFAULT_SYNC_INTERVAL = 30000;

// @public
export type DeleteOptions = {
    commitMessage?: string;
    taskId?: string;
    enqueueCallback?: (taskMetadata: TaskMetadata) => void;
};

// @public
export type DeleteResult = DeleteResultJsonDoc | DeleteResultText | DeleteResultBinary;

// @public (undocumented)
export type DeleteResultBinary = {
    name: string;
    fileOid: string;
    commit: NormalizedCommit;
    type: 'binary';
};

// @public (undocumented)
export type DeleteResultJsonDoc = {
    _id: string;
    name: string;
    fileOid: string;
    commit: NormalizedCommit;
    type: 'json';
};

// @public (undocumented)
export type DeleteResultText = {
    name: string;
    fileOid: string;
    commit: NormalizedCommit;
    type: 'text';
};

// @public
export type Doc = JsonDoc | string | Uint8Array;

// @public
export type DocMetadata = JsonDocMetadata | TextDocMetadata | BinaryDocMetadata;

// @public
export type DocType = 'json' | 'text' | 'binary';

// @public (undocumented)
export const DUPLICATED_FILE_POSTFIX = "-from-";

// @public
export type DuplicatedFile = {
    original: DocMetadata;
    duplicate: DocMetadata;
};

// @public
export function encodeToGitRemoteName(remoteURL: string): string;

// @public
export namespace Err {
    // (undocumented)
    export class AuthenticationTypeNotAllowCreateRepositoryError extends BaseError {
        constructor(type: unknown);
    }
    export class BaseError extends Error {
        constructor(e: string);
    }
    // (undocumented)
    export class CannotConnectRemoteRepositoryError extends BaseError {
        constructor(retry: number, url: string, mes: string);
        // (undocumented)
        retry: number;
    }
    // (undocumented)
    export class CannotCreateDirectoryError extends BaseError {
        constructor(e?: unknown);
    }
    // (undocumented)
    export class CannotCreateRemoteRepositoryError extends BaseError {
        constructor(reason: unknown);
    }
    // (undocumented)
    export class CannotCreateRepositoryError extends BaseError {
        constructor(reason: unknown);
    }
    // (undocumented)
    export class CannotDeleteDataError extends BaseError {
        constructor(e?: unknown);
    }
    // (undocumented)
    export class CannotOpenRepositoryError extends BaseError {
        constructor(err: unknown);
    }
    // (undocumented)
    export class CannotWriteDataError extends BaseError {
        constructor(e?: unknown);
    }
    // (undocumented)
    export class CombineDatabaseError extends BaseError {
        constructor(mes: string);
    }
    // (undocumented)
    export class ConsecutiveSyncSkippedError extends BaseError {
        constructor(taskLabel: string, taskId: string);
    }
    // (undocumented)
    export class DatabaseCloseTimeoutError extends BaseError {
        constructor(e?: unknown);
    }
    // (undocumented)
    export class DatabaseClosingError extends BaseError {
        constructor(e?: unknown);
    }
    // (undocumented)
    export class DocumentNotFoundError extends BaseError {
        constructor(e?: unknown);
    }
    // (undocumented)
    export class FileRemoveTimeoutError extends BaseError {
        constructor();
    }
    // (undocumented)
    export class GitMergeBranchError extends BaseError {
        constructor(mes: string);
    }
    // (undocumented)
    export class HttpProtocolRequiredError extends BaseError {
        constructor(url: unknown);
    }
    // (undocumented)
    export class IntervalTooSmallError extends BaseError {
        constructor(min: unknown, current: unknown);
    }
    // (undocumented)
    export class InvalidCollectionPathCharacterError extends BaseError {
        constructor(name: unknown);
    }
    // (undocumented)
    export class InvalidCollectionPathLengthError extends BaseError {
        constructor(collectionPath: unknown, minLength: unknown, maxLength: unknown);
    }
    // (undocumented)
    export class InvalidConflictResolutionStrategyError extends BaseError {
        constructor();
    }
    // (undocumented)
    export class InvalidConflictStateError extends BaseError {
        constructor(mes: unknown);
    }
    // (undocumented)
    export class InvalidDbNameCharacterError extends BaseError {
        constructor(name: unknown);
    }
    // (undocumented)
    export class InvalidDocTypeError extends BaseError {
        constructor(type: unknown);
    }
    // (undocumented)
    export class InvalidIdCharacterError extends BaseError {
        constructor(id: unknown);
    }
    // (undocumented)
    export class InvalidIdLengthError extends BaseError {
        constructor(id: unknown, minLength: unknown, maxLength: unknown);
    }
    // (undocumented)
    export class InvalidJsonFileExtensionError extends BaseError {
        constructor();
    }
    // (undocumented)
    export class InvalidJsonObjectError extends BaseError {
        constructor(idOrSha: unknown);
    }
    // (undocumented)
    export class InvalidLocalDirCharacterError extends BaseError {
        constructor(name: unknown);
    }
    // (undocumented)
    export class InvalidWorkingDirectoryPathLengthError extends BaseError {
        constructor(path: unknown, minLength: unknown, maxLength: unknown);
    }
    // (undocumented)
    export class NoMergeBaseFoundError extends BaseError {
        constructor();
    }
    // (undocumented)
    export class PersonalAccessTokenForAnotherAccountError extends BaseError {
        constructor();
    }
    // (undocumented)
    export class PushNotAllowedError extends BaseError {
        constructor(direction: unknown);
    }
    // (undocumented)
    export class PushWorkerError extends BaseError {
        constructor(mes: unknown);
    }
    // (undocumented)
    export class RemoteAlreadyRegisteredError extends BaseError {
        constructor(url: unknown);
    }
    // (undocumented)
    export class RepositoryNotFoundError extends BaseError {
        constructor(path: unknown);
    }
    // (undocumented)
    export class RepositoryNotOpenError extends BaseError {
        constructor(e?: unknown);
    }
    // (undocumented)
    export class RequestTimeoutError extends BaseError {
        constructor(url: unknown);
    }
    // (undocumented)
    export class SameIdExistsError extends BaseError {
        constructor(e?: unknown);
    }
    // (undocumented)
    export class SocketTimeoutError extends BaseError {
        constructor(url: unknown);
    }
    // (undocumented)
    export class SyncIntervalLessThanOrEqualToRetryIntervalError extends BaseError {
        constructor(syncInterval: unknown, retryInterval: unknown);
    }
    // (undocumented)
    export class SyncWorkerError extends BaseError {
        constructor(mes: unknown);
    }
    // (undocumented)
    export class TaskCancelError extends BaseError {
        constructor(taskId: unknown);
    }
    // (undocumented)
    export class ThreeWayMergeError extends BaseError {
        constructor(mes: string);
    }
    // (undocumented)
    export class UndefinedDatabaseNameError extends BaseError {
        constructor(e?: unknown);
    }
    // (undocumented)
    export class UndefinedDBError extends BaseError {
        constructor();
    }
    // (undocumented)
    export class UndefinedDocumentIdError extends BaseError {
        constructor(e?: unknown);
    }
    // (undocumented)
    export class UndefinedPersonalAccessTokenError extends BaseError {
        constructor();
    }
    // (undocumented)
    export class UndefinedRemoteURLError extends BaseError {
        constructor();
    }
    // (undocumented)
    export class UndefinedSyncError extends BaseError {
        constructor(e?: unknown);
    }
        {};
}

// @public
export type FatBinaryDoc = BinaryDocMetadata & {
    doc: Uint8Array;
};

// @public
export type FatDoc = FatJsonDoc | FatTextDoc | FatBinaryDoc;

// @public
export type FatJsonDoc = JsonDocMetadata & {
    doc: JsonDoc;
};

// @public
export type FatTextDoc = TextDocMetadata & {
    doc: string;
};

// @public (undocumented)
export const FILE_CREATE_TIMEOUT = 2000;

// @public (undocumented)
export const FILE_REMOVE_TIMEOUT = 7000;

// @public
export type FindOptions = {
    descending?: boolean;
    recursive?: boolean;
    prefix?: string;
    forceDocType?: DocType;
};

// @public (undocumented)
export const FIRST_COMMIT_MESSAGE = "first commit";

// Warning: (ae-internal-missing-underscore) The name "generateDatabaseId" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal
export function generateDatabaseId(): string;

// Warning: (ae-internal-missing-underscore) The name "GetInternalOptions" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal
export type GetInternalOptions = {
    revision?: number;
    oid?: string;
    withMetadata?: boolean;
};

// @public
export type GetOptions = {
    forceDocType?: DocType;
};

// @public (undocumented)
export const GIT_DOCUMENTDB_INFO_ID = ".gitddb/info";

// @public (undocumented)
export const GIT_DOCUMENTDB_METADATA_DIR = ".gitddb";

// @public
export interface GitDDBInterface {
    // (undocumented)
    author: {
        name: string;
        email: string;
    };
    // (undocumented)
    close(options?: DatabaseCloseOption): Promise<void>;
    // (undocumented)
    committer: {
        name: string;
        email: string;
    };
    // (undocumented)
    dbId: string;
    // (undocumented)
    dbName: string;
    defaultBranch: string;
    // (undocumented)
    destroy(options: DatabaseCloseOption): Promise<{
        ok: true;
    }>;
    // (undocumented)
    getCommit(oid: string): Promise<NormalizedCommit>;
    // (undocumented)
    getRemoteURLs(): string[];
    // (undocumented)
    getSync(remoteURL: string): SyncInterface;
    // (undocumented)
    isClosing: boolean;
    // (undocumented)
    isOpened: boolean;
    // (undocumented)
    loadAuthor(): Promise<void>;
    // (undocumented)
    loadDbInfo(): void;
    // (undocumented)
    localDir: string;
    // (undocumented)
    logger: Logger;
    logLevel: TLogLevelName;
    open(options?: OpenOptions): Promise<DatabaseOpenResult>;
    // (undocumented)
    removeSync(remoteURL: string): void;
    // (undocumented)
    rootCollection: ICollection;
    // (undocumented)
    saveAuthor(): Promise<void>;
    // (undocumented)
    schema: Schema;
    // (undocumented)
    sync(options: RemoteOptions, getSyncResult: boolean): Promise<[SyncInterface, SyncResult]>;
    // (undocumented)
    sync(options: RemoteOptions): Promise<SyncInterface>;
    // (undocumented)
    taskQueue: TaskQueue;
    // (undocumented)
    validator: Validator;
    // (undocumented)
    workingDir: string;
}

// @public
export class GitDocumentDB implements GitDDBInterface, CRUDInterface, CollectionInterface, SyncEventInterface {
    constructor(options: DatabaseOptions & CollectionOptions);
    author: {
        name: string;
        email: string;
    };
    close(options?: DatabaseCloseOption): Promise<void>;
    collection(collectionPath: CollectionPath, options?: CollectionOptions): Collection;
    committer: {
        name: string;
        email: string;
    };
    get dbId(): string;
    get dbName(): string;
    readonly defaultBranch = "main";
    delete(_id: string, options?: DeleteOptions): Promise<DeleteResultJsonDoc>;
    delete(jsonDoc: JsonDoc, options?: DeleteOptions): Promise<DeleteResultJsonDoc>;
    deleteFatDoc(name: string, options?: DeleteOptions): Promise<DeleteResult>;
    destroy(options?: DatabaseCloseOption): Promise<{
        ok: true;
    }>;
    find(options?: FindOptions): Promise<JsonDoc[]>;
    findFatDoc(options?: FindOptions): Promise<FatDoc[]>;
    get(_id: string): Promise<JsonDoc | undefined>;
    getCollections(dirPath?: string): Promise<ICollection[]>;
    getCommit(oid: string): Promise<NormalizedCommit>;
    getDocByOid(fileOid: string, docType?: DocType): Promise<Doc | undefined>;
    getFatDoc(name: string, getOptions?: GetOptions): Promise<FatDoc | undefined>;
    getFatDocHistory(name: string, historyOptions?: HistoryOptions, getOptions?: GetOptions): Promise<(FatDoc | undefined)[]>;
    getFatDocOldRevision(name: string, revision: number, historyOptions?: HistoryOptions, getOptions?: GetOptions): Promise<FatDoc | undefined>;
    getHistory(_id: string, historyOptions?: HistoryOptions): Promise<(JsonDoc | undefined)[]>;
    getOldRevision(_id: string, revision: number, historyOptions?: HistoryOptions): Promise<JsonDoc | undefined>;
    getRemoteURLs(): string[];
    getSync(remoteURL: string): Sync;
    insert(jsonDoc: JsonDoc, options?: PutOptions): Promise<PutResultJsonDoc>;
    insert(_id: string | undefined | null, jsonDoc: JsonDoc, options?: PutOptions): Promise<PutResultJsonDoc>;
    insertFatDoc(name: string | undefined | null, doc: JsonDoc | string | Uint8Array, options?: PutOptions): Promise<PutResult>;
    get isClosing(): boolean;
    get isOpened(): boolean;
    loadAuthor(): Promise<void>;
    // @internal
    loadDbInfo(): Promise<void>;
    get localDir(): string;
    get logger(): Logger;
    get logLevel(): TLogLevelName;
    set logLevel(level: TLogLevelName);
    // @eventProperty
    offSyncEvent(remoteURL: string, event: SyncEvent, callback: SyncCallback): void;
    // @eventProperty
    offSyncEvent(sync: SyncInterface, event: SyncEvent, callback: SyncCallback): void;
    // @eventProperty
    onSyncEvent(remoteURL: string, event: SyncEvent, callback: SyncCallback): SyncInterface;
    // @eventProperty
    onSyncEvent(sync: SyncInterface, event: SyncEvent, callback: SyncCallback): SyncInterface;
    open(openOptions?: OpenOptions): Promise<DatabaseOpenResult>;
    // (undocumented)
    static plugin(obj: any): void;
    put(jsonDoc: JsonDoc, options?: PutOptions): Promise<PutResultJsonDoc>;
    put(_id: string | undefined | null, jsonDoc: JsonDoc, options?: PutOptions): Promise<PutResultJsonDoc>;
    putFatDoc(name: string | undefined | null, doc: JsonDoc | Uint8Array | string, options?: PutOptions): Promise<PutResult>;
    removeSync(remoteURL: string): void;
    get rootCollection(): ICollection;
    saveAuthor(): Promise<void>;
    get schema(): Schema;
    sync(options: RemoteOptions): Promise<Sync>;
    sync(options: RemoteOptions, getSyncResult: boolean): Promise<[Sync, SyncResult]>;
    get taskQueue(): TaskQueue;
    update(jsonDoc: JsonDoc, options?: PutOptions): Promise<PutResultJsonDoc>;
    update(_id: string | undefined | null, jsonDoc: JsonDoc, options?: PutOptions): Promise<PutResultJsonDoc>;
    updateFatDoc(name: string | undefined | null, doc: JsonDoc | string | Uint8Array, options?: PutOptions): Promise<PutResult>;
    get validator(): Validator;
    get workingDir(): string;
}

// @public
export type HistoryFilter = {
    author?: {
        name?: string;
        email?: string;
    };
    committer?: {
        name?: string;
        email?: string;
    };
};

// @public
export type HistoryOptions = {
    filter?: HistoryFilter[];
};

// @public
export type ICollection = CollectionInterface & CRUDInterface & SyncEventInterface & {
    options: CollectionOptions;
    collectionPath: string;
    parent: ICollection | undefined;
    generateId(): string;
};

// Warning: (ae-internal-missing-underscore) The name "IJsonPatch" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal
export interface IJsonPatch {
    // (undocumented)
    patch(docOurs: JsonDoc, docTheirs: JsonDoc, diffOurs: {
        [key: string]: any;
    }, diffTheirs?: {
        [key: string]: any;
    } | undefined, strategy?: ConflictResolutionStrategyLabels): JsonDoc;
}

// @public (undocumented)
export const JSON_EXT = ".json";

// @public
export type JsonDiffOptions = {
    idOfSubtree?: string[];
    plainTextProperties?: {
        [key: string]: any;
    };
};

// @public
export type JsonDoc = {
    [key: string]: any;
};

// @public
export type JsonDocMetadata = {
    _id: string;
    name: string;
    fileOid: string;
    type: 'json';
};

// @public (undocumented)
export const MAX_FILE_PATH_LENGTH = 255;

// @public (undocumented)
export const MINIMUM_SYNC_INTERVAL = 3000;

// @public (undocumented)
export const NETWORK_RETRY = 3;

// @public (undocumented)
export const NETWORK_RETRY_INTERVAL = 2000;

// @public (undocumented)
export const NETWORK_TIMEOUT = 7000;

// @public
export type NormalizedCommit = {
    oid: string;
    message: string;
    parent: string[];
    author: {
        name: string;
        email: string;
        timestamp: number;
    };
    committer: {
        name: string;
        email: string;
        timestamp: number;
    };
    gpgsig?: string;
};

// @public
export type OpenOptions = {
    createIfNotExists?: boolean;
};

// @public
export type PluginTypes = 'db' | 'remote';

// @public (undocumented)
export const PUT_APP_INFO_MESSAGE = "put appinfo";

// @public
export type PutOptions = {
    commitMessage?: string;
    insertOrUpdate?: 'insert' | 'update';
    taskId?: string;
    enqueueCallback?: (taskMetadata: TaskMetadata) => void;
    debounceTime?: number;
};

// @public
export type PutResult = PutResultJsonDoc | PutResultText | PutResultBinary;

// @public (undocumented)
export type PutResultBinary = {
    name: string;
    fileOid: string;
    commit: NormalizedCommit;
    type: 'binary';
};

// @public (undocumented)
export type PutResultJsonDoc = {
    _id: string;
    name: string;
    fileOid: string;
    commit: NormalizedCommit;
    type: 'json';
};

// @public (undocumented)
export type PutResultText = {
    name: string;
    fileOid: string;
    commit: NormalizedCommit;
    type: 'text';
};

// @public
export const RemoteEngine: {
    [key: string]: RemoteEngineInterface;
};

// Warning: (ae-internal-missing-underscore) The name "RemoteEngineInterface" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal
export interface RemoteEngineInterface {
    // (undocumented)
    checkFetch: (workingDir: string, options: RemoteOptions, remoteName?: string, logger?: Logger) => Promise<boolean>;
    // (undocumented)
    clone: (workingDir: string, remoteOptions: RemoteOptions, remoteName: string, logger?: Logger) => Promise<void>;
    // (undocumented)
    fetch: (workingDir: string, remoteOptions: RemoteOptions, remoteName?: string, localBranchName?: string, remoteBranchName?: string, logger?: Logger) => Promise<void>;
    // (undocumented)
    name: string;
    // (undocumented)
    push: (workingDir: string, remoteOptions: RemoteOptions, remoteName?: string, localBranch?: string, remoteBranch?: string, logger?: Logger) => Promise<void>;
    // (undocumented)
    type: string;
}

// @public
export namespace RemoteErr {
    // Warning: (ae-forgotten-export) The symbol "BaseError" needs to be exported by the entry point main.d.ts
    //
    // (undocumented)
    export class CannotConnectError extends BaseError {
        constructor(mes: unknown);
    }
    // (undocumented)
    export class HTTPError401AuthorizationRequired extends BaseError {
        constructor(mes: unknown);
    }
    // (undocumented)
    export class HTTPError403Forbidden extends BaseError {
        constructor(mes: unknown);
    }
    // (undocumented)
    export class HTTPError404NotFound extends BaseError {
        constructor(mes: unknown);
    }
    // (undocumented)
    export class InvalidAuthenticationTypeError extends BaseError {
        constructor(mes: unknown);
    }
    // (undocumented)
    export class InvalidGitRemoteError extends BaseError {
        constructor(mes: unknown);
    }
    // (undocumented)
    export class InvalidRepositoryURLError extends BaseError {
        constructor(mes: unknown);
    }
    // (undocumented)
    export class InvalidSSHKeyPathError extends BaseError {
        constructor(mes: unknown);
    }
    // (undocumented)
    export class InvalidURLFormatError extends BaseError {
        constructor(mes: unknown);
    }
    // (undocumented)
    export class NetworkError extends BaseError {
        constructor(mes: unknown);
    }
    // (undocumented)
    export class UnfetchedCommitExistsError extends BaseError {
        constructor(mes: unknown);
    }
}

// @public
export type RemoteOptions = {
    remoteUrl?: string;
    syncDirection?: SyncDirection;
    connection?: ConnectionSettings;
    live?: boolean;
    interval?: number;
    retry?: number;
    retryInterval?: number;
    conflictResolutionStrategy?: ConflictResolutionStrategies;
    combineDbStrategy?: CombineDbStrategies;
    includeCommits?: boolean;
};

// @public
export class RemoteRepository {
    constructor(options: RemoteOptions);
    create(): Promise<void>;
    destroy(): Promise<void>;
}

// @public
export type Schema = {
    json: JsonDiffOptions;
};

// @public (undocumented)
export const SET_DATABASE_ID_MESSAGE = "set database id";

// @public (undocumented)
export const SHORT_SHA_LENGTH = 7;

// @public
export class Sync implements SyncInterface {
    constructor(gitDDB: GitDDBInterface, options?: RemoteOptions);
    close(): void;
    currentRetries(): number;
    // (undocumented)
    get engine(): string;
    enqueueSyncTask(calledAsPeriodicTask: boolean): Promise<SyncResult>;
    // @internal
    eventHandlers: {
        change: {
            collectionPath: string;
            func: SyncChangeCallback;
        }[];
        localChange: {
            collectionPath: string;
            func: SyncLocalChangeCallback;
        }[];
        remoteChange: {
            collectionPath: string;
            func: SyncRemoteChangeCallback;
        }[];
        combine: {
            collectionPath: string;
            func: SyncCombineDatabaseCallback;
        }[];
        pause: {
            collectionPath: string;
            func: SyncPauseCallback;
        }[];
        resume: {
            collectionPath: string;
            func: SyncResumeCallback;
        }[];
        start: {
            collectionPath: string;
            func: SyncStartCallback;
        }[];
        complete: {
            collectionPath: string;
            func: SyncCompleteCallback;
        }[];
        error: {
            collectionPath: string;
            func: SyncErrorCallback;
        }[];
    };
    init(): Promise<SyncResult>;
    // Warning: (ae-forgotten-export) The symbol "JsonDiff" needs to be exported by the entry point main.d.ts
    jsonDiff: JsonDiff;
    // Warning: (ae-forgotten-export) The symbol "JsonPatchOT" needs to be exported by the entry point main.d.ts
    jsonPatch: JsonPatchOT;
    // @eventProperty
    off(event: SyncEvent, callback: SyncCallback): this;
    // @eventProperty
    on(event: SyncEvent, callback: SyncCallback, collectionPath?: string): this;
    get options(): Required<RemoteOptions>;
    pause(): boolean;
    get remoteName(): string;
    get remoteRepository(): RemoteRepository;
    get remoteURL(): string;
    resume(options?: {
        interval?: number;
        retry?: number;
    }): boolean;
    tryPush(): Promise<SyncResultPush | SyncResultCancel | SyncResultNop>;
    // @internal
    tryPushImpl(calledAsPeriodicTask: boolean): Promise<SyncResultPush | SyncResultCancel | SyncResultNop>;
    trySync(): Promise<SyncResult>;
    // @internal
    trySyncImpl(calledAsPeriodicTask: boolean): Promise<SyncResult>;
}

// Warning: (ae-internal-missing-underscore) The name "syncAndGetResultImpl" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal
export function syncAndGetResultImpl(this: GitDDBInterface, options: RemoteOptions): Promise<[Sync, SyncResult]>;

// @public
export type SyncCallback = SyncChangeCallback | SyncLocalChangeCallback | SyncRemoteChangeCallback | SyncCombineDatabaseCallback | SyncPauseCallback | SyncResumeCallback | SyncStartCallback | SyncCompleteCallback | SyncErrorCallback;

// @public
export type SyncChangeCallback = (syncResult: SyncResult, taskMetadata: TaskMetadata) => void;

// @public
export type SyncCombineDatabaseCallback = (duplicates: DuplicatedFile[]) => void;

// @public
export type SyncCompleteCallback = (taskMetadata: TaskMetadata) => void;

// @public
export type SyncDirection = 'pull' | 'push' | 'both';

// @public
export type SyncErrorCallback = (error: Error, taskMetadata: TaskMetadata) => void;

// @public
export type SyncEvent = 'change' | 'localChange' | 'remoteChange' | 'combine' | 'pause' | 'resume' | 'start' | 'complete' | 'error';

// @public
export interface SyncEventInterface {
    // (undocumented)
    offSyncEvent(remoteURL: string, event: SyncEvent, callback: SyncCallback): void;
    // (undocumented)
    offSyncEvent(sync: SyncInterface, event: SyncEvent, callback: SyncCallback): void;
    // @internal (undocumented)
    offSyncEvent(remoteURLorSync: string | SyncInterface, event: SyncEvent, callback: SyncCallback): void;
    // (undocumented)
    onSyncEvent(remoteURL: string, event: SyncEvent, callback: SyncCallback): SyncInterface;
    // (undocumented)
    onSyncEvent(sync: SyncInterface, event: SyncEvent, callback: SyncCallback): SyncInterface;
    // @internal (undocumented)
    onSyncEvent(remoteURLorSync: string | SyncInterface, event: SyncEvent, callback: SyncCallback): SyncInterface;
}

// Warning: (ae-internal-missing-underscore) The name "syncImpl" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal
export function syncImpl(this: GitDDBInterface, options: RemoteOptions): Promise<Sync>;

// @public
export interface SyncInterface {
    // (undocumented)
    close(): void;
    // (undocumented)
    currentRetries(): number;
    // (undocumented)
    engine: string;
    // @internal (undocumented)
    eventHandlers: {
        change: {
            collectionPath: string;
            func: SyncChangeCallback;
        }[];
        localChange: {
            collectionPath: string;
            func: SyncLocalChangeCallback;
        }[];
        remoteChange: {
            collectionPath: string;
            func: SyncRemoteChangeCallback;
        }[];
        combine: {
            collectionPath: string;
            func: SyncCombineDatabaseCallback;
        }[];
        pause: {
            collectionPath: string;
            func: SyncPauseCallback;
        }[];
        resume: {
            collectionPath: string;
            func: SyncResumeCallback;
        }[];
        start: {
            collectionPath: string;
            func: SyncStartCallback;
        }[];
        complete: {
            collectionPath: string;
            func: SyncCompleteCallback;
        }[];
        error: {
            collectionPath: string;
            func: SyncErrorCallback;
        }[];
    };
    init(): Promise<SyncResult>;
    // (undocumented)
    jsonDiff: JsonDiff;
    // Warning: (ae-incompatible-release-tags) The symbol "jsonPatch" is marked as @public, but its signature references "IJsonPatch" which is marked as @internal
    //
    // (undocumented)
    jsonPatch: IJsonPatch;
    // (undocumented)
    off(event: SyncEvent, callback: SyncCallback): SyncInterface;
    // (undocumented)
    on(event: SyncEvent, callback: SyncCallback, collectionPath?: string): SyncInterface;
    // (undocumented)
    options: RemoteOptions;
    // (undocumented)
    pause(): void;
    // (undocumented)
    remoteName: string;
    // (undocumented)
    remoteRepository: RemoteRepository;
    remoteURL: string;
    // (undocumented)
    resume(options?: {
        interval?: number;
        retry?: number;
    }): void;
    // (undocumented)
    tryPush(): Promise<SyncResultPush | SyncResultCancel | SyncResultNop>;
    // (undocumented)
    trySync(): Promise<SyncResult>;
}

// @public
export type SyncLocalChangeCallback = (changedFiles: ChangedFile[], taskMetadata: TaskMetadata) => void;

// @public
export type SyncPauseCallback = () => void;

// @public
export type SyncRemoteChangeCallback = (changedFiles: ChangedFile[], taskMetadata: TaskMetadata) => void;

// @public
export type SyncResult = SyncResultNop | SyncResultPush | SyncResultFastForwardMerge | SyncResultMergeAndPushError | SyncResultMergeAndPush | SyncResultResolveConflictsAndPushError | SyncResultResolveConflictsAndPush | SyncResultCombineDatabase | SyncResultCancel;

// @public
export type SyncResultCancel = {
    action: 'canceled';
};

// @public
export type SyncResultCombineDatabase = {
    action: 'combine database';
    duplicates: DuplicatedFile[];
};

// @public
export type SyncResultFastForwardMerge = {
    action: 'fast-forward merge';
    changes: {
        local: ChangedFile[];
    };
    commits?: {
        local: NormalizedCommit[];
    };
};

// @public
export type SyncResultMergeAndPush = {
    action: 'merge and push';
    changes: {
        local: ChangedFile[];
        remote: ChangedFile[];
    };
    commits?: {
        local: NormalizedCommit[];
        remote: NormalizedCommit[];
    };
};

// @public
export type SyncResultMergeAndPushError = {
    action: 'merge and push error';
    changes: {
        local: ChangedFile[];
    };
    commits?: {
        local: NormalizedCommit[];
    };
    error: Error;
};

// @public
export type SyncResultNop = {
    action: 'nop';
};

// @public
export type SyncResultPush = {
    action: 'push';
    changes: {
        remote: ChangedFile[];
    };
    commits?: {
        remote: NormalizedCommit[];
    };
};

// @public
export type SyncResultResolveConflictsAndPush = {
    action: 'resolve conflicts and push';
    changes: {
        local: ChangedFile[];
        remote: ChangedFile[];
    };
    conflicts: AcceptedConflict[];
    commits?: {
        local: NormalizedCommit[];
        remote: NormalizedCommit[];
    };
};

// @public
export type SyncResultResolveConflictsAndPushError = {
    action: 'resolve conflicts and push error';
    changes: {
        local: ChangedFile[];
    };
    conflicts: AcceptedConflict[];
    commits?: {
        local: NormalizedCommit[];
    };
    error: Error;
};

// @public
export type SyncResumeCallback = () => void;

// @public
export type SyncStartCallback = (taskMetadata: TaskMetadata, currentRetries: number) => void;

// Warning: (ae-internal-missing-underscore) The name "Task" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal
export type Task = TaskMetadata & {
    func: (beforeResolve: () => void, beforeReject: () => void, taskMetadata: TaskMetadata) => Promise<void>;
    cancel: () => void;
    enqueueCallback?: (taskMetadata: TaskMetadata) => void;
};

// @public
export type TaskLabel = 'put' | 'insert' | 'update' | 'delete' | 'sync' | 'push';

// @public
export type TaskMetadata = {
    label: TaskLabel;
    taskId: string;
    shortId?: string;
    shortName?: string;
    collectionPath?: string;
    enqueueTime?: string;
    syncRemoteName?: string;
    debounceTime?: number;
};

// @public
export class TaskQueue {
    constructor(logger: Logger);
    currentStatistics(): TaskStatistics;
    currentTaskId(): string | undefined;
    getEnqueueTime(): string;
    length(): number;
    // @internal
    newTaskId(): string;
    // @internal
    pushToTaskQueue(task: Task): void;
    // @internal
    setLogger(logger: Logger): void;
    start(): void;
    stop(): void;
    // @internal (undocumented)
    waitCompletion(timeoutMsec: number): Promise<boolean>;
}

// @public
export type TaskStatistics = {
    put: number;
    insert: number;
    update: number;
    delete: number;
    push: number;
    sync: number;
    cancel: number;
};

// @public
export type TextDocMetadata = {
    name: string;
    fileOid: string;
    type: 'text';
};

// @public
export class Validator {
    constructor(workingDir: string);
    // (undocumented)
    static byteLengthOf: (str: string) => number;
    maxCollectionPathLength(): number;
    maxIdLength(): number;
    static maxWorkingDirectoryLength(): number;
    static normalizeCollectionPath(collectionPath: CollectionPath | undefined): CollectionPath;
    testWindowsInvalidFileNameCharacter(name: string, options?: {
        allowSlash?: boolean;
        allowDriveLetter?: boolean;
        allowDirectoryDot?: boolean;
        allowDot?: boolean;
        allowLastSpace?: boolean;
    }): boolean;
    testWindowsReservedFileName(name: string, options?: {
        allowDirectoryDot?: boolean;
    }): boolean;
    validateCollectionPath(collectionPath: string): void;
    validateDbName(dbName: string): void;
    validateDocument(doc: JsonDoc): void;
    validateId(_id: string): void;
    validateLocalDir(localDir: string): void;
}

// Warning: (ae-internal-missing-underscore) The name "wrappingRemoteEngineError" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal
export function wrappingRemoteEngineError(remoteEngineError: BaseError): Error;

// @public
export type WriteOperation = 'insert' | 'update' | 'delete' | 'insert-merge' | 'update-merge';

// Warnings were encountered during analysis:
//
// src/remote/remote_engine.ts:11:30 - (ae-incompatible-release-tags) The symbol "__index" is marked as @public, but its signature references "RemoteEngineInterface" which is marked as @internal

```
