---
sidebar_label: CRUDInterface interface
title: CRUDInterface interface
hide_title: true
---

[Home](./index.md) &gt; [git-documentdb](./git-documentdb.md) &gt; [CRUDInterface](./git-documentdb.crudinterface.md)

## CRUDInterface interface

Interface for GitDocumentDB CRUD

<b>Signature:</b>

```typescript
export interface CRUDInterface 
```

## Methods

|  Method | Description |
|  --- | --- |
|  [delete(jsonDoc, options)](./git-documentdb.crudinterface.delete.md) |  |
|  [delete(\_id, options)](./git-documentdb.crudinterface.delete_1.md) |  |
|  [deleteFatDoc(name, options)](./git-documentdb.crudinterface.deletefatdoc.md) |  |
|  [find(options)](./git-documentdb.crudinterface.find.md) |  |
|  [findFatDoc(options)](./git-documentdb.crudinterface.findfatdoc.md) |  |
|  [get(\_id, getOptions)](./git-documentdb.crudinterface.get.md) |  |
|  [getDocByOid(fileOid, docType)](./git-documentdb.crudinterface.getdocbyoid.md) |  |
|  [getFatDoc(name, getOptions)](./git-documentdb.crudinterface.getfatdoc.md) |  |
|  [getFatDocHistory(name, historyOptions, getOptions)](./git-documentdb.crudinterface.getfatdochistory.md) |  |
|  [getFatDocOldRevision(name, revision, historyOptions, getOptions)](./git-documentdb.crudinterface.getfatdocoldrevision.md) |  |
|  [getHistory(\_id, historyOptions)](./git-documentdb.crudinterface.gethistory.md) |  |
|  [getOldRevision(\_id, revision, historyOptions, getOptions)](./git-documentdb.crudinterface.getoldrevision.md) |  |
|  [insert(jsonDoc, options)](./git-documentdb.crudinterface.insert.md) |  |
|  [insert(\_id, data, options)](./git-documentdb.crudinterface.insert_1.md) |  |
|  [insertFatDoc(name, data, options)](./git-documentdb.crudinterface.insertfatdoc.md) |  |
|  [put(jsonDoc, options)](./git-documentdb.crudinterface.put.md) |  |
|  [put(\_id, data, options)](./git-documentdb.crudinterface.put_1.md) |  |
|  [putFatDoc(name, data, options)](./git-documentdb.crudinterface.putfatdoc.md) |  |
|  [update(jsonDoc, options)](./git-documentdb.crudinterface.update.md) |  |
|  [update(\_id, data, options)](./git-documentdb.crudinterface.update_1.md) |  |
|  [updateFatDoc(name, data, options)](./git-documentdb.crudinterface.updatefatdoc.md) |  |

