## API Report File for "git-documentdb"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { JSONOp } from 'ot-json1';
import { Logger } from 'tslog';
import nodegit from '@sosuisen/nodegit';
import { TLogLevelName } from 'tslog';

// @public
export type AcceptedConflict = {
    target: DocMetadata;
    strategy: ConflictResolutionStrategyLabels;
    operation: WriteOperation;
};

// @public
export type AllDocsOptions = {
    include_docs?: boolean;
    descending?: boolean;
    recursive?: boolean;
    prefix?: string;
};

// @public
export type AllDocsResult = {
    total_rows: number;
    commit_sha?: string;
    rows: JsonDocWithMetadata[];
};

// Warning: (ae-forgotten-export) The symbol "BaseError" needs to be exported by the entry point main.d.ts
//
// @public (undocumented)
export class AuthenticationTypeNotAllowCreateRepositoryError extends BaseError {
    constructor(type: string | undefined);
}

// @public (undocumented)
export class CannotConnectError extends BaseError {
    constructor(retry: number, url: string, mes: string);
    // (undocumented)
    retry: number;
}

// @public (undocumented)
export class CannotCreateDirectoryError extends BaseError {
    constructor(e?: string);
}

// @public (undocumented)
export class CannotCreateRemoteRepositoryError extends BaseError {
    constructor(reason: string);
}

// @public (undocumented)
export class CannotDeleteDataError extends BaseError {
    constructor(e?: string);
}

// @public (undocumented)
export class CannotGetEntryError extends BaseError {
    constructor(e?: string);
}

// @public (undocumented)
export class CannotOpenRepositoryError extends BaseError {
    constructor(err: string);
}

// @public (undocumented)
export class CannotWriteDataError extends BaseError {
    constructor(e?: string);
}

// @public
export type ChangedFile = ChangedFileInsert | ChangedFileUpdate | ChangedFileDelete;

// @public (undocumented)
export type ChangedFileDelete = {
    operation: 'delete';
    old: JsonDocWithMetadata;
};

// @public (undocumented)
export type ChangedFileInsert = {
    operation: 'insert';
    new: JsonDocWithMetadata;
};

// @public (undocumented)
export type ChangedFileUpdate = {
    operation: 'update';
    old: JsonDocWithMetadata;
    new: JsonDocWithMetadata;
};

// @public
export function cloneRepository(workingDir: string, remoteOptions: RemoteOptions, logger?: Logger): Promise<nodegit.Repository | undefined>;

// Warning: (ae-forgotten-export) The symbol "CRUDInterface" needs to be exported by the entry point main.d.ts
//
// @public
export class Collection implements CRUDInterface {
    // Warning: (ae-forgotten-export) The symbol "IDocumentDB" needs to be exported by the entry point main.d.ts
    constructor(_gitDDB: CRUDInterface & IDocumentDB, _collectionPath: CollectionPath);
    allDocs(options?: AllDocsOptions): Promise<AllDocsResult>;
    collectionPath(): string;
    delete(id: string, options?: DeleteOptions): Promise<RemoveResult>;
    delete(jsonDoc: JsonDoc, options?: DeleteOptions): Promise<RemoveResult>;
    get(docId: string, backNumber?: number): Promise<JsonDoc | undefined>;
    static getCollections(gitDDB: CRUDInterface & IDocumentDB, rootPath?: string): Promise<Collection[]>;
    insert(jsonDoc: JsonDoc, options?: PutOptions): Promise<PutResult>;
    insert(id: string, document: {
        [key: string]: any;
    }, options?: PutOptions): Promise<PutResult>;
    put(jsonDoc: JsonDoc, options?: PutOptions): Promise<PutResult>;
    put(_id: string, document: {
        [key: string]: any;
    }, options?: PutOptions): Promise<PutResult>;
    remove(id: string, options?: DeleteOptions): Promise<RemoveResult>;
    remove(jsonDoc: JsonDoc, options?: DeleteOptions): Promise<RemoveResult>;
    update(jsonDoc: JsonDoc, options?: PutOptions): Promise<PutResult>;
    update(id: string, document: {
        [key: string]: any;
    }, options?: PutOptions): Promise<PutResult>;
}

// @public
export type CollectionPath = string;

// @public
export type CombineDbStrategies = 'throw-error' | 'resolve-by-ours' | 'resolve-by-their' | 'replace-with-ours' | 'replace-with-theirs';

// @public
export type CommitInfo = {
    sha: string;
    date: Date;
    author: string;
    message: string;
};

// @public
export type ConflictResolutionStrategies = ConflictResolutionStrategyLabels | ((ours?: JsonDoc, theirs?: JsonDoc) => ConflictResolutionStrategyLabels);

// @public (undocumented)
export type ConflictResolutionStrategyLabels = 'ours-diff' | 'theirs-diff' | 'ours' | 'theirs';

// @public
export type ConnectionSettings = ConnectionSettingsNone | ConnectionSettingsGitHub | ConnectionSettingsSSH;

// @public
export type ConnectionSettingsGitHub = {
    type: 'github';
    personal_access_token?: string;
    private?: boolean;
};

// @public
export type ConnectionSettingsNone = {
    type: 'none';
};

// @public
export type ConnectionSettingsSSH = {
    type: 'ssh';
    private_key_path: string;
    public_key_path: string;
    pass_phrase?: string;
};

// @public (undocumented)
export class ConsecutiveSyncSkippedError extends BaseError {
    constructor(taskLabel: string, taskId: string);
}

// @public (undocumented)
export class CorruptedRepositoryError extends BaseError {
    constructor();
}

// @public (undocumented)
export const DATABASE_NAME = "GitDocumentDB";

// @public (undocumented)
export const DATABASE_VERSION = "1.0";

// @public
export type DatabaseCloseOption = {
    force?: boolean;
    timeout?: number;
};

// @public (undocumented)
export class DatabaseCloseTimeoutError extends BaseError {
    constructor(e?: string);
}

// @public (undocumented)
export class DatabaseClosingError extends BaseError {
    constructor(e?: string);
}

// @public (undocumented)
export class DatabaseExistsError extends BaseError {
    constructor();
}

// @public
export type DatabaseInfo = DatabaseInfoSuccess | DatabaseInfoError;

// @public
export type DatabaseInfoError = {
    ok: false;
    error: Error;
};

// @public
export type DatabaseInfoSuccess = {
    ok: true;
    is_new: boolean;
    is_clone: boolean;
    is_created_by_gitddb: boolean;
    is_valid_version: boolean;
};

// @public
export type DatabaseOption = {
    local_dir?: string;
    db_name: string;
    log_level?: TLogLevelName;
    schema?: Schema;
};

// @public
export type DeleteOptions = {
    commit_message?: string;
    taskId?: string;
    enqueueCallback?: (taskMetadata: TaskMetadata) => void;
};

// @public
export type DocMetadata = {
    id: string;
    file_sha: string;
    type?: 'json' | 'raw';
};

// @public (undocumented)
export class DocumentNotFoundError extends BaseError {
    constructor(e?: string);
}

// @public (undocumented)
export class FetchConnectionFailedError extends BaseError {
    constructor(mes: string);
}

// @public (undocumented)
export class FetchPermissionDeniedError extends BaseError {
    constructor(mes: string);
}

// @public (undocumented)
export class FileRemoveTimeoutError extends BaseError {
    constructor();
}

// @public (undocumented)
export const GIT_DOCUMENTDB_VERSION: string;

// @public (undocumented)
export const GIT_DOCUMENTDB_VERSION_FILENAME = ".gitddb/lib_version";

// @public
export class GitDocumentDB implements IDocumentDB, CRUDInterface {
    constructor(options: DatabaseOption);
    allDocs(options?: AllDocsOptions): Promise<AllDocsResult>;
    close(options?: DatabaseCloseOption): Promise<void>;
    collection(collectionPath: CollectionPath): Collection;
    createDB(remoteOptions?: RemoteOptions): Promise<DatabaseInfo>;
    dbName(): string;
    // (undocumented)
    readonly defaultBranch = "main";
    delete(id: string, options?: DeleteOptions): Promise<RemoveResult>;
    delete(jsonDoc: JsonDoc, options?: DeleteOptions): Promise<RemoveResult>;
    destroy(options?: DatabaseCloseOption): Promise<{
        ok: true;
    }>;
    readonly fileExt = ".json";
    get(docId: string, backNumber?: number): Promise<JsonDoc | undefined>;
    getByRevision(fileSHA: string): Promise<JsonDoc | undefined>;
    getCollections(rootPath?: string): Promise<Collection[]>;
    getDocHistory(docID: string): Promise<string[]>;
    getDocWithMetaData(docId: string, backNumber?: number): Promise<JsonDocWithMetadata | undefined>;
    // (undocumented)
    getLogger(): Logger;
    getRemoteURLs(): string[];
    getSynchronizer(remoteURL: string): Sync;
    readonly gitAuthor: {
        readonly name: "GitDocumentDB";
        readonly email: "gitddb@example.com";
    };
    insert(jsonDoc: JsonDoc, options?: PutOptions): Promise<PutResult>;
    insert(id: string, document: {
        [key: string]: any;
    }, options?: PutOptions): Promise<PutResult>;
    isClosing: boolean;
    isOpened(): boolean;
    open(): Promise<DatabaseInfo>;
    put(jsonDoc: JsonDoc, options?: PutOptions): Promise<PutResult>;
    put(id: string, document: {
        [key: string]: any;
    }, options?: PutOptions): Promise<PutResult>;
    remove(id: string, options?: DeleteOptions): Promise<RemoveResult>;
    remove(jsonDoc: JsonDoc, options?: DeleteOptions): Promise<RemoveResult>;
    repository(): nodegit.Repository | undefined;
    schema: Schema;
    // (undocumented)
    setLogLevel(level: TLogLevelName): void;
    sync(remoteURL: string, options?: RemoteOptions): Promise<Sync>;
    sync(options?: RemoteOptions): Promise<Sync>;
    // Warning: (ae-forgotten-export) The symbol "TaskQueue" needs to be exported by the entry point main.d.ts
    taskQueue: TaskQueue;
    unregisterRemote(remoteURL: string): void;
    update(jsonDoc: JsonDoc, options?: PutOptions): Promise<PutResult>;
    update(id: string, document: {
        [key: string]: any;
    }, options?: PutOptions): Promise<PutResult>;
    validator: Validator;
    workingDir(): string;
    }

// @public (undocumented)
export class GitMergeBranchError extends BaseError {
    constructor(mes: string);
}

// @public (undocumented)
export class GitPushError extends BaseError {
    constructor(mes: string);
}

// @public (undocumented)
export class HTTPNetworkError extends BaseError {
    constructor(mes: string);
}

// @public (undocumented)
export class HttpProtocolRequiredError extends BaseError {
    constructor(url: string);
}

// @public (undocumented)
export interface IJsonPatch {
    // (undocumented)
    patch(docOurs: JsonDoc, docTheirs: JsonDoc, diffOurs: {
        [key: string]: any;
    }, diffTheirs?: {
        [key: string]: any;
    } | undefined, strategy?: ConflictResolutionStrategyLabels): JsonDoc;
}

// @public (undocumented)
export class IntervalTooSmallError extends BaseError {
    constructor(min: number, current: number);
}

// @public (undocumented)
export class InvalidAuthenticationTypeError extends BaseError {
    constructor(type: string);
}

// @public (undocumented)
export class InvalidBackNumberError extends BaseError {
    constructor(e?: string);
}

// @public (undocumented)
export class InvalidCollectionPathCharacterError extends BaseError {
    constructor(name: string);
}

// @public (undocumented)
export class InvalidCollectionPathError extends BaseError {
    constructor(name: string);
}

// @public (undocumented)
export class InvalidCollectionPathLengthError extends BaseError {
    constructor(collectionPath: string, minLength: number, maxLength: number);
}

// @public (undocumented)
export class InvalidConflictStateError extends BaseError {
    constructor(mes: string);
}

// @public (undocumented)
export class InvalidDbNameCharacterError extends BaseError {
    constructor(name: string);
}

// @public (undocumented)
export class InvalidFileSHAFormatError extends BaseError {
    constructor();
}

// @public (undocumented)
export class InvalidIdCharacterError extends BaseError {
    constructor(id: string);
}

// @public (undocumented)
export class InvalidIdLengthError extends BaseError {
    constructor(id: string, minLength: number, maxLength: number);
}

// @public (undocumented)
export class InvalidJsonObjectError extends BaseError {
    constructor(e?: string);
}

// @public (undocumented)
export class InvalidLocalDirCharacterError extends BaseError {
    constructor(name: string);
}

// @public (undocumented)
export class InvalidPropertyNameInDocumentError extends BaseError {
    constructor(name: string);
}

// @public (undocumented)
export class InvalidRepositoryURLError extends BaseError {
    constructor(url: string);
}

// @public (undocumented)
export class InvalidSSHKeyPathError extends BaseError {
    constructor();
}

// @public (undocumented)
export class InvalidURLError extends BaseError {
    constructor(url: string);
}

// @public (undocumented)
export class InvalidWorkingDirectoryPathLengthError extends BaseError {
    constructor(path: string, minLength: number, maxLength: number);
}

// @public
export type JsonDiffOptions = {
    idOfSubtree?: string[];
    plainTextProperties?: {
        [key: string]: any;
    };
};

// @public
export type JsonDoc = {
    [key: string]: any;
};

// @public
export type JsonDocWithMetadata = DocMetadata & {
    doc?: JsonDoc;
};

// @public (undocumented)
export class NoMergeBaseFoundError extends BaseError {
    constructor();
}

// @public (undocumented)
export class PersonalAccessTokenForAnotherAccountError extends BaseError {
    constructor();
}

// @public (undocumented)
export class PushConnectionFailedError extends BaseError {
    constructor(mes: string);
}

// @public (undocumented)
export class PushNotAllowedError extends BaseError {
    constructor(direction: string);
}

// @public (undocumented)
export class PushPermissionDeniedError extends BaseError {
    constructor(mes: string);
}

// @public (undocumented)
export class PushWorkerError extends BaseError {
    constructor(mes: string);
}

// @public
export type PutOptions = {
    commit_message?: string;
    insertOrUpdate?: 'insert' | 'update';
    taskId?: string;
    enqueueCallback?: (taskMetadata: TaskMetadata) => void;
};

// @public
export type PutResult = {
    ok: true;
    id: string;
    file_sha: string;
    commit_sha: string;
};

// @public (undocumented)
export class RemoteAlreadyRegisteredError extends BaseError {
    constructor(url: string);
}

// @public
export type RemoteOptions = {
    remote_url?: string;
    sync_direction?: SyncDirection;
    connection?: ConnectionSettings;
    live?: boolean;
    interval?: number;
    retry?: number;
    retry_interval?: number;
    conflict_resolution_strategy?: ConflictResolutionStrategies;
    combine_db_strategy?: CombineDbStrategies;
    include_commits?: boolean;
};

// @public (undocumented)
export class RemoteRepository {
    constructor(options: RemoteOptions);
    // Warning: (ae-forgotten-export) The symbol "GitRemoteAction" needs to be exported by the entry point main.d.ts
    connect(repos: nodegit.Repository, credential_callbacks: {
        [key: string]: any;
    }, onlyFetch?: boolean): Promise<[GitRemoteAction, 'exist' | 'create']>;
    create(): Promise<void>;
    destroy(): Promise<void>;
    }

// @public (undocumented)
export class RemoteRepositoryConnectError extends BaseError {
    constructor(mes: string);
}

// @public (undocumented)
export class RemoteRepositoryNotFoundError extends BaseError {
    constructor(url: string);
}

// @public
export type RemoveResult = {
    ok: true;
    id: string;
    file_sha: string;
    commit_sha: string;
};

// @public (undocumented)
export class RepositoryNotFoundError extends BaseError {
    constructor(path: string);
}

// @public (undocumented)
export class RepositoryNotOpenError extends BaseError {
    constructor(e?: string);
}

// @public (undocumented)
export class RequestTimeoutError extends BaseError {
    constructor(url: string);
}

// @public (undocumented)
export class SameIdExistsError extends BaseError {
    constructor(e?: string);
}

// @public
export type Schema = {
    json: JsonDiffOptions;
};

// @public (undocumented)
export class SocketTimeoutError extends BaseError {
    constructor(url: string);
}

// Warning: (ae-forgotten-export) The symbol "ISync" needs to be exported by the entry point main.d.ts
//
// @public
export class Sync implements ISync {
    constructor(_gitDDB: IDocumentDB, _options?: RemoteOptions);
    // (undocumented)
    author: nodegit.Signature;
    cancel(): boolean;
    // @internal
    canNetworkConnection(): Promise<boolean>;
    close(): void;
    // (undocumented)
    committer: nodegit.Signature;
    // (undocumented)
    credential_callbacks: {
        [key: string]: any;
    };
    currentRetries(): number;
    enqueuePushTask(): Promise<SyncResultPush | SyncResultCancel>;
    enqueueSyncTask(): Promise<SyncResult>;
    // @internal
    eventHandlers: {
        change: SyncChangeCallback[];
        localChange: SyncLocalChangeCallback[];
        remoteChange: SyncRemoteChangeCallback[];
        paused: SyncPausedCallback[];
        active: SyncActiveCallback[];
        start: SyncStartCallback[];
        complete: SyncCompleteCallback[];
        error: SyncErrorCallback[];
    };
    init(repos: nodegit.Repository): Promise<SyncResult>;
    // Warning: (ae-forgotten-export) The symbol "JsonDiff" needs to be exported by the entry point main.d.ts
    jsonDiff: JsonDiff;
    // Warning: (ae-forgotten-export) The symbol "JsonPatchOT" needs to be exported by the entry point main.d.ts
    jsonPatch: JsonPatchOT;
    off(event: SyncEvent, callback: SyncCallback): this;
    on(event: SyncEvent, callback: SyncCallback): this;
    options(): Required<RemoteOptions>;
    pause(): boolean;
    remoteURL(): string;
    resume(options?: {
        interval?: number;
        retry?: number;
    }): boolean;
    tryPush(options?: {
        onlyPush: boolean;
    }): Promise<SyncResultPush | SyncResultCancel>;
    trySync(): Promise<SyncResult>;
    // (undocumented)
    upstream_branch: string;
}

// @public (undocumented)
export type SyncActiveCallback = () => void;

// @public (undocumented)
export type SyncCallback = SyncChangeCallback | SyncLocalChangeCallback | SyncRemoteChangeCallback | SyncPausedCallback | SyncActiveCallback | SyncStartCallback | SyncCompleteCallback | SyncErrorCallback;

// @public
export type SyncChangeCallback = (syncResult: SyncResult, taskMetadata: TaskMetadata) => void;

// @public (undocumented)
export type SyncCompleteCallback = (taskMetadata: TaskMetadata) => void;

// @public
export type SyncDirection = 'pull' | 'push' | 'both';

// @public (undocumented)
export type SyncErrorCallback = (error: Error, taskMetadata: TaskMetadata) => void;

// @public
export type SyncEvent = 'change' | 'localChange' | 'remoteChange' | 'paused' | 'active' | 'start' | 'complete' | 'error';

// Warning: (ae-internal-missing-underscore) The name "syncImpl" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal
export function syncImpl(this: IDocumentDB, options?: RemoteOptions): Promise<Sync>;

// @public (undocumented)
export class SyncIntervalLessThanOrEqualToRetryIntervalError extends BaseError {
    constructor(syncInterval: number, retryInterval: number);
}

// @public (undocumented)
export type SyncLocalChangeCallback = (changedFiles: ChangedFile[], taskMetadata: TaskMetadata) => void;

// @public (undocumented)
export type SyncPausedCallback = () => void;

// @public (undocumented)
export type SyncRemoteChangeCallback = (changedFiles: ChangedFile[], taskMetadata: TaskMetadata) => void;

// @public
export type SyncResult = SyncResultNop | SyncResultPush | SyncResultFastForwardMerge | SyncResultMergeAndPushError | SyncResultMergeAndPush | SyncResultResolveConflictsAndPushError | SyncResultResolveConflictsAndPush | SyncResultCancel;

// @public (undocumented)
export interface SyncResultCancel {
    // (undocumented)
    action: 'canceled';
}

// @public (undocumented)
export interface SyncResultFastForwardMerge {
    // (undocumented)
    action: 'fast-forward merge';
    // (undocumented)
    changes: {
        local: ChangedFile[];
    };
    // (undocumented)
    commits?: {
        local: CommitInfo[];
    };
}

// @public (undocumented)
export interface SyncResultMergeAndPush {
    // (undocumented)
    action: 'merge and push';
    // (undocumented)
    changes: {
        local: ChangedFile[];
        remote: ChangedFile[];
    };
    // (undocumented)
    commits?: {
        local: CommitInfo[];
        remote: CommitInfo[];
    };
}

// @public (undocumented)
export interface SyncResultMergeAndPushError {
    // (undocumented)
    action: 'merge and push error';
    // (undocumented)
    changes: {
        local: ChangedFile[];
    };
    // (undocumented)
    commits?: {
        local: CommitInfo[];
    };
}

// @public (undocumented)
export interface SyncResultNop {
    // (undocumented)
    action: 'nop';
}

// @public (undocumented)
export interface SyncResultPush {
    // (undocumented)
    action: 'push';
    // (undocumented)
    changes: {
        remote: ChangedFile[];
    };
    // (undocumented)
    commits?: {
        remote: CommitInfo[];
    };
}

// @public (undocumented)
export interface SyncResultResolveConflictsAndPush {
    // (undocumented)
    action: 'resolve conflicts and push';
    // (undocumented)
    changes: {
        local: ChangedFile[];
        remote: ChangedFile[];
    };
    // (undocumented)
    commits?: {
        local: CommitInfo[];
        remote: CommitInfo[];
    };
    // (undocumented)
    conflicts: AcceptedConflict[];
}

// @public (undocumented)
export interface SyncResultResolveConflictsAndPushError {
    // (undocumented)
    action: 'resolve conflicts and push error';
    // (undocumented)
    changes: {
        local: ChangedFile[];
    };
    // (undocumented)
    commits?: {
        local: CommitInfo[];
    };
    // (undocumented)
    conflicts: AcceptedConflict[];
}

// @public (undocumented)
export type SyncStartCallback = (taskMetadata: TaskMetadata, currentRetries: number) => void;

// @public (undocumented)
export class SyncWorkerError extends BaseError {
    constructor(mes: string);
}

// @public (undocumented)
export class SyncWorkerFetchError extends BaseError {
    constructor(mes: string);
}

// @public
export type Task = TaskMetadata & {
    func: (beforeResolve: () => void, beforeReject: () => void, taskMetadata: TaskMetadata) => Promise<void>;
    cancel: () => void;
    enqueueCallback?: (taskMetadata: TaskMetadata) => void;
};

// @public (undocumented)
export type TaskCallback = TaskEnqueueCallback;

// @public (undocumented)
export class TaskCancelError extends BaseError {
    constructor(taskId: string);
}

// @public (undocumented)
export type TaskEnqueueCallback = (taskMetadata: TaskMetadata) => void;

// @public
export type TaskEvent = 'enqueue';

// @public
export type TaskLabel = 'put' | 'insert' | 'update' | 'delete' | 'sync' | 'push';

// @public
export type TaskMetadata = {
    label: TaskLabel;
    taskId: string;
    targetId?: string;
    enqueueTime?: string;
};

// @public
export type TaskStatistics = {
    put: number;
    insert: number;
    update: number;
    delete: number;
    push: number;
    sync: number;
    cancel: number;
};

// @public (undocumented)
export class ThreeWayMergeError extends BaseError {
    constructor(mes: string);
}

// @public (undocumented)
export class UndefinedDatabaseNameError extends BaseError {
    constructor(e?: string);
}

// @public (undocumented)
export class UndefinedDBError extends BaseError {
    constructor();
}

// @public (undocumented)
export class UndefinedDocumentIdError extends BaseError {
    constructor(e?: string);
}

// @public (undocumented)
export class UndefinedFileSHAError extends BaseError {
    constructor(e?: string);
}

// @public (undocumented)
export class UndefinedGitHubAuthenticationError extends BaseError {
    constructor(mes: string);
}

// @public (undocumented)
export class UndefinedPersonalAccessTokenError extends BaseError {
    constructor();
}

// @public (undocumented)
export class UndefinedRemoteURLError extends BaseError {
    constructor();
}

// @public (undocumented)
export class UnfetchedCommitExistsError extends BaseError {
    constructor();
}

// @public
export class Validator {
    constructor(_workingDir: string);
    // (undocumented)
    static byteLengthOf: (str: string) => number;
    maxCollectionPathLength(): number;
    maxIdLength(): number;
    static maxWorkingDirectoryLength(): number;
    static normalizeCollectionPath(collectionPath: CollectionPath | undefined): CollectionPath;
    testWindowsInvalidFileNameCharacter(name: string, options?: {
        allow_slash?: boolean;
        allow_drive_letter?: boolean;
        allow_directory_dot?: boolean;
    }): boolean;
    testWindowsReservedFileName(name: string, options?: {
        allow_directory_dot?: boolean;
    }): boolean;
    validateCollectionPath(collectionPath: string): void;
    validateDbName(dbName: string): void;
    validateDocument(doc: JsonDoc): void;
    validateId(_id: string): void;
    validateLocalDir(localDir: string): void;
    }

// @public (undocumented)
export class WorkingDirectoryExistsError extends BaseError {
    constructor();
}

// @public
export type WriteOperation = 'insert' | 'update' | 'delete' | 'insert-merge' | 'update-merge';


```
