<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [git-documentdb](./git-documentdb.md)

## git-documentdb package

Offline-first DocumentDB using Git

## Remarks

GitDocumentDB stores a document into Git repository. It is managed by PouchDB-like offline-first API. A database can be synchronized with a remote Git repository.

## Classes

|  Class | Description |
|  --- | --- |
|  [AuthenticationTypeNotAllowCreateRepositoryError](./git-documentdb.authenticationtypenotallowcreaterepositoryerror.md) |  |
|  [CannotConnectError](./git-documentdb.cannotconnecterror.md) |  |
|  [CannotCreateDirectoryError](./git-documentdb.cannotcreatedirectoryerror.md) |  |
|  [CannotCreateRemoteRepositoryError](./git-documentdb.cannotcreateremoterepositoryerror.md) |  |
|  [CannotDeleteDataError](./git-documentdb.cannotdeletedataerror.md) |  |
|  [CannotGetEntryError](./git-documentdb.cannotgetentryerror.md) |  |
|  [CannotOpenRepositoryError](./git-documentdb.cannotopenrepositoryerror.md) |  |
|  [CannotWriteDataError](./git-documentdb.cannotwritedataerror.md) |  |
|  [Collection](./git-documentdb.collection.md) | Documents are gathered together in collections. |
|  [ConsecutiveSyncSkippedError](./git-documentdb.consecutivesyncskippederror.md) |  |
|  [CorruptedRepositoryError](./git-documentdb.corruptedrepositoryerror.md) |  |
|  [DatabaseCloseTimeoutError](./git-documentdb.databaseclosetimeouterror.md) |  |
|  [DatabaseClosingError](./git-documentdb.databaseclosingerror.md) |  |
|  [DatabaseExistsError](./git-documentdb.databaseexistserror.md) |  |
|  [DocumentNotFoundError](./git-documentdb.documentnotfounderror.md) |  |
|  [FetchConnectionFailedError](./git-documentdb.fetchconnectionfailederror.md) |  |
|  [FetchPermissionDeniedError](./git-documentdb.fetchpermissiondeniederror.md) |  |
|  [FileRemoveTimeoutError](./git-documentdb.fileremovetimeouterror.md) |  |
|  [GitDocumentDB](./git-documentdb.gitdocumentdb.md) | Main class of GitDocumentDB |
|  [GitMergeBranchError](./git-documentdb.gitmergebrancherror.md) |  |
|  [GitPushError](./git-documentdb.gitpusherror.md) |  |
|  [HTTPNetworkError](./git-documentdb.httpnetworkerror.md) |  |
|  [HttpProtocolRequiredError](./git-documentdb.httpprotocolrequirederror.md) |  |
|  [IntervalTooSmallError](./git-documentdb.intervaltoosmallerror.md) |  |
|  [InvalidAuthenticationTypeError](./git-documentdb.invalidauthenticationtypeerror.md) |  |
|  [InvalidBackNumberError](./git-documentdb.invalidbacknumbererror.md) |  |
|  [InvalidCollectionPathCharacterError](./git-documentdb.invalidcollectionpathcharactererror.md) |  |
|  [InvalidCollectionPathError](./git-documentdb.invalidcollectionpatherror.md) |  |
|  [InvalidCollectionPathLengthError](./git-documentdb.invalidcollectionpathlengtherror.md) |  |
|  [InvalidConflictStateError](./git-documentdb.invalidconflictstateerror.md) |  |
|  [InvalidDbNameCharacterError](./git-documentdb.invaliddbnamecharactererror.md) |  |
|  [InvalidFileSHAFormatError](./git-documentdb.invalidfileshaformaterror.md) |  |
|  [InvalidIdCharacterError](./git-documentdb.invalididcharactererror.md) |  |
|  [InvalidIdLengthError](./git-documentdb.invalididlengtherror.md) |  |
|  [InvalidJsonObjectError](./git-documentdb.invalidjsonobjecterror.md) |  |
|  [InvalidLocalDirCharacterError](./git-documentdb.invalidlocaldircharactererror.md) |  |
|  [InvalidPropertyNameInDocumentError](./git-documentdb.invalidpropertynameindocumenterror.md) |  |
|  [InvalidRepositoryURLError](./git-documentdb.invalidrepositoryurlerror.md) |  |
|  [InvalidSSHKeyPathError](./git-documentdb.invalidsshkeypatherror.md) |  |
|  [InvalidURLError](./git-documentdb.invalidurlerror.md) |  |
|  [InvalidWorkingDirectoryPathLengthError](./git-documentdb.invalidworkingdirectorypathlengtherror.md) |  |
|  [NoMergeBaseFoundError](./git-documentdb.nomergebasefounderror.md) |  |
|  [PersonalAccessTokenForAnotherAccountError](./git-documentdb.personalaccesstokenforanotheraccounterror.md) |  |
|  [PushConnectionFailedError](./git-documentdb.pushconnectionfailederror.md) |  |
|  [PushNotAllowedError](./git-documentdb.pushnotallowederror.md) |  |
|  [PushPermissionDeniedError](./git-documentdb.pushpermissiondeniederror.md) |  |
|  [PushWorkerError](./git-documentdb.pushworkererror.md) |  |
|  [RemoteAlreadyRegisteredError](./git-documentdb.remotealreadyregisterederror.md) |  |
|  [RemoteRepository](./git-documentdb.remoterepository.md) |  |
|  [RemoteRepositoryConnectError](./git-documentdb.remoterepositoryconnecterror.md) |  |
|  [RemoteRepositoryNotFoundError](./git-documentdb.remoterepositorynotfounderror.md) |  |
|  [RepositoryNotFoundError](./git-documentdb.repositorynotfounderror.md) |  |
|  [RepositoryNotOpenError](./git-documentdb.repositorynotopenerror.md) |  |
|  [RequestTimeoutError](./git-documentdb.requesttimeouterror.md) |  |
|  [SameIdExistsError](./git-documentdb.sameidexistserror.md) |  |
|  [SocketTimeoutError](./git-documentdb.sockettimeouterror.md) |  |
|  [Sync](./git-documentdb.sync.md) | Synchronizer class |
|  [SyncIntervalLessThanOrEqualToRetryIntervalError](./git-documentdb.syncintervallessthanorequaltoretryintervalerror.md) |  |
|  [SyncWorkerError](./git-documentdb.syncworkererror.md) |  |
|  [SyncWorkerFetchError](./git-documentdb.syncworkerfetcherror.md) |  |
|  [TaskCancelError](./git-documentdb.taskcancelerror.md) |  |
|  [ThreeWayMergeError](./git-documentdb.threewaymergeerror.md) |  |
|  [UndefinedDatabaseNameError](./git-documentdb.undefineddatabasenameerror.md) |  |
|  [UndefinedDBError](./git-documentdb.undefineddberror.md) |  |
|  [UndefinedDocumentIdError](./git-documentdb.undefineddocumentiderror.md) |  |
|  [UndefinedFileSHAError](./git-documentdb.undefinedfileshaerror.md) |  |
|  [UndefinedGitHubAuthenticationError](./git-documentdb.undefinedgithubauthenticationerror.md) |  |
|  [UndefinedPersonalAccessTokenError](./git-documentdb.undefinedpersonalaccesstokenerror.md) |  |
|  [UndefinedRemoteURLError](./git-documentdb.undefinedremoteurlerror.md) |  |
|  [UnfetchedCommitExistsError](./git-documentdb.unfetchedcommitexistserror.md) |  |
|  [Validator](./git-documentdb.validator.md) | Validator Class |
|  [WorkingDirectoryExistsError](./git-documentdb.workingdirectoryexistserror.md) |  |

## Functions

|  Function | Description |
|  --- | --- |
|  [cloneRepository(workingDir, remoteOptions, logger)](./git-documentdb.clonerepository.md) | Clone repository from remote |

## Interfaces

|  Interface | Description |
|  --- | --- |
|  [IJsonPatch](./git-documentdb.ijsonpatch.md) |  |
|  [SyncResultCancel](./git-documentdb.syncresultcancel.md) |  |
|  [SyncResultFastForwardMerge](./git-documentdb.syncresultfastforwardmerge.md) |  |
|  [SyncResultMergeAndPush](./git-documentdb.syncresultmergeandpush.md) |  |
|  [SyncResultMergeAndPushError](./git-documentdb.syncresultmergeandpusherror.md) |  |
|  [SyncResultNop](./git-documentdb.syncresultnop.md) |  |
|  [SyncResultPush](./git-documentdb.syncresultpush.md) |  |
|  [SyncResultResolveConflictsAndPush](./git-documentdb.syncresultresolveconflictsandpush.md) |  |
|  [SyncResultResolveConflictsAndPushError](./git-documentdb.syncresultresolveconflictsandpusherror.md) |  |

## Variables

|  Variable | Description |
|  --- | --- |
|  [DATABASE\_NAME](./git-documentdb.database_name.md) |  |
|  [DATABASE\_VERSION](./git-documentdb.database_version.md) |  |
|  [GIT\_DOCUMENTDB\_VERSION\_FILENAME](./git-documentdb.git_documentdb_version_filename.md) |  |
|  [GIT\_DOCUMENTDB\_VERSION](./git-documentdb.git_documentdb_version.md) |  |

## Type Aliases

|  Type Alias | Description |
|  --- | --- |
|  [AcceptedConflict](./git-documentdb.acceptedconflict.md) | Accepted Conflict |
|  [AllDocsOptions](./git-documentdb.alldocsoptions.md) | Options for allDocs() |
|  [AllDocsResult](./git-documentdb.alldocsresult.md) | Result of allDocs() |
|  [ChangedFile](./git-documentdb.changedfile.md) | Changed file in merge operation |
|  [ChangedFileDelete](./git-documentdb.changedfiledelete.md) |  |
|  [ChangedFileInsert](./git-documentdb.changedfileinsert.md) |  |
|  [ChangedFileUpdate](./git-documentdb.changedfileupdate.md) |  |
|  [CollectionPath](./git-documentdb.collectionpath.md) | CollectionPath<!-- -->- A directory name allows Unicode characters excluding OS reserved filenames and following characters: &lt; &gt; : " \| ? \* \\<!-- -->0<!-- -->- \*\*It is recommended to use ASCII characters and case-insensitive names for cross-platform.\*\*<!-- -->- A directory name cannot end with a period or a white space.<!-- -->- A directory name does not allow '.' and '..'.<!-- -->- collectionPath cannot start with a slash.<!-- -->- Trailing slash could be omitted. e.g.) 'pages' and 'pages/' show the same collection. |
|  [CombineDbStrategies](./git-documentdb.combinedbstrategies.md) | Behavior when combine inconsistent DBs |
|  [CommitInfo](./git-documentdb.commitinfo.md) | Commit information |
|  [ConflictResolutionStrategies](./git-documentdb.conflictresolutionstrategies.md) | Strategy for resolving conflicts |
|  [ConflictResolutionStrategyLabels](./git-documentdb.conflictresolutionstrategylabels.md) |  |
|  [ConnectionSettings](./git-documentdb.connectionsettings.md) | Connection settings for RemoteOptions |
|  [ConnectionSettingsGitHub](./git-documentdb.connectionsettingsgithub.md) | Connection settings for GitHub |
|  [ConnectionSettingsNone](./git-documentdb.connectionsettingsnone.md) | Connection settings do not exist. |
|  [ConnectionSettingsSSH](./git-documentdb.connectionsettingsssh.md) | Connection settings for SSH |
|  [DatabaseCloseOption](./git-documentdb.databasecloseoption.md) | How to close database |
|  [DatabaseInfo](./git-documentdb.databaseinfo.md) | Database information |
|  [DatabaseInfoError](./git-documentdb.databaseinfoerror.md) | Database information (failure) |
|  [DatabaseInfoSuccess](./git-documentdb.databaseinfosuccess.md) | Database information (success) |
|  [DatabaseOption](./git-documentdb.databaseoption.md) | Database Option |
|  [DeleteOptions](./git-documentdb.deleteoptions.md) | Options for delete() |
|  [DocMetadata](./git-documentdb.docmetadata.md) | Type for a document metadata |
|  [JsonDiffOptions](./git-documentdb.jsondiffoptions.md) | JsonDiffOptions |
|  [JsonDoc](./git-documentdb.jsondoc.md) | Type for a JSON document that is stored in a database |
|  [JsonDocWithMetadata](./git-documentdb.jsondocwithmetadata.md) | Type for a JSON document with metadata |
|  [PutOptions](./git-documentdb.putoptions.md) | Options for put() |
|  [PutResult](./git-documentdb.putresult.md) | Result of put() |
|  [RemoteOptions](./git-documentdb.remoteoptions.md) | Options for Sync class |
|  [RemoveResult](./git-documentdb.removeresult.md) | Result of remove() |
|  [Schema](./git-documentdb.schema.md) | Schema |
|  [SyncActiveCallback](./git-documentdb.syncactivecallback.md) |  |
|  [SyncCallback](./git-documentdb.synccallback.md) |  |
|  [SyncChangeCallback](./git-documentdb.syncchangecallback.md) | SyncEventCallbacks |
|  [SyncCompleteCallback](./git-documentdb.synccompletecallback.md) |  |
|  [SyncDirection](./git-documentdb.syncdirection.md) | Synchronization direction |
|  [SyncErrorCallback](./git-documentdb.syncerrorcallback.md) |  |
|  [SyncEvent](./git-documentdb.syncevent.md) | SyncEvent |
|  [SyncLocalChangeCallback](./git-documentdb.synclocalchangecallback.md) |  |
|  [SyncPausedCallback](./git-documentdb.syncpausedcallback.md) |  |
|  [SyncRemoteChangeCallback](./git-documentdb.syncremotechangecallback.md) |  |
|  [SyncResult](./git-documentdb.syncresult.md) | Result from sync\_worker() |
|  [SyncStartCallback](./git-documentdb.syncstartcallback.md) |  |
|  [Task](./git-documentdb.task.md) | Task for taskQueue |
|  [TaskCallback](./git-documentdb.taskcallback.md) |  |
|  [TaskEnqueueCallback](./git-documentdb.taskenqueuecallback.md) |  |
|  [TaskEvent](./git-documentdb.taskevent.md) | TaskEvent |
|  [TaskLabel](./git-documentdb.tasklabel.md) | TaskLabel DatabaseStatistics.taskCount must have the same members. |
|  [TaskMetadata](./git-documentdb.taskmetadata.md) | TaskMetadata |
|  [TaskStatistics](./git-documentdb.taskstatistics.md) | Task Statistics |
|  [WriteOperation](./git-documentdb.writeoperation.md) | Write operation |

