<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [git-documentdb](./git-documentdb.md) &gt; [JsonDoc](./git-documentdb.jsondoc.md)

## JsonDoc type

Type for a JSON document that is stored in a database

<b>Signature:</b>

```typescript
export declare type JsonDoc = {
    [key: string]: any;
};
```

## Remarks

A document must be a JSON Object that matches the following conditions:

```
* It must have an '_id' key that shows id of a document
  - _id allows Unicode characters excluding OS reserved filenames and following characters: \< \> : " | ? * \0
  - **It is recommended to use ASCII characters and case-insensitive names for cross-platform.**
  - _id cannot start with a slash and an underscore _.
  - _id cannot end with a slash.
  - A directory name cannot end with a period or a white space.
  - A directory name does not allow '.' and '..'.

* Property name of a document cannot start with an underscore except _id and _deleted.

```

## Example


```
{
  _id: 'profile01',
  location: 'Sapporo',
  age: '16'
}

```

