<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [git-documentdb](./git-documentdb.md) &gt; [ConflictResolutionStrategies](./git-documentdb.conflictresolutionstrategies.md)

## ConflictResolutionStrategies type

Strategy for resolving conflicts

<b>Signature:</b>

```typescript
export declare type ConflictResolutionStrategies = ConflictResolutionStrategyLabels | ((ours?: JsonDoc, theirs?: JsonDoc) => ConflictResolutionStrategyLabels);
```
<b>References:</b> [ConflictResolutionStrategyLabels](./git-documentdb.conflictresolutionstrategylabels.md)<!-- -->, [JsonDoc](./git-documentdb.jsondoc.md)

## Remarks

'ours' and 'theirs' are borrowed terms from Git (https://git-scm.com/docs/merge-strategies)

- 'ours-diff': (Default) Accept ours per property. Properties in both local and remote documents are compared and merged. When a remote change is conflicted with a local change, the local change is accepted.

- 'theirs-diff': Accept theirs per property. Properties in both local and remote documents are compared and merged. When a remote change is conflicted with a local change, the remote change is accepted.

- 'ours': Accept ours per document. Documents in both local and remote commits are compared and merged per document. When a remote change is conflicted with a local change, the local change is accepted.

- 'theirs': Accept theirs per document. Documents in both local and remote commits are compared and merged per document. When a remote change is conflicted with a local change, the remote change is accepted.

- Compare function that returns one of the strategies ('ours-diff', 'theirs-diff', 'ours', and 'theirs') can be given. Each argument will be undefined when a document is removed.

