<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [git-documentdb](./git-documentdb.md) &gt; [Collection](./git-documentdb.collection.md) &gt; [put](./git-documentdb.collection.put_1.md)

## Collection.put() method

Insert a document if not exists. Otherwise, update it.

<b>Signature:</b>

```typescript
put(_id: string, document: {
        [key: string]: any;
    }, options?: PutOptions): Promise<PutResult>;
```

## Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  \_id | string | \_id property of a document is set or overwritten by this \_id argument. |
|  document | { \[key: string\]: any; } | This is a [JsonDoc](./git-documentdb.jsondoc.md)<!-- -->, but \_id property is ignored. |
|  options | [PutOptions](./git-documentdb.putoptions.md) |  |

<b>Returns:</b>

Promise&lt;[PutResult](./git-documentdb.putresult.md)<!-- -->&gt;

## Exceptions

[DatabaseClosingError](./git-documentdb.databaseclosingerror.md)

[RepositoryNotOpenError](./git-documentdb.repositorynotopenerror.md)

[UndefinedDocumentIdError](./git-documentdb.undefineddocumentiderror.md)

[InvalidJsonObjectError](./git-documentdb.invalidjsonobjecterror.md)

[CannotWriteDataError](./git-documentdb.cannotwritedataerror.md)

[CannotCreateDirectoryError](./git-documentdb.cannotcreatedirectoryerror.md)

[InvalidIdCharacterError](./git-documentdb.invalididcharactererror.md)

[InvalidIdLengthError](./git-documentdb.invalididlengtherror.md)

[InvalidCollectionPathCharacterError](./git-documentdb.invalidcollectionpathcharactererror.md)

[InvalidCollectionPathLengthError](./git-documentdb.invalidcollectionpathlengtherror.md)

## Remarks

- put() does not check a write permission of your file system (unlike open()).

- Saved file path is `${workingDir()}/${document._id}.json`<!-- -->. [InvalidIdLengthError](./git-documentdb.invalididlengtherror.md) will be thrown if the path length exceeds the maximum length of a filepath on the device.

