<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [git-documentdb](./git-documentdb.md) &gt; [Collection](./git-documentdb.collection.md)

## Collection class

Documents are gathered together in collections.

<b>Signature:</b>

```typescript
export declare class Collection implements CRUDInterface 
```
<b>Implements:</b> CRUDInterface

## Remarks

Collection is a sugar syntax of filepath representation.

Use Collection to omit directories from the filepath.

Both filepath representation (like PouchDB) and collection put the same file on the same location in a Git repository.

## Example


```
const gitDDB = new GitDocumentDB({ local_dir: 'gddb_data', db_name: 'db01' });

// Both put 'gddb_data/db01/Sapporo/1.json' in which JSON document has { _id: '1', name: 'Yuzuki' }.
gitDDB.put({ _id: 'Sapporo/1', name: 'Yuzuki' });
gitDDB.collection('Sapporo').put({ _id: '1', name: 'Yuzuki' })

// Notice that APIs return different _id values in spite of the same source file.
gitDDB.get({ _id: 'Sapporo/1' }); // returns { _id: 'Sapporo/1', name: 'Yuzuki' }.
gitDDB.collection('Sapporo').get({ _id: '1' }); // returns { _id: '1', name: 'Yuzuki' }.

```

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)(\_gitDDB, \_collectionPath)](./git-documentdb.collection._constructor_.md) |  | Constructs a new instance of the <code>Collection</code> class |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [allDocs(options)](./git-documentdb.collection.alldocs.md) |  | Get all the documents |
|  [collectionPath()](./git-documentdb.collection.collectionpath.md) |  | Get normalized path of collection |
|  [delete(id, options)](./git-documentdb.collection.delete.md) |  | Delete a document |
|  [delete(jsonDoc, options)](./git-documentdb.collection.delete_1.md) |  | Remove a document |
|  [get(docId, backNumber)](./git-documentdb.collection.get.md) |  | Get a document |
|  [getCollections(gitDDB, rootPath)](./git-documentdb.collection.getcollections.md) | <code>static</code> | Get collections whose path start with specified path |
|  [insert(jsonDoc, options)](./git-documentdb.collection.insert.md) |  | Insert a document |
|  [insert(id, document, options)](./git-documentdb.collection.insert_1.md) |  | Insert a document |
|  [put(jsonDoc, options)](./git-documentdb.collection.put.md) |  | Insert a document if not exists. Otherwise, update it. |
|  [put(\_id, document, options)](./git-documentdb.collection.put_1.md) |  | Insert a document if not exists. Otherwise, update it. |
|  [remove(id, options)](./git-documentdb.collection.remove.md) |  | This is an alias of delete() |
|  [remove(jsonDoc, options)](./git-documentdb.collection.remove_1.md) |  | This is an alias of delete() |
|  [update(jsonDoc, options)](./git-documentdb.collection.update.md) |  | Update a document |
|  [update(id, document, options)](./git-documentdb.collection.update_1.md) |  | Update a document |

