<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [git-documentdb](./git-documentdb.md) &gt; [Collection](./git-documentdb.collection.md) &gt; [insert](./git-documentdb.collection.insert_1.md)

## Collection.insert() method

Insert a document

<b>Signature:</b>

```typescript
insert(id: string, document: {
        [key: string]: any;
    }, options?: PutOptions): Promise<PutResult>;
```

## Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  id | string | \_id property of a document |
|  document | { \[key: string\]: any; } | This is a [JsonDoc](./git-documentdb.jsondoc.md)<!-- -->, but \_id property is ignored. |
|  options | [PutOptions](./git-documentdb.putoptions.md) |  |

<b>Returns:</b>

Promise&lt;[PutResult](./git-documentdb.putresult.md)<!-- -->&gt;

## Exceptions

[DatabaseClosingError](./git-documentdb.databaseclosingerror.md)

[RepositoryNotOpenError](./git-documentdb.repositorynotopenerror.md)

[UndefinedDocumentIdError](./git-documentdb.undefineddocumentiderror.md)

[InvalidJsonObjectError](./git-documentdb.invalidjsonobjecterror.md)

[CannotWriteDataError](./git-documentdb.cannotwritedataerror.md)

[CannotCreateDirectoryError](./git-documentdb.cannotcreatedirectoryerror.md)

[InvalidIdCharacterError](./git-documentdb.invalididcharactererror.md)

[InvalidIdLengthError](./git-documentdb.invalididlengtherror.md)

[SameIdExistsError](./git-documentdb.sameidexistserror.md)

## Remarks

- Throws SameIdExistsError when a document which has the same id exists. It might be better to use put() instead of insert().

- create() does not check a write permission of your file system (unlike open()).

- Saved file path is `${workingDir()}/${document._id}.json`<!-- -->. [InvalidIdLengthError](./git-documentdb.invalididlengtherror.md) will be thrown if the path length exceeds the maximum length of a filepath on the device.

